/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.connector.sink;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.flink.api.connector.sink.SinkWriter;
import org.apache.flink.core.fs.Path;
import org.apache.flink.table.catalog.CatalogPartitionSpec;
import org.apache.flink.table.connector.sink.TestManagedCommittable;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.utils.PartitionPathUtils;
import org.assertj.core.api.Assertions;

public class TestManagedSinkWriter
implements SinkWriter<RowData, TestManagedCommittable, Void> {
    private final Map<String, CatalogPartitionSpec> processedPartitions = new HashMap<String, CatalogPartitionSpec>();
    private final Map<CatalogPartitionSpec, List<RowData>> stagingElements = new HashMap<CatalogPartitionSpec, List<RowData>>();
    private final Map<CatalogPartitionSpec, Set<Path>> toDelete = new HashMap<CatalogPartitionSpec, Set<Path>>();

    public void write(RowData element, SinkWriter.Context context) throws IOException, InterruptedException {
        Assertions.assertThat((int)element.getArity()).isEqualTo(3);
        String partition = element.getString(0).toString();
        Path filePath = new Path(element.getString(1).toString());
        GenericRowData rowData = GenericRowData.of((Object[])new Object[]{element.getString(2)});
        CatalogPartitionSpec currentPartitionSpec = this.processedPartitions.getOrDefault(partition, new CatalogPartitionSpec((Map)PartitionPathUtils.extractPartitionSpecFromPath((Path)filePath)));
        this.processedPartitions.put(partition, currentPartitionSpec);
        List elements = this.stagingElements.getOrDefault(currentPartitionSpec, new ArrayList());
        elements.add(rowData);
        this.stagingElements.put(currentPartitionSpec, elements);
        Set old = this.toDelete.getOrDefault(currentPartitionSpec, new HashSet());
        old.add(filePath);
        this.toDelete.put(currentPartitionSpec, old);
    }

    public List<TestManagedCommittable> prepareCommit(boolean flush) throws IOException, InterruptedException {
        return Collections.singletonList(new TestManagedCommittable(this.stagingElements, this.toDelete));
    }

    public void close() throws Exception {
    }
}

