/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.utils;

import java.io.Serializable;
import java.util.Objects;
import org.apache.flink.table.utils.EncodingUtils;
import org.junit.Assert;
import org.junit.Test;

public class EncodingUtilsTest {
    @Test
    public void testObjectStringEncoding() {
        MyPojo pojo = new MyPojo(33, "Hello");
        String base64 = EncodingUtils.encodeObjectToString((Serializable)pojo);
        Assert.assertEquals((Object)pojo, (Object)EncodingUtils.decodeStringToObject((String)base64, Serializable.class));
    }

    @Test
    public void testStringBase64Encoding() {
        String string = "Hello, this is apache flink.";
        String base64 = EncodingUtils.encodeStringToBase64((String)"Hello, this is apache flink.");
        Assert.assertEquals((Object)"SGVsbG8sIHRoaXMgaXMgYXBhY2hlIGZsaW5rLg==", (Object)base64);
        Assert.assertEquals((Object)"Hello, this is apache flink.", (Object)EncodingUtils.decodeBase64ToString((String)base64));
    }

    @Test
    public void testMd5Hex() {
        String string = "Hello, world! How are you? \u9ad8\u7cbe\u786e";
        Assert.assertEquals((Object)"983abac84e994b4ba73be177e5cc298b", (Object)EncodingUtils.hex((byte[])EncodingUtils.md5((String)"Hello, world! How are you? \u9ad8\u7cbe\u786e")));
    }

    @Test
    public void testJavaEscaping() {
        Assert.assertEquals((Object)"\\\\hello\\\"world'space/", (Object)EncodingUtils.escapeJava((String)"\\hello\"world'space/"));
    }

    @Test
    public void testRepetition() {
        Assert.assertEquals((Object)"wewewe", (Object)EncodingUtils.repeat((String)"we", (int)3));
    }

    private static class MyPojo
    implements Serializable {
        private int number;
        private String string;

        public MyPojo(int number, String string) {
            this.number = number;
            this.string = string;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MyPojo myPojo = (MyPojo)o;
            return this.number == myPojo.number && Objects.equals(this.string, myPojo.string);
        }

        public int hashCode() {
            return Objects.hash(this.number, this.string);
        }
    }
}

