/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.utils;

import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.FieldsDataType;
import org.apache.flink.table.types.logical.DistinctType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.StructuredType;
import org.apache.flink.table.types.utils.DataTypeUtils;
import org.apache.flink.table.types.utils.TypeConversions;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class DataTypeUtilsTest {
    @Test
    public void testProjectRow() {
        DataType thirdLevelRow = DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"c0", (DataType)DataTypes.BOOLEAN()), DataTypes.FIELD((String)"c1", (DataType)DataTypes.DOUBLE()), DataTypes.FIELD((String)"c2", (DataType)DataTypes.INT())});
        DataType secondLevelRow = DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"b0", (DataType)DataTypes.BOOLEAN()), DataTypes.FIELD((String)"b1", (DataType)thirdLevelRow), DataTypes.FIELD((String)"b2", (DataType)DataTypes.INT())});
        DataType topLevelRow = DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"a0", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"a1", (DataType)secondLevelRow), DataTypes.FIELD((String)"a1_b1_c0", (DataType)DataTypes.INT())});
        Assert.assertThat((Object)DataTypeUtils.projectRow((DataType)topLevelRow, (int[][])new int[][]{{0}, {1, 1, 0}}), (Matcher)CoreMatchers.equalTo((Object)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"a0", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"a1_b1_c0", (DataType)DataTypes.BOOLEAN())})));
        Assert.assertThat((Object)DataTypeUtils.projectRow((DataType)topLevelRow, (int[][])new int[][]{{1, 1}, {0}}), (Matcher)CoreMatchers.equalTo((Object)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"a1_b1", (DataType)thirdLevelRow), DataTypes.FIELD((String)"a0", (DataType)DataTypes.INT())})));
        Assert.assertThat((Object)DataTypeUtils.projectRow((DataType)topLevelRow, (int[][])new int[][]{{1, 1, 2}, {1, 1, 1}, {1, 1, 0}}), (Matcher)CoreMatchers.equalTo((Object)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"a1_b1_c2", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"a1_b1_c1", (DataType)DataTypes.DOUBLE()), DataTypes.FIELD((String)"a1_b1_c0", (DataType)DataTypes.BOOLEAN())})));
        Assert.assertThat((Object)DataTypeUtils.projectRow((DataType)topLevelRow, (int[][])new int[][]{{1, 1, 0}, {2}}), (Matcher)CoreMatchers.equalTo((Object)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"a1_b1_c0", (DataType)DataTypes.BOOLEAN()), DataTypes.FIELD((String)"a1_b1_c0_$0", (DataType)DataTypes.INT())})));
    }

    @Test
    public void testAppendRowFields() {
        DataType row = DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"a0", (DataType)DataTypes.BOOLEAN()), DataTypes.FIELD((String)"a1", (DataType)DataTypes.DOUBLE()), DataTypes.FIELD((String)"a2", (DataType)DataTypes.INT())});
        DataType expectedRow = DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"a0", (DataType)DataTypes.BOOLEAN()), DataTypes.FIELD((String)"a1", (DataType)DataTypes.DOUBLE()), DataTypes.FIELD((String)"a2", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"a3", (DataType)DataTypes.BIGINT()), DataTypes.FIELD((String)"a4", (DataType)DataTypes.TIMESTAMP((int)3))});
        Assert.assertThat((Object)DataTypeUtils.appendRowFields((DataType)row, Arrays.asList(DataTypes.FIELD((String)"a3", (DataType)DataTypes.BIGINT()), DataTypes.FIELD((String)"a4", (DataType)DataTypes.TIMESTAMP((int)3)))), (Matcher)CoreMatchers.equalTo((Object)expectedRow));
        row = DataTypes.ROW();
        expectedRow = DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"a", (DataType)DataTypes.BOOLEAN()), DataTypes.FIELD((String)"b", (DataType)DataTypes.INT())});
        Assert.assertThat((Object)DataTypeUtils.appendRowFields((DataType)row, Arrays.asList(DataTypes.FIELD((String)"a", (DataType)DataTypes.BOOLEAN()), DataTypes.FIELD((String)"b", (DataType)DataTypes.INT()))), (Matcher)CoreMatchers.equalTo((Object)expectedRow));
    }

    @Test
    public void testIsInternalClass() {
        Assert.assertTrue((boolean)DataTypeUtils.isInternal((DataType)DataTypes.INT()));
        Assert.assertTrue((boolean)DataTypeUtils.isInternal((DataType)((DataType)((DataType)DataTypes.INT().notNull()).bridgedTo(Integer.TYPE))));
        Assert.assertTrue((boolean)DataTypeUtils.isInternal((DataType)((DataType)DataTypes.ROW().bridgedTo(RowData.class))));
        Assert.assertFalse((boolean)DataTypeUtils.isInternal((DataType)DataTypes.ROW()));
    }

    @Test
    public void testFlattenToDataTypes() {
        Assert.assertThat((Object)DataTypeUtils.flattenToDataTypes((DataType)DataTypes.INT()), (Matcher)CoreMatchers.equalTo(Collections.singletonList(DataTypes.INT())));
        Assert.assertThat((Object)DataTypeUtils.flattenToDataTypes((DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"a", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"b", (DataType)DataTypes.BOOLEAN())})), (Matcher)CoreMatchers.equalTo(Arrays.asList(DataTypes.INT(), DataTypes.BOOLEAN())));
    }

    @Test
    public void testFlattenToNames() {
        Assert.assertThat((Object)DataTypeUtils.flattenToNames((DataType)DataTypes.INT(), Collections.emptyList()), (Matcher)CoreMatchers.equalTo(Collections.singletonList("f0")));
        Assert.assertThat((Object)DataTypeUtils.flattenToNames((DataType)DataTypes.INT(), Collections.singletonList("f0")), (Matcher)CoreMatchers.equalTo(Collections.singletonList("f0_0")));
        Assert.assertThat((Object)DataTypeUtils.flattenToNames((DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"a", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"b", (DataType)DataTypes.BOOLEAN())}), Collections.emptyList()), (Matcher)CoreMatchers.equalTo(Arrays.asList("a", "b")));
    }

    @Test
    public void testExpandRowType() {
        DataType dataType = DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f0", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"f1", (DataType)DataTypes.STRING()), DataTypes.FIELD((String)"f2", (DataType)((DataType)DataTypes.TIMESTAMP((int)5).bridgedTo(Timestamp.class))), DataTypes.FIELD((String)"f3", (DataType)DataTypes.TIMESTAMP((int)3))});
        TableSchema schema = DataTypeUtils.expandCompositeTypeToSchema((DataType)dataType);
        Assert.assertThat((Object)schema, (Matcher)CoreMatchers.equalTo((Object)TableSchema.builder().field("f0", DataTypes.INT()).field("f1", DataTypes.STRING()).field("f2", (DataType)DataTypes.TIMESTAMP((int)5).bridgedTo(Timestamp.class)).field("f3", (DataType)DataTypes.TIMESTAMP((int)3).bridgedTo(LocalDateTime.class)).build()));
    }

    @Test
    public void testExpandLegacyCompositeType() {
        DataType dataType = TypeConversions.fromLegacyInfoToDataType((TypeInformation)new TupleTypeInfo(new TypeInformation[]{Types.STRING, Types.INT, Types.SQL_TIMESTAMP}));
        TableSchema schema = DataTypeUtils.expandCompositeTypeToSchema((DataType)dataType);
        Assert.assertThat((Object)schema, (Matcher)CoreMatchers.equalTo((Object)TableSchema.builder().field("f0", DataTypes.STRING()).field("f1", DataTypes.INT()).field("f2", (DataType)DataTypes.TIMESTAMP((int)3).bridgedTo(Timestamp.class)).build()));
    }

    @Test
    public void testExpandStructuredType() {
        StructuredType logicalType = StructuredType.newBuilder((ObjectIdentifier)ObjectIdentifier.of((String)"catalog", (String)"database", (String)"type")).attributes(Arrays.asList(new StructuredType.StructuredAttribute("f0", DataTypes.INT().getLogicalType()), new StructuredType.StructuredAttribute("f1", DataTypes.STRING().getLogicalType()), new StructuredType.StructuredAttribute("f2", DataTypes.TIMESTAMP((int)5).getLogicalType()), new StructuredType.StructuredAttribute("f3", DataTypes.TIMESTAMP((int)3).getLogicalType()))).build();
        List<DataType> dataTypes = Arrays.asList(DataTypes.INT(), DataTypes.STRING(), (DataType)DataTypes.TIMESTAMP((int)5).bridgedTo(Timestamp.class), DataTypes.TIMESTAMP((int)3));
        FieldsDataType dataType = new FieldsDataType((LogicalType)logicalType, dataTypes);
        TableSchema schema = DataTypeUtils.expandCompositeTypeToSchema((DataType)dataType);
        Assert.assertThat((Object)schema, (Matcher)CoreMatchers.equalTo((Object)TableSchema.builder().field("f0", DataTypes.INT()).field("f1", DataTypes.STRING()).field("f2", (DataType)DataTypes.TIMESTAMP((int)5).bridgedTo(Timestamp.class)).field("f3", (DataType)DataTypes.TIMESTAMP((int)3).bridgedTo(LocalDateTime.class)).build()));
    }

    @Test
    public void testExpandDistinctType() {
        FieldsDataType dataType = (FieldsDataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f0", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"f1", (DataType)DataTypes.STRING()), DataTypes.FIELD((String)"f2", (DataType)((DataType)DataTypes.TIMESTAMP((int)5).bridgedTo(Timestamp.class))), DataTypes.FIELD((String)"f3", (DataType)DataTypes.TIMESTAMP((int)3))});
        LogicalType originalLogicalType = dataType.getLogicalType();
        DistinctType distinctLogicalType = DistinctType.newBuilder((ObjectIdentifier)ObjectIdentifier.of((String)"catalog", (String)"database", (String)"type"), (LogicalType)originalLogicalType).build();
        FieldsDataType distinctDataType = new FieldsDataType((LogicalType)distinctLogicalType, dataType.getChildren());
        TableSchema schema = DataTypeUtils.expandCompositeTypeToSchema((DataType)distinctDataType);
        Assert.assertThat((Object)schema, (Matcher)CoreMatchers.equalTo((Object)TableSchema.builder().field("f0", DataTypes.INT()).field("f1", DataTypes.STRING()).field("f2", (DataType)DataTypes.TIMESTAMP((int)5).bridgedTo(Timestamp.class)).field("f3", (DataType)DataTypes.TIMESTAMP((int)3).bridgedTo(LocalDateTime.class)).build()));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testExpandThrowExceptionOnAtomicType() {
        DataTypeUtils.expandCompositeTypeToSchema((DataType)DataTypes.TIMESTAMP());
    }

    @Test
    public void testDataTypeValidation() {
        DataType validDataType = DataTypes.MAP((DataType)DataTypes.INT(), (DataType)DataTypes.STRING());
        DataTypeUtils.validateInputDataType((DataType)validDataType);
        DataTypeUtils.validateOutputDataType((DataType)validDataType);
        DataType inputOnlyDataType = (DataType)validDataType.bridgedTo(HashMap.class);
        DataTypeUtils.validateInputDataType((DataType)inputOnlyDataType);
        try {
            DataTypeUtils.validateOutputDataType((DataType)inputOnlyDataType);
            Assert.fail();
        }
        catch (ValidationException e) {
            Assert.assertEquals((Object)e.getMessage(), (Object)("Data type 'MAP<INT, STRING>' does not support an output conversion to class '" + HashMap.class.getName() + "'."));
        }
    }
}

