/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.utils;

import java.util.Optional;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.DataTypeFactory;
import org.apache.flink.table.catalog.UnresolvedIdentifier;
import org.apache.flink.table.types.AbstractDataType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.UnresolvedDataType;
import org.apache.flink.table.types.extraction.DataTypeExtractor;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.utils.LogicalTypeParser;
import org.apache.flink.table.types.utils.TypeConversions;
import org.junit.Assert;

public class DataTypeFactoryMock
implements DataTypeFactory {
    public Optional<DataType> dataType = Optional.empty();
    public Optional<Class<?>> expectedClass = Optional.empty();

    public DataType createDataType(AbstractDataType<?> abstractDataType) {
        if (abstractDataType instanceof DataType) {
            return (DataType)abstractDataType;
        }
        if (abstractDataType instanceof UnresolvedDataType) {
            return ((UnresolvedDataType)abstractDataType).toDataType((DataTypeFactory)this);
        }
        throw new IllegalStateException();
    }

    public DataType createDataType(String name) {
        return TypeConversions.fromLogicalToDataType((LogicalType)LogicalTypeParser.parse((String)name));
    }

    public DataType createDataType(UnresolvedIdentifier identifier) {
        return this.dataType.orElseThrow(() -> new ValidationException("No type found."));
    }

    public <T> DataType createDataType(Class<T> clazz) {
        this.expectedClass.ifPresent(expected -> Assert.assertEquals((Object)expected, (Object)clazz));
        return DataTypeExtractor.extractFromType((DataTypeFactory)this, clazz);
    }

    public <T> DataType createRawDataType(Class<T> clazz) {
        this.expectedClass.ifPresent(expected -> Assert.assertEquals((Object)expected, (Object)clazz));
        return this.dataType.orElseThrow(IllegalStateException::new);
    }
}

