/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.inference;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import org.apache.flink.core.testutils.FlinkMatchers;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.functions.FunctionKind;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.FieldsDataType;
import org.apache.flink.table.types.inference.ArgumentTypeStrategy;
import org.apache.flink.table.types.inference.CallContext;
import org.apache.flink.table.types.inference.ConstantArgumentCount;
import org.apache.flink.table.types.inference.InputTypeStrategies;
import org.apache.flink.table.types.inference.InputTypeStrategy;
import org.apache.flink.table.types.inference.TypeInference;
import org.apache.flink.table.types.inference.TypeInferenceUtil;
import org.apache.flink.table.types.inference.TypeStrategies;
import org.apache.flink.table.types.inference.TypeStrategy;
import org.apache.flink.table.types.inference.utils.CallContextMock;
import org.apache.flink.table.types.inference.utils.FunctionDefinitionMock;
import org.apache.flink.table.types.logical.BigIntType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeFamily;
import org.apache.flink.table.types.logical.StructuredType;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TypeStrategiesTest {
    @Parameterized.Parameter
    public TestSpec testSpec;
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Parameterized.Parameters(name="{index}: {0}")
    public static List<TestSpec> testData() {
        return Arrays.asList(TestSpec.forStrategy(TypeStrategies.MISSING).inputTypes(DataTypes.INT()).expectErrorMessage("Could not infer an output type for the given arguments."), TestSpec.forStrategy(TypeStrategies.explicit((DataType)DataTypes.BIGINT())).inputTypes(new DataType[0]).expectDataType(DataTypes.BIGINT()), TestSpec.forStrategy(TypeStrategies.argument((int)0)).inputTypes(DataTypes.INT(), DataTypes.STRING()).expectDataType(DataTypes.INT()), TestSpec.forStrategy(TypeStrategies.argument((int)0)).inputTypes(new DataType[0]).expectErrorMessage("Could not infer an output type for the given arguments."), TestSpec.forStrategy(TypeStrategiesTest.createMappingTypeStrategy()).inputTypes(DataTypes.INT(), DataTypes.BOOLEAN()).expectDataType(DataTypes.STRING()), TestSpec.forStrategy(TypeStrategiesTest.createMappingTypeStrategy()).inputTypes(DataTypes.INT(), DataTypes.STRING()).expectDataType((DataType)DataTypes.BOOLEAN().bridgedTo(Boolean.TYPE)), TestSpec.forStrategy(TypeStrategiesTest.createMappingTypeStrategy()).inputTypes(DataTypes.INT(), DataTypes.CHAR((int)10)).expectDataType((DataType)DataTypes.BOOLEAN().bridgedTo(Boolean.TYPE)), TestSpec.forStrategy(TypeStrategiesTest.createMappingTypeStrategy()).inputTypes(DataTypes.INT(), DataTypes.INT()).expectErrorMessage("Could not infer an output type for the given arguments."), TestSpec.forStrategy(TypeStrategies.explicit((DataType)DataTypes.NULL())).inputTypes(new DataType[0]).expectErrorMessage("Could not infer an output type for the given arguments. Untyped NULL received."), TestSpec.forStrategy("First type strategy", TypeStrategies.first((TypeStrategy[])new TypeStrategy[]{callContext -> Optional.empty(), TypeStrategies.explicit((DataType)DataTypes.INT())})).inputTypes(new DataType[0]).expectDataType(DataTypes.INT()), TestSpec.forStrategy("Match root type strategy", TypeStrategies.matchFamily((int)0, (LogicalTypeFamily)LogicalTypeFamily.NUMERIC)).inputTypes(DataTypes.INT()).expectDataType(DataTypes.INT()), TestSpec.forStrategy("Invalid match root type strategy", TypeStrategies.matchFamily((int)0, (LogicalTypeFamily)LogicalTypeFamily.NUMERIC)).inputTypes(DataTypes.BOOLEAN()).expectErrorMessage("Could not infer an output type for the given arguments."), TestSpec.forStrategy("Infer a row type", TypeStrategies.ROW).inputTypes(DataTypes.BIGINT(), DataTypes.STRING()).expectDataType((DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f0", (DataType)DataTypes.BIGINT()), DataTypes.FIELD((String)"f1", (DataType)DataTypes.STRING())}).notNull()), TestSpec.forStrategy("Infer an array type", TypeStrategies.ARRAY).inputTypes(DataTypes.BIGINT(), DataTypes.BIGINT()).expectDataType((DataType)DataTypes.ARRAY((DataType)DataTypes.BIGINT()).notNull()), TestSpec.forStrategy("Infer a map type", TypeStrategies.MAP).inputTypes(DataTypes.BIGINT(), (DataType)DataTypes.STRING().notNull()).expectDataType((DataType)DataTypes.MAP((DataType)DataTypes.BIGINT(), (DataType)((DataType)DataTypes.STRING().notNull())).notNull()), TestSpec.forStrategy("Cascading to nullable type", TypeStrategies.nullable((TypeStrategy)TypeStrategies.explicit((DataType)((DataType)DataTypes.BOOLEAN().notNull())))).inputTypes((DataType)DataTypes.BIGINT().notNull(), (DataType)DataTypes.VARCHAR((int)2).nullable()).expectDataType((DataType)DataTypes.BOOLEAN().nullable()), TestSpec.forStrategy("Cascading to not null type", TypeStrategies.nullable((TypeStrategy)TypeStrategies.explicit((DataType)((DataType)DataTypes.BOOLEAN().nullable())))).inputTypes((DataType)DataTypes.BIGINT().notNull(), (DataType)DataTypes.VARCHAR((int)2).notNull()).expectDataType((DataType)DataTypes.BOOLEAN().notNull()), TestSpec.forStrategy("Cascading to not null type but only consider first argument", TypeStrategies.nullable((ConstantArgumentCount)ConstantArgumentCount.to((int)0), (TypeStrategy)TypeStrategies.explicit((DataType)((DataType)DataTypes.BOOLEAN().nullable())))).inputTypes((DataType)DataTypes.BIGINT().notNull(), (DataType)DataTypes.VARCHAR((int)2).nullable()).expectDataType((DataType)DataTypes.BOOLEAN().notNull()), TestSpec.forStrategy("Cascading to null type but only consider first two argument", TypeStrategies.nullable((ConstantArgumentCount)ConstantArgumentCount.to((int)1), (TypeStrategy)TypeStrategies.explicit((DataType)((DataType)DataTypes.BOOLEAN().nullable())))).inputTypes((DataType)DataTypes.BIGINT().notNull(), (DataType)DataTypes.VARCHAR((int)2).nullable()).expectDataType((DataType)DataTypes.BOOLEAN().nullable()), TestSpec.forStrategy("Cascading to not null type but only consider the second and third argument", TypeStrategies.nullable((ConstantArgumentCount)ConstantArgumentCount.between((int)1, (int)2), (TypeStrategy)TypeStrategies.explicit((DataType)((DataType)DataTypes.BOOLEAN().nullable())))).inputTypes((DataType)DataTypes.BIGINT().nullable(), (DataType)DataTypes.BIGINT().notNull(), (DataType)DataTypes.VARCHAR((int)2).notNull()).expectDataType((DataType)DataTypes.BOOLEAN().notNull()), TestSpec.forStrategy("Find a common type", TypeStrategies.COMMON).inputTypes(DataTypes.INT(), (DataType)DataTypes.TINYINT().notNull(), DataTypes.DECIMAL((int)20, (int)10)).expectDataType(DataTypes.DECIMAL((int)20, (int)10)), TestSpec.forStrategy("Find a decimal sum", TypeStrategies.DECIMAL_PLUS).inputTypes(DataTypes.DECIMAL((int)5, (int)4), DataTypes.DECIMAL((int)3, (int)2)).expectDataType((DataType)DataTypes.DECIMAL((int)6, (int)4).notNull()), TestSpec.forStrategy("Find a decimal quotient", TypeStrategies.DECIMAL_DIVIDE).inputTypes(DataTypes.DECIMAL((int)5, (int)4), DataTypes.DECIMAL((int)3, (int)2)).expectDataType((DataType)DataTypes.DECIMAL((int)11, (int)8).notNull()), TestSpec.forStrategy("Find a decimal product", TypeStrategies.DECIMAL_TIMES).inputTypes(DataTypes.DECIMAL((int)5, (int)4), DataTypes.DECIMAL((int)3, (int)2)).expectDataType((DataType)DataTypes.DECIMAL((int)8, (int)6).notNull()), TestSpec.forStrategy("Find a decimal modulo", TypeStrategies.DECIMAL_MOD).inputTypes(DataTypes.DECIMAL((int)5, (int)4), DataTypes.DECIMAL((int)3, (int)2)).expectDataType((DataType)DataTypes.DECIMAL((int)5, (int)4).notNull()), TestSpec.forStrategy("Convert to varying string", TypeStrategies.varyingString((TypeStrategy)TypeStrategies.explicit((DataType)((DataType)DataTypes.CHAR((int)12).notNull())))).inputTypes((DataType)DataTypes.CHAR((int)12).notNull()).expectDataType((DataType)DataTypes.VARCHAR((int)12).notNull()), TestSpec.forStrategy("Concat two strings", TypeStrategies.STRING_CONCAT).inputTypes((DataType)DataTypes.CHAR((int)12).notNull(), DataTypes.VARCHAR((int)12)).expectDataType(DataTypes.VARCHAR((int)24)), TestSpec.forStrategy("Access field of a row nullable type by name", TypeStrategies.GET).inputTypes(DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f0", (DataType)((DataType)DataTypes.BIGINT().notNull()))}), (DataType)DataTypes.STRING().notNull()).calledWithLiteralAt(1, "f0").expectDataType((DataType)DataTypes.BIGINT().nullable()), TestSpec.forStrategy("Access field of a row not null type by name", TypeStrategies.GET).inputTypes((DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f0", (DataType)((DataType)DataTypes.BIGINT().notNull()))}).notNull(), (DataType)DataTypes.STRING().notNull()).calledWithLiteralAt(1, "f0").expectDataType((DataType)DataTypes.BIGINT().notNull()), TestSpec.forStrategy("Access field of a structured nullable type by name", TypeStrategies.GET).inputTypes(new FieldsDataType((LogicalType)StructuredType.newBuilder((ObjectIdentifier)ObjectIdentifier.of((String)"cat", (String)"db", (String)"type")).attributes(Collections.singletonList(new StructuredType.StructuredAttribute("f0", (LogicalType)new BigIntType(false)))).build(), Collections.singletonList(DataTypes.BIGINT().notNull())).nullable(), (DataType)DataTypes.STRING().notNull()).calledWithLiteralAt(1, "f0").expectDataType((DataType)DataTypes.BIGINT().nullable()), TestSpec.forStrategy("Access field of a structured not null type by name", TypeStrategies.GET).inputTypes(new FieldsDataType((LogicalType)StructuredType.newBuilder((ObjectIdentifier)ObjectIdentifier.of((String)"cat", (String)"db", (String)"type")).attributes(Collections.singletonList(new StructuredType.StructuredAttribute("f0", (LogicalType)new BigIntType(false)))).build(), Collections.singletonList(DataTypes.BIGINT().notNull())).notNull(), (DataType)DataTypes.STRING().notNull()).calledWithLiteralAt(1, "f0").expectDataType((DataType)DataTypes.BIGINT().notNull()), TestSpec.forStrategy("Access field of a row nullable type by index", TypeStrategies.GET).inputTypes(DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f0", (DataType)((DataType)DataTypes.BIGINT().notNull()))}), (DataType)DataTypes.INT().notNull()).calledWithLiteralAt(1, 0).expectDataType((DataType)DataTypes.BIGINT().nullable()), TestSpec.forStrategy("Access field of a row not null type by index", TypeStrategies.GET).inputTypes((DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f0", (DataType)((DataType)DataTypes.BIGINT().notNull()))}).notNull(), (DataType)DataTypes.INT().notNull()).calledWithLiteralAt(1, 0).expectDataType((DataType)DataTypes.BIGINT().notNull()), TestSpec.forStrategy("Fields can be accessed only with a literal (name)", TypeStrategies.GET).inputTypes((DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f0", (DataType)((DataType)DataTypes.BIGINT().notNull()))}).notNull(), (DataType)DataTypes.STRING().notNull()).expectErrorMessage("Could not infer an output type for the given arguments."), TestSpec.forStrategy("Fields can be accessed only with a literal (index)", TypeStrategies.GET).inputTypes((DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f0", (DataType)((DataType)DataTypes.BIGINT().notNull()))}).notNull(), (DataType)DataTypes.INT().notNull()).expectErrorMessage("Could not infer an output type for the given arguments."));
    }

    @Test
    public void testTypeStrategy() {
        if (this.testSpec.expectedErrorMessage != null) {
            this.thrown.expect(ValidationException.class);
            this.thrown.expectCause(FlinkMatchers.containsCause((Throwable)new ValidationException(this.testSpec.expectedErrorMessage)));
        }
        TypeInferenceUtil.Result result = this.runTypeInference();
        if (this.testSpec.expectedDataType != null) {
            Assert.assertThat((Object)result.getOutputDataType(), (Matcher)CoreMatchers.equalTo((Object)this.testSpec.expectedDataType));
        }
    }

    private TypeInferenceUtil.Result runTypeInference() {
        FunctionDefinitionMock functionDefinitionMock = new FunctionDefinitionMock();
        functionDefinitionMock.functionKind = FunctionKind.SCALAR;
        CallContextMock callContextMock = new CallContextMock();
        callContextMock.functionDefinition = functionDefinitionMock;
        callContextMock.argumentDataTypes = this.testSpec.inputTypes;
        callContextMock.name = "f";
        callContextMock.outputDataType = Optional.empty();
        callContextMock.argumentLiterals = IntStream.range(0, this.testSpec.inputTypes.size()).mapToObj(i -> this.testSpec.literalPos != null && i == this.testSpec.literalPos).collect(Collectors.toList());
        callContextMock.argumentValues = IntStream.range(0, this.testSpec.inputTypes.size()).mapToObj(i -> this.testSpec.literalPos != null && i == this.testSpec.literalPos ? Optional.ofNullable(this.testSpec.literalValue) : Optional.empty()).collect(Collectors.toList());
        TypeInference typeInference = TypeInference.newBuilder().inputTypeStrategy((InputTypeStrategy)InputTypeStrategies.WILDCARD).outputTypeStrategy(this.testSpec.strategy).build();
        return TypeInferenceUtil.runTypeInference((TypeInference)typeInference, (CallContext)callContextMock, null);
    }

    private static TypeStrategy createMappingTypeStrategy() {
        HashMap<InputTypeStrategy, TypeStrategy> mappings = new HashMap<InputTypeStrategy, TypeStrategy>();
        mappings.put(InputTypeStrategies.sequence((ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)DataTypes.INT()), InputTypeStrategies.explicit((DataType)DataTypes.STRING())}), TypeStrategies.explicit((DataType)((DataType)DataTypes.BOOLEAN().bridgedTo(Boolean.TYPE))));
        mappings.put(InputTypeStrategies.sequence((ArgumentTypeStrategy[])new ArgumentTypeStrategy[]{InputTypeStrategies.explicit((DataType)DataTypes.INT()), InputTypeStrategies.explicit((DataType)DataTypes.BOOLEAN())}), TypeStrategies.explicit((DataType)DataTypes.STRING()));
        return TypeStrategies.mapping(mappings);
    }

    private static class TestSpec {
        @Nullable
        private final String description;
        private final TypeStrategy strategy;
        private List<DataType> inputTypes;
        @Nullable
        private DataType expectedDataType;
        @Nullable
        private String expectedErrorMessage;
        @Nullable
        private Integer literalPos;
        @Nullable
        private Object literalValue;

        private TestSpec(@Nullable String description, TypeStrategy strategy) {
            this.description = description;
            this.strategy = strategy;
        }

        static TestSpec forStrategy(TypeStrategy strategy) {
            return new TestSpec(null, strategy);
        }

        static TestSpec forStrategy(String description, TypeStrategy strategy) {
            return new TestSpec(description, strategy);
        }

        TestSpec inputTypes(DataType ... dataTypes) {
            this.inputTypes = Arrays.asList(dataTypes);
            return this;
        }

        TestSpec calledWithLiteralAt(int pos, Object value) {
            this.literalPos = pos;
            this.literalValue = value;
            return this;
        }

        TestSpec expectDataType(DataType expectedDataType) {
            this.expectedDataType = expectedDataType;
            return this;
        }

        TestSpec expectErrorMessage(String expectedErrorMessage) {
            this.expectedErrorMessage = expectedErrorMessage;
            return this;
        }

        public String toString() {
            return this.description != null ? this.description : "";
        }
    }
}

