/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.inference;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.runtime.kryo.KryoSerializer;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.types.AbstractDataType;
import org.apache.flink.table.types.AtomicDataType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.FieldsDataType;
import org.apache.flink.table.types.inference.ConstantArgumentCount;
import org.apache.flink.table.types.inference.InputTypeStrategies;
import org.apache.flink.table.types.inference.InputTypeStrategiesTestBase;
import org.apache.flink.table.types.logical.DistinctType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.StructuredType;
import org.junit.runners.Parameterized;

public class ComparableInputTypeStrategyTests
extends InputTypeStrategiesTestBase {
    @Parameterized.Parameters(name="{index}: {0}")
    public static List<InputTypeStrategiesTestBase.TestSpec> testData() {
        return Arrays.asList(InputTypeStrategiesTestBase.TestSpec.forStrategy("Numeric types are comparable", InputTypeStrategies.comparable((ConstantArgumentCount)ConstantArgumentCount.of((int)7), (StructuredType.StructuredComparision)StructuredType.StructuredComparision.EQUALS)).calledWithArgumentTypes(new AbstractDataType[]{DataTypes.TINYINT(), DataTypes.SMALLINT(), DataTypes.INT(), DataTypes.BIGINT(), DataTypes.DOUBLE(), DataTypes.FLOAT(), DataTypes.DECIMAL((int)10, (int)2)}).expectSignature("f(<COMPARABLE>...)").expectArgumentTypes(new AbstractDataType[]{DataTypes.TINYINT(), DataTypes.SMALLINT(), DataTypes.INT(), DataTypes.BIGINT(), DataTypes.DOUBLE(), DataTypes.FLOAT(), DataTypes.DECIMAL((int)10, (int)2)}), InputTypeStrategiesTestBase.TestSpec.forStrategy("Datetime types are comparable", InputTypeStrategies.comparable((ConstantArgumentCount)ConstantArgumentCount.of((int)4), (StructuredType.StructuredComparision)StructuredType.StructuredComparision.EQUALS)).calledWithArgumentTypes(new AbstractDataType[]{DataTypes.TIMESTAMP(), DataTypes.TIMESTAMP_WITH_LOCAL_TIME_ZONE(), DataTypes.TIMESTAMP_WITH_TIME_ZONE(), DataTypes.DATE()}).expectArgumentTypes(new AbstractDataType[]{DataTypes.TIMESTAMP(), DataTypes.TIMESTAMP_WITH_LOCAL_TIME_ZONE(), DataTypes.TIMESTAMP_WITH_TIME_ZONE(), DataTypes.DATE()}), InputTypeStrategiesTestBase.TestSpec.forStrategy("VARCHAR and CHAR types are comparable", InputTypeStrategies.TWO_FULLY_COMPARABLE).calledWithArgumentTypes(new AbstractDataType[]{DataTypes.VARCHAR((int)10), DataTypes.CHAR((int)13)}).expectArgumentTypes(new AbstractDataType[]{DataTypes.VARCHAR((int)10), DataTypes.CHAR((int)13)}), InputTypeStrategiesTestBase.TestSpec.forStrategy("VARBINARY and BINARY types are comparable", InputTypeStrategies.TWO_FULLY_COMPARABLE).calledWithArgumentTypes(new AbstractDataType[]{DataTypes.VARBINARY((int)10), DataTypes.BINARY((int)13)}).expectArgumentTypes(new AbstractDataType[]{DataTypes.VARBINARY((int)10), DataTypes.BINARY((int)13)}), InputTypeStrategiesTestBase.TestSpec.forStrategy("Comparable array types", InputTypeStrategies.TWO_FULLY_COMPARABLE).calledWithArgumentTypes(new AbstractDataType[]{DataTypes.ARRAY((DataType)DataTypes.TINYINT()), DataTypes.ARRAY((DataType)DataTypes.DECIMAL((int)10, (int)2))}).expectArgumentTypes(new AbstractDataType[]{DataTypes.ARRAY((DataType)DataTypes.TINYINT()), DataTypes.ARRAY((DataType)DataTypes.DECIMAL((int)10, (int)2))}), InputTypeStrategiesTestBase.TestSpec.forStrategy("Comparable map types", InputTypeStrategies.TWO_FULLY_COMPARABLE).calledWithArgumentTypes(new AbstractDataType[]{DataTypes.MAP((DataType)DataTypes.TINYINT(), (DataType)DataTypes.TIMESTAMP()), DataTypes.MAP((DataType)DataTypes.DECIMAL((int)10, (int)3), (DataType)DataTypes.TIMESTAMP_WITH_TIME_ZONE())}).expectArgumentTypes(new AbstractDataType[]{DataTypes.MAP((DataType)DataTypes.TINYINT(), (DataType)DataTypes.TIMESTAMP()), DataTypes.MAP((DataType)DataTypes.DECIMAL((int)10, (int)3), (DataType)DataTypes.TIMESTAMP_WITH_TIME_ZONE())}), InputTypeStrategiesTestBase.TestSpec.forStrategy("Fully comparable structured types", InputTypeStrategies.TWO_FULLY_COMPARABLE).calledWithArgumentTypes(ComparableInputTypeStrategyTests.structuredType("type", Collections.singletonList(DataTypes.INT()), StructuredType.StructuredComparision.FULL).notNull(), ComparableInputTypeStrategyTests.structuredType("type", Collections.singletonList(DataTypes.INT()), StructuredType.StructuredComparision.FULL).nullable()).expectArgumentTypes(ComparableInputTypeStrategyTests.structuredType("type", Collections.singletonList(DataTypes.INT()), StructuredType.StructuredComparision.FULL).notNull(), ComparableInputTypeStrategyTests.structuredType("type", Collections.singletonList(DataTypes.INT()), StructuredType.StructuredComparision.FULL).nullable()), InputTypeStrategiesTestBase.TestSpec.forStrategy("Equals comparable structured types", InputTypeStrategies.TWO_EQUALS_COMPARABLE).calledWithArgumentTypes(new AbstractDataType[]{ComparableInputTypeStrategyTests.structuredType("type", Collections.singletonList(DataTypes.INT()), StructuredType.StructuredComparision.EQUALS), ComparableInputTypeStrategyTests.structuredType("type", Collections.singletonList(DataTypes.INT()), StructuredType.StructuredComparision.EQUALS)}).expectArgumentTypes(new AbstractDataType[]{ComparableInputTypeStrategyTests.structuredType("type", Collections.singletonList(DataTypes.INT()), StructuredType.StructuredComparision.EQUALS), ComparableInputTypeStrategyTests.structuredType("type", Collections.singletonList(DataTypes.INT()), StructuredType.StructuredComparision.EQUALS)}), InputTypeStrategiesTestBase.TestSpec.forStrategy("Comparable arrays of structured types", InputTypeStrategies.TWO_EQUALS_COMPARABLE).calledWithArgumentTypes(new AbstractDataType[]{DataTypes.ARRAY((DataType)((DataType)ComparableInputTypeStrategyTests.structuredType("type", Collections.singletonList(DataTypes.INT()), StructuredType.StructuredComparision.EQUALS).notNull())), DataTypes.ARRAY((DataType)((DataType)ComparableInputTypeStrategyTests.structuredType("type", Collections.singletonList(DataTypes.INT()), StructuredType.StructuredComparision.EQUALS).nullable()))}).expectArgumentTypes(new AbstractDataType[]{DataTypes.ARRAY((DataType)((DataType)ComparableInputTypeStrategyTests.structuredType("type", Collections.singletonList(DataTypes.INT()), StructuredType.StructuredComparision.EQUALS).notNull())), DataTypes.ARRAY((DataType)((DataType)ComparableInputTypeStrategyTests.structuredType("type", Collections.singletonList(DataTypes.INT()), StructuredType.StructuredComparision.EQUALS).nullable()))}), InputTypeStrategiesTestBase.TestSpec.forStrategy("Distinct types are comparable if the source type is comparable", InputTypeStrategies.TWO_EQUALS_COMPARABLE).calledWithArgumentTypes(ComparableInputTypeStrategyTests.distinctType("type", DataTypes.INT()).notNull(), ComparableInputTypeStrategyTests.distinctType("type", DataTypes.INT()).nullable()).expectArgumentTypes(ComparableInputTypeStrategyTests.distinctType("type", DataTypes.INT()).notNull(), ComparableInputTypeStrategyTests.distinctType("type", DataTypes.INT()).nullable()), InputTypeStrategiesTestBase.TestSpec.forStrategy("Comparable multisets of distinct types", InputTypeStrategies.TWO_EQUALS_COMPARABLE).calledWithArgumentTypes(new AbstractDataType[]{DataTypes.MULTISET((DataType)((DataType)ComparableInputTypeStrategyTests.distinctType("type", DataTypes.INT()).notNull())), DataTypes.MULTISET((DataType)((DataType)ComparableInputTypeStrategyTests.distinctType("type", DataTypes.INT()).nullable()))}).expectArgumentTypes(new AbstractDataType[]{DataTypes.MULTISET((DataType)((DataType)ComparableInputTypeStrategyTests.distinctType("type", DataTypes.INT()).notNull())), DataTypes.MULTISET((DataType)((DataType)ComparableInputTypeStrategyTests.distinctType("type", DataTypes.INT()).nullable()))}), InputTypeStrategiesTestBase.TestSpec.forStrategy("Everything is comparable with null type", InputTypeStrategies.TWO_EQUALS_COMPARABLE).calledWithArgumentTypes(new AbstractDataType[]{DataTypes.INT(), DataTypes.NULL()}).expectArgumentTypes(new AbstractDataType[]{DataTypes.INT(), DataTypes.NULL()}), InputTypeStrategiesTestBase.TestSpec.forStrategy("RAW types are comparable if the originating class implements Comparable", InputTypeStrategies.TWO_EQUALS_COMPARABLE).calledWithArgumentTypes(ComparableInputTypeStrategyTests.rawType(ComparableClass.class).notNull(), ComparableInputTypeStrategyTests.rawType(ComparableClass.class).nullable()).expectArgumentTypes(ComparableInputTypeStrategyTests.rawType(ComparableClass.class).notNull(), ComparableInputTypeStrategyTests.rawType(ComparableClass.class).nullable()), InputTypeStrategiesTestBase.TestSpec.forStrategy("Comparable map of raw types", InputTypeStrategies.TWO_EQUALS_COMPARABLE).calledWithArgumentTypes(new AbstractDataType[]{DataTypes.MAP((DataType)((DataType)ComparableInputTypeStrategyTests.rawType(ComparableClass.class).notNull()), (DataType)ComparableInputTypeStrategyTests.rawType(ComparableClass.class)), DataTypes.MAP((DataType)((DataType)ComparableInputTypeStrategyTests.rawType(ComparableClass.class).nullable()), (DataType)ComparableInputTypeStrategyTests.rawType(ComparableClass.class))}).expectArgumentTypes(new AbstractDataType[]{DataTypes.MAP((DataType)((DataType)ComparableInputTypeStrategyTests.rawType(ComparableClass.class).notNull()), (DataType)ComparableInputTypeStrategyTests.rawType(ComparableClass.class)), DataTypes.MAP((DataType)((DataType)ComparableInputTypeStrategyTests.rawType(ComparableClass.class).nullable()), (DataType)ComparableInputTypeStrategyTests.rawType(ComparableClass.class))}), InputTypeStrategiesTestBase.TestSpec.forStrategy("RAW types are not comparable if the originating class does not implement Comparable", InputTypeStrategies.TWO_EQUALS_COMPARABLE).calledWithArgumentTypes(new AbstractDataType[]{ComparableInputTypeStrategyTests.rawType(NotComparableClass.class), ComparableInputTypeStrategyTests.rawType(NotComparableClass.class)}).expectErrorMessage(String.format("All types in a comparison should support 'EQUALS' comparison with each other. Can not compare RAW('%s', '...') with RAW('%s', '...')", NotComparableClass.class.getName(), NotComparableClass.class.getName())), InputTypeStrategiesTestBase.TestSpec.forStrategy("RAW types are not comparable if the types are different", InputTypeStrategies.TWO_EQUALS_COMPARABLE).calledWithArgumentTypes(new AbstractDataType[]{ComparableInputTypeStrategyTests.rawType(NotComparableClass.class), DataTypes.RAW((TypeInformation)TypeInformation.of(NotComparableClass.class))}).expectErrorMessage(String.format("All types in a comparison should support 'EQUALS' comparison with each other. Can not compare RAW('%s', '...') with RAW('%s', ?)", NotComparableClass.class.getName(), NotComparableClass.class.getName())), InputTypeStrategiesTestBase.TestSpec.forStrategy("Not fully comparable structured types", InputTypeStrategies.TWO_FULLY_COMPARABLE).calledWithArgumentTypes(new AbstractDataType[]{ComparableInputTypeStrategyTests.structuredType("type", Collections.singletonList(DataTypes.INT()), StructuredType.StructuredComparision.EQUALS), ComparableInputTypeStrategyTests.structuredType("type", Collections.singletonList(DataTypes.INT()), StructuredType.StructuredComparision.EQUALS)}).expectErrorMessage("All types in a comparison should support both 'EQUALS' and 'ORDER' comparison with each other. Can not compare `cat`.`db`.`type` with `cat`.`db`.`type`"), InputTypeStrategiesTestBase.TestSpec.forStrategy("Two different structured types are not comparable", InputTypeStrategies.TWO_EQUALS_COMPARABLE).calledWithArgumentTypes(new AbstractDataType[]{ComparableInputTypeStrategyTests.structuredType("type1", Collections.singletonList(DataTypes.INT()), StructuredType.StructuredComparision.EQUALS), ComparableInputTypeStrategyTests.structuredType("type2", Collections.singletonList(DataTypes.INT()), StructuredType.StructuredComparision.EQUALS)}).expectErrorMessage("All types in a comparison should support 'EQUALS' comparison with each other. Can not compare `cat`.`db`.`type1` with `cat`.`db`.`type2`"), InputTypeStrategiesTestBase.TestSpec.forStrategy("Two different different distinct types are not comparable even if point to the same type", InputTypeStrategies.TWO_EQUALS_COMPARABLE).calledWithArgumentTypes(new AbstractDataType[]{ComparableInputTypeStrategyTests.distinctType("type1", DataTypes.INT()), ComparableInputTypeStrategyTests.distinctType("type2", DataTypes.INT())}).expectErrorMessage("All types in a comparison should support 'EQUALS' comparison with each other. Can not compare `cat`.`db`.`type1` with `cat`.`db`.`type2`"), InputTypeStrategiesTestBase.TestSpec.forStrategy("Not comparable array types", InputTypeStrategies.TWO_FULLY_COMPARABLE).calledWithArgumentTypes(new AbstractDataType[]{DataTypes.ARRAY((DataType)DataTypes.TINYINT()), DataTypes.ARRAY((DataType)DataTypes.VARCHAR((int)2))}).expectErrorMessage("All types in a comparison should support both 'EQUALS' and 'ORDER' comparison with each other. Can not compare ARRAY<TINYINT> with ARRAY<VARCHAR(2)>"), InputTypeStrategiesTestBase.TestSpec.forStrategy("Not comparable key types in map types", InputTypeStrategies.TWO_FULLY_COMPARABLE).calledWithArgumentTypes(new AbstractDataType[]{DataTypes.MAP((DataType)DataTypes.TINYINT(), (DataType)DataTypes.TIMESTAMP()), DataTypes.MAP((DataType)DataTypes.VARCHAR((int)3), (DataType)DataTypes.TIMESTAMP_WITH_TIME_ZONE())}).expectErrorMessage("All types in a comparison should support both 'EQUALS' and 'ORDER' comparison with each other. Can not compare MAP<TINYINT, TIMESTAMP(6)> with MAP<VARCHAR(3), TIMESTAMP(6) WITH TIME ZONE>"), InputTypeStrategiesTestBase.TestSpec.forStrategy("Not comparable value types in map types", InputTypeStrategies.TWO_FULLY_COMPARABLE).calledWithArgumentTypes(new AbstractDataType[]{DataTypes.MAP((DataType)DataTypes.TINYINT(), (DataType)DataTypes.TIMESTAMP()), DataTypes.MAP((DataType)DataTypes.DECIMAL((int)10, (int)3), (DataType)DataTypes.INT())}).expectErrorMessage("All types in a comparison should support both 'EQUALS' and 'ORDER' comparison with each other. Can not compare MAP<TINYINT, TIMESTAMP(6)> with MAP<DECIMAL(10, 3), INT>"), InputTypeStrategiesTestBase.TestSpec.forStrategy("Not comparable types", InputTypeStrategies.TWO_FULLY_COMPARABLE).calledWithArgumentTypes(new AbstractDataType[]{DataTypes.TIMESTAMP(), DataTypes.BIGINT()}).expectErrorMessage("All types in a comparison should support both 'EQUALS' and 'ORDER' comparison with each other. Can not compare TIMESTAMP(6) with BIGINT"));
    }

    private static <T> DataType rawType(Class<T> clazz) {
        return DataTypes.RAW(clazz, (TypeSerializer)new KryoSerializer(clazz, new ExecutionConfig()));
    }

    private static DataType distinctType(String typeName, DataType sourceType) {
        return new AtomicDataType((LogicalType)DistinctType.newBuilder((ObjectIdentifier)ObjectIdentifier.of((String)"cat", (String)"db", (String)typeName), (LogicalType)sourceType.getLogicalType()).build(), sourceType.getConversionClass());
    }

    private static DataType structuredType(String typeName, List<DataType> fieldDataTypes, StructuredType.StructuredComparision comparision) {
        return new FieldsDataType((LogicalType)StructuredType.newBuilder((ObjectIdentifier)ObjectIdentifier.of((String)"cat", (String)"db", (String)typeName)).attributes(IntStream.range(0, fieldDataTypes.size()).mapToObj(idx -> new StructuredType.StructuredAttribute("f" + idx, ((DataType)fieldDataTypes.get(idx)).getLogicalType())).collect(Collectors.toList())).comparision(comparision).build(), fieldDataTypes);
    }

    private static class NotComparableClass {
        private NotComparableClass() {
        }
    }

    private static class ComparableClass
    implements Comparable<ComparableClass> {
        private ComparableClass() {
        }

        @Override
        public int compareTo(@Nonnull ComparableClass o) {
            return 0;
        }
    }
}

