/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.factories;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.core.testutils.FlinkMatchers;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.factories.DeserializationFormatFactory;
import org.apache.flink.table.factories.DynamicTableFactory;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.factories.TestConflictingDynamicTableFactory1;
import org.apache.flink.table.factories.TestConflictingDynamicTableFactory2;
import org.apache.flink.table.factories.TestDynamicTableFactory;
import org.apache.flink.table.factories.TestFormatFactory;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class FactoryUtilTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void testMissingConnector() {
        this.expectError("Table options do not contain an option key 'connector' for discovering a connector.");
        FactoryUtilTest.testError(options -> {
            String cfr_ignored_0 = (String)options.remove("connector");
        });
    }

    @Test
    public void testInvalidConnector() {
        this.expectError("Could not find any factory for identifier 'FAIL' that implements '" + DynamicTableFactory.class.getName() + "' in the classpath.\n\nAvailable factory identifiers are:\n\nconflicting\nsink-only\nsource-only\ntest\ntest-connector");
        FactoryUtilTest.testError(options -> options.put("connector", "FAIL"));
    }

    @Test
    public void testConflictingConnector() {
        this.expectError("Multiple factories for identifier 'conflicting' that implement '" + DynamicTableFactory.class.getName() + "' found in the classpath.\n\nAmbiguous factory classes are:\n\n" + TestConflictingDynamicTableFactory1.class.getName() + "\n" + TestConflictingDynamicTableFactory2.class.getName());
        FactoryUtilTest.testError(options -> options.put("connector", "conflicting"));
    }

    @Test
    public void testMissingConnectorOption() {
        this.expectError("One or more required options are missing.\n\nMissing required options are:\n\ntarget");
        FactoryUtilTest.testError(options -> {
            String cfr_ignored_0 = (String)options.remove("target");
        });
    }

    @Test
    public void testInvalidConnectorOption() {
        this.expectError("Invalid value for option 'buffer-size'.");
        FactoryUtilTest.testError(options -> options.put("buffer-size", "FAIL"));
    }

    @Test
    public void testMissingFormat() {
        this.expectError("Could not find required scan format 'value.format'.");
        FactoryUtilTest.testError(options -> {
            String cfr_ignored_0 = (String)options.remove("value.format");
        });
    }

    @Test
    public void testInvalidFormat() {
        this.expectError("Could not find any factory for identifier 'FAIL' that implements '" + DeserializationFormatFactory.class.getName() + "' in the classpath.\n\nAvailable factory identifiers are:\n\ntest-format");
        FactoryUtilTest.testError(options -> options.put("value.format", "FAIL"));
    }

    @Test
    public void testMissingFormatOption() {
        this.expectError("Error creating scan format 'test-format' in option space 'key.test-format.'.");
        this.expectError("One or more required options are missing.\n\nMissing required options are:\n\ndelimiter");
        FactoryUtilTest.testError(options -> {
            String cfr_ignored_0 = (String)options.remove("key.test-format.delimiter");
        });
    }

    @Test
    public void testInvalidFormatOption() {
        this.expectError("Invalid value for option 'fail-on-missing'.");
        FactoryUtilTest.testError(options -> options.put("key.test-format.fail-on-missing", "FAIL"));
    }

    @Test
    public void testUnconsumedOption() {
        this.expectError("Unsupported options found for connector 'test-connector'.\n\nUnsupported options:\n\nthis-is-also-not-consumed\nthis-is-not-consumed\n\nSupported options:\n\nbuffer-size\nconnector\nformat\nkey.format\nkey.test-format.changelog-mode\nkey.test-format.delimiter\nkey.test-format.fail-on-missing\nkey.test-format.readable-metadata\nproperty-version\ntarget\nvalue.format\nvalue.test-format.changelog-mode\nvalue.test-format.delimiter\nvalue.test-format.fail-on-missing\nvalue.test-format.readable-metadata");
        FactoryUtilTest.testError(options -> {
            options.put("this-is-not-consumed", "42");
            options.put("this-is-also-not-consumed", "true");
        });
    }

    @Test
    public void testAllOptions() {
        Map<String, String> options = FactoryUtilTest.createAllOptions();
        DynamicTableSource actualSource = FactoryUtilTest.createTableSource(options);
        TestDynamicTableFactory.DynamicTableSourceMock expectedSource = new TestDynamicTableFactory.DynamicTableSourceMock("MyTarget", new TestFormatFactory.DecodingFormatMock(",", false), new TestFormatFactory.DecodingFormatMock("|", true));
        Assert.assertEquals((Object)expectedSource, (Object)actualSource);
        DynamicTableSink actualSink = FactoryUtilTest.createTableSink(options);
        TestDynamicTableFactory.DynamicTableSinkMock expectedSink = new TestDynamicTableFactory.DynamicTableSinkMock("MyTarget", 1000L, new TestFormatFactory.EncodingFormatMock(","), new TestFormatFactory.EncodingFormatMock("|"));
        Assert.assertEquals((Object)expectedSink, (Object)actualSink);
    }

    @Test
    public void testDiscoveryForSeparateSourceSinkFactory() {
        Map<String, String> options = FactoryUtilTest.createAllOptions();
        options.put("connector", "test");
        DynamicTableSource actualSource = FactoryUtilTest.createTableSource(options);
        TestDynamicTableFactory.DynamicTableSourceMock expectedSource = new TestDynamicTableFactory.DynamicTableSourceMock("MyTarget", new TestFormatFactory.DecodingFormatMock(",", false), new TestFormatFactory.DecodingFormatMock("|", true));
        Assert.assertEquals((Object)expectedSource, (Object)actualSource);
        DynamicTableSink actualSink = FactoryUtilTest.createTableSink(options);
        TestDynamicTableFactory.DynamicTableSinkMock expectedSink = new TestDynamicTableFactory.DynamicTableSinkMock("MyTarget", 1000L, new TestFormatFactory.EncodingFormatMock(","), new TestFormatFactory.EncodingFormatMock("|"));
        Assert.assertEquals((Object)expectedSink, (Object)actualSink);
    }

    @Test
    public void testOptionalFormat() {
        Map<String, String> options = FactoryUtilTest.createAllOptions();
        options.remove("key.format");
        options.remove("key.test-format.delimiter");
        DynamicTableSource actualSource = FactoryUtilTest.createTableSource(options);
        TestDynamicTableFactory.DynamicTableSourceMock expectedSource = new TestDynamicTableFactory.DynamicTableSourceMock("MyTarget", null, new TestFormatFactory.DecodingFormatMock("|", true));
        Assert.assertEquals((Object)expectedSource, (Object)actualSource);
        DynamicTableSink actualSink = FactoryUtilTest.createTableSink(options);
        TestDynamicTableFactory.DynamicTableSinkMock expectedSink = new TestDynamicTableFactory.DynamicTableSinkMock("MyTarget", 1000L, null, new TestFormatFactory.EncodingFormatMock("|"));
        Assert.assertEquals((Object)expectedSink, (Object)actualSink);
    }

    @Test
    public void testAlternativeValueFormat() {
        Map<String, String> options = FactoryUtilTest.createAllOptions();
        options.remove("value.format");
        options.remove("value.test-format.delimiter");
        options.remove("value.test-format.fail-on-missing");
        options.put("format", "test-format");
        options.put("test-format.delimiter", ";");
        options.put("test-format.fail-on-missing", "true");
        DynamicTableSource actualSource = FactoryUtilTest.createTableSource(options);
        TestDynamicTableFactory.DynamicTableSourceMock expectedSource = new TestDynamicTableFactory.DynamicTableSourceMock("MyTarget", new TestFormatFactory.DecodingFormatMock(",", false), new TestFormatFactory.DecodingFormatMock(";", true));
        Assert.assertEquals((Object)expectedSource, (Object)actualSource);
        DynamicTableSink actualSink = FactoryUtilTest.createTableSink(options);
        TestDynamicTableFactory.DynamicTableSinkMock expectedSink = new TestDynamicTableFactory.DynamicTableSinkMock("MyTarget", 1000L, new TestFormatFactory.EncodingFormatMock(","), new TestFormatFactory.EncodingFormatMock(";"));
        Assert.assertEquals((Object)expectedSink, (Object)actualSink);
    }

    @Test
    public void testConnectorErrorHint() {
        String errorMsg;
        try {
            FactoryUtilTest.createTableSource(Collections.singletonMap("connector", "sink-only"));
            Assert.fail();
        }
        catch (Exception e) {
            errorMsg = "Connector 'sink-only' can only be used as a sink. It cannot be used as a source.";
            Assert.assertThat((Object)e, (Matcher)FlinkMatchers.containsCause((Throwable)new ValidationException(errorMsg)));
        }
        try {
            FactoryUtilTest.createTableSink(Collections.singletonMap("connector", "source-only"));
            Assert.fail();
        }
        catch (Exception e) {
            errorMsg = "Connector 'source-only' can only be used as a source. It cannot be used as a sink.";
            Assert.assertThat((Object)e, (Matcher)FlinkMatchers.containsCause((Throwable)new ValidationException(errorMsg)));
        }
    }

    private void expectError(String message) {
        this.thrown.expect(ValidationException.class);
        this.thrown.expect(FlinkMatchers.containsCause((Throwable)new ValidationException(message)));
    }

    private static void testError(Consumer<Map<String, String>> optionModifier) {
        Map<String, String> options = FactoryUtilTest.createAllOptions();
        optionModifier.accept(options);
        FactoryUtilTest.createTableSource(options);
    }

    private static Map<String, String> createAllOptions() {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("property-version", "1");
        options.put("connector", "test-connector");
        options.put("target", "MyTarget");
        options.put("buffer-size", "1000");
        options.put("key.format", "test-format");
        options.put("key.test-format.delimiter", ",");
        options.put("value.format", "test-format");
        options.put("value.test-format.delimiter", "|");
        options.put("value.test-format.fail-on-missing", "true");
        return options;
    }

    private static DynamicTableSource createTableSource(Map<String, String> options) {
        return FactoryUtil.createTableSource(null, (ObjectIdentifier)ObjectIdentifier.of((String)"cat", (String)"db", (String)"table"), (CatalogTable)new CatalogTableMock(options), (ReadableConfig)new Configuration(), (ClassLoader)FactoryUtilTest.class.getClassLoader(), (boolean)false);
    }

    private static DynamicTableSink createTableSink(Map<String, String> options) {
        return FactoryUtil.createTableSink(null, (ObjectIdentifier)ObjectIdentifier.of((String)"cat", (String)"db", (String)"table"), (CatalogTable)new CatalogTableMock(options), (ReadableConfig)new Configuration(), (ClassLoader)FactoryUtilTest.class.getClassLoader(), (boolean)false);
    }

    private static class CatalogTableMock
    implements CatalogTable {
        final Map<String, String> options;

        CatalogTableMock(Map<String, String> options) {
            this.options = options;
        }

        public boolean isPartitioned() {
            return false;
        }

        public List<String> getPartitionKeys() {
            return null;
        }

        public CatalogTable copy(Map<String, String> options) {
            return null;
        }

        public Map<String, String> toProperties() {
            return null;
        }

        public Map<String, String> getProperties() {
            return this.options;
        }

        public Map<String, String> getOptions() {
            return this.options;
        }

        public TableSchema getSchema() {
            return null;
        }

        public String getComment() {
            return null;
        }

        public CatalogBaseTable copy() {
            return null;
        }

        public Optional<String> getDescription() {
            return Optional.empty();
        }

        public Optional<String> getDetailedDescription() {
            return Optional.empty();
        }
    }
}

