/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.utils;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.TableColumn;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.sources.DefinedProctimeAttribute;
import org.apache.flink.table.sources.DefinedRowtimeAttributes;
import org.apache.flink.table.sources.RowtimeAttributeDescriptor;
import org.apache.flink.table.sources.TableSource;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.LegacyTypeInformationType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeFamily;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.VarBinaryType;
import org.apache.flink.table.types.logical.VarCharType;
import org.apache.flink.table.types.logical.utils.LogicalTypeChecks;
import org.apache.flink.table.types.logical.utils.LogicalTypeDefaultVisitor;
import org.apache.flink.table.types.utils.DataTypeUtils;

@Internal
public final class TypeMappingUtils {
    public static int[] computePhysicalIndices(List<TableColumn> logicalColumns, DataType physicalType, Function<String, String> nameRemapping) {
        Map<TableColumn, Integer> physicalIndexLookup = TypeMappingUtils.computePhysicalIndices(logicalColumns.stream(), physicalType, nameRemapping);
        return logicalColumns.stream().mapToInt(physicalIndexLookup::get).toArray();
    }

    public static int[] computePhysicalIndicesOrTimeAttributeMarkers(TableSource<?> tableSource, List<TableColumn> logicalColumns, boolean streamMarkers, Function<String, String> nameRemapping) {
        Optional<String> proctimeAttribute = TypeMappingUtils.getProctimeAttribute(tableSource);
        List<String> rowtimeAttributes = TypeMappingUtils.getRowtimeAttributes(tableSource);
        List columnsWithoutTimeAttributes = logicalColumns.stream().filter(col -> !rowtimeAttributes.contains(col.getName()) && proctimeAttribute.map(attr -> !attr.equals(col.getName())).orElse(true) != false).collect(Collectors.toList());
        Map<TableColumn, Integer> columnsToPhysicalIndices = TypeMappingUtils.computePhysicalIndices(columnsWithoutTimeAttributes.stream(), tableSource.getProducedDataType(), nameRemapping);
        return logicalColumns.stream().mapToInt(logicalColumn -> {
            if (proctimeAttribute.map(attr -> attr.equals(logicalColumn.getName())).orElse(false).booleanValue()) {
                TypeMappingUtils.verifyTimeAttributeType(logicalColumn, "Proctime");
                if (streamMarkers) {
                    return -2;
                }
                return -4;
            }
            if (rowtimeAttributes.contains(logicalColumn.getName())) {
                TypeMappingUtils.verifyTimeAttributeType(logicalColumn, "Rowtime");
                if (streamMarkers) {
                    return -1;
                }
                return -3;
            }
            return (Integer)columnsToPhysicalIndices.get(logicalColumn);
        }).toArray();
    }

    public static void checkPhysicalLogicalTypeCompatible(LogicalType physicalFieldType, LogicalType logicalFieldType, String physicalFieldName, String logicalFieldName, boolean isSource) {
        Function<Throwable, ValidationException> exceptionSupplier = cause -> new ValidationException(String.format("Type %s of table field '%s' does not match with the physical type %s of the '%s' field of the %s type.", logicalFieldType, logicalFieldName, physicalFieldType, physicalFieldName, isSource ? "TableSource return" : "TableSink consumed"), (Throwable)cause);
        try {
            boolean typesCompatible = isSource ? TypeMappingUtils.checkIfCompatible(physicalFieldType, logicalFieldType) : TypeMappingUtils.checkIfCompatible(logicalFieldType, physicalFieldType);
            if (!typesCompatible) {
                throw exceptionSupplier.apply(null);
            }
        }
        catch (Exception e) {
            throw exceptionSupplier.apply(e);
        }
    }

    private static void verifyTimeAttributeType(TableColumn logicalColumn, String rowtimeOrProctime) {
        if (!LogicalTypeChecks.hasFamily(logicalColumn.getType().getLogicalType(), LogicalTypeFamily.TIMESTAMP)) {
            throw new ValidationException(String.format("%s field '%s' has invalid type %s. %s attributes must be of a Timestamp family.", rowtimeOrProctime, logicalColumn.getName(), logicalColumn.getType(), rowtimeOrProctime));
        }
    }

    private static Map<TableColumn, Integer> computePhysicalIndices(Stream<TableColumn> columns, DataType physicalType, Function<String, String> nameRemappingFunction) {
        if (LogicalTypeChecks.isCompositeType(physicalType.getLogicalType())) {
            TableSchema physicalSchema = DataTypeUtils.expandCompositeTypeToSchema(physicalType);
            return TypeMappingUtils.computeInCompositeType(columns, physicalSchema, TypeMappingUtils.wrapWithNotNullCheck(nameRemappingFunction));
        }
        return TypeMappingUtils.computeInSimpleType(columns, physicalType);
    }

    private static Function<String, String> wrapWithNotNullCheck(Function<String, String> nameRemapping) {
        return name -> {
            String resolvedFieldName = (String)nameRemapping.apply((String)name);
            if (resolvedFieldName == null) {
                throw new ValidationException(String.format("Field '%s' could not be resolved by the field mapping.", name));
            }
            return resolvedFieldName;
        };
    }

    private static Map<TableColumn, Integer> computeInCompositeType(Stream<TableColumn> columns, TableSchema physicalSchema, Function<String, String> nameRemappingFunction) {
        return columns.collect(Collectors.toMap(Function.identity(), column -> {
            String remappedName = (String)nameRemappingFunction.apply(column.getName());
            int idx = IntStream.range(0, physicalSchema.getFieldCount()).filter(i -> physicalSchema.getFieldName(i).get().equals(remappedName)).findFirst().orElseThrow(() -> new ValidationException(String.format("Could not map %s column to the underlying physical type %s. No such field.", column.getName(), physicalSchema)));
            LogicalType physicalFieldType = physicalSchema.getFieldDataType(idx).get().getLogicalType();
            LogicalType logicalFieldType = column.getType().getLogicalType();
            TypeMappingUtils.checkPhysicalLogicalTypeCompatible(physicalFieldType, logicalFieldType, remappedName, column.getName(), true);
            return idx;
        }));
    }

    private static boolean checkIfCompatible(final LogicalType sourceType, final LogicalType targetType) {
        if (LogicalTypeChecks.areTypesCompatible(sourceType, targetType)) {
            return true;
        }
        Boolean targetTypeCompatible = targetType.accept(new LogicalTypeDefaultVisitor<Boolean>(){

            @Override
            public Boolean visit(VarCharType targetType) {
                if (sourceType.isNullable() && !targetType.isNullable()) {
                    return false;
                }
                if ((LogicalTypeChecks.hasRoot(sourceType, LogicalTypeRoot.CHAR) || LogicalTypeChecks.hasRoot(sourceType, LogicalTypeRoot.VARCHAR)) && LogicalTypeChecks.getLength(sourceType) <= targetType.getLength()) {
                    return true;
                }
                return this.defaultMethod(targetType);
            }

            @Override
            public Boolean visit(VarBinaryType targetType) {
                if (sourceType.isNullable() && !targetType.isNullable()) {
                    return false;
                }
                if ((LogicalTypeChecks.hasRoot(sourceType, LogicalTypeRoot.BINARY) || LogicalTypeChecks.hasRoot(sourceType, LogicalTypeRoot.VARBINARY)) && LogicalTypeChecks.getLength(sourceType) <= targetType.getLength()) {
                    return true;
                }
                return this.defaultMethod(targetType);
            }

            @Override
            protected Boolean defaultMethod(LogicalType logicalType) {
                return false;
            }
        });
        if (targetTypeCompatible.booleanValue()) {
            return true;
        }
        return sourceType.accept(new LogicalTypeDefaultVisitor<Boolean>(){

            @Override
            public Boolean visit(DecimalType sourceType1) {
                if (targetType instanceof LegacyTypeInformationType && targetType.getTypeRoot() == LogicalTypeRoot.DECIMAL) {
                    return true;
                }
                return this.defaultMethod(sourceType1);
            }

            @Override
            public Boolean visit(LogicalType other) {
                if (other instanceof LegacyTypeInformationType && other.getTypeRoot() == LogicalTypeRoot.DECIMAL) {
                    if (!(targetType instanceof DecimalType)) {
                        return false;
                    }
                    DecimalType logicalDecimalType = (DecimalType)targetType;
                    if (logicalDecimalType.getPrecision() != 38 || logicalDecimalType.getScale() != 18) {
                        throw new ValidationException("Legacy decimal type can only be mapped to DECIMAL(38, 18).");
                    }
                    return true;
                }
                return this.defaultMethod(other);
            }

            @Override
            protected Boolean defaultMethod(LogicalType logicalType) {
                return false;
            }
        });
    }

    private static Map<TableColumn, Integer> computeInSimpleType(Stream<TableColumn> columns, DataType physicalType) {
        Map<TableColumn, Integer> indices = columns.collect(Collectors.toMap(Function.identity(), col -> 0));
        if (indices.keySet().size() > 1) {
            throw new ValidationException(String.format("More than one table field matched to atomic input type %s.)", physicalType));
        }
        return indices;
    }

    private static List<String> getRowtimeAttributes(TableSource<?> tableSource) {
        if (tableSource instanceof DefinedRowtimeAttributes) {
            return ((DefinedRowtimeAttributes)((Object)tableSource)).getRowtimeAttributeDescriptors().stream().map(RowtimeAttributeDescriptor::getAttributeName).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private static Optional<String> getProctimeAttribute(TableSource<?> tableSource) {
        if (tableSource instanceof DefinedProctimeAttribute) {
            return Optional.ofNullable(((DefinedProctimeAttribute)((Object)tableSource)).getProctimeAttribute());
        }
        return Optional.empty();
    }

    private TypeMappingUtils() {
    }
}

