/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types;

import javax.annotation.Nullable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.DataTypeVisitor;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public final class AtomicDataType
extends DataType {
    public AtomicDataType(LogicalType logicalType, @Nullable Class<?> conversionClass) {
        super(logicalType, conversionClass);
    }

    public AtomicDataType(LogicalType logicalType) {
        super(logicalType, null);
    }

    @Override
    public DataType notNull() {
        return new AtomicDataType(this.logicalType.copy(false), this.conversionClass);
    }

    @Override
    public DataType nullable() {
        return new AtomicDataType(this.logicalType.copy(true), this.conversionClass);
    }

    @Override
    public DataType bridgedTo(Class<?> newConversionClass) {
        return new AtomicDataType(this.logicalType, (Class)Preconditions.checkNotNull(newConversionClass, (String)"New conversion class must not be null."));
    }

    @Override
    public <R> R accept(DataTypeVisitor<R> visitor) {
        return visitor.visit(this);
    }
}

