/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogFunction;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.FunctionLookup;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.catalog.UnresolvedIdentifier;
import org.apache.flink.table.catalog.exceptions.DatabaseNotExistException;
import org.apache.flink.table.catalog.exceptions.FunctionNotExistException;
import org.apache.flink.table.delegation.PlannerTypeInferenceUtil;
import org.apache.flink.table.factories.FunctionDefinitionFactory;
import org.apache.flink.table.functions.AggregateFunction;
import org.apache.flink.table.functions.AggregateFunctionDefinition;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.functions.FunctionDefinitionUtil;
import org.apache.flink.table.functions.FunctionIdentifier;
import org.apache.flink.table.functions.ScalarFunction;
import org.apache.flink.table.functions.ScalarFunctionDefinition;
import org.apache.flink.table.functions.TableAggregateFunction;
import org.apache.flink.table.functions.TableAggregateFunctionDefinition;
import org.apache.flink.table.functions.TableFunction;
import org.apache.flink.table.functions.TableFunctionDefinition;
import org.apache.flink.table.functions.UserDefinedAggregateFunction;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.functions.UserDefinedFunctionHelper;
import org.apache.flink.table.module.ModuleManager;
import org.apache.flink.util.Preconditions;

@Internal
public class FunctionCatalog
implements FunctionLookup {
    private final TableConfig config;
    private final CatalogManager catalogManager;
    private final ModuleManager moduleManager;
    private final Map<String, FunctionDefinition> tempSystemFunctions = new LinkedHashMap<String, FunctionDefinition>();
    private final Map<ObjectIdentifier, FunctionDefinition> tempCatalogFunctions = new LinkedHashMap<ObjectIdentifier, FunctionDefinition>();
    private PlannerTypeInferenceUtil plannerTypeInferenceUtil;

    public FunctionCatalog(TableConfig config, CatalogManager catalogManager, ModuleManager moduleManager) {
        this.config = (TableConfig)Preconditions.checkNotNull((Object)config);
        this.catalogManager = (CatalogManager)Preconditions.checkNotNull((Object)catalogManager);
        this.moduleManager = (ModuleManager)Preconditions.checkNotNull((Object)moduleManager);
    }

    public void setPlannerTypeInferenceUtil(PlannerTypeInferenceUtil plannerTypeInferenceUtil) {
        this.plannerTypeInferenceUtil = plannerTypeInferenceUtil;
    }

    public void registerTempSystemScalarFunction(String name, ScalarFunction function) {
        UserDefinedFunctionHelper.prepareFunction(this.config, (UserDefinedFunction)function);
        this.registerTempSystemFunction(name, (FunctionDefinition)new ScalarFunctionDefinition(name, function));
    }

    public <T> void registerTempSystemTableFunction(String name, TableFunction<T> function, TypeInformation<T> resultType) {
        UserDefinedFunctionHelper.prepareFunction(this.config, function);
        this.registerTempSystemFunction(name, (FunctionDefinition)new TableFunctionDefinition(name, function, resultType));
    }

    public <T, ACC> void registerTempSystemAggregateFunction(String name, UserDefinedAggregateFunction<T, ACC> function, TypeInformation<T> resultType, TypeInformation<ACC> accType) {
        AggregateFunctionDefinition definition;
        UserDefinedFunctionHelper.prepareFunction(this.config, function);
        if (function instanceof AggregateFunction) {
            definition = new AggregateFunctionDefinition(name, (AggregateFunction)function, resultType, accType);
        } else if (function instanceof TableAggregateFunction) {
            definition = new TableAggregateFunctionDefinition(name, (TableAggregateFunction)function, resultType, accType);
        } else {
            throw new TableException("Unknown function class: " + function.getClass());
        }
        this.registerTempSystemFunction(name, (FunctionDefinition)definition);
    }

    public void registerTempCatalogScalarFunction(ObjectIdentifier oi, ScalarFunction function) {
        UserDefinedFunctionHelper.prepareFunction(this.config, (UserDefinedFunction)function);
        this.registerTempCatalogFunction(oi, (FunctionDefinition)new ScalarFunctionDefinition(oi.getObjectName(), function));
    }

    public <T> void registerTempCatalogTableFunction(ObjectIdentifier oi, TableFunction<T> function, TypeInformation<T> resultType) {
        UserDefinedFunctionHelper.prepareFunction(this.config, function);
        this.registerTempCatalogFunction(oi, (FunctionDefinition)new TableFunctionDefinition(oi.getObjectName(), function, resultType));
    }

    public <T, ACC> void registerTempCatalogAggregateFunction(ObjectIdentifier oi, UserDefinedAggregateFunction<T, ACC> function, TypeInformation<T> resultType, TypeInformation<ACC> accType) {
        AggregateFunctionDefinition definition;
        UserDefinedFunctionHelper.prepareFunction(this.config, function);
        if (function instanceof AggregateFunction) {
            definition = new AggregateFunctionDefinition(oi.getObjectName(), (AggregateFunction)function, resultType, accType);
        } else if (function instanceof TableAggregateFunction) {
            definition = new TableAggregateFunctionDefinition(oi.getObjectName(), (TableAggregateFunction)function, resultType, accType);
        } else {
            throw new TableException("Unknown function class: " + function.getClass());
        }
        this.registerTempCatalogFunction(oi, (FunctionDefinition)definition);
    }

    public boolean hasTemporaryCatalogFunction(ObjectIdentifier functionIdentifier) {
        ObjectIdentifier normalizedIdentifier = FunctionIdentifier.normalizeObjectIdentifier((ObjectIdentifier)functionIdentifier);
        return this.tempCatalogFunctions.containsKey(normalizedIdentifier);
    }

    public boolean hasTemporarySystemFunction(String functionName) {
        return this.tempSystemFunctions.containsKey(functionName);
    }

    public void dropTempSystemFunction(String funcName, boolean ignoreIfNotExist) {
        String normalizedName = FunctionIdentifier.normalizeName((String)funcName);
        FunctionDefinition fd = this.tempSystemFunctions.remove(normalizedName);
        if (fd == null && !ignoreIfNotExist) {
            throw new ValidationException(String.format("Temporary system function %s doesn't exist", funcName));
        }
    }

    public void dropTempCatalogFunction(ObjectIdentifier identifier, boolean ignoreIfNotExist) {
        ObjectIdentifier normalizedName = FunctionIdentifier.normalizeObjectIdentifier((ObjectIdentifier)identifier);
        FunctionDefinition fd = this.tempCatalogFunctions.remove(normalizedName);
        if (fd == null && !ignoreIfNotExist) {
            throw new ValidationException(String.format("Temporary catalog function %s doesn't exist", identifier));
        }
    }

    public String[] getUserDefinedFunctions() {
        return this.getUserDefinedFunctionNames().toArray(new String[0]);
    }

    public String[] getFunctions() {
        Set<String> result = this.getUserDefinedFunctionNames();
        result.addAll(this.moduleManager.listFunctions());
        return result.toArray(new String[0]);
    }

    private Set<String> getUserDefinedFunctionNames() {
        HashSet<String> result = new HashSet<String>(this.tempSystemFunctions.keySet());
        String currentCatalog = this.catalogManager.getCurrentCatalog();
        String currentDatabase = this.catalogManager.getCurrentDatabase();
        result.addAll(this.tempCatalogFunctions.keySet().stream().filter(oi -> oi.getCatalogName().equals(currentCatalog) && oi.getDatabaseName().equals(currentDatabase)).map(ObjectIdentifier::getObjectName).collect(Collectors.toSet()));
        Catalog catalog = this.catalogManager.getCatalog(currentCatalog).get();
        try {
            result.addAll(catalog.listFunctions(currentDatabase));
        }
        catch (DatabaseNotExistException databaseNotExistException) {
            // empty catch block
        }
        return result;
    }

    @Override
    public Optional<FunctionLookup.Result> lookupFunction(UnresolvedIdentifier identifier) {
        if (identifier.getDatabaseName().isPresent()) {
            return this.resolvePreciseFunctionReference(this.catalogManager.qualifyIdentifier(identifier));
        }
        return this.resolveAmbiguousFunctionReference(identifier.getObjectName());
    }

    private Optional<FunctionLookup.Result> resolvePreciseFunctionReference(ObjectIdentifier oi) {
        ObjectIdentifier normalizedIdentifier = FunctionIdentifier.normalizeObjectIdentifier((ObjectIdentifier)oi);
        FunctionDefinition potentialResult = this.tempCatalogFunctions.get(normalizedIdentifier);
        if (potentialResult != null) {
            return Optional.of(new FunctionLookup.Result(FunctionIdentifier.of((ObjectIdentifier)oi), potentialResult));
        }
        Optional<Catalog> catalogOptional = this.catalogManager.getCatalog(oi.getCatalogName());
        if (catalogOptional.isPresent()) {
            Catalog catalog = catalogOptional.get();
            try {
                CatalogFunction catalogFunction = catalog.getFunction(new ObjectPath(oi.getDatabaseName(), oi.getObjectName()));
                FunctionDefinition fd = catalog.getFunctionDefinitionFactory().isPresent() ? ((FunctionDefinitionFactory)catalog.getFunctionDefinitionFactory().get()).createFunctionDefinition(oi.getObjectName(), catalogFunction) : FunctionDefinitionUtil.createFunctionDefinition(oi.getObjectName(), catalogFunction.getClassName());
                return Optional.of(new FunctionLookup.Result(FunctionIdentifier.of((ObjectIdentifier)oi), fd));
            }
            catch (FunctionNotExistException functionNotExistException) {
                // empty catch block
            }
        }
        return Optional.empty();
    }

    private Optional<FunctionLookup.Result> resolveAmbiguousFunctionReference(String funcName) {
        String normalizedName = FunctionIdentifier.normalizeName((String)funcName);
        if (this.tempSystemFunctions.containsKey(normalizedName)) {
            return Optional.of(new FunctionLookup.Result(FunctionIdentifier.of((String)funcName), this.tempSystemFunctions.get(normalizedName)));
        }
        Optional<FunctionDefinition> candidate = this.moduleManager.getFunctionDefinition(normalizedName);
        ObjectIdentifier oi = ObjectIdentifier.of((String)this.catalogManager.getCurrentCatalog(), (String)this.catalogManager.getCurrentDatabase(), (String)funcName);
        return candidate.map(fd -> Optional.of(new FunctionLookup.Result(FunctionIdentifier.of((String)funcName), (FunctionDefinition)fd))).orElseGet(() -> this.resolvePreciseFunctionReference(oi));
    }

    @Override
    public PlannerTypeInferenceUtil getPlannerTypeInferenceUtil() {
        Preconditions.checkNotNull((Object)this.plannerTypeInferenceUtil, (String)"A planner should have set the type inference utility.");
        return this.plannerTypeInferenceUtil;
    }

    private void registerTempSystemFunction(String name, FunctionDefinition functionDefinition) {
        this.tempSystemFunctions.put(FunctionIdentifier.normalizeName((String)name), functionDefinition);
    }

    private void registerTempCatalogFunction(ObjectIdentifier oi, FunctionDefinition functionDefinition) {
        this.tempCatalogFunctions.put(FunctionIdentifier.normalizeObjectIdentifier((ObjectIdentifier)oi), functionDefinition);
    }
}

