/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.sql.parser.ddl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.calcite.sql.SqlCharStringLiteral;
import org.apache.calcite.sql.SqlCreate;
import org.apache.calcite.sql.SqlDataTypeSpec;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.dialect.AnsiSqlDialect;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.pretty.SqlPrettyWriter;
import org.apache.calcite.util.ImmutableNullableList;
import org.apache.flink.sql.parser.ExtendedSqlNode;
import org.apache.flink.sql.parser.ddl.SqlTableColumn;
import org.apache.flink.sql.parser.ddl.SqlTableLike;
import org.apache.flink.sql.parser.ddl.SqlWatermark;
import org.apache.flink.sql.parser.ddl.constraint.SqlTableConstraint;
import org.apache.flink.sql.parser.error.SqlValidateException;

public class SqlCreateTable
extends SqlCreate
implements ExtendedSqlNode {
    public static final SqlSpecialOperator OPERATOR = new SqlSpecialOperator("CREATE TABLE", SqlKind.CREATE_TABLE);
    private final SqlIdentifier tableName;
    private final SqlNodeList columnList;
    private final SqlNodeList propertyList;
    private final List<SqlTableConstraint> tableConstraints;
    private final SqlNodeList partitionKeyList;
    private final SqlWatermark watermark;
    private final SqlCharStringLiteral comment;
    private final SqlTableLike tableLike;
    private final boolean isTemporary;

    public SqlCreateTable(SqlParserPos pos, SqlIdentifier tableName, SqlNodeList columnList, List<SqlTableConstraint> tableConstraints, SqlNodeList propertyList, SqlNodeList partitionKeyList, @Nullable SqlWatermark watermark, @Nullable SqlCharStringLiteral comment, @Nullable SqlTableLike tableLike, boolean isTemporary, boolean ifNotExists) {
        super((SqlOperator)OPERATOR, pos, false, ifNotExists);
        this.tableName = Objects.requireNonNull(tableName, "tableName should not be null");
        this.columnList = Objects.requireNonNull(columnList, "columnList should not be null");
        this.tableConstraints = Objects.requireNonNull(tableConstraints, "table constraints should not be null");
        this.propertyList = Objects.requireNonNull(propertyList, "propertyList should not be null");
        this.partitionKeyList = Objects.requireNonNull(partitionKeyList, "partitionKeyList should not be null");
        this.watermark = watermark;
        this.comment = comment;
        this.tableLike = tableLike;
        this.isTemporary = isTemporary;
    }

    @Nonnull
    public SqlOperator getOperator() {
        return OPERATOR;
    }

    @Nonnull
    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.of((Object)this.tableName, (Object)this.columnList, (Object)new SqlNodeList(this.tableConstraints, SqlParserPos.ZERO), (Object)this.propertyList, (Object)this.partitionKeyList, (Object)((Object)this.watermark), (Object)this.comment, (Object)this.tableLike, (Object[])new SqlNode[0]);
    }

    public SqlIdentifier getTableName() {
        return this.tableName;
    }

    public SqlNodeList getColumnList() {
        return this.columnList;
    }

    public SqlNodeList getPropertyList() {
        return this.propertyList;
    }

    public SqlNodeList getPartitionKeyList() {
        return this.partitionKeyList;
    }

    public List<SqlTableConstraint> getTableConstraints() {
        return this.tableConstraints;
    }

    public Optional<SqlWatermark> getWatermark() {
        return Optional.ofNullable(this.watermark);
    }

    public Optional<SqlCharStringLiteral> getComment() {
        return Optional.ofNullable(this.comment);
    }

    public Optional<SqlTableLike> getTableLike() {
        return Optional.ofNullable(this.tableLike);
    }

    public boolean isIfNotExists() {
        return this.ifNotExists;
    }

    public boolean isTemporary() {
        return this.isTemporary;
    }

    @Override
    public void validate() throws SqlValidateException {
        List constraints = this.getFullConstraints().stream().filter(SqlTableConstraint::isPrimaryKey).collect(Collectors.toList());
        if (constraints.size() > 1) {
            throw new SqlValidateException(((SqlTableConstraint)((Object)constraints.get(1))).getParserPosition(), "Duplicate primary key definition");
        }
        if (constraints.size() == 1) {
            Set primaryKeyColumns = Arrays.stream(((SqlTableConstraint)((Object)constraints.get(0))).getColumnNames()).collect(Collectors.toSet());
            for (SqlNode column : this.columnList) {
                SqlTableColumn tableColumn = (SqlTableColumn)column;
                if (!(tableColumn instanceof SqlTableColumn.SqlRegularColumn) || !primaryKeyColumns.contains(tableColumn.getName().getSimple())) continue;
                SqlTableColumn.SqlRegularColumn regularColumn = (SqlTableColumn.SqlRegularColumn)column;
                SqlDataTypeSpec notNullType = regularColumn.getType().withNullable(Boolean.valueOf(false));
                regularColumn.setType(notNullType);
            }
        }
        if (this.tableLike != null) {
            this.tableLike.validate();
        }
    }

    public boolean hasRegularColumnsOnly() {
        for (SqlNode column : this.columnList) {
            SqlTableColumn tableColumn = (SqlTableColumn)column;
            if (tableColumn instanceof SqlTableColumn.SqlRegularColumn) continue;
            return false;
        }
        return true;
    }

    public List<SqlTableConstraint> getFullConstraints() {
        ArrayList<SqlTableConstraint> ret = new ArrayList<SqlTableConstraint>();
        this.columnList.forEach(column -> {
            SqlTableColumn tableColumn = (SqlTableColumn)((Object)column);
            if (tableColumn instanceof SqlTableColumn.SqlRegularColumn) {
                SqlTableColumn.SqlRegularColumn regularColumn = (SqlTableColumn.SqlRegularColumn)tableColumn;
                regularColumn.getConstraint().map(ret::add);
            }
        });
        ret.addAll(this.tableConstraints);
        return ret;
    }

    public String getColumnSqlString() {
        SqlPrettyWriter writer = new SqlPrettyWriter(SqlPrettyWriter.config().withDialect(AnsiSqlDialect.DEFAULT).withAlwaysUseParentheses(true).withSelectListItemsOnSeparateLines(false).withIndentation(0));
        writer.startList("", "");
        for (SqlNode column : this.columnList) {
            writer.sep(",");
            SqlTableColumn tableColumn = (SqlTableColumn)column;
            if (tableColumn instanceof SqlTableColumn.SqlComputedColumn) {
                SqlTableColumn.SqlComputedColumn computedColumn = (SqlTableColumn.SqlComputedColumn)tableColumn;
                computedColumn.getExpr().unparse((SqlWriter)writer, 0, 0);
                writer.keyword("AS");
            }
            tableColumn.getName().unparse((SqlWriter)writer, 0, 0);
        }
        return writer.toString();
    }

    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword("CREATE");
        if (this.isTemporary()) {
            writer.keyword("TEMPORARY");
        }
        writer.keyword("TABLE");
        if (this.isIfNotExists()) {
            writer.keyword("IF NOT EXISTS");
        }
        this.tableName.unparse(writer, leftPrec, rightPrec);
        if (this.columnList.size() > 0) {
            SqlWriter.Frame frame = writer.startList(SqlWriter.FrameTypeEnum.create((String)"sds"), "(", ")");
            for (SqlNode column : this.columnList) {
                this.printIndent(writer);
                column.unparse(writer, leftPrec, rightPrec);
            }
            if (this.tableConstraints.size() > 0) {
                for (SqlTableConstraint constraint : this.tableConstraints) {
                    this.printIndent(writer);
                    constraint.unparse(writer, leftPrec, rightPrec);
                }
            }
            if (this.watermark != null) {
                this.printIndent(writer);
                this.watermark.unparse(writer, leftPrec, rightPrec);
            }
            writer.newlineAndIndent();
            writer.endList(frame);
        }
        if (this.comment != null) {
            writer.newlineAndIndent();
            writer.keyword("COMMENT");
            this.comment.unparse(writer, leftPrec, rightPrec);
        }
        if (this.partitionKeyList.size() > 0) {
            writer.newlineAndIndent();
            writer.keyword("PARTITIONED BY");
            SqlWriter.Frame partitionedByFrame = writer.startList("(", ")");
            this.partitionKeyList.unparse(writer, leftPrec, rightPrec);
            writer.endList(partitionedByFrame);
            writer.newlineAndIndent();
        }
        if (this.propertyList.size() > 0) {
            writer.keyword("WITH");
            SqlWriter.Frame withFrame = writer.startList("(", ")");
            for (SqlNode property : this.propertyList) {
                this.printIndent(writer);
                property.unparse(writer, leftPrec, rightPrec);
            }
            writer.newlineAndIndent();
            writer.endList(withFrame);
        }
        if (this.tableLike != null) {
            writer.newlineAndIndent();
            this.tableLike.unparse(writer, leftPrec, rightPrec);
        }
    }

    protected void printIndent(SqlWriter writer) {
        writer.sep(",", false);
        writer.newlineAndIndent();
        writer.print("  ");
    }

    public String[] fullTableName() {
        return (String[])this.tableName.names.toArray((Object[])new String[0]);
    }

    public static class TableCreationContext {
        public List<SqlNode> columnList = new ArrayList<SqlNode>();
        public List<SqlTableConstraint> constraints = new ArrayList<SqlTableConstraint>();
        @Nullable
        public SqlWatermark watermark;
    }
}

