/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.util;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.flink.hadoop2.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.net.CachedDNSToSwitchMapping;
import org.apache.hadoop.net.DNSToSwitchMapping;
import org.apache.hadoop.net.Node;
import org.apache.hadoop.net.NodeBase;
import org.apache.hadoop.net.ScriptBasedMapping;
import org.apache.hadoop.util.ReflectionUtils;

@InterfaceAudience.LimitedPrivate(value={"YARN", "MAPREDUCE"})
public class RackResolver {
    private static DNSToSwitchMapping dnsToSwitchMapping;
    private static boolean initCalled;
    private static final Log LOG;

    public static synchronized void init(Configuration conf) {
        if (initCalled) {
            return;
        }
        initCalled = true;
        Class<DNSToSwitchMapping> dnsToSwitchMappingClass = conf.getClass("net.topology.node.switch.mapping.impl", ScriptBasedMapping.class, DNSToSwitchMapping.class);
        try {
            DNSToSwitchMapping newInstance = ReflectionUtils.newInstance(dnsToSwitchMappingClass, conf);
            dnsToSwitchMapping = newInstance instanceof CachedDNSToSwitchMapping ? newInstance : new CachedDNSToSwitchMapping(newInstance);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Node resolve(Configuration conf, String hostName) {
        RackResolver.init(conf);
        return RackResolver.coreResolve(hostName);
    }

    public static Node resolve(String hostName) {
        if (!initCalled) {
            throw new IllegalStateException("RackResolver class not yet initialized");
        }
        return RackResolver.coreResolve(hostName);
    }

    private static Node coreResolve(String hostName) {
        ArrayList<String> tmpList = new ArrayList<String>(1);
        tmpList.add(hostName);
        List<String> rNameList = dnsToSwitchMapping.resolve(tmpList);
        String rName = null;
        if (rNameList == null || rNameList.get(0) == null) {
            rName = "/default-rack";
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Couldn't resolve " + hostName + ". Falling back to " + "/default-rack"));
            }
        } else {
            rName = rNameList.get(0);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Resolved " + hostName + " to " + rName));
            }
        }
        return new NodeBase(hostName, rName);
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    static DNSToSwitchMapping getDnsToSwitchMapping() {
        return dnsToSwitchMapping;
    }

    static {
        initCalled = false;
        LOG = LogFactory.getLog(RackResolver.class);
    }
}

