/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.security.PrivilegedExceptionAction;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.flink.hadoop2.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.flink.hadoop2.shaded.com.google.common.cache.CacheLoader;
import org.apache.flink.hadoop2.shaded.com.google.common.cache.LoadingCache;
import org.apache.flink.hadoop2.shaded.com.google.common.util.concurrent.Futures;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.RunJar;
import org.apache.hadoop.util.Shell;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.LocalResourceVisibility;

@InterfaceAudience.LimitedPrivate(value={"YARN", "MapReduce"})
public class FSDownload
implements Callable<Path> {
    private static final Log LOG = LogFactory.getLog(FSDownload.class);
    private FileContext files;
    private final UserGroupInformation userUgi;
    private Configuration conf;
    private LocalResource resource;
    private final LoadingCache<Path, Future<FileStatus>> statCache;
    private Path destDirPath;
    private static final FsPermission cachePerms = new FsPermission(493);
    static final FsPermission PUBLIC_FILE_PERMS = new FsPermission(365);
    static final FsPermission PRIVATE_FILE_PERMS = new FsPermission(320);
    static final FsPermission PUBLIC_DIR_PERMS = new FsPermission(493);
    static final FsPermission PRIVATE_DIR_PERMS = new FsPermission(448);

    public FSDownload(FileContext files, UserGroupInformation ugi, Configuration conf, Path destDirPath, LocalResource resource) {
        this(files, ugi, conf, destDirPath, resource, null);
    }

    public FSDownload(FileContext files, UserGroupInformation ugi, Configuration conf, Path destDirPath, LocalResource resource, LoadingCache<Path, Future<FileStatus>> statCache) {
        this.conf = conf;
        this.destDirPath = destDirPath;
        this.files = files;
        this.userUgi = ugi;
        this.resource = resource;
        this.statCache = statCache;
    }

    LocalResource getResource() {
        return this.resource;
    }

    private void createDir(Path path, FsPermission perm) throws IOException {
        this.files.mkdir(path, perm, false);
        if (!perm.equals(this.files.getUMask().applyUMask(perm))) {
            this.files.setPermission(path, perm);
        }
    }

    public static CacheLoader<Path, Future<FileStatus>> createStatusCacheLoader(final Configuration conf) {
        return new CacheLoader<Path, Future<FileStatus>>(){

            @Override
            public Future<FileStatus> load(Path path) {
                try {
                    FileSystem fs = path.getFileSystem(conf);
                    return Futures.immediateFuture(fs.getFileStatus(path));
                }
                catch (Throwable th) {
                    return Futures.immediateFailedFuture(th);
                }
            }
        };
    }

    @InterfaceAudience.Private
    public static boolean isPublic(FileSystem fs, Path current, FileStatus sStat, LoadingCache<Path, Future<FileStatus>> statCache) throws IOException {
        current = fs.makeQualified(current);
        if (!FSDownload.checkPublicPermsForAll(fs, sStat, FsAction.READ_EXECUTE, FsAction.READ)) {
            return false;
        }
        if (Shell.WINDOWS && fs instanceof LocalFileSystem) {
            return true;
        }
        return FSDownload.ancestorsHaveExecutePermissions(fs, current.getParent(), statCache);
    }

    private static boolean checkPublicPermsForAll(FileSystem fs, FileStatus status, FsAction dir, FsAction file) throws IOException {
        FsPermission perms = status.getPermission();
        FsAction otherAction = perms.getOtherAction();
        if (status.isDirectory()) {
            if (!otherAction.implies(dir)) {
                return false;
            }
            for (FileStatus child : fs.listStatus(status.getPath())) {
                if (FSDownload.checkPublicPermsForAll(fs, child, dir, file)) continue;
                return false;
            }
            return true;
        }
        return otherAction.implies(file);
    }

    @VisibleForTesting
    static boolean ancestorsHaveExecutePermissions(FileSystem fs, Path path, LoadingCache<Path, Future<FileStatus>> statCache) throws IOException {
        for (Path current = path; current != null; current = current.getParent()) {
            if (FSDownload.checkPermissionOfOther(fs, current, FsAction.EXECUTE, statCache)) continue;
            return false;
        }
        return true;
    }

    private static boolean checkPermissionOfOther(FileSystem fs, Path path, FsAction action, LoadingCache<Path, Future<FileStatus>> statCache) throws IOException {
        FileStatus status = FSDownload.getFileStatus(fs, path, statCache);
        FsPermission perms = status.getPermission();
        FsAction otherAction = perms.getOtherAction();
        return otherAction.implies(action);
    }

    private static FileStatus getFileStatus(FileSystem fs, Path path, LoadingCache<Path, Future<FileStatus>> statCache) throws IOException {
        if (statCache == null) {
            return fs.getFileStatus(path);
        }
        try {
            return statCache.get(path).get();
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw new IOException(cause);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException(e);
        }
    }

    private Path copy(Path sCopy, Path dstdir) throws IOException {
        FileSystem sourceFs = sCopy.getFileSystem(this.conf);
        Path dCopy = new Path(dstdir, "tmp_" + sCopy.getName());
        FileStatus sStat = sourceFs.getFileStatus(sCopy);
        if (sStat.getModificationTime() != this.resource.getTimestamp()) {
            throw new IOException("Resource " + sCopy + " changed on src filesystem (expected " + this.resource.getTimestamp() + ", was " + sStat.getModificationTime());
        }
        if (this.resource.getVisibility() == LocalResourceVisibility.PUBLIC && !FSDownload.isPublic(sourceFs, sCopy, sStat, this.statCache)) {
            throw new IOException("Resource " + sCopy + " is not publicly accessable and as such cannot be part of the" + " public cache.");
        }
        FileUtil.copy(sourceFs, sStat, (FileSystem)FileSystem.getLocal(this.conf), dCopy, false, true, this.conf);
        return dCopy;
    }

    private long unpack(File localrsrc, File dst) throws IOException {
        switch (this.resource.getType()) {
            case ARCHIVE: {
                String lowerDst = StringUtils.toLowerCase(dst.getName());
                if (lowerDst.endsWith(".jar")) {
                    RunJar.unJar(localrsrc, dst);
                    break;
                }
                if (lowerDst.endsWith(".zip")) {
                    FileUtil.unZip(localrsrc, dst);
                    break;
                }
                if (lowerDst.endsWith(".tar.gz") || lowerDst.endsWith(".tgz") || lowerDst.endsWith(".tar")) {
                    FileUtil.unTar(localrsrc, dst);
                    break;
                }
                LOG.warn((Object)("Cannot unpack " + localrsrc));
                if (localrsrc.renameTo(dst)) break;
                throw new IOException("Unable to rename file: [" + localrsrc + "] to [" + dst + "]");
            }
            case PATTERN: {
                String lowerDst = StringUtils.toLowerCase(dst.getName());
                if (lowerDst.endsWith(".jar")) {
                    String p = this.resource.getPattern();
                    RunJar.unJar(localrsrc, dst, p == null ? RunJar.MATCH_ANY : Pattern.compile(p));
                    File newDst = new File(dst, dst.getName());
                    if (!dst.exists() && !dst.mkdir()) {
                        throw new IOException("Unable to create directory: [" + dst + "]");
                    }
                    if (localrsrc.renameTo(newDst)) break;
                    throw new IOException("Unable to rename file: [" + localrsrc + "] to [" + newDst + "]");
                }
                if (lowerDst.endsWith(".zip")) {
                    LOG.warn((Object)("Treating [" + localrsrc + "] as an archive even though it " + "was specified as PATTERN"));
                    FileUtil.unZip(localrsrc, dst);
                    break;
                }
                if (lowerDst.endsWith(".tar.gz") || lowerDst.endsWith(".tgz") || lowerDst.endsWith(".tar")) {
                    LOG.warn((Object)("Treating [" + localrsrc + "] as an archive even though it " + "was specified as PATTERN"));
                    FileUtil.unTar(localrsrc, dst);
                    break;
                }
                LOG.warn((Object)("Cannot unpack " + localrsrc));
                if (localrsrc.renameTo(dst)) break;
                throw new IOException("Unable to rename file: [" + localrsrc + "] to [" + dst + "]");
            }
            default: {
                if (localrsrc.renameTo(dst)) break;
                throw new IOException("Unable to rename file: [" + localrsrc + "] to [" + dst + "]");
            }
        }
        if (localrsrc.isFile()) {
            try {
                this.files.delete(new Path(localrsrc.toString()), false);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return 0L;
    }

    @Override
    public Path call() throws Exception {
        Path sCopy;
        try {
            sCopy = this.resource.getResource().toPath();
        }
        catch (URISyntaxException e) {
            throw new IOException("Invalid resource", e);
        }
        this.createDir(this.destDirPath, cachePerms);
        final Path dst_work = new Path(this.destDirPath + "_tmp");
        this.createDir(dst_work, cachePerms);
        Path dFinal = this.files.makeQualified(new Path(dst_work, sCopy.getName()));
        try {
            Path dTmp = null == this.userUgi ? this.files.makeQualified(this.copy(sCopy, dst_work)) : this.userUgi.doAs(new PrivilegedExceptionAction<Path>(){

                @Override
                public Path run() throws Exception {
                    return FSDownload.this.files.makeQualified(FSDownload.this.copy(sCopy, dst_work));
                }
            });
            this.unpack(new File(dTmp.toUri()), new File(dFinal.toUri()));
            this.changePermissions(dFinal.getFileSystem(this.conf), dFinal);
            this.files.rename(dst_work, this.destDirPath, Options.Rename.OVERWRITE);
        }
        catch (Exception e) {
            try {
                this.files.delete(this.destDirPath, true);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw e;
        }
        finally {
            try {
                this.files.delete(dst_work, true);
            }
            catch (FileNotFoundException fileNotFoundException) {}
            this.conf = null;
            this.resource = null;
        }
        return this.files.makeQualified(new Path(this.destDirPath, sCopy.getName()));
    }

    private void changePermissions(FileSystem fs, final Path path) throws IOException, InterruptedException {
        File f = new File(path.toUri());
        if (FileUtils.isSymlink((File)f)) {
            return;
        }
        boolean isDir = f.isDirectory();
        FsPermission perm = cachePerms;
        perm = this.resource.getVisibility() == LocalResourceVisibility.PUBLIC ? (isDir ? PUBLIC_DIR_PERMS : PUBLIC_FILE_PERMS) : (isDir ? PRIVATE_DIR_PERMS : PRIVATE_FILE_PERMS);
        LOG.debug((Object)("Changing permissions for path " + path + " to perm " + perm));
        final FsPermission fPerm = perm;
        if (null == this.userUgi) {
            this.files.setPermission(path, perm);
        } else {
            this.userUgi.doAs(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    FSDownload.this.files.setPermission(path, fPerm);
                    return null;
                }
            });
        }
        if (isDir) {
            FileStatus[] statuses;
            for (FileStatus status : statuses = fs.listStatus(path)) {
                this.changePermissions(fs, status.getPath());
            }
        }
    }
}

