/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.api.protocolrecords.impl.pb;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.flink.hadoop2.shaded.com.google.protobuf.TextFormat;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.impl.pb.NodeIdPBImpl;
import org.apache.hadoop.yarn.proto.YarnProtos;
import org.apache.hadoop.yarn.proto.YarnServerResourceManagerServiceProtos;
import org.apache.hadoop.yarn.server.api.protocolrecords.CheckForDecommissioningNodesResponse;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class CheckForDecommissioningNodesResponsePBImpl
extends CheckForDecommissioningNodesResponse {
    YarnServerResourceManagerServiceProtos.CheckForDecommissioningNodesResponseProto proto = YarnServerResourceManagerServiceProtos.CheckForDecommissioningNodesResponseProto.getDefaultInstance();
    YarnServerResourceManagerServiceProtos.CheckForDecommissioningNodesResponseProto.Builder builder = null;
    boolean viaProto = false;
    private Set<NodeId> decommissioningNodes;

    public CheckForDecommissioningNodesResponsePBImpl() {
        this.builder = YarnServerResourceManagerServiceProtos.CheckForDecommissioningNodesResponseProto.newBuilder();
    }

    public CheckForDecommissioningNodesResponsePBImpl(YarnServerResourceManagerServiceProtos.CheckForDecommissioningNodesResponseProto proto) {
        this.proto = proto;
        this.viaProto = true;
    }

    public YarnServerResourceManagerServiceProtos.CheckForDecommissioningNodesResponseProto getProto() {
        this.mergeLocalToProto();
        this.proto = this.viaProto ? this.proto : this.builder.build();
        this.viaProto = true;
        return this.proto;
    }

    private void mergeLocalToProto() {
        if (this.viaProto) {
            this.maybeInitBuilder();
        }
        this.mergeLocalToBuilder();
        this.proto = this.builder.build();
        this.viaProto = true;
    }

    private void maybeInitBuilder() {
        if (this.viaProto || this.builder == null) {
            this.builder = YarnServerResourceManagerServiceProtos.CheckForDecommissioningNodesResponseProto.newBuilder(this.proto);
        }
        this.viaProto = false;
    }

    private void mergeLocalToBuilder() {
        if (this.decommissioningNodes != null) {
            this.addDecommissioningNodesToProto();
        }
    }

    private void addDecommissioningNodesToProto() {
        this.maybeInitBuilder();
        this.builder.clearDecommissioningNodes();
        if (this.decommissioningNodes == null) {
            return;
        }
        HashSet<YarnProtos.NodeIdProto> nodeIdProtos = new HashSet<YarnProtos.NodeIdProto>();
        for (NodeId nodeId : this.decommissioningNodes) {
            nodeIdProtos.add(this.convertToProtoFormat(nodeId));
        }
        this.builder.addAllDecommissioningNodes(nodeIdProtos);
    }

    private YarnProtos.NodeIdProto convertToProtoFormat(NodeId nodeId) {
        return ((NodeIdPBImpl)nodeId).getProto();
    }

    @Override
    public void setDecommissioningNodes(Set<NodeId> decommissioningNodes) {
        this.maybeInitBuilder();
        if (decommissioningNodes == null) {
            this.builder.clearDecommissioningNodes();
        }
        this.decommissioningNodes = decommissioningNodes;
    }

    @Override
    public Set<NodeId> getDecommissioningNodes() {
        this.initNodesDecommissioning();
        return this.decommissioningNodes;
    }

    private void initNodesDecommissioning() {
        if (this.decommissioningNodes != null) {
            return;
        }
        YarnServerResourceManagerServiceProtos.CheckForDecommissioningNodesResponseProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        List<YarnProtos.NodeIdProto> nodeIds = p.getDecommissioningNodesList();
        this.decommissioningNodes = new HashSet<NodeId>();
        for (YarnProtos.NodeIdProto nodeIdProto : nodeIds) {
            this.decommissioningNodes.add(this.convertFromProtoFormat(nodeIdProto));
        }
    }

    private NodeId convertFromProtoFormat(YarnProtos.NodeIdProto nodeIdProto) {
        return new NodeIdPBImpl(nodeIdProto);
    }

    public int hashCode() {
        return this.getProto().hashCode();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other.getClass().isAssignableFrom(this.getClass())) {
            return this.getProto().equals(((CheckForDecommissioningNodesResponsePBImpl)this.getClass().cast(other)).getProto());
        }
        return false;
    }

    public String toString() {
        return TextFormat.shortDebugString(this.getProto());
    }
}

