/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.client.api.impl;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientHandler;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientRequest;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.client.urlconnection.HttpURLConnectionFactory;
import com.sun.jersey.client.urlconnection.URLConnectionClientHandler;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.security.GeneralSecurityException;
import java.security.PrivilegedExceptionAction;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.flink.hadoop2.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.flink.hadoop2.shaded.com.google.common.base.Joiner;
import org.apache.flink.hadoop2.shaded.com.google.common.base.Preconditions;
import org.apache.flink.shaded.hadoop2.org.codehaus.jackson.map.ObjectMapper;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authentication.client.AuthenticationException;
import org.apache.hadoop.security.authentication.client.ConnectionConfigurator;
import org.apache.hadoop.security.ssl.SSLFactory;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.delegation.web.DelegationTokenAuthenticatedURL;
import org.apache.hadoop.security.token.delegation.web.DelegationTokenAuthenticator;
import org.apache.hadoop.security.token.delegation.web.KerberosDelegationTokenAuthenticator;
import org.apache.hadoop.security.token.delegation.web.PseudoDelegationTokenAuthenticator;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.timeline.TimelineDomain;
import org.apache.hadoop.yarn.api.records.timeline.TimelineDomains;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEntities;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEntity;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEntityGroupId;
import org.apache.hadoop.yarn.api.records.timeline.TimelinePutResponse;
import org.apache.hadoop.yarn.client.api.TimelineClient;
import org.apache.hadoop.yarn.client.api.impl.DirectTimelineWriter;
import org.apache.hadoop.yarn.client.api.impl.FileSystemTimelineWriter;
import org.apache.hadoop.yarn.client.api.impl.TimelineWriter;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.security.client.TimelineDelegationTokenIdentifier;
import org.apache.hadoop.yarn.webapp.YarnJacksonJaxbJsonProvider;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class TimelineClientImpl
extends TimelineClient {
    private static final Log LOG = LogFactory.getLog(TimelineClientImpl.class);
    private static final String RESOURCE_URI_STR = "/ws/v1/timeline/";
    private static final Joiner JOINER = Joiner.on("");
    public static final int DEFAULT_SOCKET_TIMEOUT = 60000;
    private static Options opts = new Options();
    private static final String ENTITY_DATA_TYPE = "entity";
    private static final String DOMAIN_DATA_TYPE = "domain";
    private Client client;
    private ConnectionConfigurator connConfigurator;
    private DelegationTokenAuthenticator authenticator;
    private DelegationTokenAuthenticatedURL.Token token;
    private URI resURI;
    private UserGroupInformation authUgi;
    private String doAsUser;
    private Configuration configuration;
    private float timelineServiceVersion;
    private TimelineWriter timelineWriter;
    private SSLFactory sslFactory;
    @InterfaceAudience.Private
    @VisibleForTesting
    TimelineClientConnectionRetry connectionRetry;
    private static final ConnectionConfigurator DEFAULT_TIMEOUT_CONN_CONFIGURATOR;

    public TimelineClientImpl() {
        super(TimelineClientImpl.class.getName());
    }

    @Override
    protected void serviceInit(Configuration conf) throws Exception {
        this.configuration = conf;
        UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
        UserGroupInformation realUgi = ugi.getRealUser();
        if (realUgi != null) {
            this.authUgi = realUgi;
            this.doAsUser = ugi.getShortUserName();
        } else {
            this.authUgi = ugi;
            this.doAsUser = null;
        }
        DefaultClientConfig cc = new DefaultClientConfig();
        cc.getClasses().add(YarnJacksonJaxbJsonProvider.class);
        this.connConfigurator = this.initConnConfigurator(conf);
        this.authenticator = UserGroupInformation.isSecurityEnabled() ? new KerberosDelegationTokenAuthenticator() : new PseudoDelegationTokenAuthenticator();
        this.authenticator.setConnectionConfigurator(this.connConfigurator);
        this.token = new DelegationTokenAuthenticatedURL.Token();
        this.connectionRetry = new TimelineClientConnectionRetry(conf);
        this.client = new Client((ClientHandler)new URLConnectionClientHandler((HttpURLConnectionFactory)new TimelineURLConnectionFactory()), (ClientConfig)cc);
        TimelineJerseyRetryFilter retryFilter = new TimelineJerseyRetryFilter();
        this.client.addFilter((ClientFilter)retryFilter);
        this.resURI = YarnConfiguration.useHttps(conf) ? URI.create(JOINER.join("https://", conf.get("yarn.timeline-service.webapp.https.address", "0.0.0.0:8190"), RESOURCE_URI_STR)) : URI.create(JOINER.join("http://", conf.get("yarn.timeline-service.webapp.address", "0.0.0.0:8188"), RESOURCE_URI_STR));
        LOG.info((Object)("Timeline service address: " + this.resURI));
        this.timelineServiceVersion = conf.getFloat("yarn.timeline-service.version", 1.0f);
        super.serviceInit(conf);
    }

    @Override
    protected void serviceStart() throws Exception {
        this.timelineWriter = this.createTimelineWriter(this.configuration, this.authUgi, this.client, this.resURI);
    }

    protected TimelineWriter createTimelineWriter(Configuration conf, UserGroupInformation ugi, Client webClient, URI uri) throws IOException {
        if (Float.compare(this.timelineServiceVersion, 1.5f) == 0) {
            return new FileSystemTimelineWriter(conf, ugi, webClient, uri);
        }
        return new DirectTimelineWriter(ugi, webClient, uri);
    }

    @Override
    protected void serviceStop() throws Exception {
        if (this.timelineWriter != null) {
            this.timelineWriter.close();
        }
        if (this.sslFactory != null) {
            this.sslFactory.destroy();
        }
        super.serviceStop();
    }

    @Override
    public void flush() throws IOException {
        if (this.timelineWriter != null) {
            this.timelineWriter.flush();
        }
    }

    @Override
    public TimelinePutResponse putEntities(TimelineEntity ... entities) throws IOException, YarnException {
        return this.timelineWriter.putEntities(entities);
    }

    @Override
    public void putDomain(TimelineDomain domain) throws IOException, YarnException {
        this.timelineWriter.putDomain(domain);
    }

    @Override
    public Token<TimelineDelegationTokenIdentifier> getDelegationToken(final String renewer) throws IOException, YarnException {
        PrivilegedExceptionAction<Token<TimelineDelegationTokenIdentifier>> getDTAction = new PrivilegedExceptionAction<Token<TimelineDelegationTokenIdentifier>>(){

            @Override
            public Token<TimelineDelegationTokenIdentifier> run() throws Exception {
                DelegationTokenAuthenticatedURL authUrl = new DelegationTokenAuthenticatedURL(TimelineClientImpl.this.authenticator, TimelineClientImpl.this.connConfigurator);
                return authUrl.getDelegationToken(TimelineClientImpl.this.resURI.toURL(), TimelineClientImpl.this.token, renewer, TimelineClientImpl.this.doAsUser);
            }
        };
        return (Token)this.operateDelegationToken(getDTAction);
    }

    @Override
    public long renewDelegationToken(final Token<TimelineDelegationTokenIdentifier> timelineDT) throws IOException, YarnException {
        final boolean isTokenServiceAddrEmpty = timelineDT.getService().toString().isEmpty();
        final String scheme = isTokenServiceAddrEmpty ? null : (YarnConfiguration.useHttps(this.getConfig()) ? "https" : "http");
        final InetSocketAddress address = isTokenServiceAddrEmpty ? null : SecurityUtil.getTokenServiceAddr(timelineDT);
        PrivilegedExceptionAction<Long> renewDTAction = new PrivilegedExceptionAction<Long>(){

            @Override
            public Long run() throws Exception {
                if (!timelineDT.equals(TimelineClientImpl.this.token.getDelegationToken())) {
                    TimelineClientImpl.this.token.setDelegationToken(timelineDT);
                }
                DelegationTokenAuthenticatedURL authUrl = new DelegationTokenAuthenticatedURL(TimelineClientImpl.this.authenticator, TimelineClientImpl.this.connConfigurator);
                URI serviceURI = isTokenServiceAddrEmpty ? TimelineClientImpl.this.resURI : new URI(scheme, null, address.getHostName(), address.getPort(), TimelineClientImpl.RESOURCE_URI_STR, null, null);
                return authUrl.renewDelegationToken(serviceURI.toURL(), TimelineClientImpl.this.token, TimelineClientImpl.this.doAsUser);
            }
        };
        return (Long)this.operateDelegationToken(renewDTAction);
    }

    @Override
    public void cancelDelegationToken(final Token<TimelineDelegationTokenIdentifier> timelineDT) throws IOException, YarnException {
        final boolean isTokenServiceAddrEmpty = timelineDT.getService().toString().isEmpty();
        final String scheme = isTokenServiceAddrEmpty ? null : (YarnConfiguration.useHttps(this.getConfig()) ? "https" : "http");
        final InetSocketAddress address = isTokenServiceAddrEmpty ? null : SecurityUtil.getTokenServiceAddr(timelineDT);
        PrivilegedExceptionAction<Void> cancelDTAction = new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                if (!timelineDT.equals(TimelineClientImpl.this.token.getDelegationToken())) {
                    TimelineClientImpl.this.token.setDelegationToken(timelineDT);
                }
                DelegationTokenAuthenticatedURL authUrl = new DelegationTokenAuthenticatedURL(TimelineClientImpl.this.authenticator, TimelineClientImpl.this.connConfigurator);
                URI serviceURI = isTokenServiceAddrEmpty ? TimelineClientImpl.this.resURI : new URI(scheme, null, address.getHostName(), address.getPort(), TimelineClientImpl.RESOURCE_URI_STR, null, null);
                authUrl.cancelDelegationToken(serviceURI.toURL(), TimelineClientImpl.this.token, TimelineClientImpl.this.doAsUser);
                return null;
            }
        };
        this.operateDelegationToken(cancelDTAction);
    }

    @Override
    public String toString() {
        return super.toString() + " with timeline server " + this.resURI + " and writer " + this.timelineWriter;
    }

    private Object operateDelegationToken(PrivilegedExceptionAction<?> action) throws IOException, YarnException {
        TimelineClientRetryOp tokenRetryOp = this.createTimelineClientRetryOpForOperateDelegationToken(action);
        return this.connectionRetry.retryOn(tokenRetryOp);
    }

    private ConnectionConfigurator initConnConfigurator(Configuration conf) {
        try {
            return this.initSslConnConfigurator(60000, conf);
        }
        catch (Exception e) {
            LOG.debug((Object)"Cannot load customized ssl related configuration. Fallback to system-generic settings.", (Throwable)e);
            return DEFAULT_TIMEOUT_CONN_CONFIGURATOR;
        }
    }

    private ConnectionConfigurator initSslConnConfigurator(final int timeout, Configuration conf) throws IOException, GeneralSecurityException {
        this.sslFactory = new SSLFactory(SSLFactory.Mode.CLIENT, conf);
        this.sslFactory.init();
        final SSLSocketFactory sf = this.sslFactory.createSSLSocketFactory();
        final HostnameVerifier hv = this.sslFactory.getHostnameVerifier();
        return new ConnectionConfigurator(){

            @Override
            public HttpURLConnection configure(HttpURLConnection conn) throws IOException {
                if (conn instanceof HttpsURLConnection) {
                    HttpsURLConnection c = (HttpsURLConnection)conn;
                    c.setSSLSocketFactory(sf);
                    c.setHostnameVerifier(hv);
                }
                TimelineClientImpl.setTimeouts(conn, timeout);
                return conn;
            }
        };
    }

    private static void setTimeouts(URLConnection connection, int socketTimeout) {
        connection.setConnectTimeout(socketTimeout);
        connection.setReadTimeout(socketTimeout);
    }

    public static void main(String[] argv) throws Exception {
        String path;
        CommandLine cliParser = new GnuParser().parse(opts, argv);
        if (cliParser.hasOption("put") && (path = cliParser.getOptionValue("put")) != null && path.length() > 0) {
            if (cliParser.hasOption(ENTITY_DATA_TYPE)) {
                TimelineClientImpl.putTimelineDataInJSONFile(path, ENTITY_DATA_TYPE);
                return;
            }
            if (cliParser.hasOption(DOMAIN_DATA_TYPE)) {
                TimelineClientImpl.putTimelineDataInJSONFile(path, DOMAIN_DATA_TYPE);
                return;
            }
        }
        TimelineClientImpl.printUsage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void putTimelineDataInJSONFile(String path, String type) {
        File jsonFile = new File(path);
        if (!jsonFile.exists()) {
            LOG.error((Object)("File [" + jsonFile.getAbsolutePath() + "] doesn't exist"));
            return;
        }
        ObjectMapper mapper = new ObjectMapper();
        YarnJacksonJaxbJsonProvider.configObjectMapper(mapper);
        TimelineEntities entities = null;
        TimelineDomains domains = null;
        try {
            if (type.equals(ENTITY_DATA_TYPE)) {
                entities = mapper.readValue(jsonFile, TimelineEntities.class);
            } else if (type.equals(DOMAIN_DATA_TYPE)) {
                domains = mapper.readValue(jsonFile, TimelineDomains.class);
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Error when reading  " + e.getMessage()));
            e.printStackTrace(System.err);
            return;
        }
        YarnConfiguration conf = new YarnConfiguration();
        TimelineClient client = TimelineClient.createTimelineClient();
        client.init(conf);
        client.start();
        try {
            if (UserGroupInformation.isSecurityEnabled() && conf.getBoolean("yarn.timeline-service.enabled", false)) {
                Token<TimelineDelegationTokenIdentifier> token = client.getDelegationToken(UserGroupInformation.getCurrentUser().getUserName());
                UserGroupInformation.getCurrentUser().addToken(token);
            }
            if (type.equals(ENTITY_DATA_TYPE)) {
                TimelinePutResponse response = client.putEntities(entities.getEntities().toArray(new TimelineEntity[entities.getEntities().size()]));
                if (response.getErrors().size() == 0) {
                    LOG.info((Object)"Timeline entities are successfully put");
                } else {
                    for (TimelinePutResponse.TimelinePutError error : response.getErrors()) {
                        LOG.error((Object)("TimelineEntity [" + error.getEntityType() + ":" + error.getEntityId() + "] is not successfully put. Error code: " + error.getErrorCode()));
                    }
                }
            } else if (type.equals(DOMAIN_DATA_TYPE)) {
                boolean hasError = false;
                for (TimelineDomain domain : domains.getDomains()) {
                    try {
                        client.putDomain(domain);
                    }
                    catch (Exception e) {
                        LOG.error((Object)("Error when putting domain " + domain.getId()), (Throwable)e);
                        hasError = true;
                    }
                }
                if (!hasError) {
                    LOG.info((Object)"Timeline domains are successfully put");
                }
            }
        }
        catch (RuntimeException e) {
            LOG.error((Object)"Error when putting the timeline data", (Throwable)e);
        }
        catch (Exception e) {
            LOG.error((Object)"Error when putting the timeline data", (Throwable)e);
        }
        finally {
            client.stop();
        }
    }

    private static void printUsage() {
        new HelpFormatter().printHelp("TimelineClient", opts);
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public UserGroupInformation getUgi() {
        return this.authUgi;
    }

    @Override
    public TimelinePutResponse putEntities(ApplicationAttemptId appAttemptId, TimelineEntityGroupId groupId, TimelineEntity ... entities) throws IOException, YarnException {
        if (Float.compare(this.timelineServiceVersion, 1.5f) != 0) {
            throw new YarnException("This API is not supported under current Timeline Service Version: " + this.timelineServiceVersion);
        }
        return this.timelineWriter.putEntities(appAttemptId, groupId, entities);
    }

    @Override
    public void putDomain(ApplicationAttemptId appAttemptId, TimelineDomain domain) throws IOException, YarnException {
        if (Float.compare(this.timelineServiceVersion, 1.5f) != 0) {
            throw new YarnException("This API is not supported under current Timeline Service Version: " + this.timelineServiceVersion);
        }
        this.timelineWriter.putDomain(appAttemptId, domain);
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public void setTimelineWriter(TimelineWriter writer) {
        this.timelineWriter = writer;
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public TimelineClientRetryOp createTimelineClientRetryOpForOperateDelegationToken(PrivilegedExceptionAction<?> action) throws IOException {
        return new TimelineClientRetryOpForOperateDelegationToken(this.authUgi, action);
    }

    static {
        opts.addOption("put", true, "Put the timeline entities/domain in a JSON file");
        opts.getOption("put").setArgName("Path to the JSON file");
        opts.addOption(ENTITY_DATA_TYPE, false, "Specify the JSON file contains the entities");
        opts.addOption(DOMAIN_DATA_TYPE, false, "Specify the JSON file contains the domain");
        opts.addOption("help", false, "Print usage");
        DEFAULT_TIMEOUT_CONN_CONFIGURATOR = new ConnectionConfigurator(){

            @Override
            public HttpURLConnection configure(HttpURLConnection conn) throws IOException {
                TimelineClientImpl.setTimeouts(conn, 60000);
                return conn;
            }
        };
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public class TimelineClientRetryOpForOperateDelegationToken
    extends TimelineClientRetryOp {
        private final UserGroupInformation authUgi;
        private final PrivilegedExceptionAction<?> action;

        public TimelineClientRetryOpForOperateDelegationToken(UserGroupInformation authUgi, PrivilegedExceptionAction<?> action) {
            this.authUgi = authUgi;
            this.action = action;
        }

        @Override
        public Object run() throws IOException {
            this.authUgi.checkTGTAndReloginFromKeytab();
            try {
                return this.authUgi.doAs(this.action);
            }
            catch (UndeclaredThrowableException e) {
                throw new IOException(e.getCause());
            }
            catch (InterruptedException e) {
                throw new IOException(e);
            }
        }

        @Override
        public boolean shouldRetryOn(Exception e) {
            return e instanceof ConnectException || e instanceof SocketTimeoutException;
        }
    }

    private class TimelineURLConnectionFactory
    implements HttpURLConnectionFactory {
        private TimelineURLConnectionFactory() {
        }

        public HttpURLConnection getHttpURLConnection(URL url) throws IOException {
            TimelineClientImpl.this.authUgi.checkTGTAndReloginFromKeytab();
            try {
                return new DelegationTokenAuthenticatedURL(TimelineClientImpl.this.authenticator, TimelineClientImpl.this.connConfigurator).openConnection(url, TimelineClientImpl.this.token, TimelineClientImpl.this.doAsUser);
            }
            catch (UndeclaredThrowableException e) {
                throw new IOException(e.getCause());
            }
            catch (AuthenticationException ae) {
                throw new IOException(ae);
            }
        }
    }

    private class TimelineJerseyRetryFilter
    extends ClientFilter {
        private TimelineJerseyRetryFilter() {
        }

        public ClientResponse handle(final ClientRequest cr) throws ClientHandlerException {
            TimelineClientRetryOp jerseyRetryOp = new TimelineClientRetryOp(){

                @Override
                public Object run() {
                    return TimelineJerseyRetryFilter.this.getNext().handle(cr);
                }

                @Override
                public boolean shouldRetryOn(Exception e) {
                    return e instanceof ClientHandlerException && (e.getCause() instanceof ConnectException || e.getCause() instanceof SocketTimeoutException);
                }
            };
            try {
                return (ClientResponse)TimelineClientImpl.this.connectionRetry.retryOn(jerseyRetryOp);
            }
            catch (IOException e) {
                throw new ClientHandlerException("Jersey retry failed!\nMessage: " + e.getMessage());
            }
        }
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    static class TimelineClientConnectionRetry {
        @InterfaceAudience.Private
        @VisibleForTesting
        public int maxRetries;
        @InterfaceAudience.Private
        @VisibleForTesting
        public long retryInterval;
        private boolean retried = false;

        @InterfaceAudience.Private
        @VisibleForTesting
        boolean getRetired() {
            return this.retried;
        }

        public TimelineClientConnectionRetry(Configuration conf) {
            Preconditions.checkArgument(conf.getInt("yarn.timeline-service.client.max-retries", 30) >= -1, "%s property value should be greater than or equal to -1", "yarn.timeline-service.client.max-retries");
            Preconditions.checkArgument(conf.getLong("yarn.timeline-service.client.retry-interval-ms", 1000L) > 0L, "%s property value should be greater than zero", "yarn.timeline-service.client.retry-interval-ms");
            this.maxRetries = conf.getInt("yarn.timeline-service.client.max-retries", 30);
            this.retryInterval = conf.getLong("yarn.timeline-service.client.retry-interval-ms", 1000L);
        }

        public Object retryOn(TimelineClientRetryOp op) throws RuntimeException, IOException {
            int leftRetries = this.maxRetries;
            this.retried = false;
            while (true) {
                try {
                    return op.run();
                }
                catch (IOException | RuntimeException e) {
                    if (leftRetries != 0) {
                        if (!op.shouldRetryOn(e)) {
                            throw e;
                        }
                        this.logException(e, leftRetries);
                        if (leftRetries > 0) {
                            --leftRetries;
                        }
                        this.retried = true;
                        try {
                            Thread.sleep(this.retryInterval);
                        }
                        catch (InterruptedException ie) {
                            LOG.warn((Object)"Client retry sleep interrupted! ");
                        }
                        continue;
                    }
                    throw new RuntimeException("Failed to connect to timeline server. Connection retries limit exceeded. The posted timeline event may be missing");
                }
                break;
            }
        }

        private void logException(Exception e, int leftRetries) {
            if (leftRetries > 0) {
                LOG.info((Object)("Exception caught by TimelineClientConnectionRetry, will try " + leftRetries + " more time(s).\nMessage: " + e.getMessage()));
            } else {
                LOG.info((Object)("ConnectionException caught by TimelineClientConnectionRetry, will keep retrying.\nMessage: " + e.getMessage()));
            }
        }
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public static abstract class TimelineClientRetryOp {
        public abstract Object run() throws IOException;

        public abstract boolean shouldRetryOn(Exception var1);
    }
}

