/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.lib;

import java.util.Collection;
import java.util.Map;
import org.apache.flink.hadoop2.shaded.com.google.common.collect.Maps;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.metrics2.MetricsException;
import org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.MetricsTag;
import org.apache.hadoop.metrics2.impl.MsInfo;
import org.apache.hadoop.metrics2.lib.Interns;
import org.apache.hadoop.metrics2.lib.MutableCounterInt;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;
import org.apache.hadoop.metrics2.lib.MutableGaugeInt;
import org.apache.hadoop.metrics2.lib.MutableGaugeLong;
import org.apache.hadoop.metrics2.lib.MutableMetric;
import org.apache.hadoop.metrics2.lib.MutableQuantiles;
import org.apache.hadoop.metrics2.lib.MutableRate;
import org.apache.hadoop.metrics2.lib.MutableRatesWithAggregation;
import org.apache.hadoop.metrics2.lib.MutableStat;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class MetricsRegistry {
    private final Map<String, MutableMetric> metricsMap = Maps.newLinkedHashMap();
    private final Map<String, MetricsTag> tagsMap = Maps.newLinkedHashMap();
    private final MetricsInfo metricsInfo;

    public MetricsRegistry(String name) {
        this.metricsInfo = Interns.info(name, name);
    }

    public MetricsRegistry(MetricsInfo info) {
        this.metricsInfo = info;
    }

    public MetricsInfo info() {
        return this.metricsInfo;
    }

    public synchronized MutableMetric get(String name) {
        return this.metricsMap.get(name);
    }

    public synchronized MetricsTag getTag(String name) {
        return this.tagsMap.get(name);
    }

    public MutableCounterInt newCounter(String name, String desc, int iVal) {
        return this.newCounter(Interns.info(name, desc), iVal);
    }

    public synchronized MutableCounterInt newCounter(MetricsInfo info, int iVal) {
        this.checkMetricName(info.name());
        MutableCounterInt ret = new MutableCounterInt(info, iVal);
        this.metricsMap.put(info.name(), ret);
        return ret;
    }

    public MutableCounterLong newCounter(String name, String desc, long iVal) {
        return this.newCounter(Interns.info(name, desc), iVal);
    }

    public synchronized MutableCounterLong newCounter(MetricsInfo info, long iVal) {
        this.checkMetricName(info.name());
        MutableCounterLong ret = new MutableCounterLong(info, iVal);
        this.metricsMap.put(info.name(), ret);
        return ret;
    }

    public MutableGaugeInt newGauge(String name, String desc, int iVal) {
        return this.newGauge(Interns.info(name, desc), iVal);
    }

    public synchronized MutableGaugeInt newGauge(MetricsInfo info, int iVal) {
        this.checkMetricName(info.name());
        MutableGaugeInt ret = new MutableGaugeInt(info, iVal);
        this.metricsMap.put(info.name(), ret);
        return ret;
    }

    public MutableGaugeLong newGauge(String name, String desc, long iVal) {
        return this.newGauge(Interns.info(name, desc), iVal);
    }

    public synchronized MutableGaugeLong newGauge(MetricsInfo info, long iVal) {
        this.checkMetricName(info.name());
        MutableGaugeLong ret = new MutableGaugeLong(info, iVal);
        this.metricsMap.put(info.name(), ret);
        return ret;
    }

    public synchronized MutableQuantiles newQuantiles(String name, String desc, String sampleName, String valueName, int interval) {
        this.checkMetricName(name);
        if (interval <= 0) {
            throw new MetricsException("Interval should be positive.  Value passed is: " + interval);
        }
        MutableQuantiles ret = new MutableQuantiles(name, desc, sampleName, valueName, interval);
        this.metricsMap.put(name, ret);
        return ret;
    }

    public synchronized MutableStat newStat(String name, String desc, String sampleName, String valueName, boolean extended) {
        this.checkMetricName(name);
        MutableStat ret = new MutableStat(name, desc, sampleName, valueName, extended);
        this.metricsMap.put(name, ret);
        return ret;
    }

    public MutableStat newStat(String name, String desc, String sampleName, String valueName) {
        return this.newStat(name, desc, sampleName, valueName, false);
    }

    public MutableRate newRate(String name) {
        return this.newRate(name, name, false);
    }

    public MutableRate newRate(String name, String description) {
        return this.newRate(name, description, false);
    }

    public MutableRate newRate(String name, String desc, boolean extended) {
        return this.newRate(name, desc, extended, true);
    }

    @InterfaceAudience.Private
    public synchronized MutableRate newRate(String name, String desc, boolean extended, boolean returnExisting) {
        MutableMetric rate;
        if (returnExisting && (rate = this.metricsMap.get(name)) != null) {
            if (rate instanceof MutableRate) {
                return (MutableRate)rate;
            }
            throw new MetricsException("Unexpected metrics type " + rate.getClass() + " for " + name);
        }
        this.checkMetricName(name);
        MutableRate ret = new MutableRate(name, desc, extended);
        this.metricsMap.put(name, ret);
        return ret;
    }

    public synchronized MutableRatesWithAggregation newRatesWithAggregation(String name) {
        this.checkMetricName(name);
        MutableRatesWithAggregation rates = new MutableRatesWithAggregation();
        this.metricsMap.put(name, rates);
        return rates;
    }

    synchronized void add(String name, MutableMetric metric) {
        this.checkMetricName(name);
        this.metricsMap.put(name, metric);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void add(String name, long value) {
        MutableMetric m = this.metricsMap.get(name);
        if (m != null) {
            if (!(m instanceof MutableStat)) throw new MetricsException("Unsupported add(value) for metric " + name);
            ((MutableStat)m).add(value);
            return;
        } else {
            this.metricsMap.put(name, this.newRate(name));
            this.add(name, value);
        }
    }

    public MetricsRegistry setContext(String name) {
        return this.tag(MsInfo.Context, name, true);
    }

    public MetricsRegistry tag(String name, String description, String value) {
        return this.tag(name, description, value, false);
    }

    public MetricsRegistry tag(String name, String description, String value, boolean override) {
        return this.tag(Interns.info(name, description), value, override);
    }

    public synchronized MetricsRegistry tag(MetricsInfo info, String value, boolean override) {
        if (!override) {
            this.checkTagName(info.name());
        }
        this.tagsMap.put(info.name(), Interns.tag(info, value));
        return this;
    }

    public MetricsRegistry tag(MetricsInfo info, String value) {
        return this.tag(info, value, false);
    }

    Collection<MetricsTag> tags() {
        return this.tagsMap.values();
    }

    Collection<MutableMetric> metrics() {
        return this.metricsMap.values();
    }

    private void checkMetricName(String name) {
        boolean foundWhitespace = false;
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (!Character.isWhitespace(c)) continue;
            foundWhitespace = true;
            break;
        }
        if (foundWhitespace) {
            throw new MetricsException("Metric name '" + name + "' contains illegal whitespace character");
        }
        if (this.metricsMap.containsKey(name)) {
            throw new MetricsException("Metric name " + name + " already exists!");
        }
    }

    private void checkTagName(String name) {
        if (this.tagsMap.containsKey(name)) {
            throw new MetricsException("Tag " + name + " already exists!");
        }
    }

    public synchronized void snapshot(MetricsRecordBuilder builder, boolean all) {
        for (MetricsTag tag : this.tags()) {
            builder.add(tag);
        }
        for (MutableMetric metric : this.metrics()) {
            metric.snapshot(builder, all);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(32);
        sb.append(this.getClass().getSimpleName());
        sb.append("{info=");
        sb.append(this.metricsInfo);
        sb.append(", tags=");
        sb.append(this.tags());
        sb.append(", metrics=");
        sb.append(this.metrics());
        return sb.append('}').toString();
    }
}

