/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.util;

import java.util.HashMap;
import java.util.Map;
import org.apache.flink.hadoop2.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.flink.hadoop2.shaded.com.google.common.collect.ImmutableList;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class ReferenceCountMap<E extends ReferenceCounter> {
    private Map<E, E> referenceMap = new HashMap<E, E>();

    public E put(E key) {
        ReferenceCounter value = (ReferenceCounter)this.referenceMap.get(key);
        if (value == null) {
            value = key;
            this.referenceMap.put(key, value);
        }
        value.incrementAndGetRefCount();
        return (E)value;
    }

    public void remove(E key) {
        ReferenceCounter value = (ReferenceCounter)this.referenceMap.get(key);
        if (value != null && value.decrementAndGetRefCount() == 0) {
            this.referenceMap.remove(key);
        }
    }

    @VisibleForTesting
    public ImmutableList<E> getEntries() {
        return ((ImmutableList.Builder)new ImmutableList.Builder().addAll(this.referenceMap.keySet())).build();
    }

    public long getReferenceCount(E key) {
        ReferenceCounter counter = (ReferenceCounter)this.referenceMap.get(key);
        if (counter != null) {
            return counter.getRefCount();
        }
        return 0L;
    }

    public int getUniqueElementsSize() {
        return this.referenceMap.size();
    }

    @VisibleForTesting
    public void clear() {
        this.referenceMap.clear();
    }

    public static interface ReferenceCounter {
        public int getRefCount();

        public int incrementAndGetRefCount();

        public int decrementAndGetRefCount();
    }
}

