/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.flink.hadoop2.shaded.com.google.common.base.Preconditions;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.AbstractFileSystem;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.BlockStoragePolicySpi;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FSLinkResolver;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsConstants;
import org.apache.hadoop.fs.FsStatus;
import org.apache.hadoop.fs.FsTracer;
import org.apache.hadoop.fs.Globber;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.ParentNotDirectoryException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.UnresolvedLinkException;
import org.apache.hadoop.fs.UnsupportedFileSystemException;
import org.apache.hadoop.fs.XAttrSetFlag;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclStatus;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.ShutdownHookManager;
import org.apache.htrace.core.Tracer;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class FileContext {
    public static final Log LOG = LogFactory.getLog(FileContext.class);
    public static final FsPermission DEFAULT_PERM = FsPermission.getDefault();
    public static final FsPermission DIR_DEFAULT_PERM = FsPermission.getDirDefault();
    public static final FsPermission FILE_DEFAULT_PERM = FsPermission.getFileDefault();
    public static final int SHUTDOWN_HOOK_PRIORITY = 20;
    static final Map<FileContext, Set<Path>> DELETE_ON_EXIT = new IdentityHashMap<FileContext, Set<Path>>();
    static final FileContextFinalizer FINALIZER = new FileContextFinalizer();
    private static final PathFilter DEFAULT_FILTER = new PathFilter(){

        @Override
        public boolean accept(Path file) {
            return true;
        }
    };
    private final AbstractFileSystem defaultFS;
    private Path workingDir;
    private FsPermission umask;
    private final Configuration conf;
    private final UserGroupInformation ugi;
    final boolean resolveSymlinks;
    private final Tracer tracer;
    private final Util util;

    private FileContext(AbstractFileSystem defFs, FsPermission theUmask, Configuration aConf) {
        this.defaultFS = defFs;
        this.umask = theUmask;
        this.conf = aConf;
        this.tracer = FsTracer.get(aConf);
        try {
            this.ugi = UserGroupInformation.getCurrentUser();
        }
        catch (IOException e) {
            LOG.error((Object)"Exception in getCurrentUser: ", (Throwable)e);
            throw new RuntimeException("Failed to get the current user while creating a FileContext", e);
        }
        this.workingDir = this.defaultFS.getInitialWorkingDirectory();
        if (this.workingDir == null) {
            this.workingDir = this.defaultFS.getHomeDirectory();
        }
        this.resolveSymlinks = this.conf.getBoolean("fs.client.resolve.remote.symlinks", true);
        this.util = new Util();
    }

    Path fixRelativePart(Path p) {
        Preconditions.checkNotNull(p, "path cannot be null");
        if (p.isUriPathAbsolute()) {
            return p;
        }
        return new Path(this.workingDir, p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void processDeleteOnExit() {
        Map<FileContext, Set<Path>> map = DELETE_ON_EXIT;
        synchronized (map) {
            Set<Map.Entry<FileContext, Set<Path>>> set = DELETE_ON_EXIT.entrySet();
            for (Map.Entry<FileContext, Set<Path>> entry : set) {
                FileContext fc = entry.getKey();
                Set<Path> paths = entry.getValue();
                for (Path path : paths) {
                    try {
                        fc.delete(path, true);
                    }
                    catch (IOException e) {
                        LOG.warn((Object)("Ignoring failure to deleteOnExit for path " + path));
                    }
                }
            }
            DELETE_ON_EXIT.clear();
        }
    }

    protected AbstractFileSystem getFSofPath(Path absOrFqPath) throws UnsupportedFileSystemException, IOException {
        absOrFqPath.checkNotSchemeWithRelative();
        absOrFqPath.checkNotRelative();
        try {
            this.defaultFS.checkPath(absOrFqPath);
            return this.defaultFS;
        }
        catch (Exception e) {
            return FileContext.getAbstractFileSystem(this.ugi, absOrFqPath.toUri(), this.conf);
        }
    }

    private static AbstractFileSystem getAbstractFileSystem(UserGroupInformation user, final URI uri, final Configuration conf) throws UnsupportedFileSystemException, IOException {
        try {
            return user.doAs(new PrivilegedExceptionAction<AbstractFileSystem>(){

                @Override
                public AbstractFileSystem run() throws UnsupportedFileSystemException {
                    return AbstractFileSystem.get(uri, conf);
                }
            });
        }
        catch (InterruptedException ex) {
            LOG.error((Object)ex);
            throw new IOException("Failed to get the AbstractFileSystem for path: " + uri, ex);
        }
    }

    public static FileContext getFileContext(AbstractFileSystem defFS, Configuration aConf) {
        return new FileContext(defFS, FsPermission.getUMask(aConf), aConf);
    }

    protected static FileContext getFileContext(AbstractFileSystem defaultFS) {
        return FileContext.getFileContext(defaultFS, new Configuration());
    }

    public static FileContext getFileContext() throws UnsupportedFileSystemException {
        return FileContext.getFileContext(new Configuration());
    }

    public static FileContext getLocalFSFileContext() throws UnsupportedFileSystemException {
        return FileContext.getFileContext(FsConstants.LOCAL_FS_URI);
    }

    public static FileContext getFileContext(URI defaultFsUri) throws UnsupportedFileSystemException {
        return FileContext.getFileContext(defaultFsUri, new Configuration());
    }

    public static FileContext getFileContext(URI defaultFsUri, Configuration aConf) throws UnsupportedFileSystemException {
        UserGroupInformation currentUser = null;
        AbstractFileSystem defaultAfs = null;
        if (defaultFsUri.getScheme() == null) {
            return FileContext.getFileContext(aConf);
        }
        try {
            currentUser = UserGroupInformation.getCurrentUser();
            defaultAfs = FileContext.getAbstractFileSystem(currentUser, defaultFsUri, aConf);
        }
        catch (UnsupportedFileSystemException ex) {
            throw ex;
        }
        catch (IOException ex) {
            LOG.error((Object)ex);
            throw new RuntimeException(ex);
        }
        return FileContext.getFileContext(defaultAfs, aConf);
    }

    public static FileContext getFileContext(Configuration aConf) throws UnsupportedFileSystemException {
        URI defaultFsUri = URI.create(aConf.get("fs.defaultFS", "file:///"));
        if (defaultFsUri.getScheme() != null && !defaultFsUri.getScheme().trim().isEmpty()) {
            return FileContext.getFileContext(defaultFsUri, aConf);
        }
        throw new UnsupportedFileSystemException(String.format("%s: URI configured via %s carries no scheme", defaultFsUri, "fs.defaultFS"));
    }

    public static FileContext getLocalFSFileContext(Configuration aConf) throws UnsupportedFileSystemException {
        return FileContext.getFileContext(FsConstants.LOCAL_FS_URI, aConf);
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public AbstractFileSystem getDefaultFileSystem() {
        return this.defaultFS;
    }

    public void setWorkingDirectory(Path newWDir) throws IOException {
        newWDir.checkNotSchemeWithRelative();
        Path newWorkingDir = new Path(this.workingDir, newWDir);
        FileStatus status = this.getFileStatus(newWorkingDir);
        if (status.isFile()) {
            throw new FileNotFoundException("Cannot setWD to a file");
        }
        this.workingDir = newWorkingDir;
    }

    public Path getWorkingDirectory() {
        return this.workingDir;
    }

    public UserGroupInformation getUgi() {
        return this.ugi;
    }

    public Path getHomeDirectory() {
        return this.defaultFS.getHomeDirectory();
    }

    public FsPermission getUMask() {
        return this.umask;
    }

    public void setUMask(FsPermission newUmask) {
        this.umask = newUmask;
    }

    public Path resolvePath(Path f) throws FileNotFoundException, UnresolvedLinkException, AccessControlException, IOException {
        return this.resolve(f);
    }

    public Path makeQualified(Path path) {
        return path.makeQualified(this.defaultFS.getUri(), this.getWorkingDirectory());
    }

    public FSDataOutputStream create(Path f, final EnumSet<CreateFlag> createFlag, Options.CreateOpts ... opts) throws AccessControlException, FileAlreadyExistsException, FileNotFoundException, ParentNotDirectoryException, UnsupportedFileSystemException, IOException {
        Path absF = this.fixRelativePart(f);
        Options.CreateOpts.Perms permOpt = Options.CreateOpts.getOpt(Options.CreateOpts.Perms.class, opts);
        FsPermission permission = permOpt != null ? permOpt.getValue() : FILE_DEFAULT_PERM;
        permission = permission.applyUMask(this.umask);
        final Options.CreateOpts[] updatedOpts = Options.CreateOpts.setOpt(Options.CreateOpts.perms(permission), opts);
        return (FSDataOutputStream)new FSLinkResolver<FSDataOutputStream>(){

            @Override
            public FSDataOutputStream next(AbstractFileSystem fs, Path p) throws IOException {
                return fs.create(p, createFlag, updatedOpts);
            }
        }.resolve(this, absF);
    }

    public void mkdir(Path dir, FsPermission permission, final boolean createParent) throws AccessControlException, FileAlreadyExistsException, FileNotFoundException, ParentNotDirectoryException, UnsupportedFileSystemException, IOException {
        Path absDir = this.fixRelativePart(dir);
        final FsPermission absFerms = (permission == null ? FsPermission.getDirDefault() : permission).applyUMask(this.umask);
        new FSLinkResolver<Void>(){

            @Override
            public Void next(AbstractFileSystem fs, Path p) throws IOException, UnresolvedLinkException {
                fs.mkdir(p, absFerms, createParent);
                return null;
            }
        }.resolve(this, absDir);
    }

    public boolean delete(Path f, final boolean recursive) throws AccessControlException, FileNotFoundException, UnsupportedFileSystemException, IOException {
        Path absF = this.fixRelativePart(f);
        return (Boolean)new FSLinkResolver<Boolean>(){

            @Override
            public Boolean next(AbstractFileSystem fs, Path p) throws IOException, UnresolvedLinkException {
                return fs.delete(p, recursive);
            }
        }.resolve(this, absF);
    }

    public FSDataInputStream open(Path f) throws AccessControlException, FileNotFoundException, UnsupportedFileSystemException, IOException {
        Path absF = this.fixRelativePart(f);
        return (FSDataInputStream)new FSLinkResolver<FSDataInputStream>(){

            @Override
            public FSDataInputStream next(AbstractFileSystem fs, Path p) throws IOException, UnresolvedLinkException {
                return fs.open(p);
            }
        }.resolve(this, absF);
    }

    public FSDataInputStream open(Path f, final int bufferSize) throws AccessControlException, FileNotFoundException, UnsupportedFileSystemException, IOException {
        Path absF = this.fixRelativePart(f);
        return (FSDataInputStream)new FSLinkResolver<FSDataInputStream>(){

            @Override
            public FSDataInputStream next(AbstractFileSystem fs, Path p) throws IOException, UnresolvedLinkException {
                return fs.open(p, bufferSize);
            }
        }.resolve(this, absF);
    }

    public boolean truncate(Path f, final long newLength) throws AccessControlException, FileNotFoundException, UnsupportedFileSystemException, IOException {
        Path absF = this.fixRelativePart(f);
        return (Boolean)new FSLinkResolver<Boolean>(){

            @Override
            public Boolean next(AbstractFileSystem fs, Path p) throws IOException, UnresolvedLinkException {
                return fs.truncate(p, newLength);
            }
        }.resolve(this, absF);
    }

    public boolean setReplication(Path f, final short replication) throws AccessControlException, FileNotFoundException, IOException {
        Path absF = this.fixRelativePart(f);
        return (Boolean)new FSLinkResolver<Boolean>(){

            @Override
            public Boolean next(AbstractFileSystem fs, Path p) throws IOException, UnresolvedLinkException {
                return fs.setReplication(p, replication);
            }
        }.resolve(this, absF);
    }

    public void rename(Path src, Path dst, final Options.Rename ... options) throws AccessControlException, FileAlreadyExistsException, FileNotFoundException, ParentNotDirectoryException, UnsupportedFileSystemException, IOException {
        Path absSrc = this.fixRelativePart(src);
        Path absDst = this.fixRelativePart(dst);
        AbstractFileSystem srcFS = this.getFSofPath(absSrc);
        AbstractFileSystem dstFS = this.getFSofPath(absDst);
        if (!srcFS.getUri().equals(dstFS.getUri())) {
            throw new IOException("Renames across AbstractFileSystems not supported");
        }
        try {
            srcFS.rename(absSrc, absDst, options);
        }
        catch (UnresolvedLinkException e) {
            final Path source = this.resolveIntermediate(absSrc);
            new FSLinkResolver<Void>(){

                @Override
                public Void next(AbstractFileSystem fs, Path p) throws IOException, UnresolvedLinkException {
                    fs.rename(source, p, options);
                    return null;
                }
            }.resolve(this, absDst);
        }
    }

    public void setPermission(Path f, final FsPermission permission) throws AccessControlException, FileNotFoundException, UnsupportedFileSystemException, IOException {
        Path absF = this.fixRelativePart(f);
        new FSLinkResolver<Void>(){

            @Override
            public Void next(AbstractFileSystem fs, Path p) throws IOException, UnresolvedLinkException {
                fs.setPermission(p, permission);
                return null;
            }
        }.resolve(this, absF);
    }

    public void setOwner(Path f, final String username, final String groupname) throws AccessControlException, UnsupportedFileSystemException, FileNotFoundException, IOException {
        if (username == null && groupname == null) {
            throw new HadoopIllegalArgumentException("username and groupname cannot both be null");
        }
        Path absF = this.fixRelativePart(f);
        new FSLinkResolver<Void>(){

            @Override
            public Void next(AbstractFileSystem fs, Path p) throws IOException, UnresolvedLinkException {
                fs.setOwner(p, username, groupname);
                return null;
            }
        }.resolve(this, absF);
    }

    public void setTimes(Path f, final long mtime, final long atime) throws AccessControlException, FileNotFoundException, UnsupportedFileSystemException, IOException {
        Path absF = this.fixRelativePart(f);
        new FSLinkResolver<Void>(){

            @Override
            public Void next(AbstractFileSystem fs, Path p) throws IOException, UnresolvedLinkException {
                fs.setTimes(p, mtime, atime);
                return null;
            }
        }.resolve(this, absF);
    }

    public FileChecksum getFileChecksum(Path f) throws AccessControlException, FileNotFoundException, IOException {
        Path absF = this.fixRelativePart(f);
        return (FileChecksum)new FSLinkResolver<FileChecksum>(){

            @Override
            public FileChecksum next(AbstractFileSystem fs, Path p) throws IOException, UnresolvedLinkException {
                return fs.getFileChecksum(p);
            }
        }.resolve(this, absF);
    }

    public void setVerifyChecksum(boolean verifyChecksum, Path f) throws AccessControlException, FileNotFoundException, UnsupportedFileSystemException, IOException {
        Path absF = this.resolve(this.fixRelativePart(f));
        this.getFSofPath(absF).setVerifyChecksum(verifyChecksum);
    }

    public FileStatus getFileStatus(Path f) throws AccessControlException, FileNotFoundException, UnsupportedFileSystemException, IOException {
        Path absF = this.fixRelativePart(f);
        return (FileStatus)new FSLinkResolver<FileStatus>(){

            @Override
            public FileStatus next(AbstractFileSystem fs, Path p) throws IOException, UnresolvedLinkException {
                return fs.getFileStatus(p);
            }
        }.resolve(this, absF);
    }

    @InterfaceAudience.LimitedPrivate(value={"HDFS", "Hive"})
    public void access(Path path, final FsAction mode) throws AccessControlException, FileNotFoundException, UnsupportedFileSystemException, IOException {
        Path absPath = this.fixRelativePart(path);
        new FSLinkResolver<Void>(){

            @Override
            public Void next(AbstractFileSystem fs, Path p) throws IOException, UnresolvedLinkException {
                fs.access(p, mode);
                return null;
            }
        }.resolve(this, absPath);
    }

    public FileStatus getFileLinkStatus(Path f) throws AccessControlException, FileNotFoundException, UnsupportedFileSystemException, IOException {
        Path absF = this.fixRelativePart(f);
        return (FileStatus)new FSLinkResolver<FileStatus>(){

            @Override
            public FileStatus next(AbstractFileSystem fs, Path p) throws IOException, UnresolvedLinkException {
                FileStatus fi = fs.getFileLinkStatus(p);
                if (fi.isSymlink()) {
                    fi.setSymlink(FSLinkResolver.qualifySymlinkTarget(fs.getUri(), p, fi.getSymlink()));
                }
                return fi;
            }
        }.resolve(this, absF);
    }

    public Path getLinkTarget(Path f) throws AccessControlException, FileNotFoundException, UnsupportedFileSystemException, IOException {
        Path absF = this.fixRelativePart(f);
        return (Path)new FSLinkResolver<Path>(){

            @Override
            public Path next(AbstractFileSystem fs, Path p) throws IOException, UnresolvedLinkException {
                FileStatus fi = fs.getFileLinkStatus(p);
                return fi.getSymlink();
            }
        }.resolve(this, absF);
    }

    @InterfaceAudience.LimitedPrivate(value={"HDFS", "MapReduce"})
    @InterfaceStability.Evolving
    public BlockLocation[] getFileBlockLocations(Path f, final long start, final long len) throws AccessControlException, FileNotFoundException, UnsupportedFileSystemException, IOException {
        Path absF = this.fixRelativePart(f);
        return (BlockLocation[])new FSLinkResolver<BlockLocation[]>(){

            @Override
            public BlockLocation[] next(AbstractFileSystem fs, Path p) throws IOException, UnresolvedLinkException {
                return fs.getFileBlockLocations(p, start, len);
            }
        }.resolve(this, absF);
    }

    public FsStatus getFsStatus(Path f) throws AccessControlException, FileNotFoundException, UnsupportedFileSystemException, IOException {
        if (f == null) {
            return this.defaultFS.getFsStatus();
        }
        Path absF = this.fixRelativePart(f);
        return (FsStatus)new FSLinkResolver<FsStatus>(){

            @Override
            public FsStatus next(AbstractFileSystem fs, Path p) throws IOException, UnresolvedLinkException {
                return fs.getFsStatus(p);
            }
        }.resolve(this, absF);
    }

    public void createSymlink(final Path target, Path link, final boolean createParent) throws AccessControlException, FileAlreadyExistsException, FileNotFoundException, ParentNotDirectoryException, UnsupportedFileSystemException, IOException {
        if (!FileSystem.areSymlinksEnabled()) {
            throw new UnsupportedOperationException("Symlinks not supported");
        }
        Path nonRelLink = this.fixRelativePart(link);
        new FSLinkResolver<Void>(){

            @Override
            public Void next(AbstractFileSystem fs, Path p) throws IOException, UnresolvedLinkException {
                fs.createSymlink(target, p, createParent);
                return null;
            }
        }.resolve(this, nonRelLink);
    }

    public RemoteIterator<FileStatus> listStatus(Path f) throws AccessControlException, FileNotFoundException, UnsupportedFileSystemException, IOException {
        Path absF = this.fixRelativePart(f);
        return (RemoteIterator)new FSLinkResolver<RemoteIterator<FileStatus>>(){

            @Override
            public RemoteIterator<FileStatus> next(AbstractFileSystem fs, Path p) throws IOException, UnresolvedLinkException {
                return fs.listStatusIterator(p);
            }
        }.resolve(this, absF);
    }

    public RemoteIterator<Path> listCorruptFileBlocks(Path path) throws IOException {
        Path absF = this.fixRelativePart(path);
        return (RemoteIterator)new FSLinkResolver<RemoteIterator<Path>>(){

            @Override
            public RemoteIterator<Path> next(AbstractFileSystem fs, Path p) throws IOException, UnresolvedLinkException {
                return fs.listCorruptFileBlocks(p);
            }
        }.resolve(this, absF);
    }

    public RemoteIterator<LocatedFileStatus> listLocatedStatus(Path f) throws AccessControlException, FileNotFoundException, UnsupportedFileSystemException, IOException {
        Path absF = this.fixRelativePart(f);
        return (RemoteIterator)new FSLinkResolver<RemoteIterator<LocatedFileStatus>>(){

            @Override
            public RemoteIterator<LocatedFileStatus> next(AbstractFileSystem fs, Path p) throws IOException, UnresolvedLinkException {
                return fs.listLocatedStatus(p);
            }
        }.resolve(this, absF);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteOnExit(Path f) throws AccessControlException, IOException {
        if (!this.util().exists(f)) {
            return false;
        }
        Map<FileContext, Set<Path>> map = DELETE_ON_EXIT;
        synchronized (map) {
            Set<Path> set;
            if (DELETE_ON_EXIT.isEmpty()) {
                ShutdownHookManager.get().addShutdownHook(FINALIZER, 20);
            }
            if ((set = DELETE_ON_EXIT.get(this)) == null) {
                set = new TreeSet<Path>();
                DELETE_ON_EXIT.put(this, set);
            }
            set.add(f);
        }
        return true;
    }

    public Util util() {
        return this.util;
    }

    private void checkDest(String srcName, Path dst, boolean overwrite) throws AccessControlException, IOException {
        try {
            FileStatus dstFs = this.getFileStatus(dst);
            if (dstFs.isDirectory()) {
                if (null == srcName) {
                    throw new IOException("Target " + dst + " is a directory");
                }
                this.checkDest(null, new Path(dst, srcName), overwrite);
            } else if (!overwrite) {
                throw new IOException("Target " + new Path(dst, srcName) + " already exists");
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    private static void checkDependencies(Path qualSrc, Path qualDst) throws IOException {
        if (FileContext.isSameFS(qualSrc, qualDst)) {
            String srcq = qualSrc.toString() + "/";
            String dstq = qualDst.toString() + "/";
            if (dstq.startsWith(srcq)) {
                if (srcq.length() == dstq.length()) {
                    throw new IOException("Cannot copy " + qualSrc + " to itself.");
                }
                throw new IOException("Cannot copy " + qualSrc + " to its subdirectory " + qualDst);
            }
        }
    }

    private static boolean isSameFS(Path qualPath1, Path qualPath2) {
        URI srcUri = qualPath1.toUri();
        URI dstUri = qualPath2.toUri();
        return srcUri.getScheme().equals(dstUri.getScheme()) && (srcUri.getAuthority() == null || dstUri.getAuthority() == null || !srcUri.getAuthority().equals(dstUri.getAuthority()));
    }

    protected Path resolve(Path f) throws FileNotFoundException, UnresolvedLinkException, AccessControlException, IOException {
        return (Path)new FSLinkResolver<Path>(){

            @Override
            public Path next(AbstractFileSystem fs, Path p) throws IOException, UnresolvedLinkException {
                return fs.resolvePath(p);
            }
        }.resolve(this, f);
    }

    protected Path resolveIntermediate(Path f) throws IOException {
        return ((FileStatus)new FSLinkResolver<FileStatus>(){

            @Override
            public FileStatus next(AbstractFileSystem fs, Path p) throws IOException, UnresolvedLinkException {
                return fs.getFileLinkStatus(p);
            }
        }.resolve(this, f)).getPath();
    }

    Set<AbstractFileSystem> resolveAbstractFileSystems(Path f) throws IOException {
        Path absF = this.fixRelativePart(f);
        final HashSet<AbstractFileSystem> result = new HashSet<AbstractFileSystem>();
        new FSLinkResolver<Void>(){

            @Override
            public Void next(AbstractFileSystem fs, Path p) throws IOException, UnresolvedLinkException {
                result.add(fs);
                fs.getFileStatus(p);
                return null;
            }
        }.resolve(this, absF);
        return result;
    }

    public static FileSystem.Statistics getStatistics(URI uri) {
        return AbstractFileSystem.getStatistics(uri);
    }

    public static void clearStatistics() {
        AbstractFileSystem.clearStatistics();
    }

    public static void printStatistics() {
        AbstractFileSystem.printStatistics();
    }

    public static Map<URI, FileSystem.Statistics> getAllStatistics() {
        return AbstractFileSystem.getAllStatistics();
    }

    @InterfaceAudience.LimitedPrivate(value={"HDFS", "MapReduce"})
    public List<Token<?>> getDelegationTokens(Path p, String renewer) throws IOException {
        Set<AbstractFileSystem> afsSet = this.resolveAbstractFileSystems(p);
        ArrayList tokenList = new ArrayList();
        for (AbstractFileSystem afs : afsSet) {
            List<Token<?>> afsTokens = afs.getDelegationTokens(renewer);
            tokenList.addAll(afsTokens);
        }
        return tokenList;
    }

    public void modifyAclEntries(Path path, final List<AclEntry> aclSpec) throws IOException {
        Path absF = this.fixRelativePart(path);
        new FSLinkResolver<Void>(){

            @Override
            public Void next(AbstractFileSystem fs, Path p) throws IOException {
                fs.modifyAclEntries(p, aclSpec);
                return null;
            }
        }.resolve(this, absF);
    }

    public void removeAclEntries(Path path, final List<AclEntry> aclSpec) throws IOException {
        Path absF = this.fixRelativePart(path);
        new FSLinkResolver<Void>(){

            @Override
            public Void next(AbstractFileSystem fs, Path p) throws IOException {
                fs.removeAclEntries(p, aclSpec);
                return null;
            }
        }.resolve(this, absF);
    }

    public void removeDefaultAcl(Path path) throws IOException {
        Path absF = this.fixRelativePart(path);
        new FSLinkResolver<Void>(){

            @Override
            public Void next(AbstractFileSystem fs, Path p) throws IOException {
                fs.removeDefaultAcl(p);
                return null;
            }
        }.resolve(this, absF);
    }

    public void removeAcl(Path path) throws IOException {
        Path absF = this.fixRelativePart(path);
        new FSLinkResolver<Void>(){

            @Override
            public Void next(AbstractFileSystem fs, Path p) throws IOException {
                fs.removeAcl(p);
                return null;
            }
        }.resolve(this, absF);
    }

    public void setAcl(Path path, final List<AclEntry> aclSpec) throws IOException {
        Path absF = this.fixRelativePart(path);
        new FSLinkResolver<Void>(){

            @Override
            public Void next(AbstractFileSystem fs, Path p) throws IOException {
                fs.setAcl(p, aclSpec);
                return null;
            }
        }.resolve(this, absF);
    }

    public AclStatus getAclStatus(Path path) throws IOException {
        Path absF = this.fixRelativePart(path);
        return (AclStatus)new FSLinkResolver<AclStatus>(){

            @Override
            public AclStatus next(AbstractFileSystem fs, Path p) throws IOException {
                return fs.getAclStatus(p);
            }
        }.resolve(this, absF);
    }

    public void setXAttr(Path path, String name, byte[] value) throws IOException {
        this.setXAttr(path, name, value, EnumSet.of(XAttrSetFlag.CREATE, XAttrSetFlag.REPLACE));
    }

    public void setXAttr(Path path, final String name, final byte[] value, final EnumSet<XAttrSetFlag> flag) throws IOException {
        Path absF = this.fixRelativePart(path);
        new FSLinkResolver<Void>(){

            @Override
            public Void next(AbstractFileSystem fs, Path p) throws IOException {
                fs.setXAttr(p, name, value, flag);
                return null;
            }
        }.resolve(this, absF);
    }

    public byte[] getXAttr(Path path, final String name) throws IOException {
        Path absF = this.fixRelativePart(path);
        return (byte[])new FSLinkResolver<byte[]>(){

            @Override
            public byte[] next(AbstractFileSystem fs, Path p) throws IOException {
                return fs.getXAttr(p, name);
            }
        }.resolve(this, absF);
    }

    public Map<String, byte[]> getXAttrs(Path path) throws IOException {
        Path absF = this.fixRelativePart(path);
        return (Map)new FSLinkResolver<Map<String, byte[]>>(){

            @Override
            public Map<String, byte[]> next(AbstractFileSystem fs, Path p) throws IOException {
                return fs.getXAttrs(p);
            }
        }.resolve(this, absF);
    }

    public Map<String, byte[]> getXAttrs(Path path, final List<String> names) throws IOException {
        Path absF = this.fixRelativePart(path);
        return (Map)new FSLinkResolver<Map<String, byte[]>>(){

            @Override
            public Map<String, byte[]> next(AbstractFileSystem fs, Path p) throws IOException {
                return fs.getXAttrs(p, names);
            }
        }.resolve(this, absF);
    }

    public void removeXAttr(Path path, final String name) throws IOException {
        Path absF = this.fixRelativePart(path);
        new FSLinkResolver<Void>(){

            @Override
            public Void next(AbstractFileSystem fs, Path p) throws IOException {
                fs.removeXAttr(p, name);
                return null;
            }
        }.resolve(this, absF);
    }

    public List<String> listXAttrs(Path path) throws IOException {
        Path absF = this.fixRelativePart(path);
        return (List)new FSLinkResolver<List<String>>(){

            @Override
            public List<String> next(AbstractFileSystem fs, Path p) throws IOException {
                return fs.listXAttrs(p);
            }
        }.resolve(this, absF);
    }

    public final Path createSnapshot(Path path) throws IOException {
        return this.createSnapshot(path, null);
    }

    public Path createSnapshot(Path path, final String snapshotName) throws IOException {
        Path absF = this.fixRelativePart(path);
        return (Path)new FSLinkResolver<Path>(){

            @Override
            public Path next(AbstractFileSystem fs, Path p) throws IOException {
                return fs.createSnapshot(p, snapshotName);
            }
        }.resolve(this, absF);
    }

    public void renameSnapshot(Path path, final String snapshotOldName, final String snapshotNewName) throws IOException {
        Path absF = this.fixRelativePart(path);
        new FSLinkResolver<Void>(){

            @Override
            public Void next(AbstractFileSystem fs, Path p) throws IOException {
                fs.renameSnapshot(p, snapshotOldName, snapshotNewName);
                return null;
            }
        }.resolve(this, absF);
    }

    public void deleteSnapshot(Path path, final String snapshotName) throws IOException {
        Path absF = this.fixRelativePart(path);
        new FSLinkResolver<Void>(){

            @Override
            public Void next(AbstractFileSystem fs, Path p) throws IOException {
                fs.deleteSnapshot(p, snapshotName);
                return null;
            }
        }.resolve(this, absF);
    }

    public void setStoragePolicy(final Path path, final String policyName) throws IOException {
        Path absF = this.fixRelativePart(path);
        new FSLinkResolver<Void>(){

            @Override
            public Void next(AbstractFileSystem fs, Path p) throws IOException {
                fs.setStoragePolicy(path, policyName);
                return null;
            }
        }.resolve(this, absF);
    }

    public void unsetStoragePolicy(final Path src) throws IOException {
        Path absF = this.fixRelativePart(src);
        new FSLinkResolver<Void>(){

            @Override
            public Void next(AbstractFileSystem fs, Path p) throws IOException {
                fs.unsetStoragePolicy(src);
                return null;
            }
        }.resolve(this, absF);
    }

    public BlockStoragePolicySpi getStoragePolicy(Path path) throws IOException {
        Path absF = this.fixRelativePart(path);
        return (BlockStoragePolicySpi)new FSLinkResolver<BlockStoragePolicySpi>(){

            @Override
            public BlockStoragePolicySpi next(AbstractFileSystem fs, Path p) throws IOException {
                return fs.getStoragePolicy(p);
            }
        }.resolve(this, absF);
    }

    public Collection<? extends BlockStoragePolicySpi> getAllStoragePolicies() throws IOException {
        return this.defaultFS.getAllStoragePolicies();
    }

    Tracer getTracer() {
        return this.tracer;
    }

    static class FileContextFinalizer
    implements Runnable {
        FileContextFinalizer() {
        }

        @Override
        public synchronized void run() {
            FileContext.processDeleteOnExit();
        }
    }

    public class Util {
        public boolean exists(Path f) throws AccessControlException, UnsupportedFileSystemException, IOException {
            try {
                FileStatus fs = FileContext.this.getFileStatus(f);
                assert (fs != null);
                return true;
            }
            catch (FileNotFoundException e) {
                return false;
            }
        }

        public ContentSummary getContentSummary(Path f) throws AccessControlException, FileNotFoundException, UnsupportedFileSystemException, IOException {
            FileStatus status = FileContext.this.getFileStatus(f);
            if (status.isFile()) {
                long length = status.getLen();
                return new ContentSummary.Builder().length(length).fileCount(1L).directoryCount(0L).spaceConsumed(length).build();
            }
            long[] summary = new long[]{0L, 0L, 1L};
            RemoteIterator<FileStatus> statusIterator = FileContext.this.listStatus(f);
            while (statusIterator.hasNext()) {
                FileStatus s = statusIterator.next();
                long length = s.getLen();
                ContentSummary c = s.isDirectory() ? this.getContentSummary(s.getPath()) : new ContentSummary.Builder().length(length).fileCount(1L).directoryCount(0L).spaceConsumed(length).build();
                summary[0] = summary[0] + c.getLength();
                summary[1] = summary[1] + c.getFileCount();
                summary[2] = summary[2] + c.getDirectoryCount();
            }
            return new ContentSummary.Builder().length(summary[0]).fileCount(summary[1]).directoryCount(summary[2]).spaceConsumed(summary[0]).build();
        }

        public FileStatus[] listStatus(Path[] files) throws AccessControlException, FileNotFoundException, IOException {
            return this.listStatus(files, DEFAULT_FILTER);
        }

        public FileStatus[] listStatus(Path f, PathFilter filter) throws AccessControlException, FileNotFoundException, UnsupportedFileSystemException, IOException {
            ArrayList<FileStatus> results = new ArrayList<FileStatus>();
            this.listStatus(results, f, filter);
            return results.toArray(new FileStatus[results.size()]);
        }

        public FileStatus[] listStatus(Path[] files, PathFilter filter) throws AccessControlException, FileNotFoundException, IOException {
            ArrayList<FileStatus> results = new ArrayList<FileStatus>();
            for (int i = 0; i < files.length; ++i) {
                this.listStatus(results, files[i], filter);
            }
            return results.toArray(new FileStatus[results.size()]);
        }

        private void listStatus(ArrayList<FileStatus> results, Path f, PathFilter filter) throws AccessControlException, FileNotFoundException, IOException {
            FileStatus[] listing = this.listStatus(f);
            if (listing != null) {
                for (int i = 0; i < listing.length; ++i) {
                    if (!filter.accept(listing[i].getPath())) continue;
                    results.add(listing[i]);
                }
            }
        }

        public FileStatus[] listStatus(Path f) throws AccessControlException, FileNotFoundException, UnsupportedFileSystemException, IOException {
            Path absF = FileContext.this.fixRelativePart(f);
            return (FileStatus[])new FSLinkResolver<FileStatus[]>(){

                @Override
                public FileStatus[] next(AbstractFileSystem fs, Path p) throws IOException, UnresolvedLinkException {
                    return fs.listStatus(p);
                }
            }.resolve(FileContext.this, absF);
        }

        public RemoteIterator<LocatedFileStatus> listFiles(final Path f, final boolean recursive) throws AccessControlException, FileNotFoundException, UnsupportedFileSystemException, IOException {
            return new RemoteIterator<LocatedFileStatus>(){
                private Stack<RemoteIterator<LocatedFileStatus>> itors = new Stack();
                RemoteIterator<LocatedFileStatus> curItor;
                LocatedFileStatus curFile;
                {
                    this.curItor = FileContext.this.listLocatedStatus(f);
                }

                @Override
                public boolean hasNext() throws IOException {
                    while (this.curFile == null) {
                        if (this.curItor.hasNext()) {
                            this.handleFileStat(this.curItor.next());
                            continue;
                        }
                        if (!this.itors.empty()) {
                            this.curItor = this.itors.pop();
                            continue;
                        }
                        return false;
                    }
                    return true;
                }

                private void handleFileStat(LocatedFileStatus stat) throws IOException {
                    if (stat.isFile()) {
                        this.curFile = stat;
                    } else if (stat.isSymlink()) {
                        FileStatus symstat = FileContext.this.getFileStatus(stat.getSymlink());
                        if (symstat.isFile() || recursive && symstat.isDirectory()) {
                            this.itors.push(this.curItor);
                            this.curItor = FileContext.this.listLocatedStatus(stat.getPath());
                        }
                    } else if (recursive) {
                        this.itors.push(this.curItor);
                        this.curItor = FileContext.this.listLocatedStatus(stat.getPath());
                    }
                }

                @Override
                public LocatedFileStatus next() throws IOException {
                    if (this.hasNext()) {
                        LocatedFileStatus result = this.curFile;
                        this.curFile = null;
                        return result;
                    }
                    throw new NoSuchElementException("No more entry in " + f);
                }
            };
        }

        public FileStatus[] globStatus(Path pathPattern) throws AccessControlException, UnsupportedFileSystemException, IOException {
            return new Globber(FileContext.this, pathPattern, DEFAULT_FILTER).glob();
        }

        public FileStatus[] globStatus(Path pathPattern, PathFilter filter) throws AccessControlException, UnsupportedFileSystemException, IOException {
            return new Globber(FileContext.this, pathPattern, filter).glob();
        }

        public boolean copy(Path src, Path dst) throws AccessControlException, FileAlreadyExistsException, FileNotFoundException, ParentNotDirectoryException, UnsupportedFileSystemException, IOException {
            return this.copy(src, dst, false, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean copy(Path src, Path dst, boolean deleteSource, boolean overwrite) throws AccessControlException, FileAlreadyExistsException, FileNotFoundException, ParentNotDirectoryException, UnsupportedFileSystemException, IOException {
            src.checkNotSchemeWithRelative();
            dst.checkNotSchemeWithRelative();
            Path qSrc = FileContext.this.makeQualified(src);
            Path qDst = FileContext.this.makeQualified(dst);
            FileContext.this.checkDest(qSrc.getName(), qDst, overwrite);
            FileStatus fs = FileContext.this.getFileStatus(qSrc);
            if (fs.isDirectory()) {
                FileStatus[] contents;
                FileContext.checkDependencies(qSrc, qDst);
                FileContext.this.mkdir(qDst, FsPermission.getDirDefault(), true);
                for (FileStatus content : contents = this.listStatus(qSrc)) {
                    this.copy(FileContext.this.makeQualified(content.getPath()), FileContext.this.makeQualified(new Path(qDst, content.getPath().getName())), deleteSource, overwrite);
                }
            } else {
                FSDataInputStream in = null;
                FSDataOutputStream out = null;
                try {
                    in = FileContext.this.open(qSrc);
                    EnumSet<CreateFlag> createFlag = overwrite ? EnumSet.of(CreateFlag.CREATE, CreateFlag.OVERWRITE) : EnumSet.of(CreateFlag.CREATE);
                    out = FileContext.this.create(qDst, createFlag, new Options.CreateOpts[0]);
                    IOUtils.copyBytes((InputStream)in, (OutputStream)out, FileContext.this.conf, true);
                }
                catch (Throwable throwable) {
                    IOUtils.closeStream(out);
                    IOUtils.closeStream(in);
                    throw throwable;
                }
                IOUtils.closeStream(out);
                IOUtils.closeStream(in);
            }
            if (deleteSource) {
                return FileContext.this.delete(qSrc, true);
            }
            return true;
        }
    }
}

