/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import org.apache.flink.hadoop2.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.CachingGetSpaceUsed;
import org.apache.hadoop.fs.GetSpaceUsed;
import org.apache.hadoop.util.Shell;

@InterfaceAudience.LimitedPrivate(value={"HDFS", "MapReduce"})
@InterfaceStability.Evolving
public class DU
extends CachingGetSpaceUsed {
    private final DUShell duShell = new DUShell();

    @VisibleForTesting
    public DU(File path, long interval, long jitter, long initialUsed) throws IOException {
        super(path, interval, jitter, initialUsed);
    }

    public DU(GetSpaceUsed.Builder builder) throws IOException {
        this(builder.getPath(), builder.getInterval(), builder.getJitter(), builder.getInitialUsed());
    }

    @Override
    protected synchronized void refresh() {
        try {
            this.duShell.startRefresh();
        }
        catch (IOException ioe) {
            LOG.warn("Could not get disk usage information for path {}", (Object)this.getDirPath(), (Object)ioe);
        }
    }

    public static void main(String[] args) throws Exception {
        String path = ".";
        if (args.length > 0) {
            path = args[0];
        }
        GetSpaceUsed du = new GetSpaceUsed.Builder().setPath(new File(path)).setConf(new Configuration()).build();
        String duResult = du.toString();
        System.out.println(duResult);
    }

    private final class DUShell
    extends Shell {
        private DUShell() {
        }

        void startRefresh() throws IOException {
            this.run();
        }

        public String toString() {
            return "du -sk " + DU.this.getDirPath() + "\n" + DU.this.used.get() + "\t" + DU.this.getDirPath();
        }

        @Override
        protected String[] getExecString() {
            return new String[]{"du", "-sk", DU.this.getDirPath()};
        }

        @Override
        protected void parseExecResult(BufferedReader lines) throws IOException {
            String line = lines.readLine();
            if (line == null) {
                throw new IOException("Expecting a line not the end of stream");
            }
            String[] tokens = line.split("\t");
            if (tokens.length == 0) {
                throw new IOException("Illegal du output");
            }
            DU.this.setUsed(Long.parseLong(tokens[0]) * 1024L);
        }
    }
}

