/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.shaded.hadoop2.org.jboss.netty.handler.timeout;

import java.util.concurrent.TimeUnit;
import org.apache.flink.shaded.hadoop2.org.jboss.netty.channel.ChannelHandler;
import org.apache.flink.shaded.hadoop2.org.jboss.netty.channel.ChannelHandlerContext;
import org.apache.flink.shaded.hadoop2.org.jboss.netty.channel.ChannelStateEvent;
import org.apache.flink.shaded.hadoop2.org.jboss.netty.channel.Channels;
import org.apache.flink.shaded.hadoop2.org.jboss.netty.channel.LifeCycleAwareChannelHandler;
import org.apache.flink.shaded.hadoop2.org.jboss.netty.channel.MessageEvent;
import org.apache.flink.shaded.hadoop2.org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.apache.flink.shaded.hadoop2.org.jboss.netty.channel.WriteCompletionEvent;
import org.apache.flink.shaded.hadoop2.org.jboss.netty.handler.timeout.DefaultIdleStateEvent;
import org.apache.flink.shaded.hadoop2.org.jboss.netty.handler.timeout.IdleState;
import org.apache.flink.shaded.hadoop2.org.jboss.netty.util.ExternalResourceReleasable;
import org.apache.flink.shaded.hadoop2.org.jboss.netty.util.Timeout;
import org.apache.flink.shaded.hadoop2.org.jboss.netty.util.Timer;
import org.apache.flink.shaded.hadoop2.org.jboss.netty.util.TimerTask;

@ChannelHandler.Sharable
public class IdleStateHandler
extends SimpleChannelUpstreamHandler
implements LifeCycleAwareChannelHandler,
ExternalResourceReleasable {
    final Timer timer;
    final long readerIdleTimeMillis;
    final long writerIdleTimeMillis;
    final long allIdleTimeMillis;

    public IdleStateHandler(Timer timer, int readerIdleTimeSeconds, int writerIdleTimeSeconds, int allIdleTimeSeconds) {
        this(timer, readerIdleTimeSeconds, writerIdleTimeSeconds, allIdleTimeSeconds, TimeUnit.SECONDS);
    }

    public IdleStateHandler(Timer timer, long readerIdleTime, long writerIdleTime, long allIdleTime, TimeUnit unit) {
        if (timer == null) {
            throw new NullPointerException("timer");
        }
        if (unit == null) {
            throw new NullPointerException("unit");
        }
        this.timer = timer;
        this.readerIdleTimeMillis = readerIdleTime <= 0L ? 0L : Math.max(unit.toMillis(readerIdleTime), 1L);
        this.writerIdleTimeMillis = writerIdleTime <= 0L ? 0L : Math.max(unit.toMillis(writerIdleTime), 1L);
        this.allIdleTimeMillis = allIdleTime <= 0L ? 0L : Math.max(unit.toMillis(allIdleTime), 1L);
    }

    public long getReaderIdleTimeInMillis() {
        return this.readerIdleTimeMillis;
    }

    public long getWriterIdleTimeInMillis() {
        return this.writerIdleTimeMillis;
    }

    public long getAllIdleTimeInMillis() {
        return this.allIdleTimeMillis;
    }

    public void releaseExternalResources() {
        this.timer.stop();
    }

    public void beforeAdd(ChannelHandlerContext ctx) throws Exception {
        if (ctx.getPipeline().isAttached()) {
            this.initialize(ctx);
        }
    }

    public void afterAdd(ChannelHandlerContext ctx) throws Exception {
    }

    public void beforeRemove(ChannelHandlerContext ctx) throws Exception {
        IdleStateHandler.destroy(ctx);
    }

    public void afterRemove(ChannelHandlerContext ctx) throws Exception {
    }

    public void channelOpen(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        this.initialize(ctx);
        ctx.sendUpstream(e);
    }

    public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        IdleStateHandler.destroy(ctx);
        ctx.sendUpstream(e);
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        State state = (State)ctx.getAttachment();
        state.lastReadTime = System.currentTimeMillis();
        ctx.sendUpstream(e);
    }

    public void writeComplete(ChannelHandlerContext ctx, WriteCompletionEvent e) throws Exception {
        if (e.getWrittenAmount() > 0L) {
            State state = (State)ctx.getAttachment();
            state.lastWriteTime = System.currentTimeMillis();
        }
        ctx.sendUpstream(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize(ChannelHandlerContext ctx) {
        State state;
        State state2 = state = IdleStateHandler.state(ctx);
        synchronized (state2) {
            switch (state.state) {
                case 1: 
                case 2: {
                    return;
                }
            }
            state.state = 1;
        }
        state.lastReadTime = state.lastWriteTime = System.currentTimeMillis();
        if (this.readerIdleTimeMillis > 0L) {
            state.readerIdleTimeout = this.timer.newTimeout(new ReaderIdleTimeoutTask(ctx), this.readerIdleTimeMillis, TimeUnit.MILLISECONDS);
        }
        if (this.writerIdleTimeMillis > 0L) {
            state.writerIdleTimeout = this.timer.newTimeout(new WriterIdleTimeoutTask(ctx), this.writerIdleTimeMillis, TimeUnit.MILLISECONDS);
        }
        if (this.allIdleTimeMillis > 0L) {
            state.allIdleTimeout = this.timer.newTimeout(new AllIdleTimeoutTask(ctx), this.allIdleTimeMillis, TimeUnit.MILLISECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void destroy(ChannelHandlerContext ctx) {
        State state;
        State state2 = state = IdleStateHandler.state(ctx);
        synchronized (state2) {
            if (state.state != 1) {
                return;
            }
            state.state = 2;
        }
        if (state.readerIdleTimeout != null) {
            state.readerIdleTimeout.cancel();
            state.readerIdleTimeout = null;
        }
        if (state.writerIdleTimeout != null) {
            state.writerIdleTimeout.cancel();
            state.writerIdleTimeout = null;
        }
        if (state.allIdleTimeout != null) {
            state.allIdleTimeout.cancel();
            state.allIdleTimeout = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static State state(ChannelHandlerContext ctx) {
        State state;
        ChannelHandlerContext channelHandlerContext = ctx;
        synchronized (channelHandlerContext) {
            state = (State)ctx.getAttachment();
            if (state != null) {
                return state;
            }
            state = new State();
            ctx.setAttachment(state);
        }
        return state;
    }

    private void fireChannelIdle(final ChannelHandlerContext ctx, final IdleState state, final long lastActivityTimeMillis) {
        ctx.getPipeline().execute(new Runnable(){

            public void run() {
                try {
                    IdleStateHandler.this.channelIdle(ctx, state, lastActivityTimeMillis);
                }
                catch (Throwable t) {
                    Channels.fireExceptionCaught(ctx, t);
                }
            }
        });
    }

    protected void channelIdle(ChannelHandlerContext ctx, IdleState state, long lastActivityTimeMillis) throws Exception {
        ctx.sendUpstream(new DefaultIdleStateEvent(ctx.getChannel(), state, lastActivityTimeMillis));
    }

    private static final class State {
        int state;
        volatile Timeout readerIdleTimeout;
        volatile long lastReadTime;
        volatile Timeout writerIdleTimeout;
        volatile long lastWriteTime;
        volatile Timeout allIdleTimeout;

        State() {
        }
    }

    private final class AllIdleTimeoutTask
    implements TimerTask {
        private final ChannelHandlerContext ctx;

        AllIdleTimeoutTask(ChannelHandlerContext ctx) {
            this.ctx = ctx;
        }

        public void run(Timeout timeout) throws Exception {
            long lastIoTime;
            if (timeout.isCancelled() || !this.ctx.getChannel().isOpen()) {
                return;
            }
            State state = (State)this.ctx.getAttachment();
            long currentTime = System.currentTimeMillis();
            long nextDelay = IdleStateHandler.this.allIdleTimeMillis - (currentTime - (lastIoTime = Math.max(state.lastReadTime, state.lastWriteTime)));
            if (nextDelay <= 0L) {
                state.allIdleTimeout = IdleStateHandler.this.timer.newTimeout(this, IdleStateHandler.this.allIdleTimeMillis, TimeUnit.MILLISECONDS);
                IdleStateHandler.this.fireChannelIdle(this.ctx, IdleState.ALL_IDLE, lastIoTime);
            } else {
                state.allIdleTimeout = IdleStateHandler.this.timer.newTimeout(this, nextDelay, TimeUnit.MILLISECONDS);
            }
        }
    }

    private final class WriterIdleTimeoutTask
    implements TimerTask {
        private final ChannelHandlerContext ctx;

        WriterIdleTimeoutTask(ChannelHandlerContext ctx) {
            this.ctx = ctx;
        }

        public void run(Timeout timeout) throws Exception {
            long lastWriteTime;
            if (timeout.isCancelled() || !this.ctx.getChannel().isOpen()) {
                return;
            }
            State state = (State)this.ctx.getAttachment();
            long currentTime = System.currentTimeMillis();
            long nextDelay = IdleStateHandler.this.writerIdleTimeMillis - (currentTime - (lastWriteTime = state.lastWriteTime));
            if (nextDelay <= 0L) {
                state.writerIdleTimeout = IdleStateHandler.this.timer.newTimeout(this, IdleStateHandler.this.writerIdleTimeMillis, TimeUnit.MILLISECONDS);
                IdleStateHandler.this.fireChannelIdle(this.ctx, IdleState.WRITER_IDLE, lastWriteTime);
            } else {
                state.writerIdleTimeout = IdleStateHandler.this.timer.newTimeout(this, nextDelay, TimeUnit.MILLISECONDS);
            }
        }
    }

    private final class ReaderIdleTimeoutTask
    implements TimerTask {
        private final ChannelHandlerContext ctx;

        ReaderIdleTimeoutTask(ChannelHandlerContext ctx) {
            this.ctx = ctx;
        }

        public void run(Timeout timeout) throws Exception {
            long lastReadTime;
            if (timeout.isCancelled() || !this.ctx.getChannel().isOpen()) {
                return;
            }
            State state = (State)this.ctx.getAttachment();
            long currentTime = System.currentTimeMillis();
            long nextDelay = IdleStateHandler.this.readerIdleTimeMillis - (currentTime - (lastReadTime = state.lastReadTime));
            if (nextDelay <= 0L) {
                state.readerIdleTimeout = IdleStateHandler.this.timer.newTimeout(this, IdleStateHandler.this.readerIdleTimeMillis, TimeUnit.MILLISECONDS);
                IdleStateHandler.this.fireChannelIdle(this.ctx, IdleState.READER_IDLE, lastReadTime);
            } else {
                state.readerIdleTimeout = IdleStateHandler.this.timer.newTimeout(this, nextDelay, TimeUnit.MILLISECONDS);
            }
        }
    }
}

