/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.shaded.hadoop2.org.apache.curator.framework.imps;

import java.util.Arrays;
import java.util.List;
import org.apache.flink.hadoop2.shaded.com.google.common.collect.ImmutableList;
import org.apache.flink.shaded.hadoop2.org.apache.curator.framework.api.CuratorEvent;
import org.apache.flink.shaded.hadoop2.org.apache.curator.framework.api.CuratorEventType;
import org.apache.flink.shaded.hadoop2.org.apache.curator.framework.imps.CuratorFrameworkImpl;
import org.apache.flink.shaded.hadoop2.org.apache.curator.framework.imps.NamespaceWatchedEvent;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;

class CuratorEventImpl
implements CuratorEvent {
    private final CuratorEventType type;
    private final int resultCode;
    private final String path;
    private final String name;
    private final List<String> children;
    private final Object context;
    private final Stat stat;
    private final byte[] data;
    private final WatchedEvent watchedEvent;
    private final List<ACL> aclList;

    @Override
    public CuratorEventType getType() {
        return this.type;
    }

    @Override
    public int getResultCode() {
        return this.resultCode;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public Object getContext() {
        return this.context;
    }

    @Override
    public Stat getStat() {
        return this.stat;
    }

    @Override
    public byte[] getData() {
        return this.data;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<String> getChildren() {
        return this.children;
    }

    @Override
    public WatchedEvent getWatchedEvent() {
        return this.watchedEvent;
    }

    @Override
    public List<ACL> getACLList() {
        return this.aclList;
    }

    public String toString() {
        return "CuratorEventImpl{type=" + (Object)((Object)this.type) + ", resultCode=" + this.resultCode + ", path='" + this.path + '\'' + ", name='" + this.name + '\'' + ", children=" + this.children + ", context=" + this.context + ", stat=" + this.stat + ", data=" + Arrays.toString(this.data) + ", watchedEvent=" + this.watchedEvent + ", aclList=" + this.aclList + '}';
    }

    CuratorEventImpl(CuratorFrameworkImpl client, CuratorEventType type, int resultCode, String path, String name, Object context, Stat stat, byte[] data, List<String> children, WatchedEvent watchedEvent, List<ACL> aclList) {
        this.type = type;
        this.resultCode = resultCode;
        this.path = client.unfixForNamespace(path);
        this.name = name;
        this.context = context;
        this.stat = stat;
        this.data = data;
        this.children = children;
        this.watchedEvent = watchedEvent != null ? new NamespaceWatchedEvent(client, watchedEvent) : watchedEvent;
        this.aclList = aclList != null ? ImmutableList.copyOf(aclList) : null;
    }
}

