/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskexecutor;

import java.util.Collection;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.api.java.tuple.Tuple6;
import org.apache.flink.runtime.blob.TransientBlobKey;
import org.apache.flink.runtime.checkpoint.CheckpointOptions;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.clusterframework.types.SlotID;
import org.apache.flink.runtime.concurrent.FutureUtils;
import org.apache.flink.runtime.deployment.TaskDeploymentDescriptor;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.executiongraph.PartitionInfo;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.jobgraph.IntermediateDataSetID;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.jobmaster.AllocatedSlotReport;
import org.apache.flink.runtime.jobmaster.JobMasterId;
import org.apache.flink.runtime.messages.Acknowledge;
import org.apache.flink.runtime.messages.TaskBackPressureResponse;
import org.apache.flink.runtime.operators.coordination.OperatorEvent;
import org.apache.flink.runtime.resourcemanager.ResourceManagerId;
import org.apache.flink.runtime.rest.messages.LogInfo;
import org.apache.flink.runtime.rest.messages.taskmanager.ThreadDumpInfo;
import org.apache.flink.runtime.rpc.RpcTimeout;
import org.apache.flink.runtime.taskexecutor.FileType;
import org.apache.flink.runtime.taskexecutor.TaskExecutorGateway;
import org.apache.flink.types.SerializableOptional;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.SerializedValue;
import org.apache.flink.util.function.TriConsumer;
import org.apache.flink.util.function.TriFunction;

public class TestingTaskExecutorGateway
implements TaskExecutorGateway {
    private final String address;
    private final String hostname;
    private final BiConsumer<ResourceID, AllocatedSlotReport> heartbeatJobManagerConsumer;
    private final BiConsumer<JobID, Throwable> disconnectJobManagerConsumer;
    private final BiFunction<TaskDeploymentDescriptor, JobMasterId, CompletableFuture<Acknowledge>> submitTaskConsumer;
    private final Function<Tuple6<SlotID, JobID, AllocationID, ResourceProfile, String, ResourceManagerId>, CompletableFuture<Acknowledge>> requestSlotFunction;
    private final BiFunction<AllocationID, Throwable, CompletableFuture<Acknowledge>> freeSlotFunction;
    private final Consumer<ResourceID> heartbeatResourceManagerConsumer;
    private final Consumer<Exception> disconnectResourceManagerConsumer;
    private final Function<ExecutionAttemptID, CompletableFuture<Acknowledge>> cancelTaskFunction;
    private final Supplier<CompletableFuture<Boolean>> canBeReleasedSupplier;
    private final TriConsumer<JobID, Set<ResultPartitionID>, Set<ResultPartitionID>> releaseOrPromotePartitionsConsumer;
    private final Consumer<Collection<IntermediateDataSetID>> releaseClusterPartitionsConsumer;
    private final TriFunction<ExecutionAttemptID, OperatorID, SerializedValue<OperatorEvent>, CompletableFuture<Acknowledge>> operatorEventHandler;
    private final Supplier<CompletableFuture<ThreadDumpInfo>> requestThreadDumpSupplier;

    TestingTaskExecutorGateway(String address, String hostname, BiConsumer<ResourceID, AllocatedSlotReport> heartbeatJobManagerConsumer, BiConsumer<JobID, Throwable> disconnectJobManagerConsumer, BiFunction<TaskDeploymentDescriptor, JobMasterId, CompletableFuture<Acknowledge>> submitTaskConsumer, Function<Tuple6<SlotID, JobID, AllocationID, ResourceProfile, String, ResourceManagerId>, CompletableFuture<Acknowledge>> requestSlotFunction, BiFunction<AllocationID, Throwable, CompletableFuture<Acknowledge>> freeSlotFunction, Consumer<ResourceID> heartbeatResourceManagerConsumer, Consumer<Exception> disconnectResourceManagerConsumer, Function<ExecutionAttemptID, CompletableFuture<Acknowledge>> cancelTaskFunction, Supplier<CompletableFuture<Boolean>> canBeReleasedSupplier, TriConsumer<JobID, Set<ResultPartitionID>, Set<ResultPartitionID>> releaseOrPromotePartitionsConsumer, Consumer<Collection<IntermediateDataSetID>> releaseClusterPartitionsConsumer, TriFunction<ExecutionAttemptID, OperatorID, SerializedValue<OperatorEvent>, CompletableFuture<Acknowledge>> operatorEventHandler, Supplier<CompletableFuture<ThreadDumpInfo>> requestThreadDumpSupplier) {
        this.address = (String)Preconditions.checkNotNull((Object)address);
        this.hostname = (String)Preconditions.checkNotNull((Object)hostname);
        this.heartbeatJobManagerConsumer = (BiConsumer)Preconditions.checkNotNull(heartbeatJobManagerConsumer);
        this.disconnectJobManagerConsumer = (BiConsumer)Preconditions.checkNotNull(disconnectJobManagerConsumer);
        this.submitTaskConsumer = (BiFunction)Preconditions.checkNotNull(submitTaskConsumer);
        this.requestSlotFunction = (Function)Preconditions.checkNotNull(requestSlotFunction);
        this.freeSlotFunction = (BiFunction)Preconditions.checkNotNull(freeSlotFunction);
        this.heartbeatResourceManagerConsumer = heartbeatResourceManagerConsumer;
        this.disconnectResourceManagerConsumer = disconnectResourceManagerConsumer;
        this.cancelTaskFunction = cancelTaskFunction;
        this.canBeReleasedSupplier = canBeReleasedSupplier;
        this.releaseOrPromotePartitionsConsumer = releaseOrPromotePartitionsConsumer;
        this.releaseClusterPartitionsConsumer = releaseClusterPartitionsConsumer;
        this.operatorEventHandler = operatorEventHandler;
        this.requestThreadDumpSupplier = requestThreadDumpSupplier;
    }

    public CompletableFuture<Acknowledge> requestSlot(SlotID slotId, JobID jobId, AllocationID allocationId, ResourceProfile resourceProfile, String targetAddress, ResourceManagerId resourceManagerId, Time timeout) {
        return this.requestSlotFunction.apply((Tuple6<SlotID, JobID, AllocationID, ResourceProfile, String, ResourceManagerId>)Tuple6.of((Object)slotId, (Object)jobId, (Object)allocationId, (Object)resourceProfile, (Object)targetAddress, (Object)resourceManagerId));
    }

    public CompletableFuture<TaskBackPressureResponse> requestTaskBackPressure(ExecutionAttemptID executionAttemptId, int requestId, @RpcTimeout Time timeout) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<Acknowledge> submitTask(TaskDeploymentDescriptor tdd, JobMasterId jobMasterId, Time timeout) {
        return this.submitTaskConsumer.apply(tdd, jobMasterId);
    }

    public CompletableFuture<Acknowledge> updatePartitions(ExecutionAttemptID executionAttemptID, Iterable<PartitionInfo> partitionInfos, Time timeout) {
        return CompletableFuture.completedFuture(Acknowledge.get());
    }

    public void releaseOrPromotePartitions(JobID jobId, Set<ResultPartitionID> partitionToRelease, Set<ResultPartitionID> partitionsToPromote) {
        this.releaseOrPromotePartitionsConsumer.accept((Object)jobId, partitionToRelease, partitionsToPromote);
    }

    public CompletableFuture<Acknowledge> releaseClusterPartitions(Collection<IntermediateDataSetID> dataSetsToRelease, Time timeout) {
        this.releaseClusterPartitionsConsumer.accept(dataSetsToRelease);
        return CompletableFuture.completedFuture(Acknowledge.get());
    }

    public CompletableFuture<Acknowledge> triggerCheckpoint(ExecutionAttemptID executionAttemptID, long checkpointID, long checkpointTimestamp, CheckpointOptions checkpointOptions) {
        return CompletableFuture.completedFuture(Acknowledge.get());
    }

    public CompletableFuture<Acknowledge> confirmCheckpoint(ExecutionAttemptID executionAttemptID, long checkpointId, long checkpointTimestamp) {
        return CompletableFuture.completedFuture(Acknowledge.get());
    }

    public CompletableFuture<Acknowledge> abortCheckpoint(ExecutionAttemptID executionAttemptID, long checkpointId, long checkpointTimestamp) {
        return CompletableFuture.completedFuture(Acknowledge.get());
    }

    public CompletableFuture<Acknowledge> cancelTask(ExecutionAttemptID executionAttemptID, Time timeout) {
        return this.cancelTaskFunction.apply(executionAttemptID);
    }

    public void heartbeatFromJobManager(ResourceID heartbeatOrigin, AllocatedSlotReport allocatedSlotReport) {
        this.heartbeatJobManagerConsumer.accept(heartbeatOrigin, allocatedSlotReport);
    }

    public void heartbeatFromResourceManager(ResourceID heartbeatOrigin) {
        this.heartbeatResourceManagerConsumer.accept(heartbeatOrigin);
    }

    public void disconnectJobManager(JobID jobId, Exception cause) {
        this.disconnectJobManagerConsumer.accept(jobId, cause);
    }

    public void disconnectResourceManager(Exception cause) {
        this.disconnectResourceManagerConsumer.accept(cause);
    }

    public CompletableFuture<Acknowledge> freeSlot(AllocationID allocationId, Throwable cause, Time timeout) {
        return this.freeSlotFunction.apply(allocationId, cause);
    }

    public CompletableFuture<TransientBlobKey> requestFileUploadByType(FileType fileType, Time timeout) {
        return FutureUtils.completedExceptionally((Throwable)new UnsupportedOperationException());
    }

    public CompletableFuture<TransientBlobKey> requestFileUploadByName(String fileName, Time timeout) {
        return FutureUtils.completedExceptionally((Throwable)new UnsupportedOperationException());
    }

    public CompletableFuture<SerializableOptional<String>> requestMetricQueryServiceAddress(Time timeout) {
        return CompletableFuture.completedFuture(SerializableOptional.empty());
    }

    public CompletableFuture<Boolean> canBeReleased() {
        return this.canBeReleasedSupplier.get();
    }

    public CompletableFuture<Acknowledge> sendOperatorEventToTask(ExecutionAttemptID task, OperatorID operator, SerializedValue<OperatorEvent> evt) {
        return (CompletableFuture)this.operatorEventHandler.apply((Object)task, (Object)operator, evt);
    }

    public CompletableFuture<ThreadDumpInfo> requestThreadDump(Time timeout) {
        return this.requestThreadDumpSupplier.get();
    }

    public String getAddress() {
        return this.address;
    }

    public String getHostname() {
        return this.hostname;
    }

    public CompletableFuture<Collection<LogInfo>> requestLogList(Time timeout) {
        return FutureUtils.completedExceptionally((Throwable)new UnsupportedOperationException());
    }
}

