/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskexecutor;

import java.net.InetAddress;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.configuration.NettyShuffleEnvironmentOptions;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.runtime.taskmanager.NettyShuffleEnvironmentConfiguration;
import org.apache.flink.util.TestLogger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class NettyShuffleEnvironmentConfigurationTest
extends TestLogger {
    private static final MemorySize MEM_SIZE_PARAM = new MemorySize(0x8000000L);

    @Test
    public void testNetworkBufferNumberCalculation() {
        Configuration config = new Configuration();
        config.set(TaskManagerOptions.MEMORY_SEGMENT_SIZE, (Object)MemorySize.parse((String)"1m"));
        int numNetworkBuffers = NettyShuffleEnvironmentConfiguration.fromConfiguration((Configuration)config, (MemorySize)MEM_SIZE_PARAM, (boolean)false, (InetAddress)InetAddress.getLoopbackAddress()).numNetworkBuffers();
        Assert.assertThat((Object)numNetworkBuffers, (Matcher)CoreMatchers.is((Object)128));
    }

    @Test
    public void testNetworkRequestBackoffAndBuffers() {
        Configuration config = new Configuration();
        config.setInteger(NettyShuffleEnvironmentOptions.NETWORK_REQUEST_BACKOFF_INITIAL, 100);
        config.setInteger(NettyShuffleEnvironmentOptions.NETWORK_REQUEST_BACKOFF_MAX, 200);
        config.setInteger(NettyShuffleEnvironmentOptions.NETWORK_BUFFERS_PER_CHANNEL, 10);
        config.setInteger(NettyShuffleEnvironmentOptions.NETWORK_EXTRA_BUFFERS_PER_GATE, 100);
        NettyShuffleEnvironmentConfiguration networkConfig = NettyShuffleEnvironmentConfiguration.fromConfiguration((Configuration)config, (MemorySize)MEM_SIZE_PARAM, (boolean)true, (InetAddress)InetAddress.getLoopbackAddress());
        Assert.assertEquals((long)networkConfig.partitionRequestInitialBackoff(), (long)100L);
        Assert.assertEquals((long)networkConfig.partitionRequestMaxBackoff(), (long)200L);
        Assert.assertEquals((long)networkConfig.networkBuffersPerChannel(), (long)10L);
        Assert.assertEquals((long)networkConfig.floatingNetworkBuffersPerGate(), (long)100L);
    }
}

