/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.ttl;

import java.io.Serializable;
import org.apache.flink.api.common.functions.FoldFunction;
import org.apache.flink.api.common.state.FoldingStateDescriptor;
import org.apache.flink.api.common.state.State;
import org.apache.flink.api.common.state.StateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.StringSerializer;
import org.apache.flink.runtime.state.internal.InternalFoldingState;
import org.apache.flink.runtime.state.ttl.TtlFoldingState;
import org.apache.flink.runtime.state.ttl.TtlStateTestContextBase;

class TtlFoldingStateTestContext
extends TtlStateTestContextBase<TtlFoldingState<?, String, Long, String>, Long, String> {
    private static final FoldFunction<Long, String> FOLD = (FoldFunction & Serializable)(acc, val) -> {
        long lacc = acc == null ? 0L : Long.parseLong(acc);
        return Long.toString(val == null ? lacc : lacc + val);
    };

    TtlFoldingStateTestContext() {
    }

    @Override
    void initTestValues() {
        this.updateEmpty = 5L;
        this.updateUnexpired = 7L;
        this.updateExpired = 6L;
        this.getUpdateEmpty = "6";
        this.getUnexpired = "13";
        this.getUpdateExpired = "7";
    }

    @Override
    public void update(Long value) throws Exception {
        ((TtlFoldingState)this.ttlState).add((Object)value);
    }

    @Override
    public String get() throws Exception {
        return (String)((TtlFoldingState)this.ttlState).get();
    }

    @Override
    public Object getOriginal() throws Exception {
        return ((InternalFoldingState)((TtlFoldingState)this.ttlState).original).get();
    }

    @Override
    public <US extends State, SV> StateDescriptor<US, SV> createStateDescriptor() {
        return new FoldingStateDescriptor(this.getName(), (Object)"1", FOLD, (TypeSerializer)StringSerializer.INSTANCE);
    }
}

