/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.heap;

import java.util.Arrays;
import java.util.Collection;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.StringSerializer;
import org.apache.flink.core.fs.CloseableRegistry;
import org.apache.flink.runtime.query.TaskKvStateRegistry;
import org.apache.flink.runtime.state.AbstractStateBackend;
import org.apache.flink.runtime.state.KeyGroupRange;
import org.apache.flink.runtime.state.KeyedStateHandle;
import org.apache.flink.runtime.state.TestLocalRecoveryConfig;
import org.apache.flink.runtime.state.heap.HeapKeyedStateBackend;
import org.apache.flink.runtime.state.heap.HeapKeyedStateBackendBuilder;
import org.apache.flink.runtime.state.heap.HeapPriorityQueueSetFactory;
import org.apache.flink.runtime.state.ttl.TtlTimeProvider;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;

@RunWith(value=Parameterized.class)
public abstract class HeapStateBackendTestBase {
    @Parameterized.Parameter
    public boolean async;

    @Parameterized.Parameters
    public static Collection<Boolean> parameters() {
        return Arrays.asList(false, true);
    }

    public HeapKeyedStateBackend<String> createKeyedBackend(Collection<KeyedStateHandle> stateHandles) throws Exception {
        return this.createKeyedBackend((TypeSerializer)StringSerializer.INSTANCE, stateHandles);
    }

    public <K> HeapKeyedStateBackend<K> createKeyedBackend(TypeSerializer<K> keySerializer, Collection<KeyedStateHandle> stateHandles) throws Exception {
        KeyGroupRange keyGroupRange = new KeyGroupRange(0, 15);
        int numKeyGroups = keyGroupRange.getNumberOfKeyGroups();
        ExecutionConfig executionConfig = new ExecutionConfig();
        return new HeapKeyedStateBackendBuilder((TaskKvStateRegistry)Mockito.mock(TaskKvStateRegistry.class), keySerializer, HeapStateBackendTestBase.class.getClassLoader(), numKeyGroups, keyGroupRange, executionConfig, TtlTimeProvider.DEFAULT, stateHandles, AbstractStateBackend.getCompressionDecorator((ExecutionConfig)executionConfig), TestLocalRecoveryConfig.disabled(), new HeapPriorityQueueSetFactory(keyGroupRange, numKeyGroups, 128), this.async, new CloseableRegistry()).build();
    }
}

