/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.heap;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.IntSerializer;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.runtime.state.ArrayListSerializer;
import org.apache.flink.runtime.state.StateEntry;
import org.apache.flink.runtime.state.StateTransformationFunction;
import org.apache.flink.runtime.state.heap.CopyOnWriteStateMap;
import org.apache.flink.runtime.state.heap.CopyOnWriteStateMapSnapshot;
import org.apache.flink.runtime.state.heap.StateMapSnapshot;
import org.apache.flink.runtime.state.internal.InternalKvState;
import org.apache.flink.util.TestLogger;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class CopyOnWriteStateMapTest
extends TestLogger {
    @Test
    public void testPutGetRemoveContainsTransform() throws Exception {
        CopyOnWriteStateMap stateMap = new CopyOnWriteStateMap((TypeSerializer)new ArrayListSerializer((TypeSerializer)IntSerializer.INSTANCE));
        ArrayList state11 = new ArrayList();
        state11.add(41);
        ArrayList<Integer> state21 = new ArrayList<Integer>();
        state21.add(42);
        ArrayList<Integer> state12 = new ArrayList<Integer>();
        state12.add(43);
        Assert.assertNull((Object)stateMap.putAndGetOld((Object)1, (Object)1, state11));
        Assert.assertEquals(state11, (Object)stateMap.get((Object)1, (Object)1));
        Assert.assertEquals((long)1L, (long)stateMap.size());
        Assert.assertNull((Object)stateMap.putAndGetOld((Object)2, (Object)1, state21));
        Assert.assertEquals(state21, (Object)stateMap.get((Object)2, (Object)1));
        Assert.assertEquals((long)2L, (long)stateMap.size());
        Assert.assertNull((Object)stateMap.putAndGetOld((Object)1, (Object)2, state12));
        Assert.assertEquals(state12, (Object)stateMap.get((Object)1, (Object)2));
        Assert.assertEquals((long)3L, (long)stateMap.size());
        Assert.assertTrue((boolean)stateMap.containsKey((Object)2, (Object)1));
        Assert.assertFalse((boolean)stateMap.containsKey((Object)3, (Object)1));
        Assert.assertFalse((boolean)stateMap.containsKey((Object)2, (Object)3));
        stateMap.put((Object)2, (Object)1, null);
        Assert.assertTrue((boolean)stateMap.containsKey((Object)2, (Object)1));
        Assert.assertEquals((long)3L, (long)stateMap.size());
        Assert.assertNull((Object)stateMap.get((Object)2, (Object)1));
        stateMap.put((Object)2, (Object)1, state21);
        Assert.assertEquals((long)3L, (long)stateMap.size());
        Assert.assertEquals(state21, (Object)stateMap.removeAndGetOld((Object)2, (Object)1));
        Assert.assertFalse((boolean)stateMap.containsKey((Object)2, (Object)1));
        Assert.assertEquals((long)2L, (long)stateMap.size());
        stateMap.remove((Object)1, (Object)2);
        Assert.assertFalse((boolean)stateMap.containsKey((Object)1, (Object)2));
        Assert.assertEquals((long)1L, (long)stateMap.size());
        Assert.assertNull((Object)stateMap.removeAndGetOld((Object)4, (Object)2));
        Assert.assertEquals((long)1L, (long)stateMap.size());
        StateTransformationFunction function = (previousState, value) -> {
            previousState.add(value);
            return previousState;
        };
        int value2 = 4711;
        stateMap.transform((Object)1, (Object)1, (Object)4711, function);
        state11 = (ArrayList)function.apply(state11, (Object)4711);
        Assert.assertEquals((Object)state11, (Object)stateMap.get((Object)1, (Object)1));
    }

    @Test
    public void testIncrementalRehash() {
        CopyOnWriteStateMap stateMap = new CopyOnWriteStateMap((TypeSerializer)new ArrayListSerializer((TypeSerializer)IntSerializer.INSTANCE));
        int insert = 0;
        int remove = 0;
        while (!stateMap.isRehashing()) {
            stateMap.put((Object)insert++, (Object)0, new ArrayList());
            if (insert % 8 != 0) continue;
            stateMap.remove((Object)remove++, (Object)0);
        }
        Assert.assertEquals((long)(insert - remove), (long)stateMap.size());
        while (stateMap.isRehashing()) {
            stateMap.put((Object)insert++, (Object)0, new ArrayList());
            if (insert % 8 != 0) continue;
            stateMap.remove((Object)remove++, (Object)0);
        }
        Assert.assertEquals((long)(insert - remove), (long)stateMap.size());
        for (int i = 0; i < insert; ++i) {
            if (i < remove) {
                Assert.assertFalse((boolean)stateMap.containsKey((Object)i, (Object)0));
                continue;
            }
            Assert.assertTrue((boolean)stateMap.containsKey((Object)i, (Object)0));
        }
    }

    @Test
    public void testRandomModificationsAndCopyOnWriteIsolation() throws Exception {
        CopyOnWriteStateMap stateMap = new CopyOnWriteStateMap((TypeSerializer)new ArrayListSerializer((TypeSerializer)IntSerializer.INSTANCE));
        HashMap<Tuple2<Integer, Integer>, ArrayList<Integer>> referenceMap = new HashMap<Tuple2<Integer, Integer>, ArrayList<Integer>>();
        Random random = new Random(42L);
        CopyOnWriteStateMap.StateMapEntry[] snapshot = null;
        int snapshotSize = 0;
        Tuple3<Integer, Integer, ArrayList<Integer>>[] reference = null;
        int val = 0;
        int snapshotCounter = 0;
        int referencedSnapshotId = 0;
        StateTransformationFunction transformationFunction = (previousState, value) -> {
            if (previousState == null) {
                previousState = new ArrayList<Integer>();
            }
            previousState.add(value);
            return previousState;
        };
        InternalKvState.StateIncrementalVisitor updatingIterator = stateMap.getStateIncrementalVisitor(5);
        for (int i = 0; i < 10000000; ++i) {
            int key = random.nextInt(20);
            int namespace = random.nextInt(4);
            Tuple2 compositeKey = new Tuple2((Object)key, (Object)namespace);
            int op = random.nextInt(10);
            ArrayList<Integer> state = null;
            ArrayList<Integer> referenceState = null;
            switch (op) {
                case 0: 
                case 1: {
                    state = (ArrayList<Integer>)stateMap.get((Object)key, (Object)namespace);
                    referenceState = (ArrayList<Integer>)referenceMap.get(compositeKey);
                    if (null != state) break;
                    state = new ArrayList<Integer>();
                    stateMap.put((Object)key, (Object)namespace, state);
                    referenceState = new ArrayList();
                    referenceMap.put((Tuple2<Integer, Integer>)compositeKey, referenceState);
                    break;
                }
                case 2: {
                    stateMap.put((Object)key, (Object)namespace, new ArrayList());
                    referenceMap.put(compositeKey, new ArrayList());
                    break;
                }
                case 3: {
                    state = (ArrayList)stateMap.putAndGetOld((Object)key, (Object)namespace, new ArrayList());
                    referenceState = referenceMap.put((Tuple2<Integer, Integer>)compositeKey, new ArrayList());
                    break;
                }
                case 4: {
                    stateMap.remove((Object)key, (Object)namespace);
                    referenceMap.remove(compositeKey);
                    break;
                }
                case 5: {
                    state = (ArrayList)stateMap.removeAndGetOld((Object)key, (Object)namespace);
                    referenceState = (ArrayList)referenceMap.remove(compositeKey);
                    break;
                }
                case 6: {
                    int updateValue = random.nextInt(1000);
                    stateMap.transform((Object)key, (Object)namespace, (Object)updateValue, transformationFunction);
                    referenceMap.put((Tuple2<Integer, Integer>)compositeKey, (ArrayList<Integer>)transformationFunction.apply(referenceMap.remove(compositeKey), (Object)updateValue));
                    break;
                }
                case 7: 
                case 8: 
                case 9: {
                    if (!updatingIterator.hasNext() && !(updatingIterator = stateMap.getStateIncrementalVisitor(5)).hasNext()) break;
                    CopyOnWriteStateMapTest.testStateIteratorWithUpdate((InternalKvState.StateIncrementalVisitor<Integer, Integer, ArrayList<Integer>>)updatingIterator, (CopyOnWriteStateMap<Integer, Integer, ArrayList<Integer>>)stateMap, referenceMap, op == 8, op == 9);
                    break;
                }
                default: {
                    Assert.fail((String)("Unknown op-code " + op));
                }
            }
            Assert.assertEquals((long)referenceMap.size(), (long)stateMap.size());
            if (state != null) {
                Assert.assertNotNull(referenceState);
                if (random.nextBoolean() && !state.isEmpty()) {
                    state.remove(state.size() - 1);
                    referenceState.remove(referenceState.size() - 1);
                } else {
                    state.add(val);
                    referenceState.add(val);
                    ++val;
                }
            }
            Assert.assertEquals(referenceState, state);
            if (i <= 0 || i % 500 != 0) continue;
            if (snapshot != null) {
                this.deepCheck(reference, CopyOnWriteStateMapTest.convert(snapshot, snapshotSize));
                if (i % 1000 == 0) {
                    stateMap.snapshotMapArrays();
                    stateMap.releaseSnapshot(++snapshotCounter);
                }
                if (i % 5000 != 0) continue;
                snapshot = null;
                reference = null;
                snapshotSize = 0;
                stateMap.releaseSnapshot(referencedSnapshotId);
                continue;
            }
            referencedSnapshotId = ++snapshotCounter;
            snapshot = stateMap.snapshotMapArrays();
            snapshotSize = stateMap.size();
            reference = this.manualDeepDump(referenceMap);
        }
    }

    private static void testStateIteratorWithUpdate(InternalKvState.StateIncrementalVisitor<Integer, Integer, ArrayList<Integer>> updatingIterator, CopyOnWriteStateMap<Integer, Integer, ArrayList<Integer>> stateMap, HashMap<Tuple2<Integer, Integer>, ArrayList<Integer>> referenceMap, boolean update, boolean remove) {
        for (StateEntry stateEntry : updatingIterator.nextEntries()) {
            Integer key = (Integer)stateEntry.getKey();
            Integer namespace = (Integer)stateEntry.getNamespace();
            Tuple2 compositeKey = new Tuple2((Object)key, (Object)namespace);
            Assert.assertEquals(referenceMap.get(compositeKey), (Object)stateEntry.getState());
            if (update) {
                ArrayList newState = new ArrayList((Collection)stateEntry.getState());
                if (!newState.isEmpty()) {
                    newState.remove(0);
                }
                updatingIterator.update(stateEntry, newState);
                referenceMap.put((Tuple2<Integer, Integer>)compositeKey, new ArrayList(newState));
                Assert.assertEquals(newState, (Object)stateMap.get((Object)key, (Object)namespace));
            }
            if (!remove) continue;
            updatingIterator.remove(stateEntry);
            referenceMap.remove(compositeKey);
        }
    }

    @Test
    public void testCopyOnWriteContracts() {
        CopyOnWriteStateMap stateMap = new CopyOnWriteStateMap((TypeSerializer)new ArrayListSerializer((TypeSerializer)IntSerializer.INSTANCE));
        ArrayList<Integer> originalState1 = new ArrayList<Integer>(1);
        ArrayList<Integer> originalState2 = new ArrayList<Integer>(1);
        ArrayList<Integer> originalState3 = new ArrayList<Integer>(1);
        ArrayList<Integer> originalState4 = new ArrayList<Integer>(1);
        ArrayList<Integer> originalState5 = new ArrayList<Integer>(1);
        originalState1.add(1);
        originalState2.add(2);
        originalState3.add(3);
        originalState4.add(4);
        originalState5.add(5);
        stateMap.put((Object)1, (Object)1, originalState1);
        stateMap.put((Object)2, (Object)1, originalState2);
        stateMap.put((Object)4, (Object)1, originalState4);
        stateMap.put((Object)5, (Object)1, originalState5);
        Assert.assertSame((Object)stateMap.get((Object)1, (Object)1), originalState1);
        CopyOnWriteStateMapSnapshot snapshot1 = stateMap.stateSnapshot();
        ArrayList copyState = (ArrayList)stateMap.get((Object)1, (Object)1);
        Assert.assertNotSame((Object)copyState, originalState1);
        Assert.assertEquals(originalState1, (Object)copyState);
        stateMap.put((Object)3, (Object)1, originalState3);
        Assert.assertSame((Object)copyState, (Object)stateMap.get((Object)1, (Object)1));
        CopyOnWriteStateMapSnapshot snapshot2 = stateMap.stateSnapshot();
        Assert.assertNotSame((Object)copyState, (Object)stateMap.get((Object)1, (Object)1));
        Assert.assertEquals((Object)copyState, (Object)stateMap.get((Object)1, (Object)1));
        stateMap.releaseSnapshot((StateMapSnapshot)snapshot2);
        Assert.assertSame(originalState3, (Object)stateMap.get((Object)3, (Object)1));
        Assert.assertNotSame(originalState4, (Object)stateMap.get((Object)4, (Object)1));
        stateMap.releaseSnapshot((StateMapSnapshot)snapshot1);
        Assert.assertSame(originalState5, (Object)stateMap.get((Object)5, (Object)1));
    }

    @Test
    public void testSnapshotRelease() {
        CopyOnWriteStateMap stateMap = new CopyOnWriteStateMap((TypeSerializer)IntSerializer.INSTANCE);
        for (int i = 0; i < 10; ++i) {
            stateMap.put((Object)i, (Object)i, (Object)i);
        }
        CopyOnWriteStateMapSnapshot snapshot = stateMap.stateSnapshot();
        Assert.assertFalse((boolean)snapshot.isReleased());
        Assert.assertThat((Object)stateMap.getSnapshotVersions(), (Matcher)Matchers.contains((Object[])new Integer[]{snapshot.getSnapshotVersion()}));
        snapshot.release();
        Assert.assertTrue((boolean)snapshot.isReleased());
        Assert.assertThat((Object)stateMap.getSnapshotVersions(), (Matcher)Matchers.empty());
        snapshot.release();
        Assert.assertThat((Object)stateMap.getSnapshotVersions(), (Matcher)Matchers.empty());
    }

    /*
     * WARNING - void declaration
     */
    private static <K, N, S> Tuple3<K, N, S>[] convert(CopyOnWriteStateMap.StateMapEntry<K, N, S>[] snapshot, int mapSize) {
        Tuple3[] result = new Tuple3[mapSize];
        int pos = 0;
        for (CopyOnWriteStateMap.StateMapEntry<K, N, S> stateMapEntry : snapshot) {
            void var7_7;
            while (null != var7_7) {
                result[pos++] = new Tuple3(var7_7.getKey(), var7_7.getNamespace(), var7_7.getState());
                CopyOnWriteStateMap.StateMapEntry stateMapEntry2 = var7_7.next;
            }
        }
        Assert.assertEquals((long)mapSize, (long)pos);
        return result;
    }

    private Tuple3<Integer, Integer, ArrayList<Integer>>[] manualDeepDump(HashMap<Tuple2<Integer, Integer>, ArrayList<Integer>> map) {
        Tuple3[] result = new Tuple3[map.size()];
        int pos = 0;
        for (Map.Entry<Tuple2<Integer, Integer>, ArrayList<Integer>> entry : map.entrySet()) {
            Integer key = (Integer)entry.getKey().f0;
            Integer namespace = (Integer)entry.getKey().f1;
            result[pos++] = new Tuple3((Object)key, (Object)namespace, new ArrayList(entry.getValue()));
        }
        return result;
    }

    private void deepCheck(Tuple3<Integer, Integer, ArrayList<Integer>>[] a, Tuple3<Integer, Integer, ArrayList<Integer>>[] b) {
        if (a == b) {
            return;
        }
        Assert.assertEquals((long)a.length, (long)b.length);
        Comparator comparator = (o1, o2) -> {
            int namespaceDiff = (Integer)o1.f1 - (Integer)o2.f1;
            return namespaceDiff != 0 ? namespaceDiff : (Integer)o1.f0 - (Integer)o2.f0;
        };
        Arrays.sort(a, comparator);
        Arrays.sort(b, comparator);
        for (int i = 0; i < a.length; ++i) {
            Tuple3<Integer, Integer, ArrayList<Integer>> av = a[i];
            Tuple3<Integer, Integer, ArrayList<Integer>> bv = b[i];
            Assert.assertEquals((Object)av.f0, (Object)bv.f0);
            Assert.assertEquals((Object)av.f1, (Object)bv.f1);
            Assert.assertEquals((Object)av.f2, (Object)bv.f2);
        }
    }
}

