/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.filesystem;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Random;
import javax.annotation.Nullable;
import org.apache.flink.core.fs.FSDataInputStream;
import org.apache.flink.core.fs.FSDataOutputStream;
import org.apache.flink.core.fs.FileStatus;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.state.CheckpointMetadataOutputStream;
import org.apache.flink.runtime.state.CheckpointStorage;
import org.apache.flink.runtime.state.CheckpointStorageLocation;
import org.apache.flink.runtime.state.CompletedCheckpointStorageLocation;
import org.apache.flink.runtime.state.StreamStateHandle;
import org.apache.flink.runtime.state.filesystem.FileStateHandle;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public abstract class AbstractFileCheckpointStorageTestBase {
    @Rule
    public final TemporaryFolder tmp = new TemporaryFolder();

    protected abstract CheckpointStorage createCheckpointStorage(Path var1) throws Exception;

    protected abstract CheckpointStorage createCheckpointStorageWithSavepointDir(Path var1, Path var2) throws Exception;

    @Test
    public void testPointerPathResolution() throws Exception {
        FileSystem fs = FileSystem.getLocalFileSystem();
        Path metadataFile = new Path(Path.fromLocalFile((File)this.tmp.newFolder()), "_metadata");
        String basePointer = metadataFile.getParent().toString();
        String pointer1 = metadataFile.toString();
        String pointer2 = metadataFile.getParent().toString();
        String pointer3 = metadataFile.getParent().toString() + '/';
        CheckpointStorage storage = this.createCheckpointStorage(this.randomTempPath());
        byte[] data = new byte[23686];
        new Random().nextBytes(data);
        try (FSDataOutputStream out = fs.create(metadataFile, FileSystem.WriteMode.NO_OVERWRITE);){
            out.write(data);
        }
        CompletedCheckpointStorageLocation completed1 = storage.resolveCheckpoint(pointer1);
        CompletedCheckpointStorageLocation completed2 = storage.resolveCheckpoint(pointer2);
        CompletedCheckpointStorageLocation completed3 = storage.resolveCheckpoint(pointer3);
        Assert.assertEquals((Object)basePointer, (Object)completed1.getExternalPointer());
        Assert.assertEquals((Object)basePointer, (Object)completed2.getExternalPointer());
        Assert.assertEquals((Object)basePointer, (Object)completed3.getExternalPointer());
        StreamStateHandle handle1 = completed1.getMetadataHandle();
        StreamStateHandle handle2 = completed2.getMetadataHandle();
        StreamStateHandle handle3 = completed3.getMetadataHandle();
        Assert.assertNotNull((Object)handle1);
        Assert.assertNotNull((Object)handle2);
        Assert.assertNotNull((Object)handle3);
        AbstractFileCheckpointStorageTestBase.validateContents(handle1, data);
        AbstractFileCheckpointStorageTestBase.validateContents(handle2, data);
        AbstractFileCheckpointStorageTestBase.validateContents(handle3, data);
    }

    @Test
    public void testFailingPointerPathResolution() throws Exception {
        CheckpointStorage storage = this.createCheckpointStorage(this.randomTempPath());
        try {
            storage.resolveCheckpoint(null);
            Assert.fail((String)"expected exception");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            storage.resolveCheckpoint("");
            Assert.fail((String)"expected exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            storage.resolveCheckpoint("this-is_not/a#filepath.at.all");
            Assert.fail((String)"expected exception");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            storage.resolveCheckpoint(this.tmp.newFile().toURI().toString() + "_not_existing");
            Assert.fail((String)"expected exception");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testPersistMultipleMetadataOnlyCheckpoints() throws Exception {
        CompletedCheckpointStorageLocation completedLocation2;
        CompletedCheckpointStorageLocation completedLocation1;
        FileSystem fs = FileSystem.getLocalFileSystem();
        Path checkpointDir = new Path(this.tmp.newFolder().toURI());
        long checkpointId = 177L;
        CheckpointStorage storage1 = this.createCheckpointStorage(checkpointDir);
        storage1.initializeBaseLocations();
        CheckpointStorage storage2 = this.createCheckpointStorage(checkpointDir);
        storage2.initializeBaseLocations();
        CheckpointStorageLocation loc1 = storage1.initializeLocationForCheckpoint(177L);
        CheckpointStorageLocation loc2 = storage2.initializeLocationForCheckpoint(177L);
        byte[] data1 = new byte[]{77, 66, 55, 99, 88};
        byte[] data2 = new byte[]{1, 3, 2, 5, 4};
        try (CheckpointMetadataOutputStream out = loc1.createMetadataOutputStream();){
            out.write(data1);
            completedLocation1 = out.closeAndFinalizeCheckpoint();
        }
        String result1 = completedLocation1.getExternalPointer();
        try (CheckpointMetadataOutputStream out = loc2.createMetadataOutputStream();){
            out.write(data2);
            completedLocation2 = out.closeAndFinalizeCheckpoint();
        }
        String result2 = completedLocation2.getExternalPointer();
        FileStatus[] files = fs.listStatus(checkpointDir);
        Assert.assertEquals((long)2L, (long)files.length);
        FileStatus[] job1Files = fs.listStatus(files[0].getPath());
        FileStatus[] job2Files = fs.listStatus(files[1].getPath());
        Assert.assertTrue((job1Files.length >= 1 ? 1 : 0) != 0);
        Assert.assertTrue((job2Files.length >= 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)fs.exists(new Path(result1, "_metadata")));
        Assert.assertTrue((boolean)fs.exists(new Path(result2, "_metadata")));
        AbstractFileCheckpointStorageTestBase.validateContents(storage1.resolveCheckpoint(result1).getMetadataHandle(), data1);
        AbstractFileCheckpointStorageTestBase.validateContents(storage1.resolveCheckpoint(result2).getMetadataHandle(), data2);
        AbstractFileCheckpointStorageTestBase.validateContents(storage2.resolveCheckpoint(result1).getMetadataHandle(), data1);
        AbstractFileCheckpointStorageTestBase.validateContents(storage2.resolveCheckpoint(result2).getMetadataHandle(), data2);
    }

    @Test
    public void writeToAlreadyExistingCheckpointFails() throws Exception {
        byte[] data = new byte[]{8, 8, 4, 5, 2, 6, 3};
        long checkpointId = 177L;
        CheckpointStorage storage = this.createCheckpointStorage(this.randomTempPath());
        storage.initializeBaseLocations();
        CheckpointStorageLocation loc = storage.initializeLocationForCheckpoint(177L);
        try (CheckpointMetadataOutputStream out = loc.createMetadataOutputStream();){
            out.write(data);
            out.closeAndFinalizeCheckpoint();
        }
        try {
            loc.createMetadataOutputStream();
            Assert.fail((String)"this should fail with an exception");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testSavepointPathConfiguredAndTarget() throws Exception {
        Path savepointDir = this.randomTempPath();
        Path customDir = this.randomTempPath();
        this.testSavepoint(savepointDir, customDir, customDir);
    }

    @Test
    public void testSavepointPathConfiguredNoTarget() throws Exception {
        Path savepointDir = this.randomTempPath();
        this.testSavepoint(savepointDir, null, savepointDir);
    }

    @Test
    public void testNoSavepointPathConfiguredAndTarget() throws Exception {
        Path customDir = Path.fromLocalFile((File)this.tmp.newFolder());
        this.testSavepoint(null, customDir, customDir);
    }

    @Test
    public void testNoSavepointPathConfiguredNoTarget() throws Exception {
        CheckpointStorage storage = this.createCheckpointStorage(this.randomTempPath());
        try {
            storage.initializeLocationForSavepoint(1337L, null);
            Assert.fail((String)"this should fail with an exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void testSavepoint(@Nullable Path savepointDir, @Nullable Path customDir, Path expectedParent) throws Exception {
        CompletedCheckpointStorageLocation completed;
        CheckpointStorage storage = savepointDir == null ? this.createCheckpointStorage(this.randomTempPath()) : this.createCheckpointStorageWithSavepointDir(this.randomTempPath(), savepointDir);
        String customLocation = customDir == null ? null : customDir.toString();
        CheckpointStorageLocation savepointLocation = storage.initializeLocationForSavepoint(52452L, customLocation);
        byte[] data = new byte[]{77, 66, 55, 99, 88};
        try (CheckpointMetadataOutputStream out = savepointLocation.createMetadataOutputStream();){
            out.write(data);
            completed = out.closeAndFinalizeCheckpoint();
        }
        Path normalizedWithSlash = Path.fromLocalFile((File)new File(new Path(completed.getExternalPointer()).getParent().getPath()));
        Assert.assertEquals((Object)expectedParent, (Object)normalizedWithSlash);
        AbstractFileCheckpointStorageTestBase.validateContents(completed.getMetadataHandle(), data);
        FileStateHandle fileStateHandle = (FileStateHandle)completed.getMetadataHandle();
        Path usedSavepointDir = new Path(new File(fileStateHandle.getFilePath().getParent().getParent().getPath()).toURI());
        Assert.assertEquals((Object)expectedParent, (Object)usedSavepointDir);
    }

    public Path randomTempPath() throws IOException {
        return Path.fromLocalFile((File)this.tmp.newFolder());
    }

    private static void validateContents(StreamStateHandle handle, byte[] expected) throws IOException {
        try (FSDataInputStream in = handle.openInputStream();){
            AbstractFileCheckpointStorageTestBase.validateContents((InputStream)in, expected);
        }
    }

    private static void validateContents(InputStream in, byte[] expected) throws IOException {
        int read;
        byte[] buffer = new byte[expected.length];
        int pos = 0;
        for (int remaining = expected.length; remaining > 0; remaining -= read) {
            read = in.read(buffer, pos, remaining);
            if (read == -1) {
                throw new EOFException();
            }
            pos += read;
        }
        Assert.assertArrayEquals((byte[])expected, (byte[])buffer);
    }
}

