/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.security;

import java.security.Permission;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.flink.configuration.ClusterOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.IllegalConfigurationException;
import org.apache.flink.core.testutils.CommonTestUtils;
import org.apache.flink.runtime.security.ExitTrappingSecurityManager;
import org.apache.flink.util.TestLogger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ExitTrappingSecurityManagerTest
extends TestLogger {
    private SecurityManager existingManager;

    @Before
    public void before() {
        this.existingManager = System.getSecurityManager();
    }

    @After
    public void after() {
        System.setSecurityManager(this.existingManager);
    }

    @Test
    public void testExitWithNoExistingSecurityManager() {
        AtomicInteger customExitExecuted = new AtomicInteger(0);
        ExitTrappingSecurityManager exitTrappingSecurityManager = new ExitTrappingSecurityManager(customExitExecuted::set, null);
        exitTrappingSecurityManager.checkExit(42);
        Assert.assertThat((Object)customExitExecuted.get(), (Matcher)Matchers.is((Object)42));
    }

    @Test
    public void testExistingSecurityManagerRespected() {
        SecurityManager securityManager = new SecurityManager(){

            @Override
            public void checkPermission(Permission perm) {
                throw new SecurityException("not allowed");
            }
        };
        ExitTrappingSecurityManager exitTrappingSecurityManager = new ExitTrappingSecurityManager(status -> Assert.fail(), securityManager);
        CommonTestUtils.assertThrows((String)"not allowed", SecurityException.class, () -> {
            exitTrappingSecurityManager.checkExit(42);
            return null;
        });
    }

    @Test
    public void testExitCodeHandling() {
        final AtomicInteger exitingSecurityManagerCalled = new AtomicInteger(0);
        SecurityManager securityManager = new SecurityManager(){

            @Override
            public void checkExit(int status) {
                exitingSecurityManagerCalled.set(status);
            }
        };
        AtomicInteger customExitExecuted = new AtomicInteger(0);
        ExitTrappingSecurityManager exitTrappingSecurityManager = new ExitTrappingSecurityManager(customExitExecuted::set, securityManager);
        exitTrappingSecurityManager.checkExit(42);
        Assert.assertThat((Object)exitingSecurityManagerCalled.get(), (Matcher)Matchers.is((Object)42));
        Assert.assertThat((Object)customExitExecuted.get(), (Matcher)Matchers.is((Object)42));
    }

    @Test
    public void testNotRegisteredByDefault() {
        ExitTrappingSecurityManager.replaceGracefulExitWithHaltIfConfigured((Configuration)new Configuration());
        Assert.assertThat((Object)System.getSecurityManager(), (Matcher)CoreMatchers.not((Matcher)Matchers.instanceOf(ExitTrappingSecurityManager.class)));
    }

    @Test
    public void testRegisteredWhenConfigValueSet() {
        Configuration configuration = new Configuration();
        configuration.set(ClusterOptions.HALT_ON_FATAL_ERROR, (Object)true);
        ExitTrappingSecurityManager.replaceGracefulExitWithHaltIfConfigured((Configuration)configuration);
        Assert.assertThat((Object)System.getSecurityManager(), (Matcher)Matchers.is((Matcher)Matchers.instanceOf(ExitTrappingSecurityManager.class)));
    }

    @Test
    public void testRegistrationNotAllowedByExistingSecurityManager() {
        Configuration configuration = new Configuration();
        configuration.set(ClusterOptions.HALT_ON_FATAL_ERROR, (Object)true);
        System.setSecurityManager(new SecurityManager(){
            private boolean fired;

            @Override
            public void checkPermission(Permission perm) {
                if (!this.fired && perm.getName().equals("setSecurityManager")) {
                    try {
                        throw new SecurityException("not allowed");
                    }
                    catch (Throwable throwable) {
                        this.fired = true;
                        throw throwable;
                    }
                }
            }
        });
        CommonTestUtils.assertThrows((String)"Could not register forceful shutdown handler.", IllegalConfigurationException.class, () -> {
            ExitTrappingSecurityManager.replaceGracefulExitWithHaltIfConfigured((Configuration)configuration);
            return null;
        });
    }
}

