/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.strategy;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.flink.runtime.io.network.partition.ResultPartitionType;
import org.apache.flink.runtime.jobgraph.IntermediateDataSetID;
import org.apache.flink.runtime.jobgraph.IntermediateResultPartitionID;
import org.apache.flink.runtime.scheduler.strategy.ResultPartitionState;
import org.apache.flink.runtime.scheduler.strategy.SchedulingResultPartition;
import org.apache.flink.runtime.scheduler.strategy.TestingSchedulingExecutionVertex;
import org.apache.flink.util.Preconditions;

public class TestingSchedulingResultPartition
implements SchedulingResultPartition {
    private final IntermediateDataSetID intermediateDataSetID;
    private final IntermediateResultPartitionID intermediateResultPartitionID;
    private final ResultPartitionType partitionType;
    private TestingSchedulingExecutionVertex producer;
    private Collection<TestingSchedulingExecutionVertex> consumers;
    private ResultPartitionState state;

    TestingSchedulingResultPartition(IntermediateDataSetID dataSetID, ResultPartitionType type, ResultPartitionState state) {
        this.intermediateDataSetID = dataSetID;
        this.partitionType = type;
        this.state = state;
        this.intermediateResultPartitionID = new IntermediateResultPartitionID();
        this.consumers = new ArrayList<TestingSchedulingExecutionVertex>();
    }

    public IntermediateResultPartitionID getId() {
        return this.intermediateResultPartitionID;
    }

    public IntermediateDataSetID getResultId() {
        return this.intermediateDataSetID;
    }

    public ResultPartitionType getResultType() {
        return this.partitionType;
    }

    public ResultPartitionState getState() {
        return this.state;
    }

    public TestingSchedulingExecutionVertex getProducer() {
        return this.producer;
    }

    public Iterable<TestingSchedulingExecutionVertex> getConsumers() {
        return this.consumers;
    }

    void addConsumer(TestingSchedulingExecutionVertex consumer) {
        this.consumers.add(consumer);
    }

    void setProducer(TestingSchedulingExecutionVertex producer) {
        this.producer = (TestingSchedulingExecutionVertex)Preconditions.checkNotNull((Object)producer);
    }

    void setState(ResultPartitionState state) {
        this.state = state;
    }

    public static final class Builder {
        private IntermediateDataSetID intermediateDataSetId = new IntermediateDataSetID();
        private ResultPartitionType resultPartitionType = ResultPartitionType.BLOCKING;
        private ResultPartitionState resultPartitionState = ResultPartitionState.CONSUMABLE;

        Builder withIntermediateDataSetID(IntermediateDataSetID intermediateDataSetId) {
            this.intermediateDataSetId = intermediateDataSetId;
            return this;
        }

        Builder withResultPartitionState(ResultPartitionState state) {
            this.resultPartitionState = state;
            return this;
        }

        Builder withResultPartitionType(ResultPartitionType type) {
            this.resultPartitionType = type;
            return this;
        }

        TestingSchedulingResultPartition build() {
            return new TestingSchedulingResultPartition(this.intermediateDataSetId, this.resultPartitionType, this.resultPartitionState);
        }
    }
}

