/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler;

import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.scheduler.DefaultExecutionSlotAllocator;
import org.apache.flink.runtime.scheduler.InputsLocationsRetriever;
import org.apache.flink.runtime.scheduler.TestingInputsLocationsRetriever;
import org.apache.flink.runtime.scheduler.strategy.ExecutionVertexID;
import org.apache.flink.util.TestLogger;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class DefaultExecutionSlotAllocatorPreferredLocationsTest
extends TestLogger {
    @Test
    public void testIgnoreEdgeOfTooManyLocations() throws Exception {
        ExecutionVertexID consumerId = new ExecutionVertexID(new JobVertexID(), 0);
        ArrayList<ExecutionVertexID> producerIds = new ArrayList<ExecutionVertexID>(9);
        TestingInputsLocationsRetriever.Builder locationRetrieverBuilder = new TestingInputsLocationsRetriever.Builder();
        JobVertexID jobVertexID = new JobVertexID();
        for (int i = 0; i < 9; ++i) {
            ExecutionVertexID producerId = new ExecutionVertexID(jobVertexID, i);
            locationRetrieverBuilder.connectConsumerToProducer(consumerId, producerId);
            producerIds.add(producerId);
        }
        TestingInputsLocationsRetriever inputsLocationsRetriever = locationRetrieverBuilder.build();
        for (int i = 0; i < 9; ++i) {
            inputsLocationsRetriever.markScheduled((ExecutionVertexID)producerIds.get(i));
        }
        CompletableFuture preferredLocations = DefaultExecutionSlotAllocator.getPreferredLocationsBasedOnInputs((ExecutionVertexID)consumerId, (InputsLocationsRetriever)inputsLocationsRetriever);
        Assert.assertThat(preferredLocations.get(), (Matcher)Matchers.hasSize((int)0));
    }

    @Test
    public void testChooseLocationsOnEdgeWithLessDifferentNumber() throws Exception {
        int i;
        ExecutionVertexID producerId;
        int i2;
        ExecutionVertexID consumerId = new ExecutionVertexID(new JobVertexID(), 0);
        TestingInputsLocationsRetriever.Builder locationRetrieverBuilder = new TestingInputsLocationsRetriever.Builder();
        JobVertexID jobVertexID1 = new JobVertexID();
        JobVertexID jobVertexID2 = new JobVertexID();
        int parallelism1 = 3;
        int parallelism2 = 5;
        ArrayList<ExecutionVertexID> producers1 = new ArrayList<ExecutionVertexID>(parallelism1);
        ArrayList<ExecutionVertexID> producers2 = new ArrayList<ExecutionVertexID>(parallelism2);
        for (i2 = 0; i2 < parallelism1; ++i2) {
            producerId = new ExecutionVertexID(jobVertexID1, i2);
            producers1.add(producerId);
            locationRetrieverBuilder.connectConsumerToProducer(consumerId, producerId);
        }
        for (i2 = 0; i2 < parallelism2; ++i2) {
            producerId = new ExecutionVertexID(jobVertexID2, i2);
            producers2.add(producerId);
            locationRetrieverBuilder.connectConsumerToProducer(consumerId, producerId);
        }
        TestingInputsLocationsRetriever inputsLocationsRetriever = locationRetrieverBuilder.build();
        ArrayList expectedLocations = new ArrayList(parallelism1);
        for (i = 0; i < parallelism1; ++i) {
            inputsLocationsRetriever.assignTaskManagerLocation((ExecutionVertexID)producers1.get(i));
            expectedLocations.add(inputsLocationsRetriever.getTaskManagerLocation((ExecutionVertexID)producers1.get(i)).get().getNow(null));
        }
        for (i = 0; i < parallelism2; ++i) {
            inputsLocationsRetriever.assignTaskManagerLocation((ExecutionVertexID)producers2.get(i));
        }
        CompletableFuture preferredLocations = DefaultExecutionSlotAllocator.getPreferredLocationsBasedOnInputs((ExecutionVertexID)consumerId, (InputsLocationsRetriever)inputsLocationsRetriever);
        Assert.assertThat(preferredLocations.get(), (Matcher)Matchers.containsInAnyOrder((Object[])expectedLocations.toArray()));
    }
}

