/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rpc;

import akka.actor.ActorSystem;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.akka.AkkaUtils;
import org.apache.flink.runtime.concurrent.FutureUtils;
import org.apache.flink.runtime.rpc.RpcEndpoint;
import org.apache.flink.runtime.rpc.RpcGateway;
import org.apache.flink.runtime.rpc.RpcService;
import org.apache.flink.runtime.rpc.RpcUtils;
import org.apache.flink.runtime.rpc.akka.AkkaRpcService;
import org.apache.flink.runtime.rpc.akka.AkkaRpcServiceConfiguration;
import org.apache.flink.util.TestLogger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import scala.concurrent.Future;

public class RpcEndpointTest
extends TestLogger {
    private static final Time TIMEOUT = Time.seconds((long)10L);
    private static ActorSystem actorSystem = null;
    private static RpcService rpcService = null;

    @BeforeClass
    public static void setup() {
        actorSystem = AkkaUtils.createDefaultActorSystem();
        rpcService = new AkkaRpcService(actorSystem, AkkaRpcServiceConfiguration.defaultConfiguration());
    }

    @AfterClass
    public static void teardown() throws Exception {
        CompletableFuture rpcTerminationFuture = rpcService.stopService();
        CompletableFuture actorSystemTerminationFuture = FutureUtils.toJava((Future)actorSystem.terminate());
        FutureUtils.waitForAll(Arrays.asList(rpcTerminationFuture, actorSystemTerminationFuture)).get(TIMEOUT.toMilliseconds(), TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSelfGateway() throws Exception {
        int expectedValue = 1337;
        BaseEndpoint baseEndpoint = new BaseEndpoint(rpcService, expectedValue);
        try {
            baseEndpoint.start();
            BaseGateway baseGateway = (BaseGateway)baseEndpoint.getSelfGateway(BaseGateway.class);
            CompletableFuture<Integer> foobar = baseGateway.foobar();
            Assert.assertEquals((Object)expectedValue, (Object)foobar.get());
        }
        finally {
            RpcUtils.terminateRpcEndpoint((RpcEndpoint)baseEndpoint, (Time)TIMEOUT);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=RuntimeException.class)
    public void testWrongSelfGateway() throws Exception {
        int expectedValue = 1337;
        BaseEndpoint baseEndpoint = new BaseEndpoint(rpcService, expectedValue);
        try {
            baseEndpoint.start();
            DifferentGateway differentGateway = (DifferentGateway)baseEndpoint.getSelfGateway(DifferentGateway.class);
            Assert.fail((String)"Expected to fail with a RuntimeException since we requested the wrong gateway type.");
        }
        finally {
            RpcUtils.terminateRpcEndpoint((RpcEndpoint)baseEndpoint, (Time)TIMEOUT);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEndpointInheritance() throws Exception {
        int foobar = 1;
        int barfoo = 2;
        String foo = "foobar";
        ExtendedEndpoint endpoint = new ExtendedEndpoint(rpcService, foobar, barfoo, foo);
        try {
            endpoint.start();
            BaseGateway baseGateway = (BaseGateway)endpoint.getSelfGateway(BaseGateway.class);
            ExtendedGateway extendedGateway = (ExtendedGateway)endpoint.getSelfGateway(ExtendedGateway.class);
            DifferentGateway differentGateway = (DifferentGateway)endpoint.getSelfGateway(DifferentGateway.class);
            Assert.assertEquals((Object)foobar, (Object)baseGateway.foobar().get());
            Assert.assertEquals((Object)foobar, (Object)extendedGateway.foobar().get());
            Assert.assertEquals((Object)barfoo, (Object)extendedGateway.barfoo().get());
            Assert.assertEquals((Object)foo, (Object)differentGateway.foo().get());
        }
        finally {
            RpcUtils.terminateRpcEndpoint((RpcEndpoint)endpoint, (Time)TIMEOUT);
        }
    }

    @Test
    public void testRunningState() throws InterruptedException, ExecutionException, TimeoutException {
        RunningStateTestingEndpoint endpoint = new RunningStateTestingEndpoint(rpcService, CompletableFuture.completedFuture(null));
        RunningStateTestingEndpointGateway gateway = (RunningStateTestingEndpointGateway)endpoint.getSelfGateway(RunningStateTestingEndpointGateway.class);
        try {
            endpoint.start();
            Assert.assertThat((Object)gateway.queryIsRunningFlag().get(), (Matcher)CoreMatchers.is((Object)true));
        }
        finally {
            RpcUtils.terminateRpcEndpoint((RpcEndpoint)endpoint, (Time)TIMEOUT);
        }
    }

    @Test
    public void testNotRunningState() throws InterruptedException, ExecutionException, TimeoutException {
        CompletableFuture<Void> stopFuture = new CompletableFuture<Void>();
        RunningStateTestingEndpoint endpoint = new RunningStateTestingEndpoint(rpcService, stopFuture);
        RunningStateTestingEndpointGateway gateway = (RunningStateTestingEndpointGateway)endpoint.getSelfGateway(RunningStateTestingEndpointGateway.class);
        endpoint.start();
        CompletableFuture<Void> terminationFuture = endpoint.closeAndWaitUntilOnStopCalled();
        Assert.assertThat((Object)gateway.queryIsRunningFlag().get(), (Matcher)CoreMatchers.is((Object)false));
        stopFuture.complete(null);
        terminationFuture.get(TIMEOUT.toMilliseconds(), TimeUnit.MILLISECONDS);
    }

    private static final class RunningStateTestingEndpoint
    extends RpcEndpoint
    implements RunningStateTestingEndpointGateway {
        private final CountDownLatch onStopCalled;
        private final CompletableFuture<Void> stopFuture;

        RunningStateTestingEndpoint(RpcService rpcService, CompletableFuture<Void> stopFuture) {
            super(rpcService);
            this.stopFuture = stopFuture;
            this.onStopCalled = new CountDownLatch(1);
        }

        public CompletableFuture<Void> onStop() {
            this.onStopCalled.countDown();
            return this.stopFuture;
        }

        CompletableFuture<Void> closeAndWaitUntilOnStopCalled() throws InterruptedException {
            CompletableFuture terminationFuture = this.closeAsync();
            this.onStopCalled.await();
            return terminationFuture;
        }

        @Override
        public CompletableFuture<Boolean> queryIsRunningFlag() {
            return CompletableFuture.completedFuture(this.isRunning());
        }
    }

    public static interface RunningStateTestingEndpointGateway
    extends RpcGateway {
        public CompletableFuture<Boolean> queryIsRunningFlag();
    }

    public static class ExtendedEndpoint
    extends BaseEndpoint
    implements ExtendedGateway,
    DifferentGateway {
        private final int barfooValue;
        private final String fooString;

        protected ExtendedEndpoint(RpcService rpcService, int foobarValue, int barfooValue, String fooString) {
            super(rpcService, foobarValue);
            this.barfooValue = barfooValue;
            this.fooString = fooString;
        }

        @Override
        public CompletableFuture<Integer> barfoo() {
            return CompletableFuture.completedFuture(this.barfooValue);
        }

        @Override
        public CompletableFuture<String> foo() {
            return CompletableFuture.completedFuture(this.fooString);
        }
    }

    public static class BaseEndpoint
    extends RpcEndpoint
    implements BaseGateway {
        private final int foobarValue;

        protected BaseEndpoint(RpcService rpcService, int foobarValue) {
            super(rpcService);
            this.foobarValue = foobarValue;
        }

        @Override
        public CompletableFuture<Integer> foobar() {
            return CompletableFuture.completedFuture(this.foobarValue);
        }
    }

    public static interface DifferentGateway
    extends RpcGateway {
        public CompletableFuture<String> foo();
    }

    public static interface ExtendedGateway
    extends BaseGateway {
        public CompletableFuture<Integer> barfoo();
    }

    public static interface BaseGateway
    extends RpcGateway {
        public CompletableFuture<Integer> foobar();
    }
}

