/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.messages.job;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.rest.messages.RestResponseMarshallingTestBase;
import org.apache.flink.runtime.rest.messages.job.JobDetailsInfo;
import org.apache.flink.runtime.rest.messages.job.metrics.IOMetricsInfo;

public class JobDetailsInfoTest
extends RestResponseMarshallingTestBase<JobDetailsInfo> {
    @Override
    protected Class<JobDetailsInfo> getTestResponseClass() {
        return JobDetailsInfo.class;
    }

    @Override
    protected JobDetailsInfo getTestResponseInstance() throws Exception {
        Random random = new Random();
        int numJobVertexDetailsInfos = 4;
        String jsonPlan = "{\"id\":\"1234\"}";
        HashMap<JobStatus, Long> timestamps = new HashMap<JobStatus, Long>(JobStatus.values().length);
        ArrayList<JobDetailsInfo.JobVertexDetailsInfo> jobVertexInfos = new ArrayList<JobDetailsInfo.JobVertexDetailsInfo>(4);
        HashMap<ExecutionState, Integer> jobVerticesPerState = new HashMap<ExecutionState, Integer>(ExecutionState.values().length);
        for (JobStatus jobStatus : JobStatus.values()) {
            timestamps.put(jobStatus, random.nextLong());
        }
        for (int i = 0; i < 4; ++i) {
            jobVertexInfos.add(this.createJobVertexDetailsInfo(random));
        }
        for (ExecutionState executionState : ExecutionState.values()) {
            jobVerticesPerState.put(executionState, random.nextInt());
        }
        return new JobDetailsInfo(new JobID(), "foobar", true, JobStatus.values()[random.nextInt(JobStatus.values().length)], 1L, 2L, 1L, 1984L, timestamps, jobVertexInfos, jobVerticesPerState, "{\"id\":\"1234\"}");
    }

    private JobDetailsInfo.JobVertexDetailsInfo createJobVertexDetailsInfo(Random random) {
        HashMap<ExecutionState, Integer> tasksPerState = new HashMap<ExecutionState, Integer>(ExecutionState.values().length);
        IOMetricsInfo jobVertexMetrics = new IOMetricsInfo(random.nextLong(), random.nextBoolean(), random.nextLong(), random.nextBoolean(), random.nextLong(), random.nextBoolean(), random.nextLong(), random.nextBoolean());
        for (ExecutionState executionState : ExecutionState.values()) {
            tasksPerState.put(executionState, random.nextInt());
        }
        return new JobDetailsInfo.JobVertexDetailsInfo(new JobVertexID(), "jobVertex" + random.nextLong(), random.nextInt(), ExecutionState.values()[random.nextInt(ExecutionState.values().length)], random.nextLong(), random.nextLong(), random.nextLong(), tasksPerState, jobVertexMetrics);
    }
}

