/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.job;

import java.util.Collections;
import java.util.HashMap;
import java.util.concurrent.Executor;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.MetricOptions;
import org.apache.flink.runtime.accumulators.StringifiedAccumulatorResult;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.AccessExecutionJobVertex;
import org.apache.flink.runtime.executiongraph.ArchivedExecution;
import org.apache.flink.runtime.executiongraph.ArchivedExecutionJobVertex;
import org.apache.flink.runtime.executiongraph.ArchivedExecutionVertex;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.executiongraph.IOMetrics;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.RestHandlerConfiguration;
import org.apache.flink.runtime.rest.handler.job.SubtaskExecutionAttemptDetailsHandler;
import org.apache.flink.runtime.rest.handler.legacy.DefaultExecutionGraphCache;
import org.apache.flink.runtime.rest.handler.legacy.ExecutionGraphCache;
import org.apache.flink.runtime.rest.handler.legacy.metrics.MetricFetcher;
import org.apache.flink.runtime.rest.handler.legacy.metrics.MetricFetcherImpl;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.rest.messages.MessageHeaders;
import org.apache.flink.runtime.rest.messages.MessageParameters;
import org.apache.flink.runtime.rest.messages.RequestBody;
import org.apache.flink.runtime.rest.messages.job.SubtaskAttemptMessageParameters;
import org.apache.flink.runtime.rest.messages.job.SubtaskExecutionAttemptDetailsHeaders;
import org.apache.flink.runtime.rest.messages.job.SubtaskExecutionAttemptDetailsInfo;
import org.apache.flink.runtime.rest.messages.job.metrics.IOMetricsInfo;
import org.apache.flink.runtime.testingUtils.TestingUtils;
import org.apache.flink.runtime.util.EvictingBoundedList;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;

public class SubtaskExecutionAttemptDetailsHandlerTest
extends TestLogger {
    @Test
    public void testHandleRequest() throws Exception {
        JobID jobID = new JobID();
        JobVertexID jobVertexId = new JobVertexID();
        boolean subtaskIndex = true;
        ExecutionState expectedState = ExecutionState.FINISHED;
        boolean attempt = false;
        StringifiedAccumulatorResult[] emptyAccumulators = new StringifiedAccumulatorResult[]{};
        long bytesIn = 1L;
        long bytesOut = 10L;
        long recordsIn = 20L;
        long recordsOut = 30L;
        IOMetrics ioMetrics = new IOMetrics(1L, 10L, 20L, 30L);
        ArchivedExecutionJobVertex archivedExecutionJobVertex = new ArchivedExecutionJobVertex(new ArchivedExecutionVertex[]{null, new ArchivedExecutionVertex(1, "test task", new ArchivedExecution(emptyAccumulators, ioMetrics, new ExecutionAttemptID(), 0, expectedState, null, null, null, 1, new long[ExecutionState.values().length]), new EvictingBoundedList(0))}, jobVertexId, "test", 1, 1, ResourceProfile.UNKNOWN, emptyAccumulators);
        MetricFetcherImpl metricFetcher = new MetricFetcherImpl(() -> null, address -> null, (Executor)TestingUtils.defaultExecutor(), Time.milliseconds((long)1000L), ((Long)MetricOptions.METRIC_FETCHER_UPDATE_INTERVAL.defaultValue()).longValue());
        RestHandlerConfiguration restHandlerConfiguration = RestHandlerConfiguration.fromConfiguration((Configuration)new Configuration());
        SubtaskExecutionAttemptDetailsHandler handler = new SubtaskExecutionAttemptDetailsHandler(() -> null, Time.milliseconds((long)100L), Collections.emptyMap(), (MessageHeaders)SubtaskExecutionAttemptDetailsHeaders.getInstance(), (ExecutionGraphCache)new DefaultExecutionGraphCache(restHandlerConfiguration.getTimeout(), Time.milliseconds((long)restHandlerConfiguration.getRefreshInterval())), (Executor)TestingUtils.defaultExecutor(), (MetricFetcher)metricFetcher);
        HashMap<String, String> receivedPathParameters = new HashMap<String, String>(4);
        receivedPathParameters.put("jobid", jobID.toString());
        receivedPathParameters.put("vertexid", jobVertexId.toString());
        receivedPathParameters.put("subtaskindex", Integer.toString(1));
        receivedPathParameters.put("attempt", Integer.toString(0));
        HandlerRequest request = new HandlerRequest((RequestBody)EmptyRequestBody.getInstance(), (MessageParameters)new SubtaskAttemptMessageParameters(), receivedPathParameters, Collections.emptyMap());
        SubtaskExecutionAttemptDetailsInfo detailsInfo = (SubtaskExecutionAttemptDetailsInfo)handler.handleRequest(request, (AccessExecutionJobVertex)archivedExecutionJobVertex);
        IOMetricsInfo ioMetricsInfo = new IOMetricsInfo(1L, true, 10L, true, 20L, true, 30L, true);
        SubtaskExecutionAttemptDetailsInfo expectedDetailsInfo = new SubtaskExecutionAttemptDetailsInfo(1, expectedState, 0, "(unassigned)", -1L, 0L, -1L, ioMetricsInfo, "(unassigned)");
        Assert.assertEquals((Object)expectedDetailsInfo, (Object)detailsInfo);
    }
}

