/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.job;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import org.apache.flink.api.common.ArchivedExecutionConfig;
import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.ConfigurationUtils;
import org.apache.flink.runtime.executiongraph.AccessExecutionGraph;
import org.apache.flink.runtime.executiongraph.ArchivedExecutionGraph;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.HandlerRequestException;
import org.apache.flink.runtime.rest.handler.job.JobConfigHandler;
import org.apache.flink.runtime.rest.handler.legacy.DefaultExecutionGraphCache;
import org.apache.flink.runtime.rest.handler.legacy.ExecutionGraphCache;
import org.apache.flink.runtime.rest.handler.legacy.utils.ArchivedExecutionConfigBuilder;
import org.apache.flink.runtime.rest.handler.legacy.utils.ArchivedExecutionGraphBuilder;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.rest.messages.JobConfigHeaders;
import org.apache.flink.runtime.rest.messages.JobConfigInfo;
import org.apache.flink.runtime.rest.messages.JobMessageParameters;
import org.apache.flink.runtime.rest.messages.MessageHeaders;
import org.apache.flink.runtime.rest.messages.MessageParameters;
import org.apache.flink.runtime.rest.messages.RequestBody;
import org.apache.flink.runtime.testingUtils.TestingUtils;
import org.apache.flink.util.TestLogger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;

public class JobConfigHandlerTest
extends TestLogger {
    @Test
    public void handleRequest_executionConfigWithSecretValues_excludesSecretValuesFromResponse() throws HandlerRequestException {
        JobConfigHandler jobConfigHandler = new JobConfigHandler(() -> null, TestingUtils.TIMEOUT(), Collections.emptyMap(), (MessageHeaders)JobConfigHeaders.getInstance(), (ExecutionGraphCache)new DefaultExecutionGraphCache(TestingUtils.TIMEOUT(), TestingUtils.TIMEOUT()), (Executor)TestingUtils.defaultExecutor());
        HashMap<String, String> globalJobParameters = new HashMap<String, String>();
        globalJobParameters.put("foobar", "barfoo");
        globalJobParameters.put("bar.secret.foo", "my secret");
        globalJobParameters.put("password.to.my.safe", "12345");
        ArchivedExecutionConfig archivedExecutionConfig = new ArchivedExecutionConfigBuilder().setGlobalJobParameters(globalJobParameters).build();
        ArchivedExecutionGraph archivedExecutionGraph = new ArchivedExecutionGraphBuilder().setArchivedExecutionConfig(archivedExecutionConfig).build();
        HandlerRequest<EmptyRequestBody, JobMessageParameters> handlerRequest = this.createRequest(archivedExecutionGraph.getJobID());
        JobConfigInfo jobConfigInfoResponse = jobConfigHandler.handleRequest(handlerRequest, (AccessExecutionGraph)archivedExecutionGraph);
        Map<String, String> filteredGlobalJobParameters = this.filterSecretValues(globalJobParameters);
        MatcherAssert.assertThat((Object)jobConfigInfoResponse.getExecutionConfigInfo().getGlobalJobParameters(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo(filteredGlobalJobParameters)));
    }

    private Map<String, String> filterSecretValues(Map<String, String> globalJobParameters) {
        return ConfigurationUtils.hideSensitiveValues(globalJobParameters);
    }

    private HandlerRequest<EmptyRequestBody, JobMessageParameters> createRequest(JobID jobId) throws HandlerRequestException {
        HashMap<String, String> pathParameters = new HashMap<String, String>();
        pathParameters.put("jobid", jobId.toString());
        return new HandlerRequest((RequestBody)EmptyRequestBody.getInstance(), (MessageParameters)new JobMessageParameters(), pathParameters, Collections.emptyMap());
    }
}

