/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.resourcemanager.slotmanager;

import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.clusterframework.types.SlotID;
import org.apache.flink.runtime.instance.InstanceID;
import org.apache.flink.runtime.resourcemanager.slotmanager.TaskManagerSlotInformation;

public final class TestingTaskManagerSlotInformation
implements TaskManagerSlotInformation {
    private final SlotID slotId;
    private final InstanceID instanceId;
    private final ResourceProfile resourceProfile;

    private TestingTaskManagerSlotInformation(SlotID slotId, InstanceID instanceId, ResourceProfile resourceProfile) {
        this.slotId = slotId;
        this.instanceId = instanceId;
        this.resourceProfile = resourceProfile;
    }

    public SlotID getSlotId() {
        return this.slotId;
    }

    public InstanceID getInstanceId() {
        return this.instanceId;
    }

    public boolean isMatchingRequirement(ResourceProfile required) {
        return this.resourceProfile.isMatching(required);
    }

    public ResourceProfile getResourceProfile() {
        return this.resourceProfile;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    static class Builder {
        private SlotID slotId = new SlotID(ResourceID.generate(), 0);
        private InstanceID instanceId = new InstanceID();
        private ResourceProfile resourceProfile = ResourceProfile.ANY;

        Builder() {
        }

        public Builder setInstanceId(InstanceID instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public Builder setResourceProfile(ResourceProfile resourceProfile) {
            this.resourceProfile = resourceProfile;
            return this;
        }

        public Builder setSlotId(SlotID slotId) {
            this.slotId = slotId;
            return this;
        }

        public TestingTaskManagerSlotInformation build() {
            return new TestingTaskManagerSlotInformation(this.slotId, this.instanceId, this.resourceProfile);
        }
    }
}

