/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.resourcemanager.slotmanager;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.tuple.Tuple6;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.clusterframework.types.SlotID;
import org.apache.flink.runtime.concurrent.FutureUtils;
import org.apache.flink.runtime.concurrent.ScheduledExecutor;
import org.apache.flink.runtime.instance.InstanceID;
import org.apache.flink.runtime.messages.Acknowledge;
import org.apache.flink.runtime.resourcemanager.ResourceManagerId;
import org.apache.flink.runtime.resourcemanager.SlotRequest;
import org.apache.flink.runtime.resourcemanager.WorkerResourceSpec;
import org.apache.flink.runtime.resourcemanager.exceptions.ResourceManagerException;
import org.apache.flink.runtime.resourcemanager.registration.TaskExecutorConnection;
import org.apache.flink.runtime.resourcemanager.slotmanager.LeastUtilizationSlotMatchingStrategy;
import org.apache.flink.runtime.resourcemanager.slotmanager.PendingSlotRequest;
import org.apache.flink.runtime.resourcemanager.slotmanager.ResourceActions;
import org.apache.flink.runtime.resourcemanager.slotmanager.SlotManager;
import org.apache.flink.runtime.resourcemanager.slotmanager.SlotManagerBuilder;
import org.apache.flink.runtime.resourcemanager.slotmanager.SlotManagerImpl;
import org.apache.flink.runtime.resourcemanager.slotmanager.SlotMatchingStrategy;
import org.apache.flink.runtime.resourcemanager.slotmanager.TaskManagerSlot;
import org.apache.flink.runtime.resourcemanager.slotmanager.TestingResourceActions;
import org.apache.flink.runtime.resourcemanager.slotmanager.TestingResourceActionsBuilder;
import org.apache.flink.runtime.taskexecutor.SlotReport;
import org.apache.flink.runtime.taskexecutor.SlotStatus;
import org.apache.flink.runtime.taskexecutor.TaskExecutorGateway;
import org.apache.flink.runtime.taskexecutor.TestingTaskExecutorGateway;
import org.apache.flink.runtime.taskexecutor.TestingTaskExecutorGatewayBuilder;
import org.apache.flink.runtime.taskexecutor.exceptions.SlotAllocationException;
import org.apache.flink.runtime.taskexecutor.exceptions.SlotOccupiedException;
import org.apache.flink.runtime.testingUtils.TestingUtils;
import org.apache.flink.util.CoreMatchers;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.TestLogger;
import org.apache.flink.util.function.FunctionUtils;
import org.apache.flink.util.function.ThrowingRunnable;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class SlotManagerImplTest
extends TestLogger {
    private static final FlinkException TEST_EXCEPTION = new FlinkException("Test exception");
    private static final WorkerResourceSpec WORKER_RESOURCE_SPEC = new WorkerResourceSpec.Builder().setCpuCores(100.0).setTaskHeapMemoryMB(10000).setTaskOffHeapMemoryMB(10000).setNetworkMemoryMB(10000).setManagedMemoryMB(10000).build();

    @Test
    public void testTaskManagerRegistration() throws Exception {
        ResourceManagerId resourceManagerId = ResourceManagerId.generate();
        TestingResourceActions resourceManagerActions = new TestingResourceActionsBuilder().build();
        TestingTaskExecutorGateway taskExecutorGateway = new TestingTaskExecutorGatewayBuilder().createTestingTaskExecutorGateway();
        ResourceID resourceId = ResourceID.generate();
        TaskExecutorConnection taskManagerConnection = new TaskExecutorConnection(resourceId, (TaskExecutorGateway)taskExecutorGateway);
        SlotID slotId1 = new SlotID(resourceId, 0);
        SlotID slotId2 = new SlotID(resourceId, 1);
        ResourceProfile resourceProfile = ResourceProfile.fromResources((double)42.0, (int)1337);
        SlotStatus slotStatus1 = new SlotStatus(slotId1, resourceProfile);
        SlotStatus slotStatus2 = new SlotStatus(slotId2, resourceProfile);
        SlotReport slotReport = new SlotReport(Arrays.asList(slotStatus1, slotStatus2));
        try (SlotManagerImpl slotManager = this.createSlotManager(resourceManagerId, resourceManagerActions);){
            slotManager.registerTaskManager(taskManagerConnection, slotReport);
            Assert.assertTrue((String)"The number registered slots does not equal the expected number.", (2 == slotManager.getNumberRegisteredSlots() ? 1 : 0) != 0);
            Assert.assertNotNull((Object)slotManager.getSlot(slotId1));
            Assert.assertNotNull((Object)slotManager.getSlot(slotId2));
        }
    }

    @Test
    public void testTaskManagerUnregistration() throws Exception {
        ResourceManagerId resourceManagerId = ResourceManagerId.generate();
        TestingResourceActions resourceManagerActions = new TestingResourceActionsBuilder().build();
        JobID jobId = new JobID();
        TestingTaskExecutorGateway taskExecutorGateway = new TestingTaskExecutorGatewayBuilder().setRequestSlotFunction(tuple6 -> {
            Assert.assertThat((Object)tuple6.f5, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)resourceManagerId)));
            return new CompletableFuture();
        }).createTestingTaskExecutorGateway();
        ResourceID resourceId = ResourceID.generate();
        TaskExecutorConnection taskManagerConnection = new TaskExecutorConnection(resourceId, (TaskExecutorGateway)taskExecutorGateway);
        SlotID slotId1 = new SlotID(resourceId, 0);
        SlotID slotId2 = new SlotID(resourceId, 1);
        AllocationID allocationId1 = new AllocationID();
        AllocationID allocationId2 = new AllocationID();
        ResourceProfile resourceProfile = ResourceProfile.fromResources((double)42.0, (int)1337);
        SlotStatus slotStatus1 = new SlotStatus(slotId1, resourceProfile, jobId, allocationId1);
        SlotStatus slotStatus2 = new SlotStatus(slotId2, resourceProfile);
        SlotReport slotReport = new SlotReport(Arrays.asList(slotStatus1, slotStatus2));
        SlotRequest slotRequest = new SlotRequest(new JobID(), allocationId2, resourceProfile, "foobar");
        try (SlotManagerImpl slotManager = this.createSlotManager(resourceManagerId, resourceManagerActions);){
            slotManager.registerTaskManager(taskManagerConnection, slotReport);
            Assert.assertTrue((String)"The number registered slots does not equal the expected number.", (2 == slotManager.getNumberRegisteredSlots() ? 1 : 0) != 0);
            TaskManagerSlot slot1 = slotManager.getSlot(slotId1);
            TaskManagerSlot slot2 = slotManager.getSlot(slotId2);
            Assert.assertTrue((slot1.getState() == TaskManagerSlot.State.ALLOCATED ? 1 : 0) != 0);
            Assert.assertTrue((slot2.getState() == TaskManagerSlot.State.FREE ? 1 : 0) != 0);
            Assert.assertTrue((boolean)slotManager.registerSlotRequest(slotRequest));
            Assert.assertFalse((slot2.getState() == TaskManagerSlot.State.FREE ? 1 : 0) != 0);
            Assert.assertTrue((slot2.getState() == TaskManagerSlot.State.PENDING ? 1 : 0) != 0);
            PendingSlotRequest pendingSlotRequest = slotManager.getSlotRequest(allocationId2);
            Assert.assertTrue((String)"The pending slot request should have been assigned to slot 2", (boolean)pendingSlotRequest.isAssigned());
            slotManager.unregisterTaskManager(taskManagerConnection.getInstanceID(), (Exception)TEST_EXCEPTION);
            Assert.assertTrue((0 == slotManager.getNumberRegisteredSlots() ? 1 : 0) != 0);
            Assert.assertFalse((boolean)pendingSlotRequest.isAssigned());
        }
    }

    @Test
    public void testSlotRequestWithoutFreeSlots() throws Exception {
        ResourceManagerId resourceManagerId = ResourceManagerId.generate();
        ResourceProfile resourceProfile = ResourceProfile.fromResources((double)42.0, (int)1337);
        SlotRequest slotRequest = new SlotRequest(new JobID(), new AllocationID(), resourceProfile, "localhost");
        CompletableFuture allocateResourceFuture = new CompletableFuture();
        TestingResourceActions resourceManagerActions = new TestingResourceActionsBuilder().setAllocateResourceConsumer(allocateResourceFuture::complete).build();
        try (SlotManagerImpl slotManager = this.createSlotManager(resourceManagerId, resourceManagerActions);){
            slotManager.registerSlotRequest(slotRequest);
            allocateResourceFuture.get();
        }
    }

    @Test
    public void testSlotRequestWithResourceAllocationFailure() throws Exception {
        ResourceManagerId resourceManagerId = ResourceManagerId.generate();
        ResourceProfile resourceProfile = ResourceProfile.fromResources((double)42.0, (int)1337);
        SlotRequest slotRequest = new SlotRequest(new JobID(), new AllocationID(), resourceProfile, "localhost");
        TestingResourceActions resourceManagerActions = new TestingResourceActionsBuilder().setAllocateResourceFunction(value -> false).build();
        try (SlotManagerImpl slotManager = this.createSlotManager(resourceManagerId, resourceManagerActions);){
            slotManager.registerSlotRequest(slotRequest);
            Assert.fail((String)"The slot request should have failed with a ResourceManagerException.");
        }
        catch (ResourceManagerException resourceManagerException) {
            // empty catch block
        }
    }

    @Test
    public void testSlotRequestWithFreeSlot() throws Exception {
        ResourceManagerId resourceManagerId = ResourceManagerId.generate();
        ResourceID resourceID = ResourceID.generate();
        JobID jobId = new JobID();
        SlotID slotId = new SlotID(resourceID, 0);
        String targetAddress = "localhost";
        AllocationID allocationId = new AllocationID();
        ResourceProfile resourceProfile = ResourceProfile.fromResources((double)42.0, (int)1337);
        SlotRequest slotRequest = new SlotRequest(jobId, allocationId, resourceProfile, "localhost");
        TestingResourceActions resourceManagerActions = new TestingResourceActionsBuilder().build();
        try (SlotManagerImpl slotManager = this.createSlotManager(resourceManagerId, resourceManagerActions);){
            CompletableFuture requestFuture = new CompletableFuture();
            TestingTaskExecutorGateway taskExecutorGateway = new TestingTaskExecutorGatewayBuilder().setRequestSlotFunction(tuple6 -> {
                requestFuture.complete(Tuple6.of((Object)tuple6.f0, (Object)tuple6.f1, (Object)tuple6.f2, (Object)tuple6.f3, (Object)tuple6.f4, (Object)tuple6.f5));
                return CompletableFuture.completedFuture(Acknowledge.get());
            }).createTestingTaskExecutorGateway();
            TaskExecutorConnection taskExecutorConnection = new TaskExecutorConnection(resourceID, (TaskExecutorGateway)taskExecutorGateway);
            SlotStatus slotStatus = new SlotStatus(slotId, resourceProfile);
            SlotReport slotReport = new SlotReport(slotStatus);
            slotManager.registerTaskManager(taskExecutorConnection, slotReport);
            Assert.assertTrue((String)"The slot request should be accepted", (boolean)slotManager.registerSlotRequest(slotRequest));
            Assert.assertThat(requestFuture.get(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)Tuple6.of((Object)slotId, (Object)jobId, (Object)allocationId, (Object)resourceProfile, (Object)"localhost", (Object)resourceManagerId))));
            TaskManagerSlot slot = slotManager.getSlot(slotId);
            Assert.assertEquals((String)"The slot has not been allocated to the expected allocation id.", (Object)allocationId, (Object)slot.getAllocationId());
        }
    }

    @Test
    public void testUnregisterPendingSlotRequest() throws Exception {
        ResourceManagerId resourceManagerId = ResourceManagerId.generate();
        TestingResourceActions resourceManagerActions = new TestingResourceActionsBuilder().build();
        ResourceID resourceID = ResourceID.generate();
        SlotID slotId = new SlotID(resourceID, 0);
        AllocationID allocationId = new AllocationID();
        TestingTaskExecutorGateway taskExecutorGateway = new TestingTaskExecutorGatewayBuilder().setRequestSlotFunction(slotIDJobIDAllocationIDStringResourceManagerIdTuple6 -> new CompletableFuture()).createTestingTaskExecutorGateway();
        ResourceProfile resourceProfile = ResourceProfile.fromResources((double)1.0, (int)1);
        SlotStatus slotStatus = new SlotStatus(slotId, resourceProfile);
        SlotReport slotReport = new SlotReport(slotStatus);
        SlotRequest slotRequest = new SlotRequest(new JobID(), allocationId, resourceProfile, "foobar");
        TaskExecutorConnection taskManagerConnection = new TaskExecutorConnection(resourceID, (TaskExecutorGateway)taskExecutorGateway);
        try (SlotManagerImpl slotManager = this.createSlotManager(resourceManagerId, resourceManagerActions);){
            slotManager.registerTaskManager(taskManagerConnection, slotReport);
            TaskManagerSlot slot = slotManager.getSlot(slotId);
            slotManager.registerSlotRequest(slotRequest);
            Assert.assertNotNull((Object)slotManager.getSlotRequest(allocationId));
            Assert.assertTrue((slot.getState() == TaskManagerSlot.State.PENDING ? 1 : 0) != 0);
            slotManager.unregisterSlotRequest(allocationId);
            Assert.assertNull((Object)slotManager.getSlotRequest(allocationId));
            slot = slotManager.getSlot(slotId);
            Assert.assertTrue((slot.getState() == TaskManagerSlot.State.FREE ? 1 : 0) != 0);
        }
    }

    @Test
    public void testFulfillingPendingSlotRequest() throws Exception {
        ResourceManagerId resourceManagerId = ResourceManagerId.generate();
        ResourceID resourceID = ResourceID.generate();
        JobID jobId = new JobID();
        SlotID slotId = new SlotID(resourceID, 0);
        String targetAddress = "localhost";
        AllocationID allocationId = new AllocationID();
        ResourceProfile resourceProfile = ResourceProfile.fromResources((double)42.0, (int)1337);
        SlotRequest slotRequest = new SlotRequest(jobId, allocationId, resourceProfile, "localhost");
        AtomicInteger numberAllocateResourceCalls = new AtomicInteger(0);
        TestingResourceActions resourceManagerActions = new TestingResourceActionsBuilder().setAllocateResourceConsumer(ignored -> numberAllocateResourceCalls.incrementAndGet()).build();
        CompletableFuture requestFuture = new CompletableFuture();
        TestingTaskExecutorGateway taskExecutorGateway = new TestingTaskExecutorGatewayBuilder().setRequestSlotFunction(tuple6 -> {
            requestFuture.complete(Tuple6.of((Object)tuple6.f0, (Object)tuple6.f1, (Object)tuple6.f2, (Object)tuple6.f3, (Object)tuple6.f4, (Object)tuple6.f5));
            return CompletableFuture.completedFuture(Acknowledge.get());
        }).createTestingTaskExecutorGateway();
        TaskExecutorConnection taskExecutorConnection = new TaskExecutorConnection(resourceID, (TaskExecutorGateway)taskExecutorGateway);
        SlotStatus slotStatus = new SlotStatus(slotId, resourceProfile);
        SlotReport slotReport = new SlotReport(slotStatus);
        try (SlotManagerImpl slotManager = this.createSlotManager(resourceManagerId, resourceManagerActions);){
            Assert.assertTrue((String)"The slot request should be accepted", (boolean)slotManager.registerSlotRequest(slotRequest));
            Assert.assertThat((Object)numberAllocateResourceCalls.get(), (Matcher)Matchers.is((Object)1));
            slotManager.registerTaskManager(taskExecutorConnection, slotReport);
            Assert.assertThat(requestFuture.get(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)Tuple6.of((Object)slotId, (Object)jobId, (Object)allocationId, (Object)resourceProfile, (Object)"localhost", (Object)resourceManagerId))));
            TaskManagerSlot slot = slotManager.getSlot(slotId);
            Assert.assertEquals((String)"The slot has not been allocated to the expected allocation id.", (Object)allocationId, (Object)slot.getAllocationId());
        }
    }

    @Test
    public void testFreeSlot() throws Exception {
        ResourceManagerId resourceManagerId = ResourceManagerId.generate();
        JobID jobId = new JobID();
        TestingResourceActions resourceManagerActions = new TestingResourceActionsBuilder().build();
        TaskExecutorConnection taskExecutorConnection = this.createTaskExecutorConnection();
        ResourceID resourceID = taskExecutorConnection.getResourceID();
        SlotID slotId = new SlotID(resourceID, 0);
        AllocationID allocationId = new AllocationID();
        ResourceProfile resourceProfile = ResourceProfile.fromResources((double)42.0, (int)1337);
        SlotStatus slotStatus = new SlotStatus(slotId, resourceProfile, jobId, allocationId);
        SlotReport slotReport = new SlotReport(slotStatus);
        try (SlotManagerImpl slotManager = this.createSlotManager(resourceManagerId, resourceManagerActions);){
            slotManager.registerTaskManager(taskExecutorConnection, slotReport);
            TaskManagerSlot slot = slotManager.getSlot(slotId);
            Assert.assertEquals((String)"The slot has not been allocated to the expected allocation id.", (Object)allocationId, (Object)slot.getAllocationId());
            slotManager.freeSlot(slotId, new AllocationID());
            Assert.assertTrue((slot.getState() == TaskManagerSlot.State.ALLOCATED ? 1 : 0) != 0);
            Assert.assertEquals((String)"The slot has not been allocated to the expected allocation id.", (Object)allocationId, (Object)slot.getAllocationId());
            slotManager.freeSlot(slotId, allocationId);
            Assert.assertTrue((slot.getState() == TaskManagerSlot.State.FREE ? 1 : 0) != 0);
            Assert.assertNull((Object)slot.getAllocationId());
        }
    }

    @Test
    public void testDuplicatePendingSlotRequest() throws Exception {
        ResourceManagerId resourceManagerId = ResourceManagerId.generate();
        AtomicInteger numberAllocateResourceFunctionCalls = new AtomicInteger(0);
        TestingResourceActions resourceManagerActions = new TestingResourceActionsBuilder().setAllocateResourceConsumer(ignored -> numberAllocateResourceFunctionCalls.incrementAndGet()).build();
        AllocationID allocationId = new AllocationID();
        ResourceProfile resourceProfile1 = ResourceProfile.fromResources((double)1.0, (int)2);
        ResourceProfile resourceProfile2 = ResourceProfile.fromResources((double)2.0, (int)1);
        SlotRequest slotRequest1 = new SlotRequest(new JobID(), allocationId, resourceProfile1, "foobar");
        SlotRequest slotRequest2 = new SlotRequest(new JobID(), allocationId, resourceProfile2, "barfoo");
        try (SlotManagerImpl slotManager = this.createSlotManager(resourceManagerId, resourceManagerActions);){
            Assert.assertTrue((boolean)slotManager.registerSlotRequest(slotRequest1));
            Assert.assertFalse((boolean)slotManager.registerSlotRequest(slotRequest2));
        }
        Assert.assertThat((Object)numberAllocateResourceFunctionCalls.get(), (Matcher)Matchers.is((Object)1));
    }

    @Test
    public void testDuplicatePendingSlotRequestAfterSlotReport() throws Exception {
        ResourceManagerId resourceManagerId = ResourceManagerId.generate();
        TestingResourceActions resourceManagerActions = new TestingResourceActionsBuilder().build();
        TaskExecutorConnection taskManagerConnection = this.createTaskExecutorConnection();
        ResourceID resourceID = taskManagerConnection.getResourceID();
        JobID jobId = new JobID();
        AllocationID allocationId = new AllocationID();
        ResourceProfile resourceProfile = ResourceProfile.fromResources((double)1.0, (int)1);
        SlotID slotId = new SlotID(resourceID, 0);
        SlotStatus slotStatus = new SlotStatus(slotId, resourceProfile, jobId, allocationId);
        SlotReport slotReport = new SlotReport(slotStatus);
        SlotRequest slotRequest = new SlotRequest(jobId, allocationId, resourceProfile, "foobar");
        try (SlotManagerImpl slotManager = this.createSlotManager(resourceManagerId, resourceManagerActions);){
            slotManager.registerTaskManager(taskManagerConnection, slotReport);
            Assert.assertFalse((boolean)slotManager.registerSlotRequest(slotRequest));
        }
    }

    @Test
    public void testDuplicatePendingSlotRequestAfterSuccessfulAllocation() throws Exception {
        ResourceManagerId resourceManagerId = ResourceManagerId.generate();
        AtomicInteger allocateResourceCalls = new AtomicInteger(0);
        TestingResourceActions resourceManagerActions = new TestingResourceActionsBuilder().setAllocateResourceConsumer(ignored -> allocateResourceCalls.incrementAndGet()).build();
        AllocationID allocationId = new AllocationID();
        ResourceProfile resourceProfile1 = ResourceProfile.fromResources((double)1.0, (int)2);
        ResourceProfile resourceProfile2 = ResourceProfile.fromResources((double)2.0, (int)1);
        SlotRequest slotRequest1 = new SlotRequest(new JobID(), allocationId, resourceProfile1, "foobar");
        SlotRequest slotRequest2 = new SlotRequest(new JobID(), allocationId, resourceProfile2, "barfoo");
        TestingTaskExecutorGateway taskExecutorGateway = new TestingTaskExecutorGatewayBuilder().createTestingTaskExecutorGateway();
        ResourceID resourceID = ResourceID.generate();
        TaskExecutorConnection taskManagerConnection = new TaskExecutorConnection(resourceID, (TaskExecutorGateway)taskExecutorGateway);
        SlotID slotId = new SlotID(resourceID, 0);
        SlotStatus slotStatus = new SlotStatus(slotId, resourceProfile1);
        SlotReport slotReport = new SlotReport(slotStatus);
        try (SlotManagerImpl slotManager = this.createSlotManager(resourceManagerId, resourceManagerActions);){
            slotManager.registerTaskManager(taskManagerConnection, slotReport);
            Assert.assertTrue((boolean)slotManager.registerSlotRequest(slotRequest1));
            TaskManagerSlot slot = slotManager.getSlot(slotId);
            Assert.assertEquals((String)"The slot has not been allocated to the expected allocation id.", (Object)allocationId, (Object)slot.getAllocationId());
            Assert.assertFalse((boolean)slotManager.registerSlotRequest(slotRequest2));
        }
        Assert.assertThat((Object)allocateResourceCalls.get(), (Matcher)Matchers.is((Object)0));
    }

    @Test
    public void testAcceptingDuplicateSlotRequestAfterAllocationRelease() throws Exception {
        ResourceManagerId resourceManagerId = ResourceManagerId.generate();
        AtomicInteger allocateResourceCalls = new AtomicInteger(0);
        TestingResourceActions resourceManagerActions = new TestingResourceActionsBuilder().setAllocateResourceConsumer(ignored -> allocateResourceCalls.incrementAndGet()).build();
        AllocationID allocationId = new AllocationID();
        ResourceProfile resourceProfile1 = ResourceProfile.fromResources((double)1.0, (int)2);
        ResourceProfile resourceProfile2 = ResourceProfile.fromResources((double)2.0, (int)1);
        SlotRequest slotRequest1 = new SlotRequest(new JobID(), allocationId, resourceProfile1, "foobar");
        SlotRequest slotRequest2 = new SlotRequest(new JobID(), allocationId, resourceProfile2, "barfoo");
        TestingTaskExecutorGateway taskExecutorGateway = new TestingTaskExecutorGatewayBuilder().createTestingTaskExecutorGateway();
        ResourceID resourceID = ResourceID.generate();
        TaskExecutorConnection taskManagerConnection = new TaskExecutorConnection(resourceID, (TaskExecutorGateway)taskExecutorGateway);
        SlotID slotId = new SlotID(resourceID, 0);
        SlotStatus slotStatus = new SlotStatus(slotId, ResourceProfile.fromResources((double)2.0, (int)2));
        SlotReport slotReport = new SlotReport(slotStatus);
        try (SlotManagerImpl slotManager = this.createSlotManager(resourceManagerId, resourceManagerActions);){
            slotManager.registerTaskManager(taskManagerConnection, slotReport);
            Assert.assertTrue((boolean)slotManager.registerSlotRequest(slotRequest1));
            TaskManagerSlot slot = slotManager.getSlot(slotId);
            Assert.assertEquals((String)"The slot has not been allocated to the expected allocation id.", (Object)allocationId, (Object)slot.getAllocationId());
            slotManager.freeSlot(slotId, allocationId);
            Assert.assertTrue((slot.getState() == TaskManagerSlot.State.FREE ? 1 : 0) != 0);
            Assert.assertNull((Object)slot.getAllocationId());
            Assert.assertTrue((boolean)slotManager.registerSlotRequest(slotRequest2));
            Assert.assertEquals((String)"The slot has not been allocated to the expected allocation id.", (Object)allocationId, (Object)slot.getAllocationId());
        }
        Assert.assertThat((Object)allocateResourceCalls.get(), (Matcher)Matchers.is((Object)0));
    }

    @Test
    public void testReceivingUnknownSlotReport() throws Exception {
        ResourceManagerId resourceManagerId = ResourceManagerId.generate();
        TestingResourceActions resourceManagerActions = new TestingResourceActionsBuilder().build();
        InstanceID unknownInstanceID = new InstanceID();
        SlotID unknownSlotId = new SlotID(ResourceID.generate(), 0);
        ResourceProfile unknownResourceProfile = ResourceProfile.fromResources((double)1.0, (int)1);
        SlotStatus unknownSlotStatus = new SlotStatus(unknownSlotId, unknownResourceProfile);
        SlotReport unknownSlotReport = new SlotReport(unknownSlotStatus);
        try (SlotManagerImpl slotManager = this.createSlotManager(resourceManagerId, resourceManagerActions);){
            Assert.assertTrue((0 == slotManager.getNumberRegisteredSlots() ? 1 : 0) != 0);
            Assert.assertFalse((boolean)slotManager.reportSlotStatus(unknownInstanceID, unknownSlotReport));
            Assert.assertTrue((0 == slotManager.getNumberRegisteredSlots() ? 1 : 0) != 0);
        }
    }

    @Test
    public void testUpdateSlotReport() throws Exception {
        ResourceManagerId resourceManagerId = ResourceManagerId.generate();
        TestingResourceActions resourceManagerActions = new TestingResourceActionsBuilder().build();
        JobID jobId = new JobID();
        AllocationID allocationId = new AllocationID();
        TaskExecutorConnection taskManagerConnection = this.createTaskExecutorConnection();
        ResourceID resourceId = taskManagerConnection.getResourceID();
        SlotID slotId1 = new SlotID(resourceId, 0);
        SlotID slotId2 = new SlotID(resourceId, 1);
        ResourceProfile resourceProfile = ResourceProfile.fromResources((double)1.0, (int)1);
        SlotStatus slotStatus1 = new SlotStatus(slotId1, resourceProfile);
        SlotStatus slotStatus2 = new SlotStatus(slotId2, resourceProfile);
        SlotStatus newSlotStatus2 = new SlotStatus(slotId2, resourceProfile, jobId, allocationId);
        SlotReport slotReport1 = new SlotReport(Arrays.asList(slotStatus1, slotStatus2));
        SlotReport slotReport2 = new SlotReport(Arrays.asList(newSlotStatus2, slotStatus1));
        try (SlotManagerImpl slotManager = this.createSlotManager(resourceManagerId, resourceManagerActions);){
            Assert.assertTrue((0 == slotManager.getNumberRegisteredSlots() ? 1 : 0) != 0);
            slotManager.registerTaskManager(taskManagerConnection, slotReport1);
            TaskManagerSlot slot1 = slotManager.getSlot(slotId1);
            TaskManagerSlot slot2 = slotManager.getSlot(slotId2);
            Assert.assertTrue((2 == slotManager.getNumberRegisteredSlots() ? 1 : 0) != 0);
            Assert.assertTrue((slot1.getState() == TaskManagerSlot.State.FREE ? 1 : 0) != 0);
            Assert.assertTrue((slot2.getState() == TaskManagerSlot.State.FREE ? 1 : 0) != 0);
            Assert.assertTrue((boolean)slotManager.reportSlotStatus(taskManagerConnection.getInstanceID(), slotReport2));
            Assert.assertTrue((2 == slotManager.getNumberRegisteredSlots() ? 1 : 0) != 0);
            Assert.assertNotNull((Object)slotManager.getSlot(slotId1));
            Assert.assertNotNull((Object)slotManager.getSlot(slotId2));
            Assert.assertEquals((Object)allocationId, (Object)slotManager.getSlot(slotId2).getAllocationId());
        }
    }

    @Test
    public void testSlotRequestTimeout() throws Exception {
        long allocationTimeout = 50L;
        CompletableFuture failedAllocationFuture = new CompletableFuture();
        TestingResourceActions resourceManagerActions = new TestingResourceActionsBuilder().setNotifyAllocationFailureConsumer(tuple3 -> failedAllocationFuture.complete(Tuple2.of((Object)tuple3.f0, (Object)tuple3.f1))).build();
        ResourceManagerId resourceManagerId = ResourceManagerId.generate();
        JobID jobId = new JobID();
        AllocationID allocationId = new AllocationID();
        ResourceProfile resourceProfile = ResourceProfile.fromResources((double)1.0, (int)1);
        SlotRequest slotRequest = new SlotRequest(jobId, allocationId, resourceProfile, "foobar");
        ScheduledExecutorService mainThreadExecutor = TestingUtils.defaultExecutor();
        try (SlotManagerImpl slotManager = this.createSlotManagerBuilder().setSlotRequestTimeout(Time.milliseconds((long)50L)).build();){
            slotManager.start(resourceManagerId, (Executor)mainThreadExecutor, (ResourceActions)resourceManagerActions);
            AtomicReference<Object> atomicException = new AtomicReference<Object>(null);
            mainThreadExecutor.execute(() -> SlotManagerImplTest.lambda$testSlotRequestTimeout$10((SlotManager)slotManager, slotRequest, atomicException));
            Assert.assertThat(failedAllocationFuture.get(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)Tuple2.of((Object)jobId, (Object)allocationId))));
            if (atomicException.get() != null) {
                throw (Exception)atomicException.get();
            }
        }
    }

    @Test
    public void testTaskManagerSlotRequestTimeoutHandling() throws Exception {
        ResourceManagerId resourceManagerId = ResourceManagerId.generate();
        TestingResourceActions resourceManagerActions = new TestingResourceActionsBuilder().build();
        JobID jobId = new JobID();
        AllocationID allocationId = new AllocationID();
        ResourceProfile resourceProfile = ResourceProfile.fromResources((double)42.0, (int)1337);
        SlotRequest slotRequest = new SlotRequest(jobId, allocationId, resourceProfile, "foobar");
        CompletableFuture slotRequestFuture1 = new CompletableFuture();
        CompletableFuture<Acknowledge> slotRequestFuture2 = new CompletableFuture<Acknowledge>();
        Iterator<CompletableFuture> slotRequestFutureIterator = Arrays.asList(slotRequestFuture1, slotRequestFuture2).iterator();
        ArrayBlockingQueue slotIds = new ArrayBlockingQueue(2);
        TestingTaskExecutorGateway taskExecutorGateway = new TestingTaskExecutorGatewayBuilder().setRequestSlotFunction(FunctionUtils.uncheckedFunction(requestSlotParameters -> {
            slotIds.put(requestSlotParameters.f0);
            return (CompletableFuture)slotRequestFutureIterator.next();
        })).createTestingTaskExecutorGateway();
        ResourceID resourceId = ResourceID.generate();
        TaskExecutorConnection taskManagerConnection = new TaskExecutorConnection(resourceId, (TaskExecutorGateway)taskExecutorGateway);
        SlotID slotId1 = new SlotID(resourceId, 0);
        SlotID slotId2 = new SlotID(resourceId, 1);
        SlotStatus slotStatus1 = new SlotStatus(slotId1, resourceProfile);
        SlotStatus slotStatus2 = new SlotStatus(slotId2, resourceProfile);
        SlotReport slotReport = new SlotReport(Arrays.asList(slotStatus1, slotStatus2));
        try (SlotManagerImpl slotManager = this.createSlotManager(resourceManagerId, resourceManagerActions);){
            slotManager.registerTaskManager(taskManagerConnection, slotReport);
            slotManager.registerSlotRequest(slotRequest);
            SlotID firstSlotId = (SlotID)slotIds.take();
            Assert.assertThat(slotIds, (Matcher)Matchers.is((Matcher)Matchers.empty()));
            TaskManagerSlot failedSlot = slotManager.getSlot(firstSlotId);
            slotRequestFuture1.completeExceptionally((Throwable)new SlotAllocationException("Test exception."));
            slotRequestFuture2.complete(Acknowledge.get());
            SlotID secondSlotId = (SlotID)slotIds.take();
            Assert.assertThat(slotIds, (Matcher)Matchers.is((Matcher)Matchers.empty()));
            TaskManagerSlot slot = slotManager.getSlot(secondSlotId);
            Assert.assertTrue((slot.getState() == TaskManagerSlot.State.ALLOCATED ? 1 : 0) != 0);
            Assert.assertEquals((Object)allocationId, (Object)slot.getAllocationId());
            if (!failedSlot.getSlotId().equals((Object)slot.getSlotId())) {
                Assert.assertTrue((failedSlot.getState() == TaskManagerSlot.State.FREE ? 1 : 0) != 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSlotReportWhileActiveSlotRequest() throws Exception {
        ResourceManagerId resourceManagerId = ResourceManagerId.generate();
        TestingResourceActions resourceManagerActions = new TestingResourceActionsBuilder().build();
        JobID jobId = new JobID();
        AllocationID allocationId = new AllocationID();
        ResourceProfile resourceProfile = ResourceProfile.fromResources((double)42.0, (int)1337);
        SlotRequest slotRequest = new SlotRequest(jobId, allocationId, resourceProfile, "foobar");
        CompletableFuture slotRequestFuture1 = new CompletableFuture();
        Iterator<CompletableFuture> slotRequestFutureIterator = Arrays.asList(slotRequestFuture1, CompletableFuture.completedFuture(Acknowledge.get())).iterator();
        ArrayBlockingQueue slotIds = new ArrayBlockingQueue(2);
        TestingTaskExecutorGateway taskExecutorGateway = new TestingTaskExecutorGatewayBuilder().setRequestSlotFunction(FunctionUtils.uncheckedFunction(requestSlotParameters -> {
            slotIds.put(requestSlotParameters.f0);
            return (CompletableFuture)slotRequestFutureIterator.next();
        })).createTestingTaskExecutorGateway();
        ResourceID resourceId = ResourceID.generate();
        TaskExecutorConnection taskManagerConnection = new TaskExecutorConnection(resourceId, (TaskExecutorGateway)taskExecutorGateway);
        SlotID slotId1 = new SlotID(resourceId, 0);
        SlotID slotId2 = new SlotID(resourceId, 1);
        SlotStatus slotStatus1 = new SlotStatus(slotId1, resourceProfile);
        SlotStatus slotStatus2 = new SlotStatus(slotId2, resourceProfile);
        SlotReport slotReport = new SlotReport(Arrays.asList(slotStatus1, slotStatus2));
        ScheduledExecutor mainThreadExecutor = TestingUtils.defaultScheduledExecutor();
        SlotManagerImpl slotManager = this.createSlotManagerBuilder().setScheduledExecutor(mainThreadExecutor).build();
        try {
            slotManager.start(resourceManagerId, (Executor)mainThreadExecutor, (ResourceActions)resourceManagerActions);
            CompletionStage registrationFuture = CompletableFuture.supplyAsync(() -> {
                slotManager.registerTaskManager(taskManagerConnection, slotReport);
                return null;
            }, (Executor)mainThreadExecutor).thenAccept(value -> {
                try {
                    slotManager.registerSlotRequest(slotRequest);
                }
                catch (ResourceManagerException e) {
                    throw new RuntimeException("Could not register slots.", e);
                }
            });
            ((CompletableFuture)registrationFuture).get();
            SlotID requestedSlotId = (SlotID)slotIds.take();
            SlotID freeSlotId = requestedSlotId.equals((Object)slotId1) ? slotId2 : slotId1;
            SlotStatus newSlotStatus1 = new SlotStatus(requestedSlotId, resourceProfile, new JobID(), new AllocationID());
            SlotStatus newSlotStatus2 = new SlotStatus(freeSlotId, resourceProfile);
            SlotReport newSlotReport = new SlotReport(Arrays.asList(newSlotStatus1, newSlotStatus2));
            CompletableFuture<Boolean> reportSlotStatusFuture = CompletableFuture.supplyAsync(() -> slotManager.reportSlotStatus(taskManagerConnection.getInstanceID(), newSlotReport), (Executor)mainThreadExecutor);
            Assert.assertTrue((boolean)reportSlotStatusFuture.get());
            SlotID requestedSlotId2 = (SlotID)slotIds.take();
            Assert.assertEquals((Object)freeSlotId, (Object)requestedSlotId2);
        }
        finally {
            CompletableFuture.runAsync(ThrowingRunnable.unchecked(() -> ((SlotManagerImpl)slotManager).close()), (Executor)mainThreadExecutor);
        }
    }

    @Test
    public void testTimeoutForUnusedTaskManager() throws Exception {
        long taskManagerTimeout = 50L;
        CompletableFuture releasedResourceFuture = new CompletableFuture();
        TestingResourceActions resourceManagerActions = new TestingResourceActionsBuilder().setReleaseResourceConsumer((instanceID, e) -> releasedResourceFuture.complete(instanceID)).build();
        ResourceManagerId resourceManagerId = ResourceManagerId.generate();
        ScheduledExecutor scheduledExecutor = TestingUtils.defaultScheduledExecutor();
        ResourceID resourceId = ResourceID.generate();
        JobID jobId = new JobID();
        AllocationID allocationId = new AllocationID();
        ResourceProfile resourceProfile = ResourceProfile.fromResources((double)1.0, (int)1);
        SlotRequest slotRequest = new SlotRequest(jobId, allocationId, resourceProfile, "foobar");
        CompletableFuture requestedSlotFuture = new CompletableFuture();
        TestingTaskExecutorGateway taskExecutorGateway = new TestingTaskExecutorGatewayBuilder().setRequestSlotFunction(tuple6 -> {
            requestedSlotFuture.complete(tuple6.f0);
            return CompletableFuture.completedFuture(Acknowledge.get());
        }).createTestingTaskExecutorGateway();
        TaskExecutorConnection taskManagerConnection = new TaskExecutorConnection(resourceId, (TaskExecutorGateway)taskExecutorGateway);
        SlotID slotId1 = new SlotID(resourceId, 0);
        SlotID slotId2 = new SlotID(resourceId, 1);
        SlotStatus slotStatus1 = new SlotStatus(slotId1, resourceProfile);
        SlotStatus slotStatus2 = new SlotStatus(slotId2, resourceProfile);
        SlotReport initialSlotReport = new SlotReport(Arrays.asList(slotStatus1, slotStatus2));
        ScheduledExecutorService mainThreadExecutor = TestingUtils.defaultExecutor();
        try (SlotManagerImpl slotManager = this.createSlotManagerBuilder().setTaskManagerTimeout(Time.of((long)50L, (TimeUnit)TimeUnit.MILLISECONDS)).build();){
            slotManager.start(resourceManagerId, (Executor)mainThreadExecutor, (ResourceActions)resourceManagerActions);
            CompletableFuture.supplyAsync(() -> {
                try {
                    return slotManager.registerSlotRequest(slotRequest);
                }
                catch (ResourceManagerException e) {
                    throw new CompletionException(e);
                }
            }, mainThreadExecutor).thenRun(() -> slotManager.registerTaskManager(taskManagerConnection, initialSlotReport));
            SlotID slotId = (SlotID)requestedSlotFuture.get();
            CompletableFuture<Boolean> idleFuture = CompletableFuture.supplyAsync(() -> slotManager.isTaskManagerIdle(taskManagerConnection.getInstanceID()), mainThreadExecutor);
            Assert.assertFalse((boolean)idleFuture.get());
            CompletableFuture<TaskManagerSlot> slotFuture = CompletableFuture.supplyAsync(() -> slotManager.getSlot(slotId), mainThreadExecutor);
            TaskManagerSlot slot = slotFuture.get();
            Assert.assertTrue((slot.getState() == TaskManagerSlot.State.ALLOCATED ? 1 : 0) != 0);
            Assert.assertEquals((Object)allocationId, (Object)slot.getAllocationId());
            CompletionStage idleFuture2 = CompletableFuture.runAsync(() -> slotManager.freeSlot(slotId, allocationId), mainThreadExecutor).thenApply(value -> slotManager.isTaskManagerIdle(taskManagerConnection.getInstanceID()));
            Assert.assertTrue((boolean)((Boolean)((CompletableFuture)idleFuture2).get()));
            Assert.assertThat(releasedResourceFuture.get(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)taskManagerConnection.getInstanceID())));
        }
    }

    @Test
    public void testTaskManagerTimeoutDoesNotRemoveSlots() throws Exception {
        Time taskManagerTimeout = Time.milliseconds((long)10L);
        ResourceManagerId resourceManagerId = ResourceManagerId.generate();
        ResourceID resourceID = ResourceID.generate();
        CompletableFuture releaseResourceFuture = new CompletableFuture();
        TestingResourceActions resourceActions = new TestingResourceActionsBuilder().setReleaseResourceConsumer((instanceId, ignored) -> releaseResourceFuture.complete(instanceId)).build();
        TestingTaskExecutorGateway taskExecutorGateway = new TestingTaskExecutorGatewayBuilder().createTestingTaskExecutorGateway();
        TaskExecutorConnection taskExecutorConnection = new TaskExecutorConnection(resourceID, (TaskExecutorGateway)taskExecutorGateway);
        SlotStatus slotStatus = SlotManagerImplTest.createEmptySlotStatus(new SlotID(resourceID, 0), ResourceProfile.fromResources((double)1.0, (int)1));
        SlotReport initialSlotReport = new SlotReport(slotStatus);
        try (SlotManagerImpl slotManager = this.createSlotManagerBuilder().setTaskManagerTimeout(taskManagerTimeout).buildAndStartWithDirectExec(resourceManagerId, resourceActions);){
            slotManager.registerTaskManager(taskExecutorConnection, initialSlotReport);
            Assert.assertEquals((long)1L, (long)slotManager.getNumberRegisteredSlots());
            Assert.assertThat(releaseResourceFuture.get(), (Matcher)Matchers.is((Object)taskExecutorConnection.getInstanceID()));
            Assert.assertEquals((long)1L, (long)slotManager.getNumberRegisteredSlots());
            slotManager.unregisterTaskManager(taskExecutorConnection.getInstanceID(), (Exception)TEST_EXCEPTION);
            Assert.assertEquals((long)0L, (long)slotManager.getNumberRegisteredSlots());
        }
    }

    @Test
    public void testReportAllocatedSlot() throws Exception {
        ResourceID taskManagerId = ResourceID.generate();
        TestingResourceActions resourceActions = new TestingResourceActionsBuilder().build();
        TestingTaskExecutorGateway taskExecutorGateway = new TestingTaskExecutorGatewayBuilder().createTestingTaskExecutorGateway();
        TaskExecutorConnection taskExecutorConnection = new TaskExecutorConnection(taskManagerId, (TaskExecutorGateway)taskExecutorGateway);
        try (SlotManagerImpl slotManager = this.createSlotManager(ResourceManagerId.generate(), resourceActions);){
            SlotID slotId = new SlotID(taskManagerId, 0);
            SlotStatus initialSlotStatus = new SlotStatus(slotId, ResourceProfile.ANY);
            SlotReport initialSlotReport = new SlotReport(initialSlotStatus);
            slotManager.registerTaskManager(taskExecutorConnection, initialSlotReport);
            Assert.assertThat((Object)slotManager.getNumberRegisteredSlots(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)1)));
            SlotStatus slotStatus = new SlotStatus(slotId, ResourceProfile.ANY, new JobID(), new AllocationID());
            SlotReport slotReport = new SlotReport(slotStatus);
            slotManager.reportSlotStatus(taskExecutorConnection.getInstanceID(), slotReport);
            AllocationID allocationId = new AllocationID();
            SlotRequest slotRequest = new SlotRequest(new JobID(), allocationId, ResourceProfile.UNKNOWN, "foobar");
            slotManager.registerSlotRequest(slotRequest);
            Assert.assertThat((Object)slotManager.getSlotRequest(allocationId).isAssigned(), (Matcher)Matchers.is((Object)false));
        }
    }

    @Test
    public void testSlotRequestFailure() throws Exception {
        try (SlotManagerImpl slotManager = this.createSlotManager(ResourceManagerId.generate(), new TestingResourceActionsBuilder().build());){
            SlotRequest slotRequest = new SlotRequest(new JobID(), new AllocationID(), ResourceProfile.UNKNOWN, "foobar");
            slotManager.registerSlotRequest(slotRequest);
            ArrayBlockingQueue requestSlotQueue = new ArrayBlockingQueue(1);
            ArrayBlockingQueue responseQueue = new ArrayBlockingQueue(1);
            TestingTaskExecutorGateway testingTaskExecutorGateway = new TestingTaskExecutorGatewayBuilder().setRequestSlotFunction(slotIDJobIDAllocationIDStringResourceManagerIdTuple6 -> {
                requestSlotQueue.offer(slotIDJobIDAllocationIDStringResourceManagerIdTuple6);
                try {
                    return (CompletableFuture)responseQueue.take();
                }
                catch (InterruptedException ignored) {
                    return FutureUtils.completedExceptionally((Throwable)new FlinkException("Response queue was interrupted."));
                }
            }).createTestingTaskExecutorGateway();
            ResourceID taskExecutorResourceId = ResourceID.generate();
            TaskExecutorConnection taskExecutionConnection = new TaskExecutorConnection(taskExecutorResourceId, (TaskExecutorGateway)testingTaskExecutorGateway);
            SlotReport slotReport = new SlotReport(SlotManagerImplTest.createEmptySlotStatus(new SlotID(taskExecutorResourceId, 0), ResourceProfile.ANY));
            CompletableFuture firstManualSlotRequestResponse = new CompletableFuture();
            responseQueue.offer(firstManualSlotRequestResponse);
            slotManager.registerTaskManager(taskExecutionConnection, slotReport);
            Tuple6 firstRequest = (Tuple6)requestSlotQueue.take();
            CompletableFuture<Acknowledge> secondManualSlotRequestResponse = new CompletableFuture<Acknowledge>();
            responseQueue.offer(secondManualSlotRequestResponse);
            firstManualSlotRequestResponse.completeExceptionally((Throwable)new SlotAllocationException("Test exception"));
            Tuple6 secondRequest = (Tuple6)requestSlotQueue.take();
            Assert.assertThat((Object)secondRequest.f2, (Matcher)Matchers.equalTo((Object)firstRequest.f2));
            Assert.assertThat((Object)secondRequest.f0, (Matcher)Matchers.equalTo((Object)firstRequest.f0));
            secondManualSlotRequestResponse.complete(Acknowledge.get());
            TaskManagerSlot slot = slotManager.getSlot((SlotID)secondRequest.f0);
            Assert.assertThat((Object)slot.getState(), (Matcher)Matchers.equalTo((Object)TaskManagerSlot.State.ALLOCATED));
            Assert.assertThat((Object)slot.getAllocationId(), (Matcher)Matchers.equalTo((Object)secondRequest.f2));
        }
    }

    @Test
    public void testSlotRequestRemovedIfTMReportAllocation() throws Exception {
        try (SlotManagerImpl slotManager = this.createSlotManager(ResourceManagerId.generate(), new TestingResourceActionsBuilder().build());){
            JobID jobID = new JobID();
            SlotRequest slotRequest1 = new SlotRequest(jobID, new AllocationID(), ResourceProfile.UNKNOWN, "foobar");
            slotManager.registerSlotRequest(slotRequest1);
            ArrayBlockingQueue requestSlotQueue = new ArrayBlockingQueue(1);
            ArrayBlockingQueue responseQueue = new ArrayBlockingQueue(1);
            TestingTaskExecutorGateway testingTaskExecutorGateway = new TestingTaskExecutorGatewayBuilder().setRequestSlotFunction(slotIDJobIDAllocationIDStringResourceManagerIdTuple6 -> {
                requestSlotQueue.offer(slotIDJobIDAllocationIDStringResourceManagerIdTuple6);
                try {
                    return (CompletableFuture)responseQueue.take();
                }
                catch (InterruptedException ignored) {
                    return FutureUtils.completedExceptionally((Throwable)new FlinkException("Response queue was interrupted."));
                }
            }).createTestingTaskExecutorGateway();
            ResourceID taskExecutorResourceId = ResourceID.generate();
            TaskExecutorConnection taskExecutionConnection = new TaskExecutorConnection(taskExecutorResourceId, (TaskExecutorGateway)testingTaskExecutorGateway);
            SlotReport slotReport = new SlotReport(SlotManagerImplTest.createEmptySlotStatus(new SlotID(taskExecutorResourceId, 0), ResourceProfile.ANY));
            CompletableFuture firstManualSlotRequestResponse = new CompletableFuture();
            responseQueue.offer(firstManualSlotRequestResponse);
            slotManager.registerTaskManager(taskExecutionConnection, slotReport);
            Tuple6 firstRequest = (Tuple6)requestSlotQueue.take();
            CompletableFuture<Acknowledge> secondManualSlotRequestResponse = new CompletableFuture<Acknowledge>();
            responseQueue.offer(secondManualSlotRequestResponse);
            SlotRequest slotRequest2 = new SlotRequest(jobID, new AllocationID(), ResourceProfile.UNKNOWN, "foobar");
            slotManager.registerSlotRequest(slotRequest2);
            firstManualSlotRequestResponse.completeExceptionally(new TimeoutException("Test exception to fail first allocation"));
            Tuple6 secondRequest = (Tuple6)requestSlotQueue.take();
            secondManualSlotRequestResponse.completeExceptionally((Throwable)new SlotOccupiedException("Test exception", slotRequest1.getAllocationId(), jobID));
            Assert.assertThat((Object)firstRequest.f2, (Matcher)Matchers.equalTo((Object)slotRequest1.getAllocationId()));
            Assert.assertThat((Object)secondRequest.f2, (Matcher)Matchers.equalTo((Object)slotRequest2.getAllocationId()));
            Assert.assertThat((Object)secondRequest.f0, (Matcher)Matchers.equalTo((Object)firstRequest.f0));
            secondManualSlotRequestResponse.complete(Acknowledge.get());
            TaskManagerSlot slot = slotManager.getSlot((SlotID)secondRequest.f0);
            Assert.assertThat((Object)slot.getState(), (Matcher)Matchers.equalTo((Object)TaskManagerSlot.State.ALLOCATED));
            Assert.assertThat((Object)slot.getAllocationId(), (Matcher)Matchers.equalTo((Object)firstRequest.f2));
            Assert.assertThat((Object)slotManager.getNumberRegisteredSlots(), (Matcher)Matchers.is((Object)1));
        }
    }

    @Test
    public void testNotifyFailedAllocationWhenTaskManagerTerminated() throws Exception {
        ArrayDeque allocationFailures = new ArrayDeque(5);
        TestingResourceActions resourceManagerActions = new TestingResourceActionsBuilder().setNotifyAllocationFailureConsumer(failureMessage -> allocationFailures.offer(Tuple2.of((Object)failureMessage.f0, (Object)failureMessage.f1))).build();
        try (SlotManagerImpl slotManager = this.createSlotManager(ResourceManagerId.generate(), resourceManagerActions);){
            Tuple2 allocationFailure;
            JobID jobId1 = new JobID();
            SlotRequest slotRequest11 = this.createSlotRequest(jobId1);
            SlotRequest slotRequest12 = this.createSlotRequest(jobId1);
            slotManager.registerSlotRequest(slotRequest11);
            slotManager.registerSlotRequest(slotRequest12);
            ResourceID taskExecutorResourceId1 = ResourceID.generate();
            TestingTaskExecutorGateway testingTaskExecutorGateway1 = new TestingTaskExecutorGatewayBuilder().createTestingTaskExecutorGateway();
            TaskExecutorConnection taskExecutionConnection1 = new TaskExecutorConnection(taskExecutorResourceId1, (TaskExecutorGateway)testingTaskExecutorGateway1);
            SlotReport slotReport1 = this.createSlotReport(taskExecutorResourceId1, 2);
            slotManager.registerTaskManager(taskExecutionConnection1, slotReport1);
            JobID jobId2 = new JobID();
            SlotRequest slotRequest21 = this.createSlotRequest(jobId2);
            SlotRequest slotRequest22 = this.createSlotRequest(jobId2);
            slotManager.registerSlotRequest(slotRequest21);
            slotManager.registerSlotRequest(slotRequest22);
            JobID jobId3 = new JobID();
            SlotRequest slotRequest31 = this.createSlotRequest(jobId3);
            slotManager.registerSlotRequest(slotRequest31);
            ResourceID taskExecutorResourceId2 = ResourceID.generate();
            TestingTaskExecutorGateway testingTaskExecutorGateway2 = new TestingTaskExecutorGatewayBuilder().createTestingTaskExecutorGateway();
            TaskExecutorConnection taskExecutionConnection2 = new TaskExecutorConnection(taskExecutorResourceId2, (TaskExecutorGateway)testingTaskExecutorGateway2);
            SlotReport slotReport2 = this.createSlotReport(taskExecutorResourceId2, 3);
            slotManager.registerTaskManager(taskExecutionConnection2, slotReport2);
            slotManager.unregisterTaskManager(taskExecutionConnection1.getInstanceID(), (Exception)TEST_EXCEPTION);
            Assert.assertThat(allocationFailures, (Matcher)Matchers.hasSize((int)2));
            HashSet<Object> failedAllocations = new HashSet<Object>(2);
            while ((allocationFailure = (Tuple2)allocationFailures.poll()) != null) {
                Assert.assertThat((Object)allocationFailure.f0, (Matcher)Matchers.equalTo((Object)jobId1));
                failedAllocations.add(allocationFailure.f1);
            }
            Assert.assertThat(failedAllocations, (Matcher)Matchers.containsInAnyOrder((Object[])new AllocationID[]{slotRequest11.getAllocationId(), slotRequest12.getAllocationId()}));
            slotManager.unregisterTaskManager(taskExecutionConnection2.getInstanceID(), (Exception)TEST_EXCEPTION);
            Assert.assertThat(allocationFailures, (Matcher)Matchers.hasSize((int)3));
            Map<JobID, List<Tuple2<JobID, AllocationID>>> job2AndJob3FailedAllocationInfo = allocationFailures.stream().collect(Collectors.groupingBy(tuple -> (JobID)tuple.f0));
            Assert.assertThat(job2AndJob3FailedAllocationInfo.entrySet(), (Matcher)Matchers.hasSize((int)2));
            Set<AllocationID> job2FailedAllocations = this.extractFailedAllocationsForJob(jobId2, job2AndJob3FailedAllocationInfo);
            Set<AllocationID> job3FailedAllocations = this.extractFailedAllocationsForJob(jobId3, job2AndJob3FailedAllocationInfo);
            Assert.assertThat(job2FailedAllocations, (Matcher)Matchers.containsInAnyOrder((Object[])new AllocationID[]{slotRequest21.getAllocationId(), slotRequest22.getAllocationId()}));
            Assert.assertThat(job3FailedAllocations, (Matcher)Matchers.containsInAnyOrder((Object[])new AllocationID[]{slotRequest31.getAllocationId()}));
        }
    }

    private Set<AllocationID> extractFailedAllocationsForJob(JobID jobId2, Map<JobID, List<Tuple2<JobID, AllocationID>>> job2AndJob3FailedAllocationInfo) {
        return job2AndJob3FailedAllocationInfo.get(jobId2).stream().map(t -> (AllocationID)t.f1).collect(Collectors.toSet());
    }

    @Nonnull
    private SlotReport createSlotReport(ResourceID taskExecutorResourceId, int numberSlots) {
        return this.createSlotReport(taskExecutorResourceId, numberSlots, ResourceProfile.ANY, SlotManagerImplTest::createEmptySlotStatus);
    }

    @Nonnull
    private SlotReport createSlotReport(ResourceID taskExecutorResourceId, int numberSlots, ResourceProfile resourceProfile, BiFunction<SlotID, ResourceProfile, SlotStatus> slotStatusFactory) {
        HashSet<SlotStatus> slotStatusSet = new HashSet<SlotStatus>(numberSlots);
        for (int i = 0; i < numberSlots; ++i) {
            slotStatusSet.add(slotStatusFactory.apply(new SlotID(taskExecutorResourceId, i), resourceProfile));
        }
        return new SlotReport(slotStatusSet);
    }

    private static SlotStatus createEmptySlotStatus(SlotID slotId, ResourceProfile resourceProfile) {
        return new SlotStatus(slotId, resourceProfile);
    }

    @Nonnull
    private SlotRequest createSlotRequest(JobID jobId) {
        return this.createSlotRequest(jobId, ResourceProfile.UNKNOWN);
    }

    @Nonnull
    private SlotRequest createSlotRequest(JobID jobId, ResourceProfile resourceProfile) {
        return new SlotRequest(jobId, new AllocationID(), resourceProfile, "foobar1");
    }

    private SlotManagerImpl createSlotManager(ResourceManagerId resourceManagerId, ResourceActions resourceManagerActions) {
        return this.createSlotManager(resourceManagerId, resourceManagerActions, 1);
    }

    private SlotManagerImpl createSlotManager(ResourceManagerId resourceManagerId, ResourceActions resourceManagerActions, int numSlotsPerWorker) {
        SlotManagerImpl slotManager = this.createSlotManagerBuilder().setNumSlotsPerWorker(numSlotsPerWorker).buildAndStartWithDirectExec(resourceManagerId, resourceManagerActions);
        return slotManager;
    }

    private SlotManagerBuilder createSlotManagerBuilder() {
        return SlotManagerBuilder.newBuilder().setDefaultWorkerResourceSpec(WORKER_RESOURCE_SPEC);
    }

    @Test
    public void testRequestNewResources() throws Exception {
        int numberSlots = 2;
        AtomicInteger resourceRequests = new AtomicInteger(0);
        TestingResourceActions testingResourceActions = new TestingResourceActionsBuilder().setAllocateResourceFunction(ignored -> {
            resourceRequests.incrementAndGet();
            return true;
        }).build();
        try (SlotManagerImpl slotManager = this.createSlotManager(ResourceManagerId.generate(), testingResourceActions, 2);){
            JobID jobId = new JobID();
            Assert.assertThat((Object)slotManager.registerSlotRequest(this.createSlotRequest(jobId)), (Matcher)Matchers.is((Object)true));
            Assert.assertThat((Object)resourceRequests.get(), (Matcher)Matchers.is((Object)1));
            Assert.assertThat((Object)slotManager.registerSlotRequest(this.createSlotRequest(jobId)), (Matcher)Matchers.is((Object)true));
            Assert.assertThat((Object)resourceRequests.get(), (Matcher)Matchers.is((Object)1));
            Assert.assertThat((Object)slotManager.getNumberAssignedPendingTaskManagerSlots(), (Matcher)Matchers.is((Object)2));
            Assert.assertThat((Object)slotManager.registerSlotRequest(this.createSlotRequest(jobId)), (Matcher)Matchers.is((Object)true));
            Assert.assertThat((Object)resourceRequests.get(), (Matcher)Matchers.is((Object)2));
        }
    }

    @Test
    public void testFailingAllocationReturnsPendingTaskManagerSlot() throws Exception {
        int numberSlots = 2;
        TestingResourceActions resourceActions = new TestingResourceActionsBuilder().build();
        try (SlotManagerImpl slotManager = this.createSlotManager(ResourceManagerId.generate(), resourceActions, 2);){
            JobID jobId = new JobID();
            SlotRequest slotRequest = this.createSlotRequest(jobId);
            Assert.assertThat((Object)slotManager.registerSlotRequest(slotRequest), (Matcher)Matchers.is((Object)true));
            Assert.assertThat((Object)slotManager.getNumberPendingTaskManagerSlots(), (Matcher)Matchers.is((Object)2));
            Assert.assertThat((Object)slotManager.getNumberAssignedPendingTaskManagerSlots(), (Matcher)Matchers.is((Object)1));
            slotManager.unregisterSlotRequest(slotRequest.getAllocationId());
            Assert.assertThat((Object)slotManager.getNumberPendingTaskManagerSlots(), (Matcher)Matchers.is((Object)2));
            Assert.assertThat((Object)slotManager.getNumberAssignedPendingTaskManagerSlots(), (Matcher)Matchers.is((Object)0));
        }
    }

    @Test
    public void testPendingTaskManagerSlotCompletion() throws Exception {
        int numberSlots = 3;
        TestingResourceActions resourceActions = new TestingResourceActionsBuilder().build();
        ResourceProfile resourceProfile = SlotManagerImpl.generateDefaultSlotResourceProfile((WorkerResourceSpec)WORKER_RESOURCE_SPEC, (int)3);
        try (SlotManagerImpl slotManager = this.createSlotManager(ResourceManagerId.generate(), resourceActions, 3);){
            JobID jobId = new JobID();
            Assert.assertThat((Object)slotManager.registerSlotRequest(this.createSlotRequest(jobId, resourceProfile)), (Matcher)Matchers.is((Object)true));
            Assert.assertThat((Object)slotManager.getNumberPendingTaskManagerSlots(), (Matcher)Matchers.is((Object)3));
            Assert.assertThat((Object)slotManager.getNumberAssignedPendingTaskManagerSlots(), (Matcher)Matchers.is((Object)1));
            Assert.assertThat((Object)slotManager.getNumberRegisteredSlots(), (Matcher)Matchers.is((Object)0));
            TaskExecutorConnection taskExecutorConnection = this.createTaskExecutorConnection();
            SlotReport slotReport = this.createSlotReport(taskExecutorConnection.getResourceID(), 2, resourceProfile, SlotManagerImplTest::createEmptySlotStatus);
            slotManager.registerTaskManager(taskExecutorConnection, slotReport);
            Assert.assertThat((Object)slotManager.getNumberRegisteredSlots(), (Matcher)Matchers.is((Object)2));
            Assert.assertThat((Object)slotManager.getNumberPendingTaskManagerSlots(), (Matcher)Matchers.is((Object)1));
        }
    }

    private TaskExecutorConnection createTaskExecutorConnection() {
        TestingTaskExecutorGateway taskExecutorGateway = new TestingTaskExecutorGatewayBuilder().createTestingTaskExecutorGateway();
        return this.createTaskExecutorConnection(taskExecutorGateway);
    }

    private TaskExecutorConnection createTaskExecutorConnection(TaskExecutorGateway taskExecutorGateway) {
        return new TaskExecutorConnection(ResourceID.generate(), taskExecutorGateway);
    }

    @Test
    public void testRegistrationOfDifferentSlot() throws Exception {
        boolean numberSlots = true;
        TestingResourceActions resourceActions = new TestingResourceActionsBuilder().build();
        try (SlotManagerImpl slotManager = this.createSlotManager(ResourceManagerId.generate(), resourceActions, 1);){
            JobID jobId = new JobID();
            ResourceProfile requestedSlotProfile = ResourceProfile.fromResources((double)1.0, (int)1);
            Assert.assertThat((Object)slotManager.registerSlotRequest(this.createSlotRequest(jobId, requestedSlotProfile)), (Matcher)Matchers.is((Object)true));
            Assert.assertThat((Object)slotManager.getNumberPendingTaskManagerSlots(), (Matcher)Matchers.is((Object)1));
            boolean numberOfferedSlots = true;
            TaskExecutorConnection taskExecutorConnection = this.createTaskExecutorConnection();
            ResourceProfile offeredSlotProfile = ResourceProfile.fromResources((double)2.0, (int)2);
            SlotReport slotReport = this.createSlotReport(taskExecutorConnection.getResourceID(), 1, offeredSlotProfile, SlotManagerImplTest::createEmptySlotStatus);
            slotManager.registerTaskManager(taskExecutorConnection, slotReport);
            Assert.assertThat((Object)slotManager.getNumberRegisteredSlots(), (Matcher)Matchers.is((Object)1));
            Assert.assertThat((Object)slotManager.getNumberPendingTaskManagerSlots(), (Matcher)Matchers.is((Object)1));
            Assert.assertThat((Object)slotManager.getNumberAssignedPendingTaskManagerSlots(), (Matcher)Matchers.is((Object)0));
        }
    }

    @Test
    public void testOnlyFreeSlotsCanFulfillPendingTaskManagerSlot() throws Exception {
        boolean numberSlots = true;
        TestingResourceActions resourceActions = new TestingResourceActionsBuilder().build();
        try (SlotManagerImpl slotManager = this.createSlotManager(ResourceManagerId.generate(), resourceActions, 1);){
            JobID jobId = new JobID();
            Assert.assertThat((Object)slotManager.registerSlotRequest(this.createSlotRequest(jobId)), (Matcher)Matchers.is((Object)true));
            TaskExecutorConnection taskExecutorConnection = this.createTaskExecutorConnection();
            SlotID slotId = new SlotID(taskExecutorConnection.getResourceID(), 0);
            SlotStatus slotStatus = new SlotStatus(slotId, ResourceProfile.ANY, jobId, new AllocationID());
            SlotReport slotReport = new SlotReport(slotStatus);
            slotManager.registerTaskManager(taskExecutorConnection, slotReport);
            Assert.assertThat((Object)slotManager.getNumberRegisteredSlots(), (Matcher)Matchers.is((Object)1));
            Assert.assertThat((Object)slotManager.getNumberPendingTaskManagerSlots(), (Matcher)Matchers.is((Object)1));
            Assert.assertThat((Object)slotManager.getNumberAssignedPendingTaskManagerSlots(), (Matcher)Matchers.is((Object)1));
        }
    }

    @Test
    public void unregisterTaskManager_withAllocatedSlot_failsAllocationsWithCause() throws Exception {
        CompletableFuture allocationFailureCause = new CompletableFuture();
        TestingResourceActions resourceActions = new TestingResourceActionsBuilder().setNotifyAllocationFailureConsumer(jobIDAllocationIDExceptionTuple3 -> allocationFailureCause.complete(jobIDAllocationIDExceptionTuple3.f2)).build();
        FlinkException failureCause = new FlinkException("unregisterTaskManager test exception.");
        try (SlotManagerImpl slotManager = this.createSlotManager(ResourceManagerId.generate(), resourceActions);){
            TaskExecutorConnection taskExecutorConnection = this.createTaskExecutorConnection();
            SlotReport slotReport = this.createSingleAllocatedSlotReport(taskExecutorConnection.getResourceID(), new JobID());
            slotManager.registerTaskManager(taskExecutorConnection, slotReport);
            slotManager.unregisterTaskManager(taskExecutorConnection.getInstanceID(), (Exception)failureCause);
            Assert.assertThat(allocationFailureCause.get(), (Matcher)CoreMatchers.containsCause((Throwable)failureCause));
        }
    }

    private SlotReport createSingleAllocatedSlotReport(ResourceID resourceID, JobID jobId) {
        return this.createSlotReport(resourceID, 1, ResourceProfile.ANY, (slotId, resourceProfile) -> new SlotStatus(slotId, resourceProfile, jobId, new AllocationID()));
    }

    @Test
    public void testSpreadOutSlotAllocationStrategy() throws Exception {
        try (SlotManagerImpl slotManager = this.createSlotManagerBuilder().setSlotMatchingStrategy((SlotMatchingStrategy)LeastUtilizationSlotMatchingStrategy.INSTANCE).buildAndStartWithDirectExec(ResourceManagerId.generate(), new TestingResourceActionsBuilder().build());){
            ArrayList<CompletableFuture<JobID>> requestSlotFutures = new ArrayList<CompletableFuture<JobID>>();
            int numberTaskExecutors = 5;
            for (int i = 0; i < 5; ++i) {
                CompletableFuture<JobID> requestSlotFuture = new CompletableFuture<JobID>();
                requestSlotFutures.add(requestSlotFuture);
                this.registerTaskExecutorWithTwoSlots(slotManager, requestSlotFuture);
            }
            JobID jobId = new JobID();
            for (int i = 0; i < 5; ++i) {
                Assert.assertTrue((boolean)slotManager.registerSlotRequest(this.createSlotRequest(jobId)));
            }
            HashSet jobIds = new HashSet((Collection)FutureUtils.combineAll(requestSlotFutures).get(10L, TimeUnit.SECONDS));
            Assert.assertThat(jobIds, (Matcher)Matchers.hasSize((int)1));
            Assert.assertThat(jobIds, (Matcher)Matchers.containsInAnyOrder((Object[])new JobID[]{jobId}));
        }
    }

    @Test
    public void testMaxSlotLimitAllocateResource() throws Exception {
        boolean numberSlots = true;
        boolean maxSlotNum = true;
        ResourceManagerId resourceManagerId = ResourceManagerId.generate();
        JobID jobId = new JobID();
        AtomicInteger resourceRequests = new AtomicInteger(0);
        TestingResourceActions resourceManagerActions = new TestingResourceActionsBuilder().setAllocateResourceFunction(ignored -> {
            resourceRequests.incrementAndGet();
            return true;
        }).build();
        try (SlotManagerImpl slotManager = this.createSlotManagerBuilder().setNumSlotsPerWorker(1).setMaxSlotNum(1).buildAndStartWithDirectExec(resourceManagerId, resourceManagerActions);){
            Assert.assertTrue((String)"The slot request should be accepted", (boolean)slotManager.registerSlotRequest(this.createSlotRequest(jobId)));
            Assert.assertThat((Object)resourceRequests.get(), (Matcher)Matchers.is((Object)1));
            Assert.assertTrue((String)"The slot request should be accepted", (boolean)slotManager.registerSlotRequest(this.createSlotRequest(jobId)));
            Assert.assertThat((Object)resourceRequests.get(), (Matcher)Matchers.is((Object)1));
        }
    }

    @Test
    public void testMaxSlotLimitRegisterResource() throws Exception {
        boolean numberSlots = true;
        boolean maxSlotNum = true;
        ResourceManagerId resourceManagerId = ResourceManagerId.generate();
        CompletableFuture releasedResourceFuture = new CompletableFuture();
        TestingResourceActions resourceManagerActions = new TestingResourceActionsBuilder().setReleaseResourceConsumer((instanceID, e) -> releasedResourceFuture.complete(instanceID)).build();
        TestingTaskExecutorGateway taskExecutorGateway1 = new TestingTaskExecutorGatewayBuilder().createTestingTaskExecutorGateway();
        TestingTaskExecutorGateway taskExecutorGateway2 = new TestingTaskExecutorGatewayBuilder().createTestingTaskExecutorGateway();
        ResourceID resourceId1 = ResourceID.generate();
        ResourceID resourceId2 = ResourceID.generate();
        TaskExecutorConnection taskManagerConnection1 = new TaskExecutorConnection(resourceId1, (TaskExecutorGateway)taskExecutorGateway1);
        TaskExecutorConnection taskManagerConnection2 = new TaskExecutorConnection(resourceId2, (TaskExecutorGateway)taskExecutorGateway2);
        SlotID slotId1 = new SlotID(resourceId1, 0);
        SlotID slotId2 = new SlotID(resourceId1, 0);
        SlotStatus slotStatus1 = new SlotStatus(slotId1, ResourceProfile.UNKNOWN);
        SlotStatus slotStatus2 = new SlotStatus(slotId2, ResourceProfile.UNKNOWN);
        SlotReport slotReport1 = new SlotReport(Collections.singletonList(slotStatus1));
        SlotReport slotReport2 = new SlotReport(Collections.singletonList(slotStatus2));
        try (SlotManagerImpl slotManager = this.createSlotManagerBuilder().setNumSlotsPerWorker(1).setMaxSlotNum(1).buildAndStartWithDirectExec(resourceManagerId, resourceManagerActions);){
            slotManager.registerTaskManager(taskManagerConnection1, slotReport1);
            slotManager.registerTaskManager(taskManagerConnection2, slotReport2);
            Assert.assertThat((String)"The number registered slots does not equal the expected number.", (Object)slotManager.getNumberRegisteredSlots(), (Matcher)Matchers.is((Object)1));
            Assert.assertNotNull((Object)slotManager.getSlot(slotId1));
            Assert.assertThat(releasedResourceFuture.get(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)taskManagerConnection2.getInstanceID())));
        }
    }

    private void registerTaskExecutorWithTwoSlots(SlotManagerImpl slotManager, CompletableFuture<JobID> firstRequestSlotFuture) {
        TestingTaskExecutorGateway taskExecutorGateway = new TestingTaskExecutorGatewayBuilder().setRequestSlotFunction(slotIDJobIDAllocationIDStringResourceManagerIdTuple6 -> {
            firstRequestSlotFuture.complete((JobID)slotIDJobIDAllocationIDStringResourceManagerIdTuple6.f1);
            return CompletableFuture.completedFuture(Acknowledge.get());
        }).createTestingTaskExecutorGateway();
        TaskExecutorConnection firstTaskExecutorConnection = this.createTaskExecutorConnection(taskExecutorGateway);
        SlotReport firstSlotReport = this.createSlotReport(firstTaskExecutorConnection.getResourceID(), 2);
        slotManager.registerTaskManager(firstTaskExecutorConnection, firstSlotReport);
    }

    @Test
    public void testGenerateDefaultSlotProfile() {
        int numSlots = 5;
        ResourceProfile resourceProfile = ResourceProfile.newBuilder().setCpuCores(1.0).setTaskHeapMemoryMB(1).setTaskOffHeapMemoryMB(2).setNetworkMemoryMB(3).setManagedMemoryMB(4).build();
        WorkerResourceSpec workerResourceSpec = new WorkerResourceSpec.Builder().setCpuCores(5.0).setTaskHeapMemoryMB(5).setTaskOffHeapMemoryMB(10).setNetworkMemoryMB(15).setManagedMemoryMB(20).build();
        Assert.assertThat((Object)SlotManagerImpl.generateDefaultSlotResourceProfile((WorkerResourceSpec)workerResourceSpec, (int)5), (Matcher)Matchers.is((Object)resourceProfile));
    }

    private static /* synthetic */ void lambda$testSlotRequestTimeout$10(SlotManager slotManager, SlotRequest slotRequest, AtomicReference atomicException) {
        try {
            Assert.assertTrue((boolean)slotManager.registerSlotRequest(slotRequest));
        }
        catch (Exception e) {
            atomicException.compareAndSet(null, e);
        }
    }
}

