/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.resourcemanager;

import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.runtime.clusterframework.TaskExecutorProcessSpec;
import org.apache.flink.runtime.clusterframework.TaskExecutorProcessUtils;
import org.apache.flink.runtime.resourcemanager.WorkerResourceSpec;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;

public class WorkerResourceSpecTest
extends TestLogger {
    @Test
    public void testEquals() {
        WorkerResourceSpec spec1 = new WorkerResourceSpec.Builder().setCpuCores(1.0).setTaskHeapMemoryMB(100).setTaskOffHeapMemoryMB(100).setNetworkMemoryMB(100).setManagedMemoryMB(100).build();
        WorkerResourceSpec spec2 = new WorkerResourceSpec.Builder().setCpuCores(1.0).setTaskHeapMemoryMB(100).setTaskOffHeapMemoryMB(100).setNetworkMemoryMB(100).setManagedMemoryMB(100).build();
        WorkerResourceSpec spec3 = new WorkerResourceSpec.Builder().setCpuCores(1.1).setTaskHeapMemoryMB(100).setTaskOffHeapMemoryMB(100).setNetworkMemoryMB(100).setManagedMemoryMB(100).build();
        WorkerResourceSpec spec4 = new WorkerResourceSpec.Builder().setCpuCores(1.0).setTaskHeapMemoryMB(110).setTaskOffHeapMemoryMB(100).setNetworkMemoryMB(100).setManagedMemoryMB(100).build();
        WorkerResourceSpec spec5 = new WorkerResourceSpec.Builder().setCpuCores(1.0).setTaskHeapMemoryMB(100).setTaskOffHeapMemoryMB(110).setNetworkMemoryMB(100).setManagedMemoryMB(100).build();
        WorkerResourceSpec spec6 = new WorkerResourceSpec.Builder().setCpuCores(1.0).setTaskHeapMemoryMB(100).setTaskOffHeapMemoryMB(100).setNetworkMemoryMB(110).setManagedMemoryMB(100).build();
        WorkerResourceSpec spec7 = new WorkerResourceSpec.Builder().setCpuCores(1.0).setTaskHeapMemoryMB(100).setTaskOffHeapMemoryMB(100).setNetworkMemoryMB(100).setManagedMemoryMB(110).build();
        Assert.assertEquals((Object)spec1, (Object)spec1);
        Assert.assertEquals((Object)spec1, (Object)spec2);
        Assert.assertNotEquals((Object)spec1, (Object)spec3);
        Assert.assertNotEquals((Object)spec1, (Object)spec4);
        Assert.assertNotEquals((Object)spec1, (Object)spec5);
        Assert.assertNotEquals((Object)spec1, (Object)spec6);
        Assert.assertNotEquals((Object)spec1, (Object)spec7);
    }

    @Test
    public void testHashCodeEquals() {
        WorkerResourceSpec spec1 = new WorkerResourceSpec.Builder().setCpuCores(1.0).setTaskHeapMemoryMB(100).setTaskOffHeapMemoryMB(100).setNetworkMemoryMB(100).setManagedMemoryMB(100).build();
        WorkerResourceSpec spec2 = new WorkerResourceSpec.Builder().setCpuCores(1.0).setTaskHeapMemoryMB(100).setTaskOffHeapMemoryMB(100).setNetworkMemoryMB(100).setManagedMemoryMB(100).build();
        WorkerResourceSpec spec3 = new WorkerResourceSpec.Builder().setCpuCores(1.1).setTaskHeapMemoryMB(100).setTaskOffHeapMemoryMB(100).setNetworkMemoryMB(100).setManagedMemoryMB(100).build();
        WorkerResourceSpec spec4 = new WorkerResourceSpec.Builder().setCpuCores(1.0).setTaskHeapMemoryMB(110).setTaskOffHeapMemoryMB(100).setNetworkMemoryMB(100).setManagedMemoryMB(100).build();
        WorkerResourceSpec spec5 = new WorkerResourceSpec.Builder().setCpuCores(1.0).setTaskHeapMemoryMB(100).setTaskOffHeapMemoryMB(110).setNetworkMemoryMB(100).setManagedMemoryMB(100).build();
        WorkerResourceSpec spec6 = new WorkerResourceSpec.Builder().setCpuCores(1.0).setTaskHeapMemoryMB(100).setTaskOffHeapMemoryMB(100).setNetworkMemoryMB(110).setManagedMemoryMB(100).build();
        WorkerResourceSpec spec7 = new WorkerResourceSpec.Builder().setCpuCores(1.0).setTaskHeapMemoryMB(100).setTaskOffHeapMemoryMB(100).setNetworkMemoryMB(100).setManagedMemoryMB(110).build();
        Assert.assertEquals((long)spec1.hashCode(), (long)spec1.hashCode());
        Assert.assertEquals((long)spec1.hashCode(), (long)spec2.hashCode());
        Assert.assertNotEquals((long)spec1.hashCode(), (long)spec3.hashCode());
        Assert.assertNotEquals((long)spec1.hashCode(), (long)spec4.hashCode());
        Assert.assertNotEquals((long)spec1.hashCode(), (long)spec5.hashCode());
        Assert.assertNotEquals((long)spec1.hashCode(), (long)spec6.hashCode());
        Assert.assertNotEquals((long)spec1.hashCode(), (long)spec7.hashCode());
    }

    @Test
    public void testCreateFromTaskExecutorProcessSpec() {
        TaskExecutorProcessSpec taskExecutorProcessSpec = TaskExecutorProcessUtils.newProcessSpecBuilder((Configuration)new Configuration()).withTotalProcessMemory(MemorySize.ofMebiBytes((long)1024L)).build();
        WorkerResourceSpec workerResourceSpec = WorkerResourceSpec.fromTaskExecutorProcessSpec((TaskExecutorProcessSpec)taskExecutorProcessSpec);
        Assert.assertEquals((Object)workerResourceSpec.getCpuCores(), (Object)taskExecutorProcessSpec.getCpuCores());
        Assert.assertEquals((Object)workerResourceSpec.getTaskHeapSize(), (Object)taskExecutorProcessSpec.getTaskHeapSize());
        Assert.assertEquals((Object)workerResourceSpec.getTaskOffHeapSize(), (Object)taskExecutorProcessSpec.getTaskOffHeapSize());
        Assert.assertEquals((Object)workerResourceSpec.getNetworkMemSize(), (Object)taskExecutorProcessSpec.getNetworkMemSize());
        Assert.assertEquals((Object)workerResourceSpec.getManagedMemSize(), (Object)taskExecutorProcessSpec.getManagedMemorySize());
    }
}

