/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.resourcemanager;

import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.configuration.ResourceManagerOptions;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.concurrent.ScheduledExecutor;
import org.apache.flink.runtime.entrypoint.ClusterInformation;
import org.apache.flink.runtime.heartbeat.TestingHeartbeatServices;
import org.apache.flink.runtime.highavailability.HighAvailabilityServices;
import org.apache.flink.runtime.highavailability.TestingHighAvailabilityServices;
import org.apache.flink.runtime.io.network.partition.NoOpResourceManagerPartitionTracker;
import org.apache.flink.runtime.leaderelection.TestingLeaderElectionService;
import org.apache.flink.runtime.metrics.groups.SlotManagerMetricGroup;
import org.apache.flink.runtime.metrics.groups.UnregisteredMetricGroups;
import org.apache.flink.runtime.resourcemanager.ResourceManagerRuntimeServices;
import org.apache.flink.runtime.resourcemanager.ResourceManagerRuntimeServicesConfiguration;
import org.apache.flink.runtime.resourcemanager.StandaloneResourceManager;
import org.apache.flink.runtime.resourcemanager.WorkerResourceSpec;
import org.apache.flink.runtime.resourcemanager.slotmanager.AnyMatchingSlotMatchingStrategy;
import org.apache.flink.runtime.resourcemanager.slotmanager.SlotManagerConfiguration;
import org.apache.flink.runtime.resourcemanager.slotmanager.SlotMatchingStrategy;
import org.apache.flink.runtime.rpc.RpcService;
import org.apache.flink.runtime.rpc.RpcUtils;
import org.apache.flink.runtime.rpc.TestingRpcService;
import org.apache.flink.runtime.testingUtils.TestingUtils;
import org.apache.flink.runtime.util.TestingFatalErrorHandler;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;

public class ResourceManagerHATest
extends TestLogger {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGrantAndRevokeLeadership() throws Exception {
        ResourceID rmResourceId = ResourceID.generate();
        TestingRpcService rpcService = new TestingRpcService();
        final CompletableFuture leaderSessionIdFuture = new CompletableFuture();
        TestingLeaderElectionService leaderElectionService = new TestingLeaderElectionService(){

            @Override
            public void confirmLeadership(UUID leaderId, String leaderAddress) {
                leaderSessionIdFuture.complete(leaderId);
            }
        };
        TestingHighAvailabilityServices highAvailabilityServices = new TestingHighAvailabilityServices();
        highAvailabilityServices.setResourceManagerLeaderElectionService(leaderElectionService);
        TestingHeartbeatServices heartbeatServices = new TestingHeartbeatServices();
        ResourceManagerRuntimeServicesConfiguration resourceManagerRuntimeServicesConfiguration = new ResourceManagerRuntimeServicesConfiguration(Time.seconds((long)5L), new SlotManagerConfiguration(TestingUtils.infiniteTime(), TestingUtils.infiniteTime(), TestingUtils.infiniteTime(), true, (SlotMatchingStrategy)AnyMatchingSlotMatchingStrategy.INSTANCE, WorkerResourceSpec.ZERO, 1, ((Integer)ResourceManagerOptions.MAX_SLOT_NUM.defaultValue()).intValue()));
        ResourceManagerRuntimeServices resourceManagerRuntimeServices = ResourceManagerRuntimeServices.fromConfiguration((ResourceManagerRuntimeServicesConfiguration)resourceManagerRuntimeServicesConfiguration, (HighAvailabilityServices)highAvailabilityServices, (ScheduledExecutor)rpcService.getScheduledExecutor(), (SlotManagerMetricGroup)UnregisteredMetricGroups.createUnregisteredSlotManagerMetricGroup());
        TestingFatalErrorHandler testingFatalErrorHandler = new TestingFatalErrorHandler();
        final CompletableFuture revokedLeaderIdFuture = new CompletableFuture();
        StandaloneResourceManager resourceManager = new StandaloneResourceManager((RpcService)rpcService, rmResourceId, highAvailabilityServices, heartbeatServices, resourceManagerRuntimeServices.getSlotManager(), NoOpResourceManagerPartitionTracker::get, resourceManagerRuntimeServices.getJobLeaderIdService(), new ClusterInformation("localhost", 1234), testingFatalErrorHandler, UnregisteredMetricGroups.createUnregisteredResourceManagerMetricGroup(), Time.minutes((long)5L), RpcUtils.INF_TIMEOUT){

            public void revokeLeadership() {
                super.revokeLeadership();
                this.runAsyncWithoutFencing(() -> revokedLeaderIdFuture.complete(this.getFencingToken()));
            }
        };
        try {
            resourceManager.start();
            Assert.assertNull((Object)resourceManager.getFencingToken());
            UUID leaderId = UUID.randomUUID();
            leaderElectionService.isLeader(leaderId);
            Assert.assertEquals((Object)leaderId, leaderSessionIdFuture.get());
            leaderElectionService.notLeader();
            Assert.assertNotEquals((Object)leaderId, revokedLeaderIdFuture.get());
            if (testingFatalErrorHandler.hasExceptionOccurred()) {
                testingFatalErrorHandler.rethrowError();
            }
        }
        finally {
            rpcService.stopService().get();
        }
    }
}

