/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.metrics;

import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.MetricOptions;
import org.apache.flink.metrics.CharacterFilter;
import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.Metric;
import org.apache.flink.metrics.MetricConfig;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.metrics.SimpleCounter;
import org.apache.flink.metrics.reporter.MetricReporter;
import org.apache.flink.metrics.reporter.Scheduled;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.metrics.MetricRegistry;
import org.apache.flink.runtime.metrics.MetricRegistryConfiguration;
import org.apache.flink.runtime.metrics.MetricRegistryImpl;
import org.apache.flink.runtime.metrics.ReporterSetup;
import org.apache.flink.runtime.metrics.dump.MetricDumpSerialization;
import org.apache.flink.runtime.metrics.dump.MetricQueryService;
import org.apache.flink.runtime.metrics.groups.AbstractMetricGroup;
import org.apache.flink.runtime.metrics.groups.MetricGroupTest;
import org.apache.flink.runtime.metrics.groups.TaskManagerMetricGroup;
import org.apache.flink.runtime.metrics.groups.UnregisteredMetricGroups;
import org.apache.flink.runtime.metrics.scope.ScopeFormats;
import org.apache.flink.runtime.metrics.util.TestReporter;
import org.apache.flink.runtime.rpc.RpcService;
import org.apache.flink.runtime.rpc.TestingRpcService;
import org.apache.flink.runtime.webmonitor.retriever.MetricQueryServiceGateway;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;

public class MetricRegistryImplTest
extends TestLogger {
    private static final char GLOBAL_DEFAULT_DELIMITER = '.';

    @Test
    public void testIsShutdown() throws Exception {
        MetricRegistryImpl metricRegistry = new MetricRegistryImpl(MetricRegistryConfiguration.defaultMetricRegistryConfiguration());
        Assert.assertFalse((boolean)metricRegistry.isShutdown());
        metricRegistry.shutdown().get();
        Assert.assertTrue((boolean)metricRegistry.isShutdown());
    }

    @Test
    public void testMetricQueryServiceSetup() throws Exception {
        MetricRegistryImpl metricRegistry = new MetricRegistryImpl(MetricRegistryConfiguration.defaultMetricRegistryConfiguration());
        Assert.assertNull((Object)metricRegistry.getMetricQueryServiceGatewayRpcAddress());
        metricRegistry.startQueryService((RpcService)new TestingRpcService(), new ResourceID("mqs"));
        MetricQueryServiceGateway metricQueryServiceGateway = metricRegistry.getMetricQueryServiceGateway();
        Assert.assertNotNull((Object)metricQueryServiceGateway);
        metricRegistry.register((Metric)new SimpleCounter(), "counter", (AbstractMetricGroup)UnregisteredMetricGroups.createUnregisteredTaskManagerMetricGroup());
        boolean metricsSuccessfullyQueried = false;
        for (int x = 0; x < 10; ++x) {
            MetricDumpSerialization.MetricSerializationResult metricSerializationResult = (MetricDumpSerialization.MetricSerializationResult)metricQueryServiceGateway.queryMetrics(Time.seconds((long)5L)).get(5L, TimeUnit.SECONDS);
            if (metricSerializationResult.numCounters == 1) {
                metricsSuccessfullyQueried = true;
                continue;
            }
            Thread.sleep(50L);
        }
        Assert.assertTrue((String)"metrics query did not return expected result", (boolean)metricsSuccessfullyQueried);
    }

    @Test
    public void testReporterScheduling() throws Exception {
        MetricConfig config = new MetricConfig();
        config.setProperty("arg1", "hello");
        config.setProperty("interval", "50 MILLISECONDS");
        MetricRegistryImpl registry = new MetricRegistryImpl(MetricRegistryConfiguration.defaultMetricRegistryConfiguration(), Collections.singletonList(ReporterSetup.forReporter((String)"test", (MetricConfig)config, (MetricReporter)new TestReporter3())));
        long start = System.currentTimeMillis();
        TestReporter3.reportCount = 0;
        for (int x = 0; x < 10; ++x) {
            Thread.sleep(100L);
            int reportCount = TestReporter3.reportCount;
            long curT = System.currentTimeMillis();
            long maxAllowedReports = (curT - start) / 50L + 2L;
            Assert.assertTrue((String)"Too many reports were triggered.", (maxAllowedReports >= (long)reportCount ? 1 : 0) != 0);
        }
        Assert.assertTrue((String)"No report was triggered.", (TestReporter3.reportCount > 0 ? 1 : 0) != 0);
        registry.shutdown().get();
    }

    @Test
    public void testReporterNotifications() throws Exception {
        Configuration config = new Configuration();
        config.setString("metrics.reporter.test1.class", TestReporter6.class.getName());
        config.setString("metrics.reporter.test2.class", TestReporter7.class.getName());
        MetricRegistryImpl registry = new MetricRegistryImpl(MetricRegistryConfiguration.defaultMetricRegistryConfiguration(), Arrays.asList(ReporterSetup.forReporter((String)"test1", (MetricReporter)new TestReporter6()), ReporterSetup.forReporter((String)"test2", (MetricReporter)new TestReporter7())));
        TaskManagerMetricGroup root = new TaskManagerMetricGroup((MetricRegistry)registry, "host", "id");
        root.counter("rootCounter");
        Assert.assertTrue((boolean)(TestReporter6.addedMetric instanceof Counter));
        Assert.assertEquals((Object)"rootCounter", (Object)TestReporter6.addedMetricName);
        Assert.assertTrue((boolean)(TestReporter7.addedMetric instanceof Counter));
        Assert.assertEquals((Object)"rootCounter", (Object)TestReporter7.addedMetricName);
        root.close();
        Assert.assertTrue((boolean)(TestReporter6.removedMetric instanceof Counter));
        Assert.assertEquals((Object)"rootCounter", (Object)TestReporter6.removedMetricName);
        Assert.assertTrue((boolean)(TestReporter7.removedMetric instanceof Counter));
        Assert.assertEquals((Object)"rootCounter", (Object)TestReporter7.removedMetricName);
        registry.shutdown().get();
    }

    @Test
    public void testScopeConfig() {
        Configuration config = new Configuration();
        config.setString(MetricOptions.SCOPE_NAMING_TM, "A");
        config.setString(MetricOptions.SCOPE_NAMING_TM_JOB, "B");
        config.setString(MetricOptions.SCOPE_NAMING_TASK, "C");
        config.setString(MetricOptions.SCOPE_NAMING_OPERATOR, "D");
        ScopeFormats scopeConfig = ScopeFormats.fromConfig((Configuration)config);
        Assert.assertEquals((Object)"A", (Object)scopeConfig.getTaskManagerFormat().format());
        Assert.assertEquals((Object)"B", (Object)scopeConfig.getTaskManagerJobFormat().format());
        Assert.assertEquals((Object)"C", (Object)scopeConfig.getTaskFormat().format());
        Assert.assertEquals((Object)"D", (Object)scopeConfig.getOperatorFormat().format());
    }

    @Test
    public void testConfigurableDelimiter() throws Exception {
        Configuration config = new Configuration();
        config.setString(MetricOptions.SCOPE_DELIMITER, "_");
        config.setString(MetricOptions.SCOPE_NAMING_TM, "A.B.C.D.E");
        MetricRegistryImpl registry = new MetricRegistryImpl(MetricRegistryConfiguration.fromConfiguration((Configuration)config), (Collection)ReporterSetup.fromConfiguration((Configuration)config, null));
        TaskManagerMetricGroup tmGroup = new TaskManagerMetricGroup((MetricRegistry)registry, "host", "id");
        Assert.assertEquals((Object)"A_B_C_D_E_name", (Object)tmGroup.getMetricIdentifier("name"));
        registry.shutdown().get();
    }

    @Test
    public void testConfigurableDelimiterForReporters() throws Exception {
        MetricConfig config1 = new MetricConfig();
        config1.setProperty("scope.delimiter", "_");
        MetricConfig config2 = new MetricConfig();
        config2.setProperty("scope.delimiter", "-");
        MetricConfig config3 = new MetricConfig();
        config3.setProperty("scope.delimiter", "AA");
        MetricRegistryImpl registry = new MetricRegistryImpl(MetricRegistryConfiguration.defaultMetricRegistryConfiguration(), Arrays.asList(ReporterSetup.forReporter((String)"test1", (MetricConfig)config1, (MetricReporter)new TestReporter()), ReporterSetup.forReporter((String)"test2", (MetricConfig)config2, (MetricReporter)new TestReporter()), ReporterSetup.forReporter((String)"test3", (MetricConfig)config3, (MetricReporter)new TestReporter())));
        Assert.assertEquals((long)46L, (long)registry.getDelimiter());
        Assert.assertEquals((long)95L, (long)registry.getDelimiter(0));
        Assert.assertEquals((long)45L, (long)registry.getDelimiter(1));
        Assert.assertEquals((long)46L, (long)registry.getDelimiter(2));
        Assert.assertEquals((long)46L, (long)registry.getDelimiter(3));
        Assert.assertEquals((long)46L, (long)registry.getDelimiter(-1));
        registry.shutdown().get();
    }

    @Test
    public void testConfigurableDelimiterForReportersInGroup() throws Exception {
        MetricConfig config1 = new MetricConfig();
        config1.setProperty("scope.delimiter", "_");
        MetricConfig config2 = new MetricConfig();
        config2.setProperty("scope.delimiter", "-");
        MetricConfig config3 = new MetricConfig();
        config3.setProperty("scope.delimiter", "AA");
        Configuration config = new Configuration();
        config.setString(MetricOptions.SCOPE_NAMING_TM, "A.B");
        config.setString("metrics.reporter.test1.scope.delimiter", "_");
        config.setString("metrics.reporter.test1.class", TestReporter8.class.getName());
        config.setString("metrics.reporter.test2.scope.delimiter", "-");
        config.setString("metrics.reporter.test2.class", TestReporter8.class.getName());
        config.setString("metrics.reporter.test3.scope.delimiter", "AA");
        config.setString("metrics.reporter.test3.class", TestReporter8.class.getName());
        config.setString("metrics.reporter.test4.class", TestReporter8.class.getName());
        MetricRegistryImpl registry = new MetricRegistryImpl(MetricRegistryConfiguration.fromConfiguration((Configuration)config), Arrays.asList(ReporterSetup.forReporter((String)"test1", (MetricConfig)config1, (MetricReporter)new TestReporter8()), ReporterSetup.forReporter((String)"test2", (MetricConfig)config2, (MetricReporter)new TestReporter8()), ReporterSetup.forReporter((String)"test3", (MetricConfig)config3, (MetricReporter)new TestReporter8()), ReporterSetup.forReporter((String)"test4", (MetricReporter)new TestReporter8())));
        List reporters = registry.getReporters();
        ((TestReporter8)((Object)reporters.get((int)0))).expectedDelimiter = (char)95;
        ((TestReporter8)((Object)reporters.get((int)1))).expectedDelimiter = (char)45;
        ((TestReporter8)((Object)reporters.get((int)2))).expectedDelimiter = (char)46;
        ((TestReporter8)((Object)reporters.get((int)3))).expectedDelimiter = (char)46;
        TaskManagerMetricGroup group = new TaskManagerMetricGroup((MetricRegistry)registry, "host", "id");
        group.counter("C");
        group.close();
        registry.shutdown().get();
        Assert.assertEquals((long)4L, (long)TestReporter8.numCorrectDelimitersForRegister);
        Assert.assertEquals((long)4L, (long)TestReporter8.numCorrectDelimitersForUnregister);
    }

    @Test
    public void testQueryActorShutdown() throws Exception {
        Duration timeout = Duration.ofSeconds(10L);
        MetricRegistryImpl registry = new MetricRegistryImpl(MetricRegistryConfiguration.defaultMetricRegistryConfiguration());
        TestingRpcService rpcService = new TestingRpcService();
        registry.startQueryService((RpcService)rpcService, null);
        MetricQueryService queryService = (MetricQueryService)Preconditions.checkNotNull((Object)registry.getQueryService());
        registry.shutdown().get();
        queryService.getTerminationFuture().get(timeout.toMillis(), TimeUnit.MILLISECONDS);
    }

    @Test
    public void testExceptionIsolation() throws Exception {
        MetricRegistryImpl registry = new MetricRegistryImpl(MetricRegistryConfiguration.defaultMetricRegistryConfiguration(), Arrays.asList(ReporterSetup.forReporter((String)"test1", (MetricReporter)new FailingReporter()), ReporterSetup.forReporter((String)"test2", (MetricReporter)new TestReporter7())));
        SimpleCounter metric = new SimpleCounter();
        registry.register((Metric)metric, "counter", (AbstractMetricGroup)new MetricGroupTest.DummyAbstractMetricGroup((MetricRegistry)registry));
        Assert.assertEquals((Object)metric, (Object)TestReporter7.addedMetric);
        Assert.assertEquals((Object)"counter", (Object)TestReporter7.addedMetricName);
        registry.unregister((Metric)metric, "counter", (AbstractMetricGroup)new MetricGroupTest.DummyAbstractMetricGroup((MetricRegistry)registry));
        Assert.assertEquals((Object)metric, (Object)TestReporter7.removedMetric);
        Assert.assertEquals((Object)"counter", (Object)TestReporter7.removedMetricName);
        registry.shutdown().get();
    }

    protected static class FailingReporter
    extends TestReporter {
        protected FailingReporter() {
        }

        @Override
        public void notifyOfAddedMetric(Metric metric, String metricName, MetricGroup group) {
            throw new RuntimeException();
        }

        @Override
        public void notifyOfRemovedMetric(Metric metric, String metricName, MetricGroup group) {
            throw new RuntimeException();
        }
    }

    public static class TestReporter8
    extends TestReporter {
        char expectedDelimiter;
        public static int numCorrectDelimitersForRegister = 0;
        public static int numCorrectDelimitersForUnregister = 0;

        @Override
        public void notifyOfAddedMetric(Metric metric, String metricName, MetricGroup group) {
            String expectedMetric = "A" + this.expectedDelimiter + "B" + this.expectedDelimiter + "C";
            Assert.assertEquals((Object)expectedMetric, (Object)group.getMetricIdentifier(metricName, (CharacterFilter)this));
            Assert.assertEquals((Object)expectedMetric, (Object)group.getMetricIdentifier(metricName));
            ++numCorrectDelimitersForRegister;
        }

        @Override
        public void notifyOfRemovedMetric(Metric metric, String metricName, MetricGroup group) {
            String expectedMetric = "A" + this.expectedDelimiter + "B" + this.expectedDelimiter + "C";
            Assert.assertEquals((Object)expectedMetric, (Object)group.getMetricIdentifier(metricName, (CharacterFilter)this));
            Assert.assertEquals((Object)expectedMetric, (Object)group.getMetricIdentifier(metricName));
            ++numCorrectDelimitersForUnregister;
        }
    }

    protected static class TestReporter7
    extends TestReporter {
        static Metric addedMetric;
        static String addedMetricName;
        static Metric removedMetric;
        static String removedMetricName;

        protected TestReporter7() {
        }

        @Override
        public void notifyOfAddedMetric(Metric metric, String metricName, MetricGroup group) {
            addedMetric = metric;
            addedMetricName = metricName;
        }

        @Override
        public void notifyOfRemovedMetric(Metric metric, String metricName, MetricGroup group) {
            removedMetric = metric;
            removedMetricName = metricName;
        }
    }

    protected static class TestReporter6
    extends TestReporter {
        static Metric addedMetric;
        static String addedMetricName;
        static Metric removedMetric;
        static String removedMetricName;

        protected TestReporter6() {
        }

        @Override
        public void notifyOfAddedMetric(Metric metric, String metricName, MetricGroup group) {
            addedMetric = metric;
            addedMetricName = metricName;
        }

        @Override
        public void notifyOfRemovedMetric(Metric metric, String metricName, MetricGroup group) {
            removedMetric = metric;
            removedMetricName = metricName;
        }
    }

    protected static class TestReporter3
    extends TestReporter
    implements Scheduled {
        public static int reportCount = 0;

        protected TestReporter3() {
        }

        public void report() {
            ++reportCount;
        }
    }

    protected static class TestReporter2
    extends TestReporter {
        static MetricConfig mc;

        protected TestReporter2() {
        }

        @Override
        public void open(MetricConfig config) {
            mc = config;
        }
    }

    protected static class TestReporter1
    extends TestReporter {
        public static boolean wasOpened = false;

        protected TestReporter1() {
        }

        @Override
        public void open(MetricConfig config) {
            wasOpened = true;
        }
    }
}

