/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.leaderelection;

import java.io.IOException;
import java.time.Duration;
import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.curator.test.TestingServer;
import org.apache.flink.api.common.time.Deadline;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.HighAvailabilityOptions;
import org.apache.flink.runtime.leaderelection.LeaderContender;
import org.apache.flink.runtime.leaderelection.LeaderElectionService;
import org.apache.flink.runtime.leaderelection.TestingContender;
import org.apache.flink.runtime.leaderelection.ZooKeeperLeaderElectionService;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalListener;
import org.apache.flink.runtime.leaderretrieval.ZooKeeperLeaderRetrievalService;
import org.apache.flink.runtime.testutils.CommonTestUtils;
import org.apache.flink.runtime.util.ZooKeeperUtils;
import org.apache.flink.shaded.curator4.org.apache.curator.framework.CuratorFramework;
import org.apache.flink.util.TestLogger;
import org.apache.flink.util.function.SupplierWithException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ZooKeeperLeaderElectionConnectionHandlingTest
extends TestLogger {
    private TestingServer testingServer;
    private Configuration config;
    private CuratorFramework zooKeeperClient;

    @Before
    public void before() throws Exception {
        this.testingServer = new TestingServer();
        this.config = new Configuration();
        this.config.setString(HighAvailabilityOptions.HA_MODE, "zookeeper");
        this.config.setString(HighAvailabilityOptions.HA_ZOOKEEPER_QUORUM, this.testingServer.getConnectString());
        this.zooKeeperClient = ZooKeeperUtils.startCuratorFramework((Configuration)this.config);
    }

    @After
    public void after() throws Exception {
        this.closeTestServer();
        if (this.zooKeeperClient != null) {
            this.zooKeeperClient.close();
            this.zooKeeperClient = null;
        }
    }

    @Test
    public void testConnectionSuspendedHandlingDuringInitialization() throws Exception {
        QueueLeaderElectionListener queueLeaderElectionListener = new QueueLeaderElectionListener(1, Duration.ofMillis(50L));
        ZooKeeperLeaderRetrievalService testInstance = ZooKeeperUtils.createLeaderRetrievalService((CuratorFramework)this.zooKeeperClient, (Configuration)this.config);
        testInstance.start((LeaderRetrievalListener)queueLeaderElectionListener);
        CompletableFuture<String> firstAddress = queueLeaderElectionListener.next();
        Assert.assertThat((String)"No results are expected, yet, since no leader was elected.", firstAddress, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        this.closeTestServer();
        CompletableFuture<String> secondAddress = queueLeaderElectionListener.next();
        Assert.assertThat((String)"No result is expected since there was no leader elected before stopping the server, yet.", secondAddress, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void testConnectionSuspendedHandling() throws Exception {
        String leaderAddress = "localhost";
        ZooKeeperLeaderElectionService leaderElectionService = ZooKeeperUtils.createLeaderElectionService((CuratorFramework)this.zooKeeperClient, (Configuration)this.config);
        TestingContender contender = new TestingContender(leaderAddress, (LeaderElectionService)leaderElectionService);
        leaderElectionService.start((LeaderContender)contender);
        QueueLeaderElectionListener queueLeaderElectionListener = new QueueLeaderElectionListener(2);
        ZooKeeperLeaderRetrievalService testInstance = ZooKeeperUtils.createLeaderRetrievalService((CuratorFramework)this.zooKeeperClient, (Configuration)this.config);
        testInstance.start((LeaderRetrievalListener)queueLeaderElectionListener);
        CompletableFuture<String> firstAddress = queueLeaderElectionListener.next();
        Assert.assertThat((String)"The first result is expected to be the initially set leader address.", (Object)firstAddress.get(), (Matcher)CoreMatchers.is((Object)leaderAddress));
        this.closeTestServer();
        CompletableFuture<String> secondAddress = queueLeaderElectionListener.next();
        Assert.assertThat((String)"The next result must not be missing.", secondAddress, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((String)"The next result is expected to be null.", (Object)secondAddress.get(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void testSameLeaderAfterReconnectTriggersListenerNotification() throws Exception {
        String retrievalPath = "/testSameLeaderAfterReconnectTriggersListenerNotification/leaderAddress";
        ZooKeeperLeaderRetrievalService leaderRetrievalService = new ZooKeeperLeaderRetrievalService(this.zooKeeperClient, "/testSameLeaderAfterReconnectTriggersListenerNotification/leaderAddress");
        QueueLeaderElectionListener queueLeaderElectionListener = new QueueLeaderElectionListener(2);
        leaderRetrievalService.start((LeaderRetrievalListener)queueLeaderElectionListener);
        String leaderAddress = "foobar";
        UUID sessionId = UUID.randomUUID();
        this.writeLeaderInformationToZooKeeper("/testSameLeaderAfterReconnectTriggersListenerNotification/leaderAddress", "foobar", sessionId);
        queueLeaderElectionListener.next();
        this.testingServer.stop();
        CompletableFuture<String> connectionSuspension = queueLeaderElectionListener.next();
        connectionSuspension.join();
        this.testingServer.restart();
        CompletableFuture<String> connectionReconnect = queueLeaderElectionListener.next();
        Assert.assertThat((Object)connectionReconnect.get(), (Matcher)CoreMatchers.is((Object)"foobar"));
    }

    private void writeLeaderInformationToZooKeeper(String retrievalPath, String leaderAddress, UUID sessionId) throws Exception {
        byte[] data = this.createLeaderInformation(leaderAddress, sessionId);
        if (this.zooKeeperClient.checkExists().forPath(retrievalPath) != null) {
            this.zooKeeperClient.setData().forPath(retrievalPath, data);
        } else {
            this.zooKeeperClient.create().creatingParentsIfNeeded().forPath(retrievalPath, data);
        }
    }

    /*
     * Exception decompiling
     */
    private byte[] createLeaderInformation(String leaderAddress, UUID sessionId) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Test
    public void testNewLeaderAfterReconnectTriggersListenerNotification() throws Exception {
        String retrievalPath = "/testNewLeaderAfterReconnectTriggersListenerNotification/leaderAddress";
        ZooKeeperLeaderRetrievalService leaderRetrievalService = new ZooKeeperLeaderRetrievalService(this.zooKeeperClient, "/testNewLeaderAfterReconnectTriggersListenerNotification/leaderAddress");
        QueueLeaderElectionListener queueLeaderElectionListener = new QueueLeaderElectionListener(2);
        leaderRetrievalService.start((LeaderRetrievalListener)queueLeaderElectionListener);
        String leaderAddress = "foobar";
        UUID sessionId = UUID.randomUUID();
        this.writeLeaderInformationToZooKeeper("/testNewLeaderAfterReconnectTriggersListenerNotification/leaderAddress", "foobar", sessionId);
        queueLeaderElectionListener.next();
        this.testingServer.stop();
        CompletableFuture<String> connectionSuspension = queueLeaderElectionListener.next();
        connectionSuspension.join();
        this.testingServer.restart();
        String newLeaderAddress = "barfoo";
        UUID newSessionId = UUID.randomUUID();
        this.writeLeaderInformationToZooKeeper("/testNewLeaderAfterReconnectTriggersListenerNotification/leaderAddress", "barfoo", newSessionId);
        CommonTestUtils.waitUntilCondition((SupplierWithException<Boolean, Exception>)((SupplierWithException)() -> {
            CompletableFuture<String> afterConnectionReconnect = queueLeaderElectionListener.next();
            return afterConnectionReconnect.get().equals("barfoo");
        }), Deadline.fromNow((Duration)Duration.ofSeconds(30L)));
    }

    private void closeTestServer() throws IOException {
        if (this.testingServer != null) {
            this.testingServer.close();
            this.testingServer = null;
        }
    }

    private static class QueueLeaderElectionListener
    implements LeaderRetrievalListener {
        private final BlockingQueue<CompletableFuture<String>> queue;
        private final Duration timeout;

        public QueueLeaderElectionListener(int expectedCalls) {
            this(expectedCalls, null);
        }

        public QueueLeaderElectionListener(int expectedCalls, Duration timeout) {
            this.queue = new ArrayBlockingQueue<CompletableFuture<String>>(expectedCalls);
            this.timeout = timeout;
        }

        public void notifyLeaderAddress(String leaderAddress, UUID leaderSessionID) {
            try {
                if (this.timeout == null) {
                    this.queue.put(CompletableFuture.completedFuture(leaderAddress));
                } else {
                    this.queue.offer(CompletableFuture.completedFuture(leaderAddress), this.timeout.toMillis(), TimeUnit.MILLISECONDS);
                }
            }
            catch (InterruptedException e) {
                throw new IllegalStateException(e);
            }
        }

        public CompletableFuture<String> next() {
            try {
                if (this.timeout == null) {
                    return this.queue.take();
                }
                return this.queue.poll(this.timeout.toMillis(), TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                throw new IllegalStateException(e);
            }
        }

        public void handleError(Exception exception) {
            throw new UnsupportedOperationException("handleError(Exception) shouldn't have been called, but it was triggered anyway.", exception);
        }
    }
}

