/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster.slotpool;

import java.net.InetAddress;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.flink.api.common.resources.GPUResource;
import org.apache.flink.api.common.resources.Resource;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.clusterframework.types.SlotProfile;
import org.apache.flink.runtime.executiongraph.utils.SimpleAckingTaskManagerGateway;
import org.apache.flink.runtime.instance.SimpleSlotContext;
import org.apache.flink.runtime.instance.SlotSharingGroupId;
import org.apache.flink.runtime.jobmanager.scheduler.Locality;
import org.apache.flink.runtime.jobmanager.slots.DummySlotOwner;
import org.apache.flink.runtime.jobmanager.slots.TaskManagerGateway;
import org.apache.flink.runtime.jobmaster.LogicalSlot;
import org.apache.flink.runtime.jobmaster.SlotOwner;
import org.apache.flink.runtime.jobmaster.SlotRequestId;
import org.apache.flink.runtime.jobmaster.slotpool.AllocatedSlot;
import org.apache.flink.runtime.jobmaster.slotpool.AllocatedSlotActions;
import org.apache.flink.runtime.jobmaster.slotpool.LocationPreferenceSlotSelectionStrategy;
import org.apache.flink.runtime.jobmaster.slotpool.SlotSelectionStrategy;
import org.apache.flink.runtime.jobmaster.slotpool.SlotSharingManager;
import org.apache.flink.runtime.jobmaster.slotpool.TestingAllocatedSlotActions;
import org.apache.flink.runtime.taskmanager.LocalTaskManagerLocation;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.apache.flink.util.AbstractID;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.TestLogger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class SlotSharingManagerTest
extends TestLogger {
    private static final SlotSharingGroupId SLOT_SHARING_GROUP_ID = new SlotSharingGroupId();
    private static final DummySlotOwner SLOT_OWNER = new DummySlotOwner();

    @Test
    public void testRootSlotCreation() {
        SlotSharingManager slotSharingManager = this.createTestingSlotSharingManager();
        SlotRequestId slotRequestId = new SlotRequestId();
        SlotRequestId allocatedSlotRequestId = new SlotRequestId();
        SlotSharingManager.MultiTaskSlot multiTaskSlot = slotSharingManager.createRootSlot(slotRequestId, new CompletableFuture(), allocatedSlotRequestId);
        Assert.assertEquals((Object)slotRequestId, (Object)multiTaskSlot.getSlotRequestId());
        Assert.assertNotNull((Object)slotSharingManager.getTaskSlot(slotRequestId));
    }

    @Test
    public void testRootSlotRelease() throws ExecutionException, InterruptedException {
        CompletableFuture slotReleasedFuture = new CompletableFuture();
        TestingAllocatedSlotActions allocatedSlotActions = new TestingAllocatedSlotActions();
        allocatedSlotActions.setReleaseSlotConsumer(tuple3 -> slotReleasedFuture.complete(tuple3.f0));
        SlotSharingManager slotSharingManager = new SlotSharingManager(SLOT_SHARING_GROUP_ID, (AllocatedSlotActions)allocatedSlotActions, (SlotOwner)SLOT_OWNER);
        SlotRequestId slotRequestId = new SlotRequestId();
        SlotRequestId allocatedSlotRequestId = new SlotRequestId();
        CompletableFuture slotContextFuture = new CompletableFuture();
        SlotSharingManager.MultiTaskSlot rootSlot = slotSharingManager.createRootSlot(slotRequestId, slotContextFuture, allocatedSlotRequestId);
        Assert.assertTrue((boolean)slotSharingManager.contains(slotRequestId));
        rootSlot.release((Throwable)new FlinkException("Test exception"));
        Assert.assertEquals((Object)allocatedSlotRequestId, slotReleasedFuture.get());
        Assert.assertFalse((boolean)slotSharingManager.contains(slotRequestId));
    }

    @Test
    public void testNestedSlotCreation() {
        SlotSharingManager slotSharingManager = this.createTestingSlotSharingManager();
        SlotSharingManager.MultiTaskSlot rootSlot = slotSharingManager.createRootSlot(new SlotRequestId(), new CompletableFuture(), new SlotRequestId());
        AbstractID singleTaskSlotGroupId = new AbstractID();
        SlotRequestId singleTaskSlotRequestId = new SlotRequestId();
        SlotSharingManager.SingleTaskSlot singleTaskSlot = rootSlot.allocateSingleTaskSlot(singleTaskSlotRequestId, ResourceProfile.UNKNOWN, singleTaskSlotGroupId, Locality.LOCAL);
        AbstractID multiTaskSlotGroupId = new AbstractID();
        SlotRequestId multiTaskSlotRequestId = new SlotRequestId();
        SlotSharingManager.MultiTaskSlot multiTaskSlot = rootSlot.allocateMultiTaskSlot(multiTaskSlotRequestId, multiTaskSlotGroupId);
        Assert.assertTrue((boolean)Objects.equals(singleTaskSlotRequestId, singleTaskSlot.getSlotRequestId()));
        Assert.assertTrue((boolean)Objects.equals(multiTaskSlotRequestId, multiTaskSlot.getSlotRequestId()));
        Assert.assertTrue((boolean)rootSlot.contains(singleTaskSlotGroupId));
        Assert.assertTrue((boolean)rootSlot.contains(multiTaskSlotGroupId));
        Assert.assertTrue((boolean)slotSharingManager.contains(singleTaskSlotRequestId));
        Assert.assertTrue((boolean)slotSharingManager.contains(multiTaskSlotRequestId));
    }

    @Test
    public void testNestedSlotRelease() throws Exception {
        TestingAllocatedSlotActions testingAllocatedSlotActions = new TestingAllocatedSlotActions();
        CompletableFuture releasedSlotFuture = new CompletableFuture();
        testingAllocatedSlotActions.setReleaseSlotConsumer(tuple3 -> releasedSlotFuture.complete(tuple3.f0));
        SlotSharingManager slotSharingManager = new SlotSharingManager(SLOT_SHARING_GROUP_ID, (AllocatedSlotActions)testingAllocatedSlotActions, (SlotOwner)SLOT_OWNER);
        SlotRequestId rootSlotRequestId = new SlotRequestId();
        SlotRequestId allocatedSlotRequestId = new SlotRequestId();
        SlotSharingManager.MultiTaskSlot rootSlot = slotSharingManager.createRootSlot(rootSlotRequestId, new CompletableFuture(), allocatedSlotRequestId);
        SlotRequestId singleTaskSlotRequestId = new SlotRequestId();
        SlotSharingManager.SingleTaskSlot singleTaskSlot = rootSlot.allocateSingleTaskSlot(singleTaskSlotRequestId, ResourceProfile.UNKNOWN, new AbstractID(), Locality.LOCAL);
        SlotRequestId multiTaskSlotRequestId = new SlotRequestId();
        SlotSharingManager.MultiTaskSlot multiTaskSlot = rootSlot.allocateMultiTaskSlot(multiTaskSlotRequestId, new AbstractID());
        CompletableFuture singleTaskSlotFuture = singleTaskSlot.getLogicalSlotFuture();
        Assert.assertTrue((boolean)slotSharingManager.contains(rootSlotRequestId));
        Assert.assertTrue((boolean)slotSharingManager.contains(singleTaskSlotRequestId));
        Assert.assertFalse((boolean)singleTaskSlotFuture.isDone());
        FlinkException testException = new FlinkException("Test exception");
        singleTaskSlot.release((Throwable)testException);
        Assert.assertTrue((boolean)singleTaskSlotFuture.isCompletedExceptionally());
        Assert.assertFalse((boolean)slotSharingManager.contains(singleTaskSlotRequestId));
        Assert.assertTrue((boolean)slotSharingManager.contains(rootSlotRequestId));
        multiTaskSlot.release((Throwable)testException);
        Assert.assertEquals((Object)allocatedSlotRequestId, releasedSlotFuture.get());
        Assert.assertFalse((boolean)slotSharingManager.contains(rootSlotRequestId));
        Assert.assertFalse((boolean)slotSharingManager.contains(multiTaskSlotRequestId));
        Assert.assertTrue((boolean)slotSharingManager.isEmpty());
    }

    @Test
    public void testInnerSlotRelease() {
        SlotSharingManager slotSharingManager = this.createTestingSlotSharingManager();
        SlotSharingManager.MultiTaskSlot rootSlot = slotSharingManager.createRootSlot(new SlotRequestId(), new CompletableFuture(), new SlotRequestId());
        SlotSharingManager.MultiTaskSlot multiTaskSlot = rootSlot.allocateMultiTaskSlot(new SlotRequestId(), new AbstractID());
        SlotSharingManager.SingleTaskSlot singleTaskSlot1 = multiTaskSlot.allocateSingleTaskSlot(new SlotRequestId(), ResourceProfile.UNKNOWN, new AbstractID(), Locality.LOCAL);
        SlotSharingManager.MultiTaskSlot multiTaskSlot1 = multiTaskSlot.allocateMultiTaskSlot(new SlotRequestId(), new AbstractID());
        Assert.assertTrue((boolean)slotSharingManager.contains(multiTaskSlot1.getSlotRequestId()));
        Assert.assertTrue((boolean)slotSharingManager.contains(singleTaskSlot1.getSlotRequestId()));
        Assert.assertTrue((boolean)slotSharingManager.contains(multiTaskSlot.getSlotRequestId()));
        multiTaskSlot.release((Throwable)new FlinkException("Test exception"));
        Assert.assertFalse((boolean)slotSharingManager.contains(multiTaskSlot1.getSlotRequestId()));
        Assert.assertFalse((boolean)slotSharingManager.contains(singleTaskSlot1.getSlotRequestId()));
        Assert.assertFalse((boolean)slotSharingManager.contains(multiTaskSlot.getSlotRequestId()));
        Assert.assertTrue((boolean)singleTaskSlot1.getLogicalSlotFuture().isCompletedExceptionally());
    }

    @Test
    public void testSlotContextFutureCompletion() throws Exception {
        SlotSharingManager slotSharingManager = this.createTestingSlotSharingManager();
        SimpleSlotContext slotContext = this.createSimpleSlotContext();
        CompletableFuture<SimpleSlotContext> slotContextFuture = new CompletableFuture<SimpleSlotContext>();
        SlotSharingManager.MultiTaskSlot rootSlot = slotSharingManager.createRootSlot(new SlotRequestId(), slotContextFuture, new SlotRequestId());
        Locality locality1 = Locality.LOCAL;
        SlotSharingManager.SingleTaskSlot singleTaskSlot1 = rootSlot.allocateSingleTaskSlot(new SlotRequestId(), ResourceProfile.UNKNOWN, new AbstractID(), locality1);
        Locality locality2 = Locality.HOST_LOCAL;
        SlotSharingManager.SingleTaskSlot singleTaskSlot2 = rootSlot.allocateSingleTaskSlot(new SlotRequestId(), ResourceProfile.UNKNOWN, new AbstractID(), locality2);
        CompletableFuture logicalSlotFuture1 = singleTaskSlot1.getLogicalSlotFuture();
        CompletableFuture logicalSlotFuture2 = singleTaskSlot2.getLogicalSlotFuture();
        Assert.assertFalse((boolean)logicalSlotFuture1.isDone());
        Assert.assertFalse((boolean)logicalSlotFuture2.isDone());
        slotContextFuture.complete(slotContext);
        Assert.assertTrue((boolean)logicalSlotFuture1.isDone());
        Assert.assertTrue((boolean)logicalSlotFuture2.isDone());
        LogicalSlot logicalSlot1 = (LogicalSlot)logicalSlotFuture1.get();
        LogicalSlot logicalSlot2 = (LogicalSlot)logicalSlotFuture2.get();
        Assert.assertEquals((Object)logicalSlot1.getAllocationId(), (Object)slotContext.getAllocationId());
        Assert.assertEquals((Object)logicalSlot2.getAllocationId(), (Object)slotContext.getAllocationId());
        Assert.assertEquals((Object)locality1, (Object)logicalSlot1.getLocality());
        Assert.assertEquals((Object)locality2, (Object)logicalSlot2.getLocality());
        Locality locality3 = Locality.NON_LOCAL;
        SlotSharingManager.SingleTaskSlot singleTaskSlot3 = rootSlot.allocateSingleTaskSlot(new SlotRequestId(), ResourceProfile.UNKNOWN, new AbstractID(), locality3);
        CompletableFuture logicalSlotFuture3 = singleTaskSlot3.getLogicalSlotFuture();
        Assert.assertTrue((boolean)logicalSlotFuture3.isDone());
        LogicalSlot logicalSlot3 = (LogicalSlot)logicalSlotFuture3.get();
        Assert.assertEquals((Object)locality3, (Object)logicalSlot3.getLocality());
        Assert.assertEquals((Object)slotContext.getAllocationId(), (Object)logicalSlot3.getAllocationId());
    }

    private SimpleSlotContext createSimpleSlotContext() {
        return new SimpleSlotContext(new AllocationID(), new LocalTaskManagerLocation(), 0, new SimpleAckingTaskManagerGateway());
    }

    @Test
    public void testSlotContextFutureFailure() {
        SlotSharingManager slotSharingManager = this.createTestingSlotSharingManager();
        CompletableFuture slotContextFuture = new CompletableFuture();
        Assert.assertTrue((boolean)slotSharingManager.isEmpty());
        SlotSharingManager.MultiTaskSlot rootSlot = slotSharingManager.createRootSlot(new SlotRequestId(), slotContextFuture, new SlotRequestId());
        SlotSharingManager.SingleTaskSlot singleTaskSlot = rootSlot.allocateSingleTaskSlot(new SlotRequestId(), ResourceProfile.UNKNOWN, new AbstractID(), Locality.LOCAL);
        slotContextFuture.completeExceptionally((Throwable)new FlinkException("Test exception"));
        Assert.assertTrue((boolean)singleTaskSlot.getLogicalSlotFuture().isCompletedExceptionally());
        Assert.assertTrue((boolean)slotSharingManager.isEmpty());
        Assert.assertTrue((boolean)slotSharingManager.getResolvedRootSlots().isEmpty());
        Assert.assertTrue((boolean)slotSharingManager.getUnresolvedRootSlots().isEmpty());
    }

    @Test
    public void testRootSlotTransition() {
        SlotSharingManager slotSharingManager = this.createTestingSlotSharingManager();
        CompletableFuture<SimpleSlotContext> slotContextFuture = new CompletableFuture<SimpleSlotContext>();
        SlotSharingManager.MultiTaskSlot rootSlot = slotSharingManager.createRootSlot(new SlotRequestId(), slotContextFuture, new SlotRequestId());
        Assert.assertTrue((boolean)slotSharingManager.getUnresolvedRootSlots().contains(rootSlot));
        Assert.assertFalse((boolean)slotSharingManager.getResolvedRootSlots().contains(rootSlot));
        slotContextFuture.complete(this.createSimpleSlotContext());
        Assert.assertFalse((boolean)slotSharingManager.getUnresolvedRootSlots().contains(rootSlot));
        Assert.assertTrue((boolean)slotSharingManager.getResolvedRootSlots().contains(rootSlot));
    }

    @Test
    public void testGetResolvedSlot() {
        SlotSharingManager slotSharingManager = this.createTestingSlotSharingManager();
        SlotSharingManager.MultiTaskSlot rootSlot = this.createRootSlot(new LocalTaskManagerLocation(), slotSharingManager);
        AbstractID groupId = new AbstractID();
        Collection slotInfos = slotSharingManager.listResolvedRootSlotInfo(groupId);
        Assert.assertEquals((long)1L, (long)slotInfos.size());
        SlotSelectionStrategy.SlotInfoAndResources slotInfoAndRemainingResource = (SlotSelectionStrategy.SlotInfoAndResources)slotInfos.iterator().next();
        SlotSharingManager.MultiTaskSlot resolvedMultiTaskSlot = slotSharingManager.getResolvedRootSlot(slotInfoAndRemainingResource.getSlotInfo());
        LocationPreferenceSlotSelectionStrategy locationPreferenceSlotSelectionStrategy = LocationPreferenceSlotSelectionStrategy.createDefault();
        SlotSelectionStrategy.SlotInfoAndLocality slotInfoAndLocality = (SlotSelectionStrategy.SlotInfoAndLocality)locationPreferenceSlotSelectionStrategy.selectBestSlotForProfile(slotInfos, SlotProfile.noRequirements()).get();
        Assert.assertNotNull((Object)resolvedMultiTaskSlot);
        Assert.assertEquals((Object)Locality.UNCONSTRAINED, (Object)slotInfoAndLocality.getLocality());
        Assert.assertEquals((Object)rootSlot.getSlotRequestId(), (Object)resolvedMultiTaskSlot.getSlotRequestId());
        resolvedMultiTaskSlot.allocateSingleTaskSlot(new SlotRequestId(), ResourceProfile.UNKNOWN, groupId, Locality.UNCONSTRAINED);
        slotInfos = slotSharingManager.listResolvedRootSlotInfo(groupId);
        Assert.assertTrue((boolean)slotInfos.isEmpty());
    }

    @Test
    public void testGetResolvedSlotWithLocationPreferences() {
        SlotSharingManager slotSharingManager = this.createTestingSlotSharingManager();
        SlotSharingManager.MultiTaskSlot rootSlot1 = this.createRootSlot(new LocalTaskManagerLocation(), slotSharingManager);
        LocalTaskManagerLocation taskManagerLocation = new LocalTaskManagerLocation();
        SlotSharingManager.MultiTaskSlot rootSlot2 = this.createRootSlot(taskManagerLocation, slotSharingManager);
        AbstractID groupId = new AbstractID();
        SlotProfile slotProfile = SlotProfile.preferredLocality((ResourceProfile)ResourceProfile.UNKNOWN, Collections.singleton(taskManagerLocation));
        Collection slotInfos = slotSharingManager.listResolvedRootSlotInfo(groupId);
        LocationPreferenceSlotSelectionStrategy locationPreferenceSlotSelectionStrategy = LocationPreferenceSlotSelectionStrategy.createDefault();
        SlotSelectionStrategy.SlotInfoAndLocality slotInfoAndLocality = (SlotSelectionStrategy.SlotInfoAndLocality)locationPreferenceSlotSelectionStrategy.selectBestSlotForProfile(slotInfos, slotProfile).get();
        SlotSharingManager.MultiTaskSlot resolvedRootSlot = slotSharingManager.getResolvedRootSlot(slotInfoAndLocality.getSlotInfo());
        Assert.assertNotNull((Object)resolvedRootSlot);
        Assert.assertEquals((Object)Locality.LOCAL, (Object)slotInfoAndLocality.getLocality());
        Assert.assertEquals((Object)rootSlot2.getSlotRequestId(), (Object)resolvedRootSlot.getSlotRequestId());
        resolvedRootSlot.allocateSingleTaskSlot(new SlotRequestId(), ResourceProfile.UNKNOWN, groupId, slotInfoAndLocality.getLocality());
        slotInfos = slotSharingManager.listResolvedRootSlotInfo(groupId);
        slotInfoAndLocality = (SlotSelectionStrategy.SlotInfoAndLocality)locationPreferenceSlotSelectionStrategy.selectBestSlotForProfile(slotInfos, slotProfile).get();
        resolvedRootSlot = slotSharingManager.getResolvedRootSlot(slotInfoAndLocality.getSlotInfo());
        Assert.assertNotNull((Object)resolvedRootSlot);
        Assert.assertNotSame((Object)Locality.LOCAL, (Object)slotInfoAndLocality.getLocality());
        Assert.assertEquals((Object)rootSlot1.getSlotRequestId(), (Object)resolvedRootSlot.getSlotRequestId());
    }

    @Test
    public void testResolvedSlotInReleasingIsNotAvailable() throws Exception {
        final SlotSharingManager slotSharingManager = this.createTestingSlotSharingManager();
        SlotSharingManager.MultiTaskSlot rootSlot = this.createRootSlot(new LocalTaskManagerLocation(), slotSharingManager);
        AbstractID groupId1 = new AbstractID();
        SlotSharingManager.SingleTaskSlot singleTaskSlot = rootSlot.allocateSingleTaskSlot(new SlotRequestId(), ResourceProfile.UNKNOWN, groupId1, Locality.UNCONSTRAINED);
        final AtomicBoolean verified = new AtomicBoolean(false);
        final AbstractID groupId2 = new AbstractID();
        ((LogicalSlot)singleTaskSlot.getLogicalSlotFuture().get()).tryAssignPayload(new LogicalSlot.Payload(){

            public void fail(Throwable cause) {
                Assert.assertEquals((long)0L, (long)slotSharingManager.listResolvedRootSlotInfo(groupId2).size());
                verified.set(true);
            }

            public CompletableFuture<?> getTerminalStateFuture() {
                return null;
            }
        });
        Assert.assertEquals((long)1L, (long)slotSharingManager.listResolvedRootSlotInfo(groupId2).size());
        rootSlot.release((Throwable)new Exception("test exception"));
        Assert.assertTrue((boolean)verified.get());
    }

    @Test
    public void testGetUnresolvedSlot() {
        SlotSharingManager slotSharingManager = this.createTestingSlotSharingManager();
        SlotSharingManager.MultiTaskSlot rootSlot1 = slotSharingManager.createRootSlot(new SlotRequestId(), new CompletableFuture(), new SlotRequestId());
        AbstractID groupId = new AbstractID();
        SlotSharingManager.MultiTaskSlot unresolvedRootSlot = slotSharingManager.getUnresolvedRootSlot(groupId);
        Assert.assertNotNull((Object)unresolvedRootSlot);
        Assert.assertEquals((Object)rootSlot1.getSlotRequestId(), (Object)unresolvedRootSlot.getSlotRequestId());
        unresolvedRootSlot.allocateSingleTaskSlot(new SlotRequestId(), ResourceProfile.UNKNOWN, groupId, Locality.UNKNOWN);
        SlotSharingManager.MultiTaskSlot unresolvedRootSlot1 = slotSharingManager.getUnresolvedRootSlot(groupId);
        Assert.assertNull((Object)unresolvedRootSlot1);
    }

    @Test
    public void testResourceCalculationOnSlotAllocatingAndReleasing() {
        ResourceProfile rp1 = ResourceProfile.newBuilder().setCpuCores(1.0).setTaskHeapMemoryMB(100).setTaskOffHeapMemoryMB(100).setManagedMemoryMB(100).setNetworkMemoryMB(100).build();
        ResourceProfile rp2 = ResourceProfile.newBuilder().setCpuCores(2.0).setTaskHeapMemoryMB(200).setTaskOffHeapMemoryMB(200).setManagedMemoryMB(200).setNetworkMemoryMB(200).addExtendedResource("gpu", (Resource)new GPUResource(2.0)).build();
        ResourceProfile rp3 = ResourceProfile.newBuilder().setCpuCores(3.0).setTaskHeapMemoryMB(300).setTaskOffHeapMemoryMB(300).setManagedMemoryMB(300).setNetworkMemoryMB(300).addExtendedResource("gpu", (Resource)new GPUResource(3.0)).build();
        SlotSharingManager slotSharingManager = this.createTestingSlotSharingManager();
        SlotSharingManager.MultiTaskSlot unresolvedRootSlot = slotSharingManager.createRootSlot(new SlotRequestId(), new CompletableFuture(), new SlotRequestId());
        SlotSharingManager.MultiTaskSlot leftMultiTaskSlot = unresolvedRootSlot.allocateMultiTaskSlot(new SlotRequestId(), (AbstractID)new SlotSharingGroupId());
        SlotSharingManager.SingleTaskSlot firstChild = leftMultiTaskSlot.allocateSingleTaskSlot(new SlotRequestId(), rp1, (AbstractID)new SlotSharingGroupId(), Locality.LOCAL);
        SlotSharingManager.SingleTaskSlot secondChild = leftMultiTaskSlot.allocateSingleTaskSlot(new SlotRequestId(), rp2, (AbstractID)new SlotSharingGroupId(), Locality.LOCAL);
        Assert.assertEquals((Object)rp1, (Object)firstChild.getReservedResources());
        Assert.assertEquals((Object)rp2, (Object)secondChild.getReservedResources());
        Assert.assertEquals((Object)rp1.merge(rp2), (Object)leftMultiTaskSlot.getReservedResources());
        Assert.assertEquals((Object)rp1.merge(rp2), (Object)unresolvedRootSlot.getReservedResources());
        SlotSharingManager.SingleTaskSlot thirdChild = unresolvedRootSlot.allocateSingleTaskSlot(new SlotRequestId(), rp3, (AbstractID)new SlotSharingGroupId(), Locality.LOCAL);
        Assert.assertEquals((Object)rp3, (Object)thirdChild.getReservedResources());
        Assert.assertEquals((Object)rp1.merge(rp2).merge(rp3), (Object)unresolvedRootSlot.getReservedResources());
        secondChild.release(new Throwable("Release for testing"));
        Assert.assertEquals((Object)rp1, (Object)leftMultiTaskSlot.getReservedResources());
        Assert.assertEquals((Object)rp1.merge(rp3), (Object)unresolvedRootSlot.getReservedResources());
        thirdChild.release(new Throwable("Release for testing"));
        Assert.assertEquals((Object)rp1, (Object)unresolvedRootSlot.getReservedResources());
        firstChild.release(new Throwable("Release for testing"));
        Assert.assertEquals((Object)ResourceProfile.ZERO, (Object)unresolvedRootSlot.getReservedResources());
    }

    @Test
    public void testGetResolvedSlotWithResourceConfigured() {
        ResourceProfile rp1 = ResourceProfile.fromResources((double)1.0, (int)100);
        ResourceProfile rp2 = ResourceProfile.fromResources((double)2.0, (int)200);
        ResourceProfile allocatedSlotRp = ResourceProfile.fromResources((double)5.0, (int)500);
        SlotSharingManager slotSharingManager = this.createTestingSlotSharingManager();
        SlotSharingManager.MultiTaskSlot rootSlot = slotSharingManager.createRootSlot(new SlotRequestId(), CompletableFuture.completedFuture(new SimpleSlotContext(new AllocationID(), new LocalTaskManagerLocation(), 0, new SimpleAckingTaskManagerGateway(), allocatedSlotRp)), new SlotRequestId());
        rootSlot.allocateSingleTaskSlot(new SlotRequestId(), rp1, (AbstractID)new SlotSharingGroupId(), Locality.LOCAL);
        Collection resolvedRoots = slotSharingManager.listResolvedRootSlotInfo(new AbstractID());
        Assert.assertEquals((long)1L, (long)resolvedRoots.size());
        Assert.assertEquals((Object)allocatedSlotRp.subtract(rp1), (Object)((SlotSelectionStrategy.SlotInfoAndResources)resolvedRoots.iterator().next()).getRemainingResources());
        rootSlot.allocateSingleTaskSlot(new SlotRequestId(), rp2, (AbstractID)new SlotSharingGroupId(), Locality.LOCAL);
        resolvedRoots = slotSharingManager.listResolvedRootSlotInfo(new AbstractID());
        Assert.assertEquals((long)1L, (long)resolvedRoots.size());
        Assert.assertEquals((Object)allocatedSlotRp.subtract(rp1).subtract(rp2), (Object)((SlotSelectionStrategy.SlotInfoAndResources)resolvedRoots.iterator().next()).getRemainingResources());
    }

    @Test
    public void testHashEnoughResourceOfMultiTaskSlot() {
        ResourceProfile rp1 = ResourceProfile.fromResources((double)1.0, (int)100);
        ResourceProfile rp2 = ResourceProfile.fromResources((double)2.0, (int)200);
        ResourceProfile allocatedSlotRp = ResourceProfile.fromResources((double)2.0, (int)200);
        SlotSharingManager slotSharingManager = this.createTestingSlotSharingManager();
        CompletableFuture<AllocatedSlot> slotContextFuture = new CompletableFuture<AllocatedSlot>();
        SlotSharingManager.MultiTaskSlot unresolvedRootSlot = slotSharingManager.createRootSlot(new SlotRequestId(), slotContextFuture, new SlotRequestId());
        SlotSharingManager.MultiTaskSlot multiTaskSlot = unresolvedRootSlot.allocateMultiTaskSlot(new SlotRequestId(), (AbstractID)new SlotSharingGroupId());
        SlotSharingManager.SingleTaskSlot firstChild = multiTaskSlot.allocateSingleTaskSlot(new SlotRequestId(), rp1, (AbstractID)new SlotSharingGroupId(), Locality.LOCAL);
        Assert.assertThat((Object)multiTaskSlot.mayHaveEnoughResourcesToFulfill(rp1), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)multiTaskSlot.mayHaveEnoughResourcesToFulfill(rp2), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)multiTaskSlot.mayHaveEnoughResourcesToFulfill(ResourceProfile.UNKNOWN), (Matcher)Is.is((Object)true));
        slotContextFuture.complete(new AllocatedSlot(new AllocationID(), new TaskManagerLocation(new ResourceID("tm-X"), InetAddress.getLoopbackAddress(), 46), 0, allocatedSlotRp, (TaskManagerGateway)Mockito.mock(TaskManagerGateway.class)));
        Assert.assertThat((Object)multiTaskSlot.mayHaveEnoughResourcesToFulfill(rp1), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)multiTaskSlot.mayHaveEnoughResourcesToFulfill(rp2), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)multiTaskSlot.mayHaveEnoughResourcesToFulfill(ResourceProfile.UNKNOWN), (Matcher)Is.is((Object)true));
    }

    @Test
    public void testSlotAllocatedWithEnoughResource() {
        SlotSharingResourceTestContext context = this.createResourceTestContext(ResourceProfile.fromResources((double)16.0, (int)1600));
        for (SlotSharingManager.SingleTaskSlot singleTaskSlot : context.singleTaskSlotsInOrder) {
            Assert.assertThat((Object)singleTaskSlot.getLogicalSlotFuture().isDone(), (Matcher)Is.is((Object)true));
            Assert.assertThat((Object)singleTaskSlot.getLogicalSlotFuture().isCompletedExceptionally(), (Matcher)Is.is((Object)false));
        }
        Assert.assertThat((Object)context.slotSharingManager.getTaskSlot(context.coLocationTaskSlot.getSlotRequestId()), (Matcher)CoreMatchers.notNullValue());
    }

    @Test
    public void testSlotOverAllocatedAndTaskSlotsReleased() {
        SlotSharingResourceTestContext context = this.createResourceTestContext(ResourceProfile.fromResources((double)7.0, (int)700));
        for (int i = 0; i < context.singleTaskSlotsInOrder.size(); ++i) {
            SlotSharingManager.SingleTaskSlot singleTaskSlot = context.singleTaskSlotsInOrder.get(i);
            Assert.assertThat((Object)singleTaskSlot.getLogicalSlotFuture().isDone(), (Matcher)Is.is((Object)true));
            Assert.assertThat((Object)singleTaskSlot.getLogicalSlotFuture().isCompletedExceptionally(), (Matcher)Is.is((Object)true));
            singleTaskSlot.getLogicalSlotFuture().whenComplete((ignored, throwable) -> Assert.assertThat((Object)throwable, (Matcher)Matchers.instanceOf(IllegalStateException.class)));
        }
        Assert.assertThat((Object)context.slotSharingManager.isEmpty(), (Matcher)Is.is((Object)true));
    }

    private SlotSharingResourceTestContext createResourceTestContext(ResourceProfile allocatedResourceProfile) {
        ResourceProfile coLocationTaskRp = ResourceProfile.fromResources((double)2.0, (int)200);
        ResourceProfile thirdChildRp = ResourceProfile.fromResources((double)3.0, (int)300);
        ResourceProfile forthChildRp = ResourceProfile.fromResources((double)9.0, (int)900);
        SlotSharingManager slotSharingManager = this.createTestingSlotSharingManager();
        CompletableFuture<AllocatedSlot> slotContextFuture = new CompletableFuture<AllocatedSlot>();
        SlotSharingManager.MultiTaskSlot unresolvedRootSlot = slotSharingManager.createRootSlot(new SlotRequestId(), slotContextFuture, new SlotRequestId());
        SlotSharingManager.MultiTaskSlot coLocationTaskSlot = unresolvedRootSlot.allocateMultiTaskSlot(new SlotRequestId(), (AbstractID)new SlotSharingGroupId());
        SlotSharingManager.SingleTaskSlot firstCoLocatedChild = coLocationTaskSlot.allocateSingleTaskSlot(new SlotRequestId(), coLocationTaskRp, (AbstractID)new SlotSharingGroupId(), Locality.LOCAL);
        SlotSharingManager.SingleTaskSlot secondCoLocatedChild = coLocationTaskSlot.allocateSingleTaskSlot(new SlotRequestId(), coLocationTaskRp, (AbstractID)new SlotSharingGroupId(), Locality.LOCAL);
        SlotSharingManager.SingleTaskSlot thirdChild = unresolvedRootSlot.allocateSingleTaskSlot(new SlotRequestId(), thirdChildRp, (AbstractID)new SlotSharingGroupId(), Locality.LOCAL);
        SlotSharingManager.SingleTaskSlot forthChild = unresolvedRootSlot.allocateSingleTaskSlot(new SlotRequestId(), forthChildRp, (AbstractID)new SlotSharingGroupId(), Locality.LOCAL);
        slotContextFuture.complete(new AllocatedSlot(new AllocationID(), new TaskManagerLocation(new ResourceID("tm-X"), InetAddress.getLoopbackAddress(), 46), 0, allocatedResourceProfile, (TaskManagerGateway)Mockito.mock(TaskManagerGateway.class)));
        return new SlotSharingResourceTestContext(slotSharingManager, coLocationTaskSlot, Arrays.asList(firstCoLocatedChild, secondCoLocatedChild, thirdChild, forthChild));
    }

    private SlotSharingManager createTestingSlotSharingManager() {
        TestingAllocatedSlotActions allocatedSlotActions = new TestingAllocatedSlotActions();
        return new SlotSharingManager(SLOT_SHARING_GROUP_ID, (AllocatedSlotActions)allocatedSlotActions, (SlotOwner)SLOT_OWNER);
    }

    @Test
    public void testTaskExecutorUtilizationCalculation() {
        TestingAllocatedSlotActions allocatedSlotActions = new TestingAllocatedSlotActions();
        LocalTaskManagerLocation firstTaskExecutorLocation = new LocalTaskManagerLocation();
        LocalTaskManagerLocation secondTaskExecutorLocation = new LocalTaskManagerLocation();
        SlotSharingManager slotSharingManager = new SlotSharingManager(SLOT_SHARING_GROUP_ID, (AllocatedSlotActions)allocatedSlotActions, (SlotOwner)SLOT_OWNER);
        SlotSharingManager.MultiTaskSlot firstRootSlot = this.createRootSlot(firstTaskExecutorLocation, slotSharingManager);
        this.createRootSlot(firstTaskExecutorLocation, slotSharingManager);
        this.createRootSlot(secondTaskExecutorLocation, slotSharingManager);
        AbstractID groupId = new AbstractID();
        firstRootSlot.allocateSingleTaskSlot(new SlotRequestId(), ResourceProfile.UNKNOWN, groupId, Locality.UNCONSTRAINED);
        Collection slotInfoAndResources = slotSharingManager.listResolvedRootSlotInfo(groupId);
        Assert.assertThat((Object)slotInfoAndResources, (Matcher)Matchers.hasSize((int)2));
        Map<TaskManagerLocation, Double> utilizationPerTaskExecutor = slotInfoAndResources.stream().collect(Collectors.toMap(slot -> slot.getSlotInfo().getTaskManagerLocation(), SlotSelectionStrategy.SlotInfoAndResources::getTaskExecutorUtilization));
        Assert.assertThat((Object)utilizationPerTaskExecutor.get((Object)firstTaskExecutorLocation), (Matcher)Is.is((Matcher)Matchers.closeTo((double)0.5, (double)0.1)));
        Assert.assertThat((Object)utilizationPerTaskExecutor.get((Object)secondTaskExecutorLocation), (Matcher)Is.is((Matcher)Matchers.closeTo((double)0.0, (double)0.1)));
    }

    @Test
    public void shouldResolveRootSlotBeforeCompletingChildSlots() {
        SlotSharingManager slotSharingManager = this.createTestingSlotSharingManager();
        CompletableFuture<SimpleSlotContext> slotFuture = new CompletableFuture<SimpleSlotContext>();
        CompletionStage identityFuture = slotFuture.thenApply(Function.identity());
        SlotSharingManager.MultiTaskSlot rootSlot = slotSharingManager.createRootSlot(new SlotRequestId(), (CompletableFuture)identityFuture, new SlotRequestId());
        SlotSharingManager.SingleTaskSlot singleTaskSlot = rootSlot.allocateSingleTaskSlot(new SlotRequestId(), ResourceProfile.UNKNOWN, new AbstractID(), Locality.UNCONSTRAINED);
        CompletionStage assertionFuture = singleTaskSlot.getLogicalSlotFuture().thenRun(() -> Assert.assertThat((Object)slotSharingManager.getResolvedRootSlots(), (Matcher)Matchers.contains((Object[])new SlotSharingManager.MultiTaskSlot[]{rootSlot})));
        slotFuture.complete(this.createSimpleSlotContext());
        ((CompletableFuture)assertionFuture).join();
    }

    private SlotSharingManager.MultiTaskSlot createRootSlot(TaskManagerLocation firstTaskExecutorLocation, SlotSharingManager slotSharingManager) {
        return slotSharingManager.createRootSlot(new SlotRequestId(), CompletableFuture.completedFuture(new SimpleSlotContext(new AllocationID(), firstTaskExecutorLocation, 0, new SimpleAckingTaskManagerGateway())), new SlotRequestId());
    }

    private class SlotSharingResourceTestContext {
        final SlotSharingManager slotSharingManager;
        final SlotSharingManager.MultiTaskSlot coLocationTaskSlot;
        final List<SlotSharingManager.SingleTaskSlot> singleTaskSlotsInOrder;

        SlotSharingResourceTestContext(@Nonnull SlotSharingManager slotSharingManager, @Nonnull SlotSharingManager.MultiTaskSlot coLocationTaskSlot, List<SlotSharingManager.SingleTaskSlot> singleTaskSlotsInOrder) {
            this.slotSharingManager = slotSharingManager;
            this.coLocationTaskSlot = coLocationTaskSlot;
            this.singleTaskSlotsInOrder = singleTaskSlotsInOrder;
        }
    }
}

