/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster.slotpool;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.clusterframework.types.SlotProfile;
import org.apache.flink.runtime.executiongraph.ExecutionGraphTestUtils;
import org.apache.flink.runtime.executiongraph.TestingComponentMainThreadExecutor;
import org.apache.flink.runtime.executiongraph.utils.SimpleAckingTaskManagerGateway;
import org.apache.flink.runtime.jobmanager.scheduler.DummyScheduledUnit;
import org.apache.flink.runtime.jobmanager.scheduler.ScheduledUnit;
import org.apache.flink.runtime.jobmaster.JobMasterId;
import org.apache.flink.runtime.jobmaster.SlotRequestId;
import org.apache.flink.runtime.jobmaster.slotpool.AvailableSlotsTest;
import org.apache.flink.runtime.jobmaster.slotpool.LocationPreferenceSlotSelectionStrategy;
import org.apache.flink.runtime.jobmaster.slotpool.Scheduler;
import org.apache.flink.runtime.jobmaster.slotpool.SchedulerImpl;
import org.apache.flink.runtime.jobmaster.slotpool.SlotPool;
import org.apache.flink.runtime.jobmaster.slotpool.SlotPoolImpl;
import org.apache.flink.runtime.jobmaster.slotpool.SlotSelectionStrategy;
import org.apache.flink.runtime.resourcemanager.utils.TestingResourceManagerGateway;
import org.apache.flink.runtime.taskexecutor.slot.SlotOffer;
import org.apache.flink.runtime.taskmanager.LocalTaskManagerLocation;
import org.apache.flink.runtime.testingUtils.TestingUtils;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.TestLogger;
import org.apache.flink.util.clock.Clock;
import org.apache.flink.util.clock.SystemClock;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;

public class SlotPoolInteractionsTest
extends TestLogger {
    private static final Time fastTimeout = Time.milliseconds((long)1L);
    @ClassRule
    public static final TestingComponentMainThreadExecutor.Resource EXECUTOR_RESOURCE = new TestingComponentMainThreadExecutor.Resource(10L);
    private final TestingComponentMainThreadExecutor testMainThreadExecutor = EXECUTOR_RESOURCE.getComponentMainThreadTestExecutor();

    @Test
    public void testSlotAllocationNoResourceManager() throws Exception {
        JobID jid = new JobID();
        try (SlotPoolImpl pool = new SlotPoolImpl(jid, (Clock)SystemClock.getInstance(), TestingUtils.infiniteTime(), TestingUtils.infiniteTime(), TestingUtils.infiniteTime());){
            pool.start(JobMasterId.generate(), "foobar", this.testMainThreadExecutor.getMainThreadExecutor());
            SchedulerImpl scheduler = new SchedulerImpl((SlotSelectionStrategy)LocationPreferenceSlotSelectionStrategy.createDefault(), (SlotPool)pool);
            scheduler.start(this.testMainThreadExecutor.getMainThreadExecutor());
            CompletableFuture future = (CompletableFuture)this.testMainThreadExecutor.execute(() -> SlotPoolInteractionsTest.lambda$testSlotAllocationNoResourceManager$0((Scheduler)scheduler));
            try {
                future.get();
                Assert.fail((String)"We expected an ExecutionException.");
            }
            catch (ExecutionException e) {
                Assert.assertTrue((boolean)(ExceptionUtils.stripExecutionException((Throwable)e) instanceof TimeoutException));
            }
        }
    }

    @Test
    public void testCancelSlotAllocationWithoutResourceManager() throws Exception {
        JobID jid = new JobID();
        try (TestingSlotPool pool = this.createTestingSlotPool(jid);){
            CompletableFuture timeoutFuture = new CompletableFuture();
            pool.setTimeoutPendingSlotRequestConsumer(timeoutFuture::complete);
            pool.start(JobMasterId.generate(), "foobar", this.testMainThreadExecutor.getMainThreadExecutor());
            SchedulerImpl scheduler = new SchedulerImpl((SlotSelectionStrategy)LocationPreferenceSlotSelectionStrategy.createDefault(), (SlotPool)pool);
            scheduler.start(this.testMainThreadExecutor.getMainThreadExecutor());
            SlotRequestId requestId = new SlotRequestId();
            CompletableFuture future = (CompletableFuture)this.testMainThreadExecutor.execute(() -> SlotPoolInteractionsTest.lambda$testCancelSlotAllocationWithoutResourceManager$1((Scheduler)scheduler, requestId));
            try {
                future.get();
                Assert.fail((String)"We expected a TimeoutException.");
            }
            catch (ExecutionException e) {
                Assert.assertTrue((boolean)(ExceptionUtils.stripExecutionException((Throwable)e) instanceof TimeoutException));
            }
            timeoutFuture.get();
            Assert.assertEquals((long)0L, (long)pool.getNumberOfWaitingForResourceRequests());
        }
    }

    @Nonnull
    private TestingSlotPool createTestingSlotPool(JobID jid) {
        return new TestingSlotPool(jid, (Clock)SystemClock.getInstance(), TestingUtils.infiniteTime(), TestingUtils.infiniteTime(), TestingUtils.infiniteTime());
    }

    @Test
    public void testSlotAllocationTimeout() throws Exception {
        JobID jid = new JobID();
        try (TestingSlotPool pool = this.createTestingSlotPool(jid);){
            pool.start(JobMasterId.generate(), "foobar", this.testMainThreadExecutor.getMainThreadExecutor());
            CompletableFuture slotRequestTimeoutFuture = new CompletableFuture();
            pool.setTimeoutPendingSlotRequestConsumer(slotRequestTimeoutFuture::complete);
            TestingResourceManagerGateway resourceManagerGateway = new TestingResourceManagerGateway();
            pool.connectToResourceManager(resourceManagerGateway);
            SchedulerImpl scheduler = new SchedulerImpl((SlotSelectionStrategy)LocationPreferenceSlotSelectionStrategy.createDefault(), (SlotPool)pool);
            scheduler.start(this.testMainThreadExecutor.getMainThreadExecutor());
            SlotRequestId requestId = new SlotRequestId();
            CompletableFuture future = (CompletableFuture)this.testMainThreadExecutor.execute(() -> SlotPoolInteractionsTest.lambda$testSlotAllocationTimeout$2((Scheduler)scheduler, requestId));
            try {
                future.get();
                Assert.fail((String)"We expected a TimeoutException.");
            }
            catch (ExecutionException e) {
                Assert.assertTrue((boolean)(ExceptionUtils.stripExecutionException((Throwable)e) instanceof TimeoutException));
            }
            slotRequestTimeoutFuture.get();
            Assert.assertEquals((long)0L, (long)pool.getNumberOfPendingRequests());
        }
    }

    @Test
    public void testExtraSlotsAreKept() throws Exception {
        JobID jid = new JobID();
        try (TestingSlotPool pool = this.createTestingSlotPool(jid);){
            pool.start(JobMasterId.generate(), "foobar", this.testMainThreadExecutor.getMainThreadExecutor());
            SchedulerImpl scheduler = new SchedulerImpl((SlotSelectionStrategy)LocationPreferenceSlotSelectionStrategy.createDefault(), (SlotPool)pool);
            scheduler.start(this.testMainThreadExecutor.getMainThreadExecutor());
            CompletableFuture allocationIdFuture = new CompletableFuture();
            TestingResourceManagerGateway resourceManagerGateway = new TestingResourceManagerGateway();
            resourceManagerGateway.setRequestSlotConsumer(slotRequest -> allocationIdFuture.complete(slotRequest.getAllocationId()));
            CompletableFuture slotRequestTimeoutFuture = new CompletableFuture();
            pool.setTimeoutPendingSlotRequestConsumer(slotRequestTimeoutFuture::complete);
            pool.connectToResourceManager(resourceManagerGateway);
            SlotRequestId requestId = new SlotRequestId();
            CompletableFuture future = (CompletableFuture)this.testMainThreadExecutor.execute(() -> SlotPoolInteractionsTest.lambda$testExtraSlotsAreKept$4((Scheduler)scheduler, requestId));
            try {
                future.get();
                Assert.fail((String)"We expected a TimeoutException.");
            }
            catch (ExecutionException e) {
                Assert.assertTrue((boolean)(ExceptionUtils.stripExecutionException((Throwable)e) instanceof TimeoutException));
            }
            slotRequestTimeoutFuture.get();
            Assert.assertEquals((long)0L, (long)pool.getNumberOfPendingRequests());
            AllocationID allocationId = (AllocationID)allocationIdFuture.get();
            SlotOffer slotOffer = new SlotOffer(allocationId, 0, AvailableSlotsTest.DEFAULT_TESTING_PROFILE);
            LocalTaskManagerLocation taskManagerLocation = new LocalTaskManagerLocation();
            SimpleAckingTaskManagerGateway taskManagerGateway = new SimpleAckingTaskManagerGateway();
            this.testMainThreadExecutor.execute(() -> pool.registerTaskManager(taskManagerLocation.getResourceID()));
            Assert.assertTrue((boolean)((Boolean)this.testMainThreadExecutor.execute(() -> pool.offerSlot(taskManagerLocation, taskManagerGateway, slotOffer))));
            Assert.assertTrue((boolean)pool.containsAvailableSlot(allocationId));
        }
    }

    @Test
    public void testProviderAndOwnerSlotAllocationTimeout() throws Exception {
        JobID jid = new JobID();
        try (TestingSlotPool pool = this.createTestingSlotPool(jid);){
            CompletableFuture releaseSlotFuture = new CompletableFuture();
            pool.setReleaseSlotConsumer(releaseSlotFuture::complete);
            pool.start(JobMasterId.generate(), "foobar", this.testMainThreadExecutor.getMainThreadExecutor());
            TestingResourceManagerGateway resourceManagerGateway = new TestingResourceManagerGateway();
            pool.connectToResourceManager(resourceManagerGateway);
            SchedulerImpl scheduler = new SchedulerImpl((SlotSelectionStrategy)LocationPreferenceSlotSelectionStrategy.createDefault(), (SlotPool)pool);
            scheduler.start(this.testMainThreadExecutor.getMainThreadExecutor());
            CompletableFuture future = (CompletableFuture)this.testMainThreadExecutor.execute(() -> SlotPoolInteractionsTest.lambda$testProviderAndOwnerSlotAllocationTimeout$7((Scheduler)scheduler));
            try {
                future.get();
                Assert.fail((String)"We expected a TimeoutException.");
            }
            catch (ExecutionException e) {
                Assert.assertTrue((boolean)(ExceptionUtils.stripExecutionException((Throwable)e) instanceof TimeoutException));
            }
            releaseSlotFuture.get();
            Assert.assertEquals((long)0L, (long)pool.getNumberOfPendingRequests());
        }
    }

    private static /* synthetic */ CompletableFuture lambda$testProviderAndOwnerSlotAllocationTimeout$7(Scheduler scheduler) throws Throwable {
        return scheduler.allocateSlot((ScheduledUnit)new DummyScheduledUnit(), SlotProfile.noRequirements(), fastTimeout);
    }

    private static /* synthetic */ CompletableFuture lambda$testExtraSlotsAreKept$4(Scheduler scheduler, SlotRequestId requestId) throws Throwable {
        return scheduler.allocateSlot(requestId, new ScheduledUnit(ExecutionGraphTestUtils.getExecution()), SlotProfile.noLocality((ResourceProfile)AvailableSlotsTest.DEFAULT_TESTING_PROFILE), fastTimeout);
    }

    private static /* synthetic */ CompletableFuture lambda$testSlotAllocationTimeout$2(Scheduler scheduler, SlotRequestId requestId) throws Throwable {
        return scheduler.allocateSlot(requestId, (ScheduledUnit)new DummyScheduledUnit(), SlotProfile.noLocality((ResourceProfile)AvailableSlotsTest.DEFAULT_TESTING_PROFILE), fastTimeout);
    }

    private static /* synthetic */ CompletableFuture lambda$testCancelSlotAllocationWithoutResourceManager$1(Scheduler scheduler, SlotRequestId requestId) throws Throwable {
        return scheduler.allocateSlot(requestId, new ScheduledUnit(ExecutionGraphTestUtils.getExecution()), SlotProfile.noLocality((ResourceProfile)AvailableSlotsTest.DEFAULT_TESTING_PROFILE), fastTimeout);
    }

    private static /* synthetic */ CompletableFuture lambda$testSlotAllocationNoResourceManager$0(Scheduler scheduler) throws Throwable {
        return scheduler.allocateSlot(new SlotRequestId(), new ScheduledUnit(ExecutionGraphTestUtils.getExecution()), SlotProfile.noLocality((ResourceProfile)AvailableSlotsTest.DEFAULT_TESTING_PROFILE), fastTimeout);
    }

    private static final class TestingSlotPool
    extends SlotPoolImpl {
        private volatile Consumer<SlotRequestId> releaseSlotConsumer = null;
        private volatile Consumer<SlotRequestId> timeoutPendingSlotRequestConsumer = null;

        public TestingSlotPool(JobID jobId, Clock clock, Time rpcTimeout, Time idleSlotTimeout, Time batchSlotTimeout) {
            super(jobId, clock, rpcTimeout, idleSlotTimeout, batchSlotTimeout);
        }

        public void setReleaseSlotConsumer(Consumer<SlotRequestId> releaseSlotConsumer) {
            this.releaseSlotConsumer = (Consumer)Preconditions.checkNotNull(releaseSlotConsumer);
        }

        public void setTimeoutPendingSlotRequestConsumer(Consumer<SlotRequestId> timeoutPendingSlotRequestConsumer) {
            this.timeoutPendingSlotRequestConsumer = (Consumer)Preconditions.checkNotNull(timeoutPendingSlotRequestConsumer);
        }

        public void releaseSlot(@Nonnull SlotRequestId slotRequestId, @Nullable Throwable cause) {
            Consumer<SlotRequestId> currentReleaseSlotConsumer = this.releaseSlotConsumer;
            super.releaseSlot(slotRequestId, cause);
            if (currentReleaseSlotConsumer != null) {
                currentReleaseSlotConsumer.accept(slotRequestId);
            }
        }

        protected void timeoutPendingSlotRequest(SlotRequestId slotRequestId) {
            Consumer<SlotRequestId> currentTimeoutPendingSlotRequestConsumer = this.timeoutPendingSlotRequestConsumer;
            if (currentTimeoutPendingSlotRequestConsumer != null) {
                currentTimeoutPendingSlotRequestConsumer.accept(slotRequestId);
            }
            super.timeoutPendingSlotRequest(slotRequestId);
        }

        boolean containsAllocatedSlot(AllocationID allocationId) {
            return this.getAllocatedSlots().contains(allocationId);
        }

        boolean containsAvailableSlot(AllocationID allocationId) {
            return this.getAvailableSlots().contains(allocationId);
        }

        int getNumberOfPendingRequests() {
            return this.getPendingRequests().size();
        }

        int getNumberOfWaitingForResourceRequests() {
            return this.getWaitingForResourceManager().size();
        }
    }
}

