/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster.slotpool;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.concurrent.ComponentMainThreadExecutor;
import org.apache.flink.runtime.jobmaster.JobMasterId;
import org.apache.flink.runtime.jobmaster.slotpool.TestingSlotPoolImpl;
import org.apache.flink.runtime.resourcemanager.ResourceManagerGateway;
import org.apache.flink.runtime.resourcemanager.utils.TestingResourceManagerGateway;
import org.apache.flink.runtime.testingUtils.TestingUtils;
import org.apache.flink.util.clock.Clock;
import org.apache.flink.util.clock.SystemClock;

public class SlotPoolBuilder {
    private ComponentMainThreadExecutor componentMainThreadExecutor;
    private ResourceManagerGateway resourceManagerGateway = new TestingResourceManagerGateway();
    private Time batchSlotTimeout = Time.milliseconds((long)2L);
    private Clock clock = SystemClock.getInstance();

    public SlotPoolBuilder(ComponentMainThreadExecutor componentMainThreadExecutor) {
        this.componentMainThreadExecutor = componentMainThreadExecutor;
    }

    public SlotPoolBuilder setResourceManagerGateway(ResourceManagerGateway resourceManagerGateway) {
        this.resourceManagerGateway = resourceManagerGateway;
        return this;
    }

    public SlotPoolBuilder setBatchSlotTimeout(Time batchSlotTimeout) {
        this.batchSlotTimeout = batchSlotTimeout;
        return this;
    }

    public SlotPoolBuilder setClock(Clock clock) {
        this.clock = clock;
        return this;
    }

    public TestingSlotPoolImpl build() throws Exception {
        TestingSlotPoolImpl slotPool = new TestingSlotPoolImpl(new JobID(), this.clock, TestingUtils.infiniteTime(), TestingUtils.infiniteTime(), this.batchSlotTimeout);
        slotPool.start(JobMasterId.generate(), "foobar", this.componentMainThreadExecutor);
        CompletableFuture.runAsync(() -> slotPool.connectToResourceManager(this.resourceManagerGateway), (Executor)this.componentMainThreadExecutor).join();
        return slotPool;
    }
}

