/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster.slotpool;

import java.net.InetAddress;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.executiongraph.utils.SimpleAckingTaskManagerGateway;
import org.apache.flink.runtime.jobmanager.slots.TaskManagerGateway;
import org.apache.flink.runtime.jobmaster.slotpool.AllocatedSlot;
import org.apache.flink.runtime.jobmaster.slotpool.SlotPoolImpl;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;

public class AvailableSlotsTest
extends TestLogger {
    static final ResourceProfile DEFAULT_TESTING_PROFILE = ResourceProfile.fromResources((double)1.0, (int)512);

    @Test
    public void testAddAndRemove() {
        SlotPoolImpl.AvailableSlots availableSlots = new SlotPoolImpl.AvailableSlots();
        ResourceID resource1 = new ResourceID("resource1");
        ResourceID resource2 = new ResourceID("resource2");
        AllocatedSlot slot1 = AvailableSlotsTest.createAllocatedSlot(resource1);
        AllocatedSlot slot2 = AvailableSlotsTest.createAllocatedSlot(resource1);
        AllocatedSlot slot3 = AvailableSlotsTest.createAllocatedSlot(resource2);
        availableSlots.add(slot1, 1L);
        availableSlots.add(slot2, 2L);
        availableSlots.add(slot3, 3L);
        Assert.assertEquals((long)3L, (long)availableSlots.size());
        Assert.assertTrue((boolean)availableSlots.contains(slot1.getAllocationId()));
        Assert.assertTrue((boolean)availableSlots.contains(slot2.getAllocationId()));
        Assert.assertTrue((boolean)availableSlots.contains(slot3.getAllocationId()));
        Assert.assertTrue((boolean)availableSlots.containsTaskManager(resource1));
        Assert.assertTrue((boolean)availableSlots.containsTaskManager(resource2));
        availableSlots.removeAllForTaskManager(resource1);
        Assert.assertEquals((long)1L, (long)availableSlots.size());
        Assert.assertFalse((boolean)availableSlots.contains(slot1.getAllocationId()));
        Assert.assertFalse((boolean)availableSlots.contains(slot2.getAllocationId()));
        Assert.assertTrue((boolean)availableSlots.contains(slot3.getAllocationId()));
        Assert.assertFalse((boolean)availableSlots.containsTaskManager(resource1));
        Assert.assertTrue((boolean)availableSlots.containsTaskManager(resource2));
        availableSlots.removeAllForTaskManager(resource2);
        Assert.assertEquals((long)0L, (long)availableSlots.size());
        Assert.assertFalse((boolean)availableSlots.contains(slot1.getAllocationId()));
        Assert.assertFalse((boolean)availableSlots.contains(slot2.getAllocationId()));
        Assert.assertFalse((boolean)availableSlots.contains(slot3.getAllocationId()));
        Assert.assertFalse((boolean)availableSlots.containsTaskManager(resource1));
        Assert.assertFalse((boolean)availableSlots.containsTaskManager(resource2));
    }

    private static AllocatedSlot createAllocatedSlot(ResourceID resourceId) {
        return new AllocatedSlot(new AllocationID(), new TaskManagerLocation(resourceId, InetAddress.getLoopbackAddress(), 42), 0, DEFAULT_TESTING_PROFILE, (TaskManagerGateway)new SimpleAckingTaskManagerGateway());
    }
}

