/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster;

import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.executiongraph.utils.SimpleAckingTaskManagerGateway;
import org.apache.flink.runtime.instance.SlotSharingGroupId;
import org.apache.flink.runtime.jobmanager.slots.DummySlotOwner;
import org.apache.flink.runtime.jobmanager.slots.TaskManagerGateway;
import org.apache.flink.runtime.jobmaster.SlotOwner;
import org.apache.flink.runtime.jobmaster.SlotRequestId;
import org.apache.flink.runtime.jobmaster.TestingLogicalSlot;
import org.apache.flink.runtime.taskmanager.LocalTaskManagerLocation;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;

public class TestingLogicalSlotBuilder {
    private TaskManagerGateway taskManagerGateway = new SimpleAckingTaskManagerGateway();
    private TaskManagerLocation taskManagerLocation = new LocalTaskManagerLocation();
    private int slotNumber = 0;
    private AllocationID allocationId = new AllocationID();
    private SlotRequestId slotRequestId = new SlotRequestId();
    private SlotSharingGroupId slotSharingGroupId = new SlotSharingGroupId();
    private SlotOwner slotOwner = new DummySlotOwner();
    private boolean automaticallyCompleteReleaseFuture = true;

    public TestingLogicalSlotBuilder setTaskManagerGateway(TaskManagerGateway taskManagerGateway) {
        this.taskManagerGateway = taskManagerGateway;
        return this;
    }

    public TestingLogicalSlotBuilder setTaskManagerLocation(TaskManagerLocation taskManagerLocation) {
        this.taskManagerLocation = taskManagerLocation;
        return this;
    }

    public TestingLogicalSlotBuilder setSlotNumber(int slotNumber) {
        this.slotNumber = slotNumber;
        return this;
    }

    public TestingLogicalSlotBuilder setAllocationId(AllocationID allocationId) {
        this.allocationId = allocationId;
        return this;
    }

    public TestingLogicalSlotBuilder setSlotRequestId(SlotRequestId slotRequestId) {
        this.slotRequestId = slotRequestId;
        return this;
    }

    public TestingLogicalSlotBuilder setSlotSharingGroupId(SlotSharingGroupId slotSharingGroupId) {
        this.slotSharingGroupId = slotSharingGroupId;
        return this;
    }

    public TestingLogicalSlotBuilder setAutomaticallyCompleteReleaseFuture(boolean automaticallyCompleteReleaseFuture) {
        this.automaticallyCompleteReleaseFuture = automaticallyCompleteReleaseFuture;
        return this;
    }

    public TestingLogicalSlotBuilder setSlotOwner(SlotOwner slotOwner) {
        this.slotOwner = slotOwner;
        return this;
    }

    public TestingLogicalSlot createTestingLogicalSlot() {
        return new TestingLogicalSlot(this.taskManagerLocation, this.taskManagerGateway, this.slotNumber, this.allocationId, this.slotRequestId, this.slotSharingGroupId, this.automaticallyCompleteReleaseFuture, this.slotOwner);
    }
}

