/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster;

import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.apache.flink.runtime.jobmaster.JobMasterGateway;
import org.apache.flink.runtime.jobmaster.JobMasterId;
import org.apache.flink.runtime.jobmaster.JobMasterService;
import org.apache.flink.runtime.jobmaster.utils.TestingJobMasterGatewayBuilder;
import org.apache.flink.runtime.messages.Acknowledge;
import org.apache.flink.util.Preconditions;

public class TestingJobMasterService
implements JobMasterService {
    @Nonnull
    private final String address;
    @Nonnull
    private final Function<Exception, CompletableFuture<Acknowledge>> suspendFunction;
    @Nonnull
    private final Function<JobMasterId, CompletableFuture<Acknowledge>> startFunction;
    private JobMasterGateway jobMasterGateway;

    public TestingJobMasterService(@Nonnull String address, @Nonnull Function<Exception, CompletableFuture<Acknowledge>> suspendFunction) {
        this(address, suspendFunction, ignored -> CompletableFuture.completedFuture(Acknowledge.get()));
    }

    public TestingJobMasterService(@Nonnull String address, @Nonnull Function<Exception, CompletableFuture<Acknowledge>> suspendFunction, @Nonnull Function<JobMasterId, CompletableFuture<Acknowledge>> startFunction) {
        this.address = address;
        this.suspendFunction = suspendFunction;
        this.startFunction = startFunction;
    }

    public TestingJobMasterService() {
        this("localhost", e -> CompletableFuture.completedFuture(Acknowledge.get()));
    }

    public CompletableFuture<Acknowledge> start(JobMasterId jobMasterId) {
        this.jobMasterGateway = new TestingJobMasterGatewayBuilder().build();
        return this.startFunction.apply(jobMasterId);
    }

    public CompletableFuture<Acknowledge> suspend(Exception cause) {
        this.jobMasterGateway = null;
        return this.suspendFunction.apply(cause);
    }

    public JobMasterGateway getGateway() {
        Preconditions.checkNotNull((Object)this.jobMasterGateway, (String)"TestingJobMasterService has not been started yet.");
        return this.jobMasterGateway;
    }

    public String getAddress() {
        return this.address;
    }

    public CompletableFuture<Void> closeAsync() {
        this.jobMasterGateway = null;
        return CompletableFuture.completedFuture(null);
    }
}

