/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster;

import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nonnull;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.core.testutils.OneShotLatch;
import org.apache.flink.runtime.blob.PermanentBlobKey;
import org.apache.flink.runtime.checkpoint.CheckpointRecoveryFactory;
import org.apache.flink.runtime.checkpoint.StandaloneCheckpointRecoveryFactory;
import org.apache.flink.runtime.execution.librarycache.LibraryCacheManager;
import org.apache.flink.runtime.execution.librarycache.TestingClassLoaderLease;
import org.apache.flink.runtime.executiongraph.ArchivedExecutionGraph;
import org.apache.flink.runtime.highavailability.HighAvailabilityServices;
import org.apache.flink.runtime.highavailability.TestingHighAvailabilityServices;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.runtime.jobmaster.JobManagerRunner;
import org.apache.flink.runtime.jobmaster.JobManagerRunnerImpl;
import org.apache.flink.runtime.jobmaster.JobNotFinishedException;
import org.apache.flink.runtime.jobmaster.TestingJobMasterService;
import org.apache.flink.runtime.jobmaster.factories.JobMasterServiceFactory;
import org.apache.flink.runtime.jobmaster.factories.TestingJobMasterServiceFactory;
import org.apache.flink.runtime.leaderelection.TestingLeaderElectionService;
import org.apache.flink.runtime.leaderretrieval.SettableLeaderRetrievalService;
import org.apache.flink.runtime.messages.Acknowledge;
import org.apache.flink.runtime.rest.handler.legacy.utils.ArchivedExecutionGraphBuilder;
import org.apache.flink.runtime.rpc.FatalErrorHandler;
import org.apache.flink.runtime.testingUtils.TestingUtils;
import org.apache.flink.runtime.testtasks.NoOpInvokable;
import org.apache.flink.runtime.util.TestingFatalErrorHandler;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.TestLogger;
import org.apache.flink.util.function.BiFunctionWithException;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class JobManagerRunnerImplTest
extends TestLogger {
    @ClassRule
    public static TemporaryFolder temporaryFolder = new TemporaryFolder();
    private static JobGraph jobGraph;
    private static ArchivedExecutionGraph archivedExecutionGraph;
    private static JobMasterServiceFactory defaultJobMasterServiceFactory;
    private TestingHighAvailabilityServices haServices;
    private TestingLeaderElectionService leaderElectionService;
    private TestingFatalErrorHandler fatalErrorHandler;

    @BeforeClass
    public static void setupClass() {
        defaultJobMasterServiceFactory = new TestingJobMasterServiceFactory();
        JobVertex jobVertex = new JobVertex("Test vertex");
        jobVertex.setInvokableClass(NoOpInvokable.class);
        jobGraph = new JobGraph(new JobVertex[]{jobVertex});
        archivedExecutionGraph = new ArchivedExecutionGraphBuilder().setJobID(jobGraph.getJobID()).setState(JobStatus.FINISHED).build();
    }

    @Before
    public void setup() {
        this.leaderElectionService = new TestingLeaderElectionService();
        this.haServices = new TestingHighAvailabilityServices();
        this.haServices.setJobMasterLeaderElectionService(jobGraph.getJobID(), this.leaderElectionService);
        this.haServices.setResourceManagerLeaderRetriever(new SettableLeaderRetrievalService());
        this.haServices.setCheckpointRecoveryFactory((CheckpointRecoveryFactory)new StandaloneCheckpointRecoveryFactory());
        this.fatalErrorHandler = new TestingFatalErrorHandler();
    }

    @After
    public void tearDown() throws Exception {
        this.fatalErrorHandler.rethrowError();
    }

    @Test
    public void testJobCompletion() throws Exception {
        try (JobManagerRunnerImpl jobManagerRunner = this.createJobManagerRunner();){
            jobManagerRunner.start();
            CompletableFuture resultFuture = jobManagerRunner.getResultFuture();
            Assert.assertThat((Object)resultFuture.isDone(), (Matcher)Matchers.is((Object)false));
            jobManagerRunner.jobReachedGloballyTerminalState(archivedExecutionGraph);
            Assert.assertThat(resultFuture.get(), (Matcher)Matchers.is((Object)archivedExecutionGraph));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testJobFinishedByOther() throws Exception {
        try (JobManagerRunnerImpl jobManagerRunner = this.createJobManagerRunner();){
            jobManagerRunner.start();
            CompletableFuture resultFuture = jobManagerRunner.getResultFuture();
            Assert.assertThat((Object)resultFuture.isDone(), (Matcher)Matchers.is((Object)false));
            jobManagerRunner.jobFinishedByOther();
            try {
                resultFuture.get();
                Assert.fail((String)"Should have failed.");
            }
            catch (ExecutionException ee) {
                Assert.assertThat((Object)ExceptionUtils.stripExecutionException((Throwable)ee), (Matcher)Matchers.instanceOf(JobNotFinishedException.class));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testShutDown() throws Exception {
        try (JobManagerRunnerImpl jobManagerRunner = this.createJobManagerRunner();){
            jobManagerRunner.start();
            CompletableFuture resultFuture = jobManagerRunner.getResultFuture();
            Assert.assertThat((Object)resultFuture.isDone(), (Matcher)Matchers.is((Object)false));
            jobManagerRunner.closeAsync();
            try {
                resultFuture.get();
                Assert.fail((String)"Should have failed.");
            }
            catch (ExecutionException ee) {
                Assert.assertThat((Object)ExceptionUtils.stripExecutionException((Throwable)ee), (Matcher)Matchers.instanceOf(JobNotFinishedException.class));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLibraryCacheManagerRegistration() throws Exception {
        OneShotLatch registerClassLoaderLatch = new OneShotLatch();
        OneShotLatch closeClassLoaderLeaseLatch = new OneShotLatch();
        TestingClassLoaderLease classLoaderLease = TestingClassLoaderLease.newBuilder().setGetOrResolveClassLoaderFunction((BiFunctionWithException<Collection<PermanentBlobKey>, Collection<URL>, ClassLoader, IOException>)((BiFunctionWithException)(permanentBlobKeys, urls) -> {
            registerClassLoaderLatch.trigger();
            return JobManagerRunnerImplTest.class.getClassLoader();
        })).setCloseRunnable(() -> ((OneShotLatch)closeClassLoaderLeaseLatch).trigger()).build();
        try (JobManagerRunner jobManagerRunner = this.createJobManagerRunner(classLoaderLease);){
            jobManagerRunner.start();
            registerClassLoaderLatch.await();
            jobManagerRunner.close();
            closeClassLoaderLeaseLatch.await();
        }
    }

    @Test
    public void testConcurrentLeadershipOperationsBlockingSuspend() throws Exception {
        CompletableFuture<Acknowledge> suspendedFuture = new CompletableFuture<Acknowledge>();
        TestingJobMasterServiceFactory jobMasterServiceFactory = new TestingJobMasterServiceFactory(() -> new TestingJobMasterService("localhost", e -> suspendedFuture));
        JobManagerRunner jobManagerRunner = this.createJobManagerRunner(jobMasterServiceFactory);
        jobManagerRunner.start();
        this.leaderElectionService.isLeader(UUID.randomUUID()).get();
        this.leaderElectionService.notLeader();
        CompletableFuture<UUID> leaderFuture = this.leaderElectionService.isLeader(UUID.randomUUID());
        Assert.assertThat((Object)leaderFuture.isDone(), (Matcher)Matchers.is((Object)false));
        try {
            leaderFuture.get(1L, TimeUnit.MILLISECONDS);
            Assert.fail((String)"Granted leadership even though the JobMaster has not been suspended.");
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
        suspendedFuture.complete(Acknowledge.get());
        leaderFuture.get();
    }

    @Test
    public void testConcurrentLeadershipOperationsBlockingGainLeadership() throws Exception {
        CompletableFuture suspendFuture = new CompletableFuture();
        CompletableFuture<Acknowledge> startFuture = new CompletableFuture<Acknowledge>();
        TestingJobMasterServiceFactory jobMasterServiceFactory = new TestingJobMasterServiceFactory(() -> new TestingJobMasterService("localhost", e -> {
            suspendFuture.complete(e);
            return CompletableFuture.completedFuture(Acknowledge.get());
        }, ignored -> startFuture));
        JobManagerRunner jobManagerRunner = this.createJobManagerRunner(jobMasterServiceFactory);
        jobManagerRunner.start();
        this.leaderElectionService.isLeader(UUID.randomUUID());
        this.leaderElectionService.notLeader();
        Assert.assertThat((Object)suspendFuture.isDone(), (Matcher)Matchers.is((Object)false));
        try {
            suspendFuture.get(1L, TimeUnit.MILLISECONDS);
            Assert.fail((String)"Suspended leadership even though the JobMaster has not been started.");
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
        startFuture.complete(Acknowledge.get());
        suspendFuture.get();
    }

    @Nonnull
    private JobManagerRunner createJobManagerRunner(LibraryCacheManager.ClassLoaderLease classLoaderLease) throws Exception {
        return this.createJobManagerRunner(defaultJobMasterServiceFactory, classLoaderLease);
    }

    @Nonnull
    private JobManagerRunnerImpl createJobManagerRunner() throws Exception {
        return this.createJobManagerRunner(defaultJobMasterServiceFactory, TestingClassLoaderLease.newBuilder().build());
    }

    @Nonnull
    private JobManagerRunner createJobManagerRunner(JobMasterServiceFactory jobMasterServiceFactory) throws Exception {
        return this.createJobManagerRunner(jobMasterServiceFactory, TestingClassLoaderLease.newBuilder().build());
    }

    @Nonnull
    private JobManagerRunnerImpl createJobManagerRunner(JobMasterServiceFactory jobMasterServiceFactory, LibraryCacheManager.ClassLoaderLease classLoaderLease) throws Exception {
        return new JobManagerRunnerImpl(jobGraph, jobMasterServiceFactory, (HighAvailabilityServices)this.haServices, classLoaderLease, (Executor)TestingUtils.defaultExecutor(), (FatalErrorHandler)this.fatalErrorHandler);
    }
}

