/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster;

import java.util.concurrent.CompletableFuture;
import org.apache.flink.runtime.io.network.partition.ResultPartitionType;
import org.apache.flink.runtime.jobgraph.DistributionPattern;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.runtime.jobmanager.scheduler.SlotSharingGroup;
import org.apache.flink.runtime.jobmaster.JobResult;
import org.apache.flink.runtime.jobmaster.TestingAbstractInvokables;
import org.apache.flink.runtime.minicluster.TestingMiniCluster;
import org.apache.flink.runtime.minicluster.TestingMiniClusterConfiguration;
import org.apache.flink.util.TestLogger;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class JobExecutionITCase
extends TestLogger {
    @Test
    public void testCoLocationConstraintJobExecution() throws Exception {
        boolean numSlotsPerTaskExecutor = true;
        int numTaskExecutors = 3;
        int parallelism = 3;
        JobGraph jobGraph = this.createJobGraph(3);
        TestingMiniClusterConfiguration miniClusterConfiguration = new TestingMiniClusterConfiguration.Builder().setNumSlotsPerTaskManager(1).setNumTaskManagers(3).setLocalCommunication(true).build();
        try (TestingMiniCluster miniCluster = new TestingMiniCluster(miniClusterConfiguration);){
            miniCluster.start();
            miniCluster.submitJob(jobGraph).get();
            CompletableFuture jobResultFuture = miniCluster.requestJobResult(jobGraph.getJobID());
            Assert.assertThat((Object)((JobResult)jobResultFuture.get()).isSuccess(), (Matcher)Matchers.is((Object)true));
        }
    }

    private JobGraph createJobGraph(int parallelism) {
        JobVertex sender = new JobVertex("Sender");
        sender.setParallelism(parallelism);
        sender.setInvokableClass(TestingAbstractInvokables.Sender.class);
        JobVertex receiver = new JobVertex("Receiver");
        receiver.setParallelism(parallelism);
        receiver.setInvokableClass(TestingAbstractInvokables.Receiver.class);
        SlotSharingGroup slotSharingGroup = new SlotSharingGroup();
        receiver.setSlotSharingGroup(slotSharingGroup);
        sender.setSlotSharingGroup(slotSharingGroup);
        receiver.setStrictlyCoLocatedWith(sender);
        receiver.connectNewDataSetAsInput(sender, DistributionPattern.POINTWISE, ResultPartitionType.PIPELINED);
        JobGraph jobGraph = new JobGraph(((Object)((Object)this)).getClass().getSimpleName(), new JobVertex[]{sender, receiver});
        return jobGraph;
    }
}

