/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmanager;

import javax.annotation.Nonnull;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.HighAvailabilityOptions;
import org.apache.flink.runtime.checkpoint.TestingRetrievableStateStorageHelper;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.runtime.jobmanager.ZooKeeperJobGraphStore;
import org.apache.flink.runtime.util.ZooKeeperUtils;
import org.apache.flink.runtime.zookeeper.ZooKeeperResource;
import org.apache.flink.runtime.zookeeper.ZooKeeperStateHandleStore;
import org.apache.flink.shaded.curator4.org.apache.curator.framework.CuratorFramework;
import org.apache.flink.shaded.curator4.org.apache.curator.framework.recipes.cache.PathChildrenCache;
import org.apache.flink.util.TestLogger;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class ZooKeeperJobGraphStoreTest
extends TestLogger {
    @Rule
    public ZooKeeperResource zooKeeperResource = new ZooKeeperResource();
    private Configuration configuration;

    @Before
    public void setup() {
        this.configuration = new Configuration();
        this.configuration.setString(HighAvailabilityOptions.HA_ZOOKEEPER_QUORUM, this.zooKeeperResource.getConnectString());
    }

    @Test
    public void testJobGraphRemovalFailureAndLockRelease() throws Exception {
        try (CuratorFramework client = ZooKeeperUtils.startCuratorFramework((Configuration)this.configuration);){
            TestingRetrievableStateStorageHelper<JobGraph> stateStorage = new TestingRetrievableStateStorageHelper<JobGraph>();
            ZooKeeperJobGraphStore submittedJobGraphStore = this.createSubmittedJobGraphStore(client, stateStorage);
            submittedJobGraphStore.start(null);
            ZooKeeperJobGraphStore otherSubmittedJobGraphStore = this.createSubmittedJobGraphStore(client, stateStorage);
            otherSubmittedJobGraphStore.start(null);
            JobGraph jobGraph = new JobGraph(new JobVertex[0]);
            submittedJobGraphStore.putJobGraph(jobGraph);
            JobGraph recoveredJobGraph = otherSubmittedJobGraphStore.recoverJobGraph(jobGraph.getJobID());
            Assert.assertThat((Object)recoveredJobGraph, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
            try {
                otherSubmittedJobGraphStore.removeJobGraph(recoveredJobGraph.getJobID());
                Assert.fail((String)"It should not be possible to remove the JobGraph since the first store still has a lock on it.");
            }
            catch (Exception exception) {
                // empty catch block
            }
            submittedJobGraphStore.stop();
            otherSubmittedJobGraphStore.removeJobGraph(recoveredJobGraph.getJobID());
            Assert.assertThat((Object)otherSubmittedJobGraphStore.recoverJobGraph(recoveredJobGraph.getJobID()), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
            otherSubmittedJobGraphStore.stop();
        }
    }

    @Nonnull
    private ZooKeeperJobGraphStore createSubmittedJobGraphStore(CuratorFramework client, TestingRetrievableStateStorageHelper<JobGraph> stateStorage) {
        return new ZooKeeperJobGraphStore(client.getNamespace(), new ZooKeeperStateHandleStore(client, stateStorage), new PathChildrenCache(client, "/", false));
    }
}

