/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.util;

import java.io.IOException;
import java.util.Queue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.LinkedBlockingDeque;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.BufferBuilder;
import org.apache.flink.runtime.io.network.buffer.BufferListener;
import org.apache.flink.runtime.io.network.buffer.BufferProvider;
import org.apache.flink.runtime.io.network.buffer.BufferRecycler;
import org.apache.flink.runtime.io.network.buffer.NetworkBuffer;
import org.apache.flink.runtime.io.network.util.TestBufferFactory;
import org.apache.flink.shaded.guava18.com.google.common.collect.Queues;
import org.apache.flink.util.Preconditions;

public class TestPooledBufferProvider
implements BufferProvider {
    private final BlockingQueue<Buffer> buffers = new LinkedBlockingDeque<Buffer>();
    private final TestBufferFactory bufferFactory;
    private final PooledBufferProviderRecycler bufferRecycler;

    public TestPooledBufferProvider(int poolSize) {
        this(poolSize, 32768);
    }

    public TestPooledBufferProvider(int poolSize, int bufferSize) {
        Preconditions.checkArgument((poolSize > 0 ? 1 : 0) != 0);
        this.bufferRecycler = new PooledBufferProviderRecycler(this.buffers);
        this.bufferFactory = new TestBufferFactory(poolSize, bufferSize, this.bufferRecycler);
    }

    public Buffer requestBuffer() throws IOException {
        Buffer buffer = (Buffer)this.buffers.poll();
        if (buffer != null) {
            return buffer;
        }
        return this.bufferFactory.create();
    }

    public BufferBuilder requestBufferBuilder() throws IOException {
        Buffer buffer = this.requestBuffer();
        if (buffer != null) {
            return new BufferBuilder(buffer.getMemorySegment(), buffer.getRecycler());
        }
        return null;
    }

    public BufferBuilder requestBufferBuilder(int targetChannel) throws IOException {
        return this.requestBufferBuilder();
    }

    private Buffer requestBufferBlocking() throws IOException, InterruptedException {
        Buffer buffer = (Buffer)this.buffers.poll();
        if (buffer != null) {
            return buffer;
        }
        buffer = this.bufferFactory.create();
        if (buffer != null) {
            return buffer;
        }
        return this.buffers.take();
    }

    public BufferBuilder requestBufferBuilderBlocking() throws IOException, InterruptedException {
        Buffer buffer = this.requestBufferBlocking();
        return new BufferBuilder(buffer.getMemorySegment(), buffer.getRecycler());
    }

    public BufferBuilder requestBufferBuilderBlocking(int targetChannel) throws IOException, InterruptedException {
        return this.requestBufferBuilderBlocking();
    }

    public boolean addBufferListener(BufferListener listener) {
        return this.bufferRecycler.registerListener(listener);
    }

    public boolean isDestroyed() {
        return false;
    }

    public CompletableFuture<?> getAvailableFuture() {
        return AVAILABLE;
    }

    public int getNumberOfAvailableBuffers() {
        return this.buffers.size();
    }

    public int getNumberOfCreatedBuffers() {
        return this.bufferFactory.getNumberOfCreatedBuffers();
    }

    private static class PooledBufferProviderRecycler
    implements BufferRecycler {
        private final Object listenerRegistrationLock = new Object();
        private final Queue<Buffer> buffers;
        private final ConcurrentLinkedQueue<BufferListener> registeredListeners = Queues.newConcurrentLinkedQueue();

        public PooledBufferProviderRecycler(Queue<Buffer> buffers) {
            this.buffers = buffers;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void recycle(MemorySegment segment) {
            Object object = this.listenerRegistrationLock;
            synchronized (object) {
                NetworkBuffer buffer = new NetworkBuffer(segment, (BufferRecycler)this);
                BufferListener listener = this.registeredListeners.poll();
                if (listener == null) {
                    this.buffers.add((Buffer)buffer);
                } else {
                    listener.notifyBufferAvailable((Buffer)buffer);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean registerListener(BufferListener listener) {
            Object object = this.listenerRegistrationLock;
            synchronized (object) {
                if (this.buffers.isEmpty()) {
                    this.registeredListeners.add(listener);
                    return true;
                }
                return false;
            }
        }
    }
}

